package com.tiffintom.partner1.common;


import android.app.Activity;
import android.content.Intent;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.gson.Gson;
import com.stripe.stripeterminal.external.callable.TerminalListener;
import com.stripe.stripeterminal.external.models.ConnectionStatus;
import com.stripe.stripeterminal.external.models.PaymentStatus;
import com.stripe.stripeterminal.external.models.Reader;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;

import org.jetbrains.annotations.NotNull;

public class CustomTerminalEventListener implements TerminalListener {
    Activity activity;

    public CustomTerminalEventListener(Activity activity) {
        this.activity = activity;
    }

    @Override
    public void onConnectionStatusChange(@NotNull ConnectionStatus connectionStatus) {
        LogUtils.e("connectionStatus Change: " + new Gson().toJson(connectionStatus));
//        sendMessage(connectionStatus.toString(), 0);
    }

    @Override
    public void onPaymentStatusChange(@NotNull PaymentStatus paymentStatus) {
        LogUtils.e("Payment Status Change: " + new Gson().toJson(paymentStatus));
//        sendMessage(paymentStatus.name(), 0);
    }

    @Override
    public void onUnexpectedReaderDisconnect(@NotNull Reader reader) {
        sendMessage("Reader disconnected", 2);
    }

    private void sendMessage(String message, int status) {
        Intent pushNotification = new Intent(Constants.CARD_READER_MESSAGE);
        pushNotification.putExtra("status", status);
        if (message != null)
            pushNotification.putExtra("message", message);
        LocalBroadcastManager.getInstance(activity).sendBroadcast(pushNotification);
    }
}
