package com.tiffintom.partner1.common

import com.stripe.stripeterminal.external.callable.ConnectionTokenCallback
import com.stripe.stripeterminal.external.callable.ConnectionTokenProvider
import com.stripe.stripeterminal.external.models.ConnectionTokenException
import com.tiffintom.partner1.network.ApiClient

class CustomTokenProvider constructor(s_location_id: String, businessId: String) :
    ConnectionTokenProvider {
    var s_location_id: String = ""
    var businessId: String = ""

    init {
        this.s_location_id = s_location_id
        this.businessId = businessId
    }

    override fun fetchConnectionToken(callback: ConnectionTokenCallback) {
        try {
            val token = ApiClient.createConnectionToken(
                s_location_id = s_location_id,
                businessId = businessId
            )
            callback.onSuccess(token)
        } catch (e: ConnectionTokenException) {
            callback.onFailure(e)
        }
    }
}