package com.tiffintom.partner1.common.bluetoothprinter;


import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;

import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.printer.WifiPrinterUtil;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.models.OrderProductDetail;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.models.SurChargesModel;
import com.tiffintom.partner1.models.TransactionSummary;
import com.tiffintom.partner1.utils.LogUtils;
import com.zqprintersdk.PrinterConst;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class BluetoothPrinter {

    BluetoothDevice connectedPrinter;
    Context mContext;
    String tip = "";
    String actual = "";
    String grand = "";
    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);
    private RestaurantUser loggedInRestaurant = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public BluetoothPrinter(Context context) {
        mContext = context;
    }

    public BluetoothDevice getConnectedPrinter() {
        connectedPrinter = Printama.with(mContext).getConnectedPrinter();
        if (connectedPrinter == null) return null;
        return connectedPrinter;
    }

    public void printCardReaderReceipt(Bitmap tiffintomLogo,String rePrintTitle, String title, String header, String header1, String address, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        tip = tip_amount;
        actual = actual_amount;
        grand = grand_total;
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo, 320);
                        printama.addNewLine();
                    }
                    //      prn.Prn_PrintText(header + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    //  prn.Prn_PrintText(header1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(header1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    //  prn.Prn_PrintText(address + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    //prn.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    if(!Validators.isNullOrEmpty(rePrintTitle)){
                        printama.printTextEpos(rePrintTitle, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    }
                    printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);

                    //zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    if (!Validators.isNullOrEmpty(tip)) {
                        actual = actual.replace("£", "");
                        actual = actual + " GBP";
                        //  zonerich.Prn_PrintText(actual_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos(actual, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        tip = tip.replace("£", "");
                        tip = tip + " GBP";
                        // zonerich.Prn_PrintText(tip_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos(tip, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    }
                    grand = grand.replace("£", "");
                    grand = grand + " GBP";
                    //    zonerich.Prn_PrintText(grand_total + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    printama.printTextEpos(grand, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);

                    printama.printTextEpos(main_content, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //zonerich.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    //zonerich.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(please, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //    zonerich.Prn_PrintText(final_date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(final_date, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    // zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    // zonerich.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(footer, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    //  zonerich.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(footer1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //    zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);
                    //   zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);
                    //  zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);

                    //WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);

            } catch (Exception e) {
                e.printStackTrace();
                FirebaseCrashlytics.getInstance().recordException(e);
            }
        }).start();

    }

    public void printMerchantPaymentReport(TransactionSummary transactionSummary, Bitmap bm, String header_a, String header_b, String footer_a, String footer_b) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (bm != null) {
                        printama.printImage(bm, 320);
                    }
                    //    prn.Prn_PrintText(header_a + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(header_a, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // prn.Prn_PrintText(header_b + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(header_b, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //   prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //    prn.Prn_PrintText("Tiffintom Partner\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    printama.printTextEpos("Tiffintom Partner", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    //    prn.Prn_PrintText("Transaction Report\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Transaction Report", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    if (!Validators.isNullOrEmpty(transactionSummary.date_range)) {
                        //   prn.Prn_PrintText("\n\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                        printama.addNewLine(2);
                        //  prn.Prn_PrintText(transactionSummary.date_range, PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                        printama.printTextEpos(transactionSummary.date_range, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    }
                    // prn.Prn_PrintText("\n\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    printama.addNewLine(2);
                    //      prn.Prn_PrintText("Total Transaction              :" + transactionSummary.totalTransaction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    printama.printTextEpos("Total Transaction              :" + transactionSummary.totalTransaction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //  prn.Prn_PrintText("Total Refund Amount            :" + MyApp.df.format(transactionSummary.totalRefundAmount) + " GBP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    printama.printTextEpos("Total Refund Amount            :" + MyApp.df.format(transactionSummary.totalRefundAmount) + " GBP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //   prn.Prn_PrintText("Total Refund Transactions      :" + transactionSummary.totalRefundTransactions + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    printama.printTextEpos("Total Refund Transactions      :" + transactionSummary.totalRefundTransactions, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //  prn.Prn_PrintText("Total Successful Amount        :" + MyApp.df.format(transactionSummary.totalSuccessfulAmount) + " GBP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    printama.printTextEpos("Total Successful Amount        :" + MyApp.df.format(transactionSummary.totalSuccessfulAmount) + " GBP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //     prn.Prn_PrintText("Total Successful Transactions  :" + transactionSummary.totalSuccessfulTransactions + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    printama.printTextEpos("Total Successful Transactions  :" + transactionSummary.totalSuccessfulTransactions, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //    prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //    prn.Prn_PrintText(footer_a + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(footer_a, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //  prn.Prn_PrintText(footer_b + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(footer_b, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    printama.addNewLine(3);
                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printMotoReceipt(Bitmap bitmap, String title, String header, String header1, String address, String amount, String main_content, String date_final, String please, String footer, String footer1) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (bitmap != null) {
                        printama.printImage(bitmap, 320);
                    }
                    printama.printTextEpos(header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    // prn.Prn_PrintText(header + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    // prn.Prn_PrintText(header1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(header1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    //  prn.Prn_PrintText(address + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    //  prn.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);

                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    String amt = amount;
                    amt = amt.replace("£", "");
                    amt = amt.replace("\n", "");
                    amt = amt + " GBP";
                    printama.printTextEpos(amt, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    printama.printTextEpos(main_content.replace(" :", ": "), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    printama.printTextEpos(date_final, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(please, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(footer, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(footer1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.addNewLine(3);
                    printama.setCutPaper();
                    printama.close();
                    //   MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Moto disconnect: " + title)); // TODO
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printReservation(Reservation reservation, Bitmap tiffintomLogo) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    //wifiCommunication.sndByte(ByteCommand.ESC_Init);
                    //*WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo, 320);
                        // WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                    }
                    printama.printTextEpos(loggedInRestaurant.restaurant_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    // prn.Prn_PrintText(loggedInRestaurant.restaurant_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    // prn.Prn_PrintText("Tel   : " + loggedInRestaurant.restaurant_phone + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Tel   : " + loggedInRestaurant.restaurant_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    //   prn.Prn_PrintText("Email : " + loggedInRestaurant.contact_email + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Email : " + loggedInRestaurant.contact_email, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    //     prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    // prn.Prn_PrintText(reservation.booking_date + "/" + reservation.booking_time + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(reservation.booking_date + "/" + reservation.booking_time, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    //  prn.Prn_PrintText(reservation.booking_id + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(reservation.booking_id, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                    //  prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    //prn.Prn_PrintText("Customer name     : " + reservation.customer_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Customer name     : " + reservation.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    //  prn.Prn_PrintText("Guest Count       : " + reservation.guest_count + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Guest Count       : " + reservation.guest_count, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    //  prn.Prn_PrintText("Booking Email     : " + reservation.booking_email + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Booking Email     : " + reservation.booking_email, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    // prn.Prn_PrintText("Booking Phone     : " + reservation.booking_phone + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Booking Phone     : " + reservation.booking_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    //  prn.Prn_PrintText("Booking Status    : " + reservation.status + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Booking Status    : " + reservation.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                        //    prn.Prn_PrintText("Reason            : " + reservation.cancel_reason + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos("Reason            : " + reservation.cancel_reason, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    //    prn.Prn_PrintText("Booking Date/Time : " + reservation.booking_date + "/" + reservation.booking_time + "\n\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Booking Date/Time : " + reservation.booking_date + "/" + reservation.booking_time, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    printama.addNewLine(1);

                    //  prn.Prn_PrintText("Instructions      :" + reservation.booking_instruction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Instructions      :" + reservation.booking_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    printama.addNewLine(3);
                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printOrder(Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    int orderType = -1;
                    if (Validators.isNullOrEmpty(orderDetail.order_type)) {
                        orderType = 0;
                    } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
                        orderType = 1;
                    } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
                        orderType = 2;
                    }
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (!orderTiffinTomLogo) {
                        if (tiffintomLogo != null) {
                            //  WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                            printama.printImage(tiffintomLogo, 320);
                        } else {
                            LogUtils.e("PRINT::", "Tiffintom Logo null");
                        }
                    } else {
                        if (businessLogo != null) {
                            //  WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                            printama.printImage(businessLogo, 320);
                        } else {
                            LogUtils.e("PRINT::", "Tiffintom Logo null");
                        }
                    }
                    String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                    String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    if (!todayDate.equalsIgnoreCase(orderDateString)) {
                        printama.printTextEpos("This order is not for today", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "This order is not for today", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    printama.printTextEpos("Tiffintom.com sent you order", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(CommonFunctions.getOrderType(orderType), WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos("ORDER NO:" + orderDetail.order_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Tiffintom.com sent you order", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, CommonFunctions.getOnlineOrderType(orderType), WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ORDER NO:" + orderDetail.order_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    if (orderType > 0) {
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            printama.printTextEpos("ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            printama.printTextEpos(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            //    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    String itemName = "", price = "", qty = "";
                    for (OrderProductDetail productDetail : orderDetail.cart_view) {
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                        String productQty = String.valueOf(productDetail.quantity);
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (!kitchenCopy) ? MyApp.df.format(productDetail.total_price) : "";
                        if (kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 15);
                        else
                            itemName = getProductNameWithPad(productName, price, 35);
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + "  ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        String printItem;
                        printItem = qty + itemName;

                        printItem = printItem.replace(MyApp.getInstance().currencySymbol, "");
                        if (!kitchenCopy)
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        else
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);

                        if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                            try {
                                //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                String[] parts = productDetail.subaddons_name.split(",");

                                for (String subAddonPart : parts) {
                                    if (!kitchenCopy) {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                        subdomainPrintText = subdomainPrintText.replace(MyApp.getInstance().currencySymbol, "");
                                        printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                    } else {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                        subdomainPrintText = subdomainPrintText.replace(MyApp.getInstance().currencySymbol, "");
                                        printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                                    }
                                }
                            } catch (Exception e) {
                                Log.e("Addon_Error", e.getMessage());
                            }
                        }
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(padRightSpaces("SubTotal:", 40) + MyApp.df.format(orderDetail.order_sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("SubTotal:", 40) + MyApp.df.format(orderDetail.order_sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (orderDetail.delivery_charge > 0) {
                        printama.printTextEpos(padRightSpaces("Delivery Charge:", 40) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Delivery Charge:", 40) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderDetail.offer_amount > 0) {
                        printama.printTextEpos(padRightSpaces("Offer:", 40) + MyApp.df.format(orderDetail.offer_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Offer:", 40) + MyApp.df.format(orderDetail.offer_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderDetail.service_charge > 0) {
                        if (!"no".equalsIgnoreCase(loggedInRestaurant.service_charge_status)) { //TODO
                            printama.printTextEpos(padRightSpaces("Service Charge:", 40) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Service Charge:", 40) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                    }
                    if (orderDetail.driver_tip > 0) {
                        printama.printTextEpos(padRightSpaces("Driver Tip:", 40) + MyApp.df.format(orderDetail.driver_tip), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Driver Tip:", 40) + MyApp.df.format(orderDetail.driver_tip), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderDetail.reward_offer > 0) {
                        printama.printTextEpos(padRightSpaces("Loyalty Point Discount:", 40) + MyApp.df.format(orderDetail.reward_offer), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Loyalty Point Discount:", 40) + MyApp.df.format(orderDetail.reward_offer), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if(orderDetail.surcharges!=null && !orderDetail.surcharges.isEmpty()){
                        for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                            if (surChargesModel.surcharge_amount > 0) {
                                printama.printTextEpos(padRightSpaces(surChargesModel.surcharge_name, 40) + MyApp.df.format(surChargesModel.surcharge_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            }
                        }
                    }
                    printama.printTextEpos("Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                        if (kitchenCopy) {
                            printama.printTextEpos("Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                        } else {
                            printama.printTextEpos("Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        }
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                        printama.printTextEpos("Delivery Instructions: " + orderDetail.delivery_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        //     WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Delivery Instructions: " + orderDetail.delivery_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    printama.printTextEpos("Cust Name: " + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust Name: " + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                        printama.printTextEpos("Cust No: " + orderDetail.customer_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //     WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust No: " + orderDetail.customer_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    if (orderType == 1) {

                        String address = orderDetail.address + "\n";
                        String[] parts = address.split("[\\\\s,]+");
                        StringBuilder str = new StringBuilder();

                        for (String name : parts) {
                            str.append(name).append("\n");
                        }
                        printama.printTextEpos("Del. address: " + orderDetail.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Del. address: " + orderDetail.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }

                    if (orderType >= 0) {

                        if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                            printama.printTextEpos("Confirmed for: " + orderDetail.preparation, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Confirmed for: " + orderDetail.preparation, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        }
                    }
                    printama.printTextEpos("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    String paymentName = "";
                    if (orderDetail.payment_method.equalsIgnoreCase("stripe"))
                        paymentName = "ONLINE";
                    if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                    if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                        paymentName = "WALLET";
                    if (orderDetail.payment_method.equalsIgnoreCase("paypal"))
                        paymentName = "PAYPAL";
                    printama.printTextEpos("Payment Type:  " + paymentName, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //     WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Type:  " + paymentName, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    printama.printTextEpos("Receipt Time:  " + CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    printama.printTextEpos("Order status: " + orderDetail.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Receipt Time:  " + CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order status: " + orderDetail.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (orderDetail.status.equalsIgnoreCase("failed")) {
                        printama.printTextEpos("Reason: " + orderDetail.failed_reason, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reason: " + orderDetail.failed_reason, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos(MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().restaurant_name + ", " + MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().contact_address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    printama.printTextEpos("Thanks", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                    //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Thanks", WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                    //WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);

                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);

            } catch (Exception e) {
                e.printStackTrace();
                FirebaseCrashlytics.getInstance().recordException(e);
            }
        }).start();
        //CommonFunctions.functionThatDelay(100);
    }

    public void openCashDrawer() {
        try {
            new Thread(() -> {
                try {
                    Printama.with(mContext).connect(printama -> {
                        printama.openCashDrawer();
                        printama.close();
                    }, this::displayErrorMessage);
                } catch (Exception e) {
                    FirebaseCrashlytics.getInstance().recordException(e);
                    e.printStackTrace();
                }
            }).start();
            //CommonFunctions.functionThatDelay(200);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openCashDrawer(boolean close) {
        try {
            new Thread(() -> {
                try {
                    Printama.with(mContext).connect(Printama::openCashDrawer, this::displayErrorMessage);
                    if (close) {
                        Printama.with(mContext).close();
                    }
                } catch (Exception e) {
                    FirebaseCrashlytics.getInstance().recordException(e);
                    e.printStackTrace();
                }
            }).start();
            //   CommonFunctions.functionThatDelay(200);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(parts1[1].trim(), charatersInLine);
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(part.trim(), charatersInLine);

            }

        }
        return subAddonName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }

    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private void displayErrorMessage(String message) {

    }

}
