package com.tiffintom.partner1.common.printer;

public class ByteCommand {

    //打印机初始化
    //Printer initialization
    public static byte[] ESC_Init = new byte[]{0x1b, 0x40};

    // Drawer kick-out instruction
    public static byte[] DLE_DRAWER_KICK_OUT = new byte[]{0x10, 0x14, 0x01, 0x01, 0x01};
    public static byte[] ESC_DRAWER_KICK_OUT = new byte[]{0x1B, 0x70, 0x01, 0x01, 0x11};
    public static byte[] ESC_DRAWER_KICK_OUT1 = new byte[]{0x1b, 0x70, 0x00, 0x50, 0x50};

    /**
     * 打印命令
     * Print command
     */
    //打印并换行  Print and wrap
    public static byte[] LF = new byte[]{0x0a};

    //打印并走纸
    //Print and feed paper
    public static byte[] ESC_J = new byte[]{0x1b, 0x4a, 0x00};
    public static byte[] ESC_d = new byte[]{0x1b, 0x64, 0x00};

    //打印自检页 Print self-test page
    public static byte[] US_vt_eot = new byte[]{0x1f, 0x11, 0x04};

    //蜂鸣指令 Beep command
    public static byte[] ESC_B_m_n = new byte[]{0x1b, 0x42, 0x00, 0x00};

    //切刀指令 Cutting knife instruction
    public static byte[] GS_V_n = new byte[]{0x1d, 0x56, 0x00};
    public static byte[] GS_V_m_n = new byte[]{0x1d, 0x56, 0x42, 0x00};
    //    public static byte[] GS_V_m_n = new byte[]{0x1d, 0x56, 0x66, 0x00};
    public static byte[] GS_i = new byte[]{0x1b, 0x69};
    public static byte[] GS_m = new byte[]{0x1b, 0x6d};

    /**
     * 字符设置命令
     * Character setting command
     */
    //设置字符右间距 Set the right spacing of characters
    public static byte[] ESC_SP = new byte[]{0x1b, 0x20, 0x00};

    //设置字符打印字体格式 Set character print font format
    public static byte[] ESC_ExclamationMark = new byte[]{0x1b, 0x21, 0x00};

    //设置字体倍高倍宽
    //Set font double height width
    public static byte[] GS_ExclamationMark = new byte[]{0x1d, 0x21, 0x00};
//    public static byte[] GS_ExclamationMark = new byte[]{0x1b, 0x21, 0x00};

    //设置反显打印
    //Set reverse printing
    public static byte[] GS_B = new byte[]{0x1d, 0x42, 0x00};

    //取消/选择90度旋转打印 Cancel/select 90 degree rotation print
    public static byte[] ESC_V = new byte[]{0x1b, 0x56, 0x00};

    //选择字体字型(主要是ASCII码) Select font font (mainly ASCII code)
    public static byte[] ESC_M = new byte[]{0x1b, 0x4d, 0x00};

    //选择/取消加粗指令 Select/Cancel bold instructions
    public static byte[] ESC_G = new byte[]{0x1b, 0x47, 0x00};
    public static byte[] ESC_E = new byte[]{0x1b, 0x45, 0x00};

    //选择/取消倒置打印模式 Select/Cancel Inverted Print Mode
    public static byte[] ESC_LeftBrace = new byte[]{0x1b, 0x7b, 0x00};

    //设置下划线点高度(字符) Set the underline height (character)
    public static byte[] ESC_Minus = new byte[]{0x1b, 0x2d, 0x00};

    //字符模式 Character mode
    public static byte[] FS_dot = new byte[]{0x1c, 0x2e};

    //汉字模式
    //Chinese character mode
    public static byte[] FS_and = new byte[]{0x1c, 0x26};

    //设置汉字打印模式 Set Chinese character print mode
    public static byte[] FS_ExclamationMark = new byte[]{0x1c, 0x21, 0x00};

    //设置下划线点高度(汉字)
    //Set the height of the underline (Chinese character)
    public static byte[] FS_Minus = new byte[]{0x1c, 0x2d, 0x00};

    //设置汉字左右间距 Set the left and right spacing of Chinese characters
    public static byte[] FS_S = new byte[]{0x1c, 0x53, 0x00, 0x00};

    //选择字符代码页 Select character code page
    public static byte[] ESC_t = new byte[]{0x1b, 0x74, 0x00};

    /**
     * 格式设置指令
     * Formatting instructions
     */
    //设置默认行间距
    //Set the default line spacing
    public static byte[] ESC_Two = new byte[]{0x1b, 0x32};

    //设置行间距 Set line spacing
    public static byte[] ESC_Three = new byte[]{0x1b, 0x33, 0x00};

    //设置对齐模式 Set the alignment mode
    public static byte[] ESC_Align = new byte[]{0x1b, 0x61, 0x00};

    //设置左边距 Set the left margin
    public static byte[] GS_LeftSp = new byte[]{0x1d, 0x4c, 0x00, 0x00};

    //设置绝对打印位置
    //Set absolute print position
    //将当前位置设置到距离行首（nL + nH x 256）处。
    //Set the current position to the beginning of the line (nL + nH x 256).
    //如果设置位置在指定打印区域外，该命令被忽略
    //If the setting position is outside the specified print area, this command is ignored
    public static byte[] ESC_Relative = new byte[]{0x1b, 0x24, 0x00, 0x00};

    //设置相对打印位置 Set the relative print position
    public static byte[] ESC_Absolute = new byte[]{0x1b, 0x5c, 0x00, 0x00};

    //设置打印区域宽度
    //Set the print area width
    public static byte[] GS_W = new byte[]{0x1d, 0x57, 0x00, 0x00};

    /**
     * 状态指令 Status instruction
     */
    //实时状态传送指令
    //Real-time status transfer instructions
    public static byte[] DLE_eot = new byte[]{0x10, 0x04, 0x00};

    //实时弹钱箱指令
    //Real-time cash box instruction
    public static byte[] DLE_DC4 = new byte[]{0x10, 0x14, 0x00, 0x00, 0x00};

    //标准弹钱箱指令
    //Standard bill box instruction
    public static byte[] ESC_p = new byte[]{0x1b, 0x70, 0x00, 0x00, 0x00};

    /**
     * 条码设置指令 Barcode setting instructions
     */
    //选择HRI打印方式 Select HRI printing method
    public static byte[] GS_H = new byte[]{0x1d, 0x48, 0x00};

    //设置条码高度 Set the bar code height
    public static byte[] GS_h = new byte[]{0x1d, 0x68, (byte) 0xa2};

    //设置条码宽度 Set the bar code width
    public static byte[] GS_w = new byte[]{0x1d, 0x77, 0x00};

    //设置HRI字符字体字型 Set HRI character font font
    public static byte[] GS_f = new byte[]{0x1d, 0x66, 0x00};

    //条码左偏移指令 Barcode left offset instruction
    public static byte[] GS_x = new byte[]{0x1d, 0x78, 0x00};

    //打印条码指令 Print barcode instructions
    public static byte[] GS_k = new byte[]{0x1d, 0x6b, 0x41, 0x0c};

    //二维码相关指令
    //QR code related instructions
    public static byte[] GS_k_m_v_r_nL_nH = new byte[]{0x1b, 0x5a, 0x03, 0x03, 0x08, 0x00, 0x00};

}
