package com.tiffintom.partner1.common.printer

import android.graphics.Bitmap
import android.util.Log
import com.ctk.sdk.PosApiHelper
import com.tiffintom.partner1.MyApp
import com.tiffintom.partner1.common.CommonFunctions
import com.tiffintom.partner1.common.Validators
import com.tiffintom.partner1.models.OrderDetail
import com.tiffintom.partner1.models.ReportTextModel
import com.tiffintom.partner1.models.TransactionSummary
import com.tiffintom.partner1.storageutils.MyPreferences
import com.zqprintersdk.PrinterConst
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch
import java.text.DecimalFormat
import java.text.NumberFormat
import java.util.Locale

class CS20PrintHelper {
    var apiHelper: PosApiHelper = PosApiHelper.getInstance()

    init {
        MainScope().launch(Dispatchers.IO) {
            apiHelper.PrintInit()
        }
    }

    fun printCardReaderReceipt(
        tiffintomLogo: Bitmap? = null,
        rePrintTitle: String? = null,
        title: String? = null,
        header: String? = null,
        header1: String? = null,
        address: String? = null,
        actual_amount: String? = null,
        tip_amount: String? = null,
        grand_total: String? = null,
        main_content: String? = null,
        please: String? = null,
        final_date: String? = null,
        footer: String? = null,
        footer1: String? = null
    ) {
        var actual_amount = actual_amount
        var tip_amount = tip_amount
        var grand_total = grand_total
        if (tiffintomLogo != null) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintBmp(tiffintomLogo)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(
                "\n",
            )
        }
        if (!Validators.isNullOrEmpty(header)) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            // 1 bold 0 normal
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(header)
        }
        if (!Validators.isNullOrEmpty(header1)) {
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(header1)
        }
        if (!Validators.isNullOrEmpty(address)) {
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(address)
        }
        if (!Validators.isNullOrEmpty(rePrintTitle)) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            // 1 bold 0 normal
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x33.toByte())
            apiHelper.PrintStr(rePrintTitle)
        }
        if (!Validators.isNullOrEmpty(title)) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x33.toByte())
            apiHelper.PrintStr(title)
        }
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("--------------------------------")
        if (!Validators.isNullOrEmpty(tip_amount)) {
            if (!Validators.isNullOrEmpty(actual_amount)) {
                actual_amount = actual_amount!!.replace("£", "")
                actual_amount = "$actual_amount GBP"
            }
            apiHelper.PrintStr(actual_amount)
            tip_amount = tip_amount!!.replace("£", "")
            tip_amount = "$tip_amount GBP"

            apiHelper.PrintStr(tip_amount)
        }
        grand_total = grand_total?.replace("£", "")
        grand_total = "$grand_total GBP"

        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(1)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x33.toByte())
        apiHelper.PrintStr(grand_total)

        apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        if (!Validators.isNullOrEmpty(main_content)) {
            apiHelper.PrintStr(main_content)
        }

        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintStr("\n\n")
        if (!Validators.isNullOrEmpty(please)) {
            apiHelper.PrintStr("Please Retain Receipt")
            apiHelper.PrintStr("For Your Record")
        }
        if (!Validators.isNullOrEmpty(final_date)) {
            apiHelper.PrintStr(final_date)
        }
        apiHelper.PrintStr("--------------------------------")
        if (!Validators.isNullOrEmpty(footer)) {
            apiHelper.PrintStr(footer)
        }
        if (!Validators.isNullOrEmpty(footer1)) {
            apiHelper.PrintStr(footer1)
        }
        apiHelper.PrintStr("\n")
        apiHelper.PrintStr("\n")
        apiHelper.PrintStr("\n")
        apiHelper.PrintStr("\n\n\n\n\n")
        apiHelper.PrintFeedPaper(3)
        apiHelper.PrintStart()
        //apiHelper.PrintCutQrCode_Str("", "", 5, 300, 300, "")
    }

    fun printMotoReceipt(
        bm: Bitmap?,
        title: String? = null,
        header: String? = null,
        header1: String? = null,
        address: String? = null,
        amount: String? = null,
        main_content: String? = null,
        date_final: String? = null,
        please: String? = null,
        footer: String? = null,
        footer1: String? = null
    ) {
        var amount = amount
        try {
            if (bm != null) {
                apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                apiHelper.PrintBmp(bm)
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr(
                    "\n",
                )
            }
            if (!Validators.isNullOrEmpty(header)) {
                apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                // 1 bold 0 normal
                apiHelper.PrintSetBold(1)
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr(header)
            }
            if (!Validators.isNullOrEmpty(header1)) {
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr(header1)
            }
            if (!Validators.isNullOrEmpty(address)) {
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr(address)
            }
            if (!Validators.isNullOrEmpty(title)) {
                apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                apiHelper.PrintSetBold(1)
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x33.toByte())
                apiHelper.PrintStr(title)
            }
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("--------------------------------")
            amount = amount?.replace("£", "")
            amount = amount?.replace("\n", "")
            amount = "$amount GBP"

            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x33.toByte())
            apiHelper.PrintStr(amount)

            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            if (!Validators.isNullOrEmpty(main_content)) {
                apiHelper.PrintStr(main_content)
            }

            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintStr("\n\n")
            if (!Validators.isNullOrEmpty(date_final)) {
                apiHelper.PrintStr(date_final)
            }
            if (!Validators.isNullOrEmpty(please)) {
                apiHelper.PrintStr("Please Retain Receipt")
                apiHelper.PrintStr("For Your Record")
            }
            apiHelper.PrintStr("--------------------------------")

            if (!Validators.isNullOrEmpty(footer)) {
                apiHelper.PrintStr(footer)
            }
            if (!Validators.isNullOrEmpty(footer1)) {
                apiHelper.PrintStr(footer1)
            }

            apiHelper.PrintStr("\n")
            apiHelper.PrintStr("\n")
            apiHelper.PrintStr("\n\n\n\n\n")
            apiHelper.PrintFeedPaper(3)
            apiHelper.PrintStart()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    var formatter = NumberFormat.getNumberInstance(Locale.US) as DecimalFormat
    fun printOrder(
        tiffintomLogo: Bitmap?,
        businessLogo: Bitmap?,
        orderDetail: OrderDetail,
        kitchenCopy: Boolean,
        orderTiffinTomLogo: Boolean
    ) {
        val loggedInRestaurant = MyApp.getInstance().myPreferences.loggedInRestaurant
        var orderType = -1
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0
        } else if (orderDetail.order_type.equals("delivery", ignoreCase = true)) {
            orderType = 1
        } else if (orderDetail.order_type.equals("pickup", ignoreCase = true)) {
            orderType = 2
        }
        formatter.applyPattern("00.00")
        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomLogo != null) {
                    apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                    apiHelper.PrintBmp(tiffintomLogo)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr(
                        "\n",
                    )
                }
            } else {
                if (businessLogo != null) {
                    apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                    apiHelper.PrintBmp(businessLogo)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr(
                        "\n",
                    )
                }
            }
            val todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy")
            val orderDateString = CommonFunctions.formatUnknownDateTime(
                orderDetail.delivery_date,
                MyApp.DEL_TIMEFORMAT,
                "dd-MM-yyyy"
            )

            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x11.toByte())
            if (!todayDate.equals(orderDateString, ignoreCase = true)) {
                apiHelper.PrintStr(
                    "This order is not for today".trimIndent(),
                )
            }

            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(
                "Tiffintom.com sent you order\n".trimIndent(),
            )


            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x33.toByte())
            apiHelper.PrintStr(
                CommonFunctions.getOrderType(orderType)
            )

            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("--------------------------------")

            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(
                "ORDER NO:${orderDetail.order_number} ".trimIndent()
            )
            if (orderType > 0) {
                if (orderDetail.assoonas.equals("now", ignoreCase = true)) {
                    apiHelper.PrintSetBold(0)
                    apiHelper.PrintStr("ASAP".trimIndent())
                } else {
                    apiHelper.PrintSetBold(0)
                    apiHelper.PrintStr(
                        "${CommonFunctions.convertTimeFormat(orderDetail.delivery_time)} ${
                            CommonFunctions.formatUnknownDateTime(
                                orderDetail.delivery_date,
                                MyApp.DEL_TIMEFORMAT,
                                "dd-MM-yyyy"
                            )
                        }".trimIndent()
                    )
                }
                apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                apiHelper.PrintSetBold(0)
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr("--------------------------------")
            }
            var itemName = ""
            var price = ""
            var qty = ""
            for (productDetail in orderDetail.cart_view) {
                val productName =
                    if (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) productDetail.short_name else productDetail.menu_name
                val productQty = productDetail.quantity.toString()
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price =
                    if (!kitchenCopy) formatter.format(productDetail.total_price.toDouble()) else ""
                /*itemName =
                    if (kitchenCopy) getProductNameWithPad(
                        productName,
                        price,
                        31
                    ) else getProductNameWithPad(productName, price, 31)*/
                qty = productQty
                if (productQty.length <= 1) {
                    qty = " $productQty "
                } else if (productQty.length <= 2) {
                    qty = "$productQty "
                } else if (productQty.length <= 3) {
                    qty = "$productQty "
                } else if (productQty.length <= 4) {
                    qty = productQty + ""
                }
                val printItem: String = calculateNumberOfLines(
                    productName,
                    price,
                    PrinterConst.WidthSize.SIZE0,
                    qty
                ); //"$qty$itemName".trimIndent()
                if (!kitchenCopy) {
                    apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
                    apiHelper.PrintSetBold(1)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr(printItem)
                } else {
                    apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
                    apiHelper.PrintSetBold(1)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr(printItem)
                }
                if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                    try {
                        //String[] parts = menus.get(position).getSubaddonsName().split(",");
                        val parts = productDetail.subaddons_name.split(",".toRegex())
                            .dropLastWhile { it.isEmpty() }
                            .toTypedArray()
                        for (subAddonPart in parts) {
                            if (!kitchenCopy) {
                                val subdomainPrintText: String =
                                    getSubaddonWithPad(subAddonPart, 35)
                                apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
                                apiHelper.PrintSetBold(1)
                                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                                apiHelper.PrintStr(subdomainPrintText)
                            } else {
                                val subdomainPrintText: String =
                                    getSubaddonWithPad(subAddonPart, 20)
                                apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
                                apiHelper.PrintSetBold(1)
                                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                                apiHelper.PrintStr(subdomainPrintText)
                            }
                        }
                    } catch (e: java.lang.Exception) {
                        Log.e("Addon_Error", e.message!!)
                    }
                }
            }
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("--------------------------------")

            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(
                calculateNumberOfLines(
                    "SubTotal:",
                    MyApp.df.format(orderDetail.order_sub_total),
                    PrinterConst.WidthSize.SIZE0,
                    ""
                )
            )

            if (orderDetail.delivery_charge > 0) {
                apiHelper.PrintStr(
                    calculateNumberOfLines(
                        "Delivery Charge:",
                        MyApp.df.format(orderDetail.delivery_charge),
                        PrinterConst.WidthSize.SIZE0,
                        ""
                    )
                )
            }
            if (orderDetail.offer_amount > 0) {
                apiHelper.PrintStr(
                    calculateNumberOfLines(
                        "Offer:",
                        MyApp.df.format(orderDetail.offer_amount),
                        PrinterConst.WidthSize.SIZE0,
                        ""
                    )
                )
            }
            if (orderDetail.service_charge > 0) {
                if (!"no".equals(loggedInRestaurant.service_charge_status, ignoreCase = true)) {
                    apiHelper.PrintStr(
                        calculateNumberOfLines(
                            "Service Charge:",
                            MyApp.df.format(orderDetail.service_charge),
                            PrinterConst.WidthSize.SIZE0,
                            ""
                        )
                    )
                }
            }
            if (orderDetail.driver_tip > 0) {
                apiHelper.PrintStr(
                    calculateNumberOfLines(
                        "Driver Tip:",
                        MyApp.df.format(orderDetail.driver_tip),
                        PrinterConst.WidthSize.SIZE0,
                        ""
                    )
                )
            }
            if (orderDetail.reward_offer > 0) {
                apiHelper.PrintStr(
                    calculateNumberOfLines(
                        "Loyalty Point Discount:",
                        MyApp.df.format(orderDetail.reward_offer),
                        PrinterConst.WidthSize.SIZE0,
                        ""
                    )
                )
            }
            if (orderDetail.surcharges != null && orderDetail.surcharges.isNotEmpty()) {
                for (surChargesModel in orderDetail.surcharges) {
                    if (surChargesModel.surcharge_amount > 0) {
                        apiHelper.PrintStr(
                            calculateNumberOfLines(
                                surChargesModel.surcharge_name,
                                MyApp.df.format(surChargesModel.surcharge_amount),
                                PrinterConst.WidthSize.SIZE0,
                                ""
                            )
                        )
                    }
                }
            }

            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(
                calculateNumberOfLines(
                    "Grand Total:",
                    MyApp.df.format(orderDetail.order_grand_total),
                    PrinterConst.WidthSize.SIZE0,
                    ""
                )
            )

            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("--------------------------------")
            if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
                apiHelper.PrintSetBold(0)
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr("Comments:${orderDetail.order_description}".trimIndent())
                apiHelper.PrintStr("--------------------------------")
            }
            apiHelper.PrintStr("Cust Name:${orderDetail.customer_name}".trimIndent())
            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                apiHelper.PrintStr("Cust No:${orderDetail.customer_phone}".trimIndent())
            }
            apiHelper.PrintStr("--------------------------------")
            if (orderType == 1) {
                val address = "${orderDetail.address}".trimIndent()
                val parts = address.split("[\\\\s,]+".toRegex()).dropLastWhile { it.isEmpty() }
                    .toTypedArray()
                val str = StringBuilder()
                for (name in parts) {
                    str.append(name).append("\n")
                }
                apiHelper.PrintSetBold(1)
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr("Del. address:$address\n")

                apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                apiHelper.PrintSetBold(0)
                apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                apiHelper.PrintStr("--------------------------------")
            }
            if (orderType >= 0) {
                if (orderDetail.status.equals(
                        "accepted",
                        ignoreCase = true
                    ) && !Validators.isNullOrEmpty(orderDetail.preparation)
                ) {
                    apiHelper.PrintSetBold(0)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr("Confirmed for:".trimIndent())
                    apiHelper.PrintSetBold(1)
                    apiHelper.PrintStr("${orderDetail.preparation}".trimIndent())

                    apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                    apiHelper.PrintSetBold(0)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr("--------------------------------")
                }
            }

            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(
                "Order ${
                    if (orderDetail.payment_status.equals(
                            "np",
                            ignoreCase = true
                        )
                    ) "Unpaid" else "Paid"
                }".trimIndent()
            )
            var paymentName = ""
            if (orderDetail.payment_method.equals("stripe", ignoreCase = true)) paymentName =
                "ONLINE"
            if (orderDetail.payment_method.equals("cod", ignoreCase = true)) paymentName = "COD"
            if (orderDetail.payment_method.equals(
                    "wallet",
                    ignoreCase = true
                ) || orderDetail.payment_method.equals("credit", ignoreCase = true)
            ) paymentName = "WALLET"
            if (orderDetail.payment_method.equals("paypal", ignoreCase = true)) paymentName =
                "PAYPAL"

            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("Payment Type:  $paymentName\n")
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("--------------------------------")

            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("Receipt Time:\n")

            apiHelper.PrintSetBold(0)
            apiHelper.PrintStr("${CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a")}".trimIndent())
            apiHelper.PrintStr("Order status: ${orderDetail.status}".trimIndent())

            if (orderDetail.status.equals("failed", ignoreCase = true)) {
                apiHelper.PrintStr("Reason: ${orderDetail.failed_reason}".trimIndent())
            }

            apiHelper.PrintSetBold(1)
            apiHelper.PrintStr("${MyApp.getInstance().myPreferences.loggedInRestaurant.restaurant_name}, ${MyApp.getInstance().myPreferences.loggedInRestaurant.contact_address}".trimIndent())

            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("Thanks!".trimIndent())

            apiHelper.PrintStr("\n")
            apiHelper.PrintStr("\n")
            apiHelper.PrintStr("\n\n\n\n\n")
            apiHelper.PrintFeedPaper(5)
            apiHelper.PrintStart()
        } catch (e: java.lang.Exception) {
            println(e)
        }
    }

    fun printMerchantPaymentReport(
        transactionSummary: TransactionSummary,
        bm: Bitmap?,
        header_a: String?,
        header_b: String?,
        footer_a: String?,
        footer_b: String?
    ) {
        if (bm != null) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintBmp(bm)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(
                "\n",
            )
        }
        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        if(!Validators.isNullOrEmpty(header_a)){
            apiHelper.PrintStr(header_a?.trimIndent())
        }
        if(!Validators.isNullOrEmpty(header_b)){
            apiHelper.PrintStr(header_b?.trimIndent())
        }

        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("--------------------------------")

        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(1)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("Tiffintom Partner")
        apiHelper.PrintStr("Transaction Report")
        if (!Validators.isNullOrEmpty(transactionSummary.date_range)) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("\n\n")
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintStr(transactionSummary.date_range)
        }
        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(1)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("\n\n")
        apiHelper.PrintStr("Total\n\n")
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)

        apiHelper.PrintStr(preparePaymentTitle(":"+transactionSummary.totalTransaction,"Transaction"))
        apiHelper.PrintStr(preparePaymentTitle(":${MyApp.df.format(transactionSummary.totalRefundAmount)} GBP","Refund Amount"))
        apiHelper.PrintStr(preparePaymentTitle(":${transactionSummary.totalRefundTransactions}","Refund Transactions"))
        apiHelper.PrintStr(preparePaymentTitle(":${MyApp.df.format(transactionSummary.totalSuccessfulAmount)} GBP","Successful Amount"))
        apiHelper.PrintStr(preparePaymentTitle(":${transactionSummary.totalSuccessfulTransactions}","Successful Transactions"))
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("--------------------------------")

        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        if(!Validators.isNullOrEmpty(footer_a)){
            apiHelper.PrintStr(footer_a)
        }
        if(!Validators.isNullOrEmpty(footer_b)){
            apiHelper.PrintStr(footer_b)
        }

        apiHelper.PrintStr("\n\n\n\n\n\n\n")
        apiHelper.PrintFeedPaper(5)
        apiHelper.PrintStart()
    }

    private fun preparePaymentTitle(totalTransaction:String?,totalTransactionTitle:String):String{
        val totalCharInLine = 32
        val transactionTitleCount = if(Validators.isNullOrEmpty(totalTransaction)) 0 else totalTransaction!!.length
        val remainingCount = totalCharInLine-(totalTransactionTitle.length + transactionTitleCount)
        var spaceInTransaction = ""
        repeat(remainingCount){
            spaceInTransaction = "$spaceInTransaction ";
        }
        return "$totalTransactionTitle$spaceInTransaction$totalTransaction"
    }

    fun printFoodHubFullReport(
        bm: Bitmap?,
        header: String?,
        headerAlignment: Int?,
        title: String?,
        date: String?,
        user: String?,
        data: java.util.ArrayList<Any?>,
        footerA: String?,
        footerB: String?,
        myPreferences: MyPreferences?
    ) {
        val zonerich = ZoneRichPrinter.prn
        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(1)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        if (!Validators.isNullOrEmpty(title)){
            apiHelper.PrintStr(title)
        }
        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("--------------------------------")
        if (!Validators.isNullOrEmpty(date)) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr(date)

            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("--------------------------------")
        }
        //reportHeader(PrinterConst.WidthSize.SIZE0);
        if (!Validators.isNullOrEmpty(user)) {
            apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
            apiHelper.PrintSetBold(1)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("User name: $user\n")

            apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
            apiHelper.PrintSetBold(0)
            apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
            apiHelper.PrintStr("--------------------------------")
        }
        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(1)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr(reportHeader(PrinterConst.WidthSize.SIZE0))

        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("--------------------------------")
        for (objct in data) {
            if (objct is ReportTextModel) {
                val textModel = objct
                var printText: String?
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.getInstance().currencySymbol)) {
                            //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                            printText = reportDetail(
                                PrinterConst.WidthSize.SIZE0,
                                "",
                                textModel.value,
                                textModel.title
                            )
                        } else {
                            //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                            printText = reportDetail(
                                PrinterConst.WidthSize.SIZE0,
                                textModel.value,
                                "",
                                textModel.title
                            )
                        }
                    } else {
                        printText = if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(
                                textModel.orderCount
                            )
                        ) {
                            reportDetail(
                                PrinterConst.WidthSize.SIZE0,
                                textModel.orderCount,
                                textModel.totalPrice,
                                textModel.title
                            )
                        } else {
                            //printText = getProductNameWithPad(textModel.title, "", 35)
                            ""
                        }
                    }
                } else {
                    printText = textModel.title
                }
                if (textModel.isHeader) {
                    apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                    apiHelper.PrintSetBold(0)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr("--------------------------------")

                    apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                    apiHelper.PrintSetBold(1)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr(printText)

                    apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
                    apiHelper.PrintSetBold(0)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr("--------------------------------")
                } else {
                    apiHelper.PrintSetAlign(PrinterConst.Alignment.LEFT)
                    apiHelper.PrintSetBold(0)
                    apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
                    apiHelper.PrintStr(printText)
                }
            }
        }
        apiHelper.PrintSetAlign(PrinterConst.Alignment.CENTER)
        apiHelper.PrintSetBold(0)
        apiHelper.PrintSetFont(24.toByte(), 24.toByte(), 0x00.toByte())
        apiHelper.PrintStr("--------------------------------")

        apiHelper.PrintStr("\n\n\n\n\n\n\n")
        apiHelper.PrintFeedPaper(5)
        apiHelper.PrintStart()
    }

    private fun getSubaddonWithPad(part: String, charatersInLine: Int): String {
        var subAddonName = ""
        subAddonName = if (part.contains(":")) {
            val parts1 = part.split(":".toRegex()).dropLastWhile { it.isEmpty() }
                .toTypedArray()
            if (parts1[1].length > charatersInLine) {
                val sb = java.lang.StringBuilder()
                for (partSub in getParts(parts1[1], charatersInLine)) {
                    if (partSub.length >= charatersInLine) {
                        sb.append("   ").append(partSub.trim { it <= ' ' }).append("\n")
                    } else {
                        sb.append("   ").append(
                            padRightSpaces(
                                partSub.trim { it <= ' ' },
                                charatersInLine
                            )
                        ).append("\n")
                    }
                }
                sb.toString()
            } else {
                val sb = java.lang.StringBuilder()
                sb.append("   ").append(
                    padRightSpaces(
                        parts1[1].trim { it <= ' ' },
                        charatersInLine
                    )
                ).append("\n")
                sb.toString()
            }
        } else {
            if (part.length > charatersInLine) {
                val sb = java.lang.StringBuilder()
                for (partSub in getParts(part, charatersInLine)) {
                    if (partSub.length >= charatersInLine) {
                        sb.append("   ").append(partSub.trim { it <= ' ' }).append("\n")
                    } else {
                        sb.append("   ").append(
                            padRightSpaces(
                                partSub.trim { it <= ' ' },
                                charatersInLine
                            )
                        ).append("\n")
                    }
                }
                sb.toString()
            } else {
                val sb = java.lang.StringBuilder()
                sb.append("   ").append(
                    padRightSpaces(
                        part.trim { it <= ' ' },
                        charatersInLine
                    )
                ).append("\n")
                sb.toString()
            }
        }
        return subAddonName
    }

    private fun padRightSpaces(str: String?, n: Int): String {
        return String.format("%1$-" + n + "s", str)
    }

    private fun getParts(string: String, partitionSize: Int): List<String> {
        val parts: MutableList<String> = ArrayList()
        val len = string.length
        var i = 0
        while (i < len) {
            parts.add(string.substring(i, len.coerceAtMost(i + partitionSize)))
            i += partitionSize
        }
        return parts
    }

    private fun calculateNumberOfLines(
        productName: String,
        format: String,
        widthSize: Int,
        qty: String
    ): String {
        val productNameSplit = productName.split(" ".toRegex()).dropLastWhile { it.isEmpty() }
            .toTypedArray()
        val finalPrice = "  " + format.trim { it <= ' ' }
        var secondLine = qty
        val lengthForSize = if (widthSize == PrinterConst.WidthSize.SIZE0) 32 else 32
        var multiplyLength = 1
        var index = 0
        for (s in productNameSplit) {
            index += 1
            Log.e("finalPrice", "finalPrice " + finalPrice + "string to apend " + s.length)
            if (secondLine.length < multiplyLength * lengthForSize) {
                if ("$secondLine $s$finalPrice".length > multiplyLength * lengthForSize) {
                    //secondLine = secondLine+secondLine.replace(,"");
                    var emptySpaceLength = multiplyLength * lengthForSize - secondLine.length
                    if (multiplyLength == 1) {
                        emptySpaceLength -= finalPrice.length
                        for (space in 0 until emptySpaceLength) {
                            secondLine = "$secondLine "
                        }
                        secondLine += finalPrice
                    } else {
                        for (space in 0 until emptySpaceLength) {
                            secondLine = "$secondLine "
                        }
                    }
                    multiplyLength += 1
                    secondLine = "$secondLine".trimIndent()
                    for (j in qty.indices) {
                        secondLine = "$secondLine "
                    }
                }
            } else {
                multiplyLength += 1
                secondLine = "$secondLine".trimIndent()
                for (j in qty.indices) {
                    secondLine = "$secondLine "
                }
            }
            secondLine = "$secondLine $s"
            //if(productNameSplit.length==1 && multiplyLength==1 &&secondLine.length() < (multiplyLength * lengthForSize)){
            // in last index need to compare length of the item with numbers of line in print
            if (productNameSplit.size == index && multiplyLength == 1 && secondLine.length < (multiplyLength * lengthForSize)) {
                if (multiplyLength == 1) {
                    var emptySpaceLength = multiplyLength * lengthForSize - secondLine.length
                    emptySpaceLength -= finalPrice.length
                    for (space in 0 until emptySpaceLength) {
                        secondLine = "$secondLine "
                    }
                    secondLine = secondLine + finalPrice
                }
            }
        }
        return secondLine
    }

    private fun reportHeader(widthSize: Int): String? {
        val orderTitle = "Orders"
        val priceTitle = " Price  "
        val _60Per = (if (widthSize == PrinterConst.WidthSize.SIZE0) 18 else 18).toFloat()
        var orderPriceTitle = ""
        var emptySpace = 0
        while (emptySpace < _60Per) {
            orderPriceTitle = "$orderPriceTitle "
            emptySpace++
        }
        // 2 space after orders in order to display space between orders and price
        orderPriceTitle = orderPriceTitle + orderTitle + ""
        orderPriceTitle += priceTitle
        return orderPriceTitle
    }

    private fun reportDetail(
        widthSize: Int,
        ordersValue: String,
        priceValue: String,
        titleValue: String
    ): String? {
        val _60Per = if (widthSize == PrinterConst.WidthSize.SIZE0) 18 else 18
        var orderPriceTitle = ""
        val titleLength = _60Per - titleValue.length
        orderPriceTitle = titleValue + ""
        for (emptySpace in 0 until titleLength) {
            orderPriceTitle = "$orderPriceTitle "
        }
        // 2 space after orders in order to display space between orders and price
        if (Validators.isNullOrEmpty(ordersValue)) {
            orderPriceTitle = "$orderPriceTitle-"
        } else {
            orderPriceTitle += ordersValue
        }
        orderPriceTitle += ""
        if (Validators.isNullOrEmpty(priceValue)) {
            val different = 7- ordersValue.length
            for (i in 0 until different) {
                orderPriceTitle = "$orderPriceTitle "
            }
            orderPriceTitle = "$orderPriceTitle-"
        } else {
            val different =7- ordersValue.length
            for (i in 0 until different) {
                orderPriceTitle = "$orderPriceTitle "
            }
            orderPriceTitle += priceValue
        }
        return orderPriceTitle
    }}