package com.tiffintom.partner1.common.printer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;

import com.imin.printerlib.IminPrintUtils;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.models.OrderProductDetail;
import com.tiffintom.partner1.models.ReportTextModel;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.models.SurChargesModel;
import com.tiffintom.partner1.models.TransactionSummary;
import com.tiffintom.partner1.storageutils.MyPreferences;
import com.zqprintersdk.PrinterConst;
import com.zqprintersdk.ZQPrinterSDK;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class IMinPrinterUtils {
    private IminPrintUtils mIminPrintUtils;
    private RestaurantUser loggedInRestaurant;

    public IMinPrinterUtils(Context currentActivity) {
        initIMinPrinter(currentActivity);
    }

    private void initIMinPrinter(Context currentActivity) {
        if (mIminPrintUtils == null) {
            mIminPrintUtils = IminPrintUtils.getInstance(currentActivity);

        }
        mIminPrintUtils.resetDevice();
        mIminPrintUtils.initPrinter(IminPrintUtils.PrintConnectType.SPI);
        loggedInRestaurant = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();
    }

    public void printReservation(Reservation reservation, Bitmap tiffintomLogo) {
        RestaurantUser loggedInRestaurant = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();
        try {
            if (tiffintomLogo != null) {
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
            }

            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.printText(loggedInRestaurant.restaurant_name + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Tel   : " + loggedInRestaurant.restaurant_phone, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Email : " + loggedInRestaurant.contact_email, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.printText(reservation.booking_date + "/" + reservation.booking_time, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText(reservation.booking_id, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.printText("Customer name     : " + reservation.customer_name, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Guest Count       : " + reservation.guest_count, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Booking Email     : " + reservation.booking_email, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Booking Phone     : " + reservation.booking_phone, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Booking Status    : " + reservation.status, PrinterConst.Alignment.CENTER);
            if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                mIminPrintUtils.printText("Reason            : " + reservation.cancel_reason, PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.printText("Booking Date/Time : \n" + reservation.booking_date + "/" + reservation.booking_time, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Instructions      :" + reservation.booking_instruction + "\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.fullCut();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void printMerchantPaymentReport(TransactionSummary transactionSummary, Bitmap bm, String header_a, String header_b, String footer_a, String footer_b) {
        if (bm != null) {
            mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printSingleBitmap(bm, 2500);
        }
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.printText(header_a + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(header_b + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.setTextSize(35);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("Tiffintom Partner", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printText("Transaction Report", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setAlignment(0);
        if (!Validators.isNullOrEmpty(transactionSummary.date_range)) {
            mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(transactionSummary.date_range + "\n", PrinterConst.Alignment.CENTER);
        } else {
            mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        }
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.printText("Total Transaction              :" + transactionSummary.totalTransaction, PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Refund Amount            :" + MyApp.df.format(transactionSummary.totalRefundAmount) + " GBP", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Refund Transactions      :" + transactionSummary.totalRefundTransactions, PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Successful Amount        :" + MyApp.df.format(transactionSummary.totalSuccessfulAmount) + " GBP", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Successful Transactions  :" + transactionSummary.totalSuccessfulTransactions, PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.printText(footer_a + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(footer_b + "\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printAndFeedPaper(3);
        mIminPrintUtils.fullCut();
    }

    public void printMotoReceipt(Bitmap bm, String title, String header, String header1, String address, String amount, String main_content, String date_final, String please, String footer, String footer1) {
        try {
            if (bm != null) {
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(bm, 2500);
                //mIminPrintUtils.printText("\n", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(header + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            if (!Validators.isNullOrEmpty(address)) {
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.printText(header1 + "", PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printText(address + "\n", PrinterConst.Alignment.CENTER);
            } else {
                mIminPrintUtils.printText(header1 + "\n", PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.printText(title + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            amount = amount.replace("£", "");
            amount = amount.replace("\n", "");
            amount = amount + " GBP";
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(amount + "", PrinterConst.Alignment.CENTER);

            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.printText(main_content + "\n");
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText(date_final + "\n");
            mIminPrintUtils.printText(please + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.printText(footer + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText(footer1 + "\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.fullCut();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printCardReaderReceipt(Bitmap tiffintomLogo, String rePrintTitle, String title, String header, String header1, String address, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        if (tiffintomLogo != null) {
            mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
            //mIminPrintUtils.printText("\n", PrinterConst.Alignment.LEFT);
        }
        if (!Validators.isNullOrEmpty(header)) {
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(header + "", PrinterConst.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(header1)) {
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(header1 + "", PrinterConst.Alignment.CENTER);
        }
        mIminPrintUtils.sethaveBold(true);
        if (!Validators.isNullOrEmpty(address)) {
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(address + "\n", PrinterConst.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(rePrintTitle)) {
            mIminPrintUtils.printText(rePrintTitle + "", PrinterConst.Alignment.CENTER);
        }
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setTextSize(35);
        mIminPrintUtils.printText(title + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        if (!Validators.isNullOrEmpty(tip_amount)) {
            actual_amount = actual_amount.replace("£", "");
            actual_amount = actual_amount + " GBP";
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(actual_amount + "", PrinterConst.Alignment.CENTER);

            tip_amount = tip_amount.replace("£", "");
            tip_amount = tip_amount + " GBP";
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(tip_amount + "", PrinterConst.Alignment.CENTER);
        }
        grand_total = grand_total.replace("£", "");
        grand_total = grand_total + " GBP";
        mIminPrintUtils.printText(grand_total + "", PrinterConst.Alignment.CENTER);

        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.setAlignment(0);
        mIminPrintUtils.printText(main_content + "\n");

        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.printText(please + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(final_date + "\n");
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printText(footer + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(footer1 + "\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printAndFeedPaper(3);
        mIminPrintUtils.fullCut();
    }

    public void printOrder(Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo) {
        DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);
        int orderType = -1;
        String orderName = "";
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
            orderName = "Dine in";
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
            orderName = "Delivery";
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
            orderName = "Pickup";
        }
        formatter.applyPattern("00.00");
        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomLogo != null) {
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
                }
            } else {
                if (businessLogo != null) {
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.printSingleBitmap(businessLogo, 2500);
                }
            }
            String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
            String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd-MM-yyyy");
            if (!todayDate.equalsIgnoreCase(orderDateString)) {
                mIminPrintUtils.setTextSize(35);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("This order is not for today", PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("Tiffintom.com sent you order", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.printText(orderName, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText("ORDER NO:" + orderDetail.order_number, PrinterConst.Alignment.CENTER);
            if (orderType > 0) {
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    mIminPrintUtils.printText("ASAP", PrinterConst.Alignment.CENTER);
                } else {
                    mIminPrintUtils.printText(CommonFunctions.convertTimeFormat(orderDetail.delivery_time) + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd-MM-yyyy") + "\n", PrinterConst.Alignment.CENTER);
                }
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.printText("--------------------------------------", PrinterConst.Alignment.CENTER);
            }
            String itemName = "", price = "", qty = "";
            for (OrderProductDetail productDetail : orderDetail.cart_view) {
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                String productQty = String.valueOf(productDetail.quantity);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
                itemName = productName;
               /* if (kitchenCopy)
                    itemName = getProductNameWithPad(productName, price, 20);
                else
                    itemName = getProductNameWithPad(productName, price, 35);*/
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                String printItem;
                printItem = qty + itemName;
                if (!kitchenCopy) {
                    String[] strings3 = new String[]{"", qty + productName, price};
                    int[] colsWidthArr3 = new int[]{0, 8, 2};
                    int[] colsAlign3 = new int[]{0, 0, 2};
                    int[] colsSize3 = new int[]{26, 26, 26};
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                            colsAlign3, colsSize3);
                    //mIminPrintUtils.printText(printItem , PrinterConst.Alignment.CENTER);
                } else {
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                }

                if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                    try {
                        //String[] parts = menus.get(position).getSubaddonsName().split(",");
                        String[] parts = productDetail.subaddons_name.split(",");

                        for (String subAddonPart : parts) {
                            if (!kitchenCopy) {
                                mIminPrintUtils.sethaveBold(true);
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                            } else {
                                mIminPrintUtils.sethaveBold(true);
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                            }
                        }
                    } catch (Exception e) {
                        Log.e("Addon_Error", e.getMessage());
                    }
                }
            }
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total), PrinterConst.Alignment.CENTER);
            if (orderDetail.delivery_charge > 0) {
                mIminPrintUtils.printText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.offer_amount > 0) {
                mIminPrintUtils.printText(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.service_charge > 0) {
                if (!"no".equalsIgnoreCase(loggedInRestaurant.service_charge_status)) {
                    mIminPrintUtils.printText(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge), PrinterConst.Alignment.CENTER);
                }
            }
            if (orderDetail.driver_tip > 0) {
                mIminPrintUtils.printText(padRightSpaces("Driver Tip::", 20) + MyApp.df.format(orderDetail.driver_tip), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.reward_offer > 0) {
                mIminPrintUtils.printText(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                    if (surChargesModel.surcharge_amount > 0) {
                        mIminPrintUtils.printText(padRightSpaces(surChargesModel.surcharge_name, 20) + MyApp.df.format(surChargesModel.surcharge_amount), PrinterConst.Alignment.CENTER);
                    }
                }
            }
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText("Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------", PrinterConst.Alignment.CENTER);
            if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                mIminPrintUtils.printText("Comments:" + orderDetail.order_description, PrinterConst.Alignment.LEFT);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.printText("--------------------------------------", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText("Cust Name:" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT);
            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                mIminPrintUtils.printText("Cust No:" + orderDetail.customer_phone + "\n", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);

            if (orderType == 1) {

                String address = orderDetail.address;
                String[] parts = address.split("[\\\\s,]+");
                StringBuilder str = new StringBuilder();

                for (String name : parts) {
                    str.append(name).append("\n");
                }
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Del. address:" + address, PrinterConst.Alignment.LEFT);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setTextSize(30);
                //mIminPrintUtils.printText("---------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            }

            if (orderType >= 0) {

                if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Confirmed for:", PrinterConst.Alignment.LEFT);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.printText(orderDetail.preparation + "\n", PrinterConst.Alignment.LEFT);
                }
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", PrinterConst.Alignment.LEFT);
            String paymentName = "";
            if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
            if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
            if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                paymentName = "WALLET";
            if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText("Payment Type:  " + paymentName + "", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText("Receipt Time:", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.printText("Order status: " + orderDetail.status + "\n", PrinterConst.Alignment.LEFT);
            if (orderDetail.status.equalsIgnoreCase("failed")) {
                mIminPrintUtils.printText("Reason: " + orderDetail.failed_reason + "\n", PrinterConst.Alignment.LEFT);
            }

            mIminPrintUtils.printText(MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().restaurant_name + ", " + MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().contact_address + "\n", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.printText("Thanks!" + "\n", PrinterConst.Alignment.LEFT);

            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.fullCut();

        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public void printFoodHubFullReport(Bitmap bm, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        /*if (bm != null) {
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.printSingleBitmap(bm, 2500);
        }
*/
        /*if (headerAlignment < 2) {
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText(header, PrinterConst.Alignment.CENTER);
        } else {
            String[] headers = header.split("\n");
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(1);
            for (String h : headers) {
                mIminPrintUtils.printText(h, PrinterConst.Alignment.CENTER);
            }
        }*/

        mIminPrintUtils.setTextSize(35);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setAlignment(1);
        if (!Validators.isNullOrEmpty(title))
            mIminPrintUtils.printText(title, PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);

        if (!Validators.isNullOrEmpty(date)) {
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText(date, PrinterConst.Alignment.LEFT);
            //zonerich.Prn_PrintText("" + CommonFunctions.formatMiliToDesireFormat(Calendar.getInstance().getTimeInMillis(),"hh:mm a") + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
        //reportHeader(PrinterConst.WidthSize.SIZE0);
        if (!Validators.isNullOrEmpty(user)) {
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText("User name: " + user, PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
        reportHeader();
        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        for (Object objct : data) {
            if (objct instanceof ReportTextModel) {
                ReportTextModel textModel = (ReportTextModel) objct;

                String printText;
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.getInstance().currencySymbol)) {
                            //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                            reportDetail("  -  ", Validators.isNullOrEmpty(textModel.value) ? "  -  " : textModel.value, textModel.title, false);
                        } else {
                            //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                            reportDetail(Validators.isNullOrEmpty(textModel.value) ? "  -  " : textModel.value, "", textModel.title, false);
                        }
                    } else {
                        if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(textModel.orderCount)) {
                            reportDetail(Validators.isNullOrEmpty(textModel.orderCount) ? "  -  " : textModel.orderCount, Validators.isNullOrEmpty(textModel.totalPrice) ? "  -  " : textModel.totalPrice, textModel.title, false);
                        } else {
                            getProductNameWithPad(textModel.title, "", 35);
                        }
                    }
                } else {
                    //printText = textModel.title;
                    reportDetail(textModel.value, "", textModel.title, true);
                }
                /*if (textModel.isHeader) {
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
                } else {
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }*/
            }
        }

        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.printText("--------------------------------------" + "\n\n\n\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.setAlignment(1);
//        mIminPrintUtils.printText(footerA + "", PrinterConst.Alignment.CENTER);
//        mIminPrintUtils.printText(footerB + "\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printAndFeedPaper(3);
        mIminPrintUtils.fullCut();
    }

    private void reportHeader() {
        String orderTitle = "Orders";
        String priceTitle = "Price";
        String[] strings3 = new String[]{"", orderTitle, priceTitle};
        int[] colsWidthArr3 = new int[]{0, 8, 4};
        int[] colsAlign3 = new int[]{0, 2, 2};
        int[] colsSize3 = new int[]{0, 26, 26};
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setAlignment(0);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                colsAlign3, colsSize3);
    }

    private void reportDetail(String ordersValue, String priceValue, String titleValue, boolean isHeader) {
        if (isHeader) {
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
        String[] strings3 = new String[]{titleValue, ordersValue, priceValue};
        int[] colsWidthArr3 = isHeader ? new int[]{12, 0, 0} : new int[]{10, 7, 7};
        int[] colsAlign3 = new int[]{0, 2, 2};
        int[] colsSize3 = new int[]{26, 26, 26};
        if (isHeader) {
            mIminPrintUtils.sethaveBold(true);
        } else {
            mIminPrintUtils.sethaveBold(false);
        }
        mIminPrintUtils.setAlignment(0);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                colsAlign3, colsSize3);
        if (isHeader) {
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }

    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = containsTwoDots(part) ? part.split("::") :part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("");
                    }
                }
                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(parts1[1].trim(), charatersInLine)).append("");
                subAddonName = sb.toString();
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("");
                    }
                }

                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(part.trim(), charatersInLine)).append("");
                subAddonName = sb.toString();

            }

        }
        return subAddonName;
    }

    boolean containsTwoDots(String str) {
        return str.indexOf(':') != str.lastIndexOf(':');
    }
}
