package com.tiffintom.partner1.common.printer;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.IBinder;
import android.text.Html;
import android.util.Log;

import com.sunmi.sunmi_utils.SunmiPrintHelper;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.models.OrderProductDetail;
import com.tiffintom.partner1.models.ReportTextModel;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.models.SurChargesModel;
import com.tiffintom.partner1.models.TransactionSummary;
import com.tiffintom.partner1.storageutils.MyPreferences;
import com.zqprintersdk.PrinterConst;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

import woyou.aidlservice.jiuiv5.IWoyouService;

/**
 * Created by Amrish on 04-12-2020.
 */
public class SunmiPrinter {
    private Context context;
    public IWoyouService woyouService;
    private RestaurantUser loggedInRestaurant = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();
    private MyApp myApp = MyApp.getInstance();

    ServiceConnection connService = new ServiceConnection() {

        @Override
        public void onServiceDisconnected(ComponentName name) {
            woyouService = null;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            woyouService = IWoyouService.Stub.asInterface(service);
        }
    };

    public SunmiPrinter(Context context) {
        this.context = context;
        startService(context);

    }

    private void startService(Context context) {
        Intent intent = new Intent();
        intent.setPackage("woyou.aidlservice.jiuiv5");
        intent.setAction("woyou.aidlservice.jiuiv5.IWoyouService");
        context.startService(intent);//Start printer service
        context.bindService(intent, connService, Context.BIND_AUTO_CREATE);
    }

    //not in use
    public void printCardReaderReceipt(Bitmap bm, String title, String header, int headerAlignment, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        if (bm != null)
            AidlUtil.getInstance().printBitmap(bm);
        AidlUtil.getInstance().printText(header, 32, true, false, headerAlignment);
        AidlUtil.getInstance().printText(title, 40, true, false, 1);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 0);
        if (!Validators.isNullOrEmpty(tip_amount)) {
            AidlUtil.getInstance().printText(actual_amount, 36, true, false, 1);
            AidlUtil.getInstance().printText(tip_amount, 36, true, false, 1);
        }
        AidlUtil.getInstance().printText(grand_total, 52, true, false, 1);
        AidlUtil.getInstance().printText(main_content, 22, true, false, 0);
        AidlUtil.getInstance().printText(please, 22, true, false, 1);
        AidlUtil.getInstance().printText(final_date, 22, true, false, 0);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 0);
        AidlUtil.getInstance().printText(footer, 32, true, false, 1);
        AidlUtil.getInstance().printText(footer1, 32, true, false, 1);
        AidlUtil.getInstance().CutPaper();

    }

    public void printCardReaderReceipt(Bitmap bm, String rePrintTitle, String title, String header, String header1, String address, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        if (bm != null)
            AidlUtil.getInstance().printBitmap(bm);
        AidlUtil.getInstance().printText(header, 32, true, false, 1);
        AidlUtil.getInstance().printText(header1, 32, true, false, 1);
        AidlUtil.getInstance().printText(address, 26, true, false, 1);
        if (!Validators.isNullOrEmpty(rePrintTitle)) {
            AidlUtil.getInstance().printText(rePrintTitle, 40, true, false, 1);
        }
        AidlUtil.getInstance().printText(title, 40, true, false, 1);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 0);
        if (!Validators.isNullOrEmpty(tip_amount)) {
            AidlUtil.getInstance().printText(actual_amount, 36, true, false, 1);
            AidlUtil.getInstance().printText(tip_amount, 36, true, false, 1);
        }
        AidlUtil.getInstance().printText(grand_total, 52, true, false, 1);
        AidlUtil.getInstance().printText(main_content, 22, true, false, 0);
        AidlUtil.getInstance().printText(please, 22, true, false, 1);
        AidlUtil.getInstance().printText(final_date, 22, true, false, 0);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 0);
        AidlUtil.getInstance().printText(footer, 32, true, false, 1);
        AidlUtil.getInstance().printText(footer1, 32, true, false, 1);
        AidlUtil.getInstance().CutPaper();

    }

    public void printCardReaderReceiptV2s(Bitmap bm, String title, String header, String header1, String address, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        try {
            if (SunmiPrintHelper.getInstance() != null) {
                if (bm != null)
                    SunmiPrintHelper.getInstance().printBitmap(bm);
                SunmiPrintHelper.getInstance().printText(header, 32, true, false, null);
                SunmiPrintHelper.getInstance().printText(header1, 32, true, false, null);
                SunmiPrintHelper.getInstance().printText(address, 26, true, false, null);
                SunmiPrintHelper.getInstance().printText(title, 40, true, false, null);
                SunmiPrintHelper.getInstance().printText("--------------------------------", 24, true, false, null);
                if (!Validators.isNullOrEmpty(tip_amount)) {
                    SunmiPrintHelper.getInstance().printText(actual_amount, 36, true, false, null);
                    SunmiPrintHelper.getInstance().printText(tip_amount, 36, true, false, null);
                }
                SunmiPrintHelper.getInstance().printText(grand_total, 52, true, false, null);
                SunmiPrintHelper.getInstance().printText(main_content, 22, true, false, null);
                SunmiPrintHelper.getInstance().printText(please, 22, true, false, null);
                SunmiPrintHelper.getInstance().printText(final_date, 22, true, false, null);
                SunmiPrintHelper.getInstance().printText("--------------------------------", 24, true, false, null);
                SunmiPrintHelper.getInstance().printText(footer, 32, true, false, null);
                SunmiPrintHelper.getInstance().printText(footer1, 32, true, false, null);
                SunmiPrintHelper.getInstance().feedPaper();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printMotoReceipt(Bitmap bm, String title, String header, String header1, String address, String amount, String main_content, String footer, String footer1) {
        try {
            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            //Bitmap bm = BitmapFactory.decodeResource(MotoPaymentActivity.this.getResources(), R.drawable.tiffintomlogo);
            if (bm != null) {
                woyouService.setAlignment(1, null);
                woyouService.printBitmap(bm, null);
                woyouService.printText("" + Html.fromHtml("<br>"), null);
                woyouService.printText("" + Html.fromHtml("<br>"), null);
            }

            woyouService.setAlignment(1, null);
            woyouService.setFontSize(40, null);
            woyouService.printText("" + Html.fromHtml(header), null);
            woyouService.printText("" + Html.fromHtml(header1), null);
            woyouService.setAlignment(1, null);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml(address), null);

            woyouService.setAlignment(2, null);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml(title), null);
            woyouService.setAlignment(0, null);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            woyouService.setAlignment(1, null);
            woyouService.setFontSize(50, null);
            woyouService.printText("" + Html.fromHtml(amount), null);
            woyouService.setAlignment(0, null);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml(main_content), null);
            woyouService.setAlignment(0, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            woyouService.setAlignment(1, null);
            woyouService.setFontSize(30, null);
            woyouService.printText("" + Html.fromHtml(footer), null);
            woyouService.printText("" + Html.fromHtml(footer1), null);
            woyouService.printText("" + Html.fromHtml("<br>"), null);
            woyouService.printText("" + Html.fromHtml("<br>"), null);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void printMotoReceiptAidlUtil(Bitmap bm, String title, String header, int headerAlignment, String amount, String main_content, String date_final, String please, String footer, String footer1) {
        if (bm != null)
            AidlUtil.getInstance().printBitmap(bm);
        AidlUtil.getInstance().printText(header, 32, true, false, headerAlignment);
        AidlUtil.getInstance().printText(title, 40, true, false, 1);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 0);

        AidlUtil.getInstance().printText(amount, 52, true, false, 1);
        AidlUtil.getInstance().printText(main_content.replace(" :", ": "), 22, true, false, 0);
        AidlUtil.getInstance().printText(date_final, 22, true, false, 1);
        AidlUtil.getInstance().printText(please, 22, true, false, 1);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 1);
        AidlUtil.getInstance().printText(footer, 32, true, false, 1);
        AidlUtil.getInstance().printText(footer1, 32, true, false, 1);
        AidlUtil.getInstance().CutPaper();
    }

    public void printMotoReceiptAidlUtil(Bitmap bm, String title, String header, String header1, String address, String amount, String main_content, String date_final, String please, String footer, String footer1) {
        if (bm != null)
            AidlUtil.getInstance().printBitmap(bm);
        AidlUtil.getInstance().printText(header, 32, true, false, 1);
        AidlUtil.getInstance().printText(header1, 32, true, false, 1);
        AidlUtil.getInstance().printText(address, 26, true, false, 1);
        AidlUtil.getInstance().printText(title, 40, true, false, 1);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 0);

        AidlUtil.getInstance().printText(amount, 52, true, false, 1);
        AidlUtil.getInstance().printText(main_content.replace(" :", ": "), 22, true, false, 0);
        AidlUtil.getInstance().printText(date_final, 22, true, false, 1);
        AidlUtil.getInstance().printText(please, 22, true, false, 1);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 1);
        AidlUtil.getInstance().printText(footer, 32, true, false, 1);
        AidlUtil.getInstance().printText(footer1, 32, true, false, 1);
        AidlUtil.getInstance().CutPaper();

    }

    public void printReservation(Context context, Reservation reservation) {
        try {
            woyouService.sendRAWData(ESCUtil.boldOn(), null);

            Bitmap bm = null;
            try {
                bm = BitmapFactory.decodeResource(context.getResources(), R.drawable.printer_tiffinotom_logo);
            } catch (Exception e) {
                System.out.println(e);
            }
            if (bm != null) {
                woyouService.setAlignment(1, null);
                woyouService.printBitmap(bm, null);
                woyouService.printText("\n", null);
                woyouService.printText("\n", null);
            }

            woyouService.setAlignment(0, null);//Right
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("<b>" + loggedInRestaurant.restaurant_name + "</b><br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Tel   : " + loggedInRestaurant.restaurant_phone + "</b><br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Email : " + loggedInRestaurant.contact_email + " </b><br>"), null);

            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            if (!Validators.isNullOrEmpty(reservation.booking_date) && !Validators.isNullOrEmpty(reservation.booking_time)) {
                woyouService.setAlignment(1, null);//Right
                woyouService.setFontSize(24, null);
                woyouService.printText("" + Html.fromHtml("<strong>" + reservation.booking_date + "/" + reservation.booking_time + "</strong> <br>"), null);
            }
            woyouService.setAlignment(1, null);//Right
            woyouService.setFontSize(24, null);
            woyouService.printText("" + Html.fromHtml("<strong>" + reservation.booking_id + "</strong> <br>"), null);

            woyouService.setAlignment(0, null);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Customer Name     : " + reservation.customer_name + "</b><br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Guest Count       : " + reservation.guest_count + "</b><br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Booking Email     : " + reservation.booking_email + "</b><br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Booking Phone     : " + reservation.booking_phone + "</b><br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Booking Status    : " + reservation.status + "</b><br>"), null);
            if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                woyouService.printText("" + Html.fromHtml("<b>Reason            : " + reservation.cancel_reason + "</b><br>"), null);
            }
            woyouService.printText("" + Html.fromHtml("<b>Booking Date/Time : " + reservation.booking_date + " / " + reservation.booking_time + "</b><br>"), null);

            woyouService.printText("" + Html.fromHtml("<b>Instructions      : " + reservation.booking_instruction + "</b><br>"), null);
            woyouService.printText("" + Html.fromHtml("<br>"), null);

            woyouService.printText("" + Html.fromHtml("<br>"), null);

            woyouService.printText("" + Html.fromHtml("<br>"), null);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void printMerchantPaymentReport(TransactionSummary transactionSummary, Bitmap bm, String header_a, String header_b, String footer_a, String footer_b) {
        if (bm != null) {
            AidlUtil.getInstance().printBitmap(bm);
        }
        AidlUtil.getInstance().printText(header_a, 32, true, false, 1);
        AidlUtil.getInstance().printText(header_b, 32, true, false, 1);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 1);
        AidlUtil.getInstance().printText("Tiffintom Partner", 44, true, false, 1);
        AidlUtil.getInstance().printText("Transaction Report", 36, true, false, 1);
        if (!Validators.isNullOrEmpty(transactionSummary.date_range)) {
            AidlUtil.getInstance().printText("\n", 26, true, false, 0);
            AidlUtil.getInstance().printText(transactionSummary.date_range, 26, true, false, 0);
        }
        AidlUtil.getInstance().printText("\n", 26, true, false, 0);
        AidlUtil.getInstance().printText("Total Transaction   :" + transactionSummary.totalTransaction, 26, true, false, 0);
        AidlUtil.getInstance().printText("Total Refund\nAmount              :" + MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(transactionSummary.totalRefundAmount), 26, true, false, 0);
        AidlUtil.getInstance().printText("Total Refund\nTransactions        :" + transactionSummary.totalRefundTransactions, 26, true, false, 0);
        AidlUtil.getInstance().printText("Total Successful\nAmount              :" + MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(transactionSummary.totalSuccessfulAmount), 26, true, false, 0);
        AidlUtil.getInstance().printText("Total Successful\nTransactions        :" + transactionSummary.totalSuccessfulTransactions, 26, true, false, 0);
//        AidlUtil.getInstance().printText("Total Pending\nTransactions        :" + transactionSummary.totalPendingTransactions, 26, true, false, 0);
//        AidlUtil.getInstance().printText("Total Pending       :" + MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(transactionSummary.totalPending), 26, true, false, 0);
//        AidlUtil.getInstance().printText("Total Failed\nTransactions        :" + transactionSummary.totalFailedTransactions, 26, true, false, 0);
//        AidlUtil.getInstance().printText("Total Failed        :" + MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(transactionSummary.totalFailed), 26, true, false, 0);
        AidlUtil.getInstance().printText("--------------------------------", 24, true, false, 1);
        AidlUtil.getInstance().printText(footer_a, 32, true, false, 1);
        AidlUtil.getInstance().printText(footer_b, 32, true, false, 1);
        AidlUtil.getInstance().print3Line();
        AidlUtil.getInstance().CutPaper();
    }

    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);

    public void printOrder(Bitmap tiffintomBitmap, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }

        formatter.applyPattern("00.00");
        try {
            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            if (!orderTiffinTomLogo) {
                if (tiffintomBitmap != null) {
                    woyouService.setAlignment(1, null);
                    woyouService.printBitmap(tiffintomBitmap, null);
                    woyouService.printText("\n", null);
                }
            } else {
                if (businessLogo != null) {
                    woyouService.setAlignment(1, null);
                    woyouService.printBitmap(businessLogo, null);
                    woyouService.printText("\n", null);
                }
            }
            String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
            String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd-MM-yyyy");
            if (!todayDate.equalsIgnoreCase(orderDateString)) {
                woyouService.setFontSize(40, null);
                woyouService.setAlignment(1, null);//Right
                woyouService.printText("This Order Is Not For Today\n\n", null);
            }

            //woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.setAlignment(1, null);//Right
            woyouService.setFontSize(20, null);
            woyouService.printText("\n\n", null);

            //woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.printText("Tiffintom.com sent you order\n\n", null);

            woyouService.setAlignment(0, null);//Right
            woyouService.setFontSize(36, null);
            woyouService.printText(CommonFunctions.getOrderType(orderType) + "\n", null);

            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            woyouService.setFontSize(36, null);
            woyouService.printText("ORDER NO: " + orderDetail.order_number + "\n", null);

            if (orderType > 0) {
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    woyouService.printText("ASAP" + "\n", null);
                } else {
                    woyouService.printText(CommonFunctions.convertTimeFormat(orderDetail.delivery_time) + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd-MM-yyyy") + "\n", null);
                }
            }
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            if (kitchenCopy)
                woyouService.setFontSize(36, null);
            else woyouService.setFontSize(24, null);

            String itemName = "", price = "", qty = "";
            for (OrderProductDetail productDetail : orderDetail.cart_view) {
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                String productQty = String.valueOf(productDetail.quantity);
                String totalPrice = String.valueOf(productDetail.total_price);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
                itemName = getProductNameWithPad(productName, price, 16);
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                String printItem;
                printItem = qty + itemName + "\n";
                int fontSize = 30;
                if (kitchenCopy) fontSize = 36;
                woyouService.setFontSize(fontSize, null);
                woyouService.printText(printItem, null);

                if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                    try {
                        //String[] parts = menus.get(position).getSubaddonsName().split(",");
                        String[] parts = productDetail.subaddons_name.split(",");

                        for (String subAddonPart : parts) {
                            int fontSizeSub = 30;
                            int charactersInLine = 20;
                            if (kitchenCopy) {
                                fontSizeSub = 36;
                                charactersInLine = 16;
                            }
                            String printedItem = getSubaddonWithPad(subAddonPart, charactersInLine);
                            woyouService.setFontSize(fontSizeSub, null);
                            woyouService.printText(printedItem, null);

                        }
                    } catch (Exception e) {
                        Log.e("Addon_Error", e.getMessage());
                    }
                }
            }
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            woyouService.setFontSize(23, null);
            woyouService.printText(padRightSpaces("SubTotal:", 16) + myApp.getCurrencySymbol() + MyApp.df.format(orderDetail.order_sub_total) + "\n", null);

            if (orderDetail.delivery_charge > 0) {
                woyouService.printText(padRightSpaces("Delivery Charge:", 16) + myApp.getCurrencySymbol() + MyApp.df.format(orderDetail.delivery_charge) + "\n", null);
            }
            if (orderDetail.offer_amount > 0) {
                woyouService.printText(padRightSpaces("Offer:", 16) + myApp.getCurrencySymbol() + MyApp.df.format(orderDetail.offer_amount) + "\n", null);
            }
            if (orderDetail.service_charge > 0) {
                if (!"no".equalsIgnoreCase(loggedInRestaurant.service_charge_status)) {
                    woyouService.printText(padRightSpaces("Service Charge:", 16) + myApp.getCurrencySymbol() + MyApp.df.format(orderDetail.service_charge) + "\n", null);
                }
            }
            if (orderDetail.driver_tip > 0) {
                woyouService.printText(padRightSpaces("Driver Tip:", 16) + myApp.getCurrencySymbol() + MyApp.df.format(orderDetail.driver_tip) + "\n", null);
            }
            if (orderDetail.reward_offer > 0) {
                woyouService.printText(padRightSpaces("Loyalty Point Discount:", 34) + myApp.getCurrencySymbol() + MyApp.df.format(orderDetail.reward_offer) + "\n", null);
            }
            woyouService.setFontSize(36, null);
            if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                    if (surChargesModel.surcharge_amount > 0) {
                        woyouService.printText(padRightSpaces(surChargesModel.surcharge_name, 16) + myApp.getCurrencySymbol() + MyApp.df.format(surChargesModel.surcharge_amount) + "\n", null);
                    }
                }
            }
            woyouService.printText("Grand Total:  " + myApp.getCurrencySymbol() + MyApp.df.format(orderDetail.order_grand_total) + "\n", null);

            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            if (!Validators.isNullOrEmpty(orderDetail.order_description)) {

                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.setFontSize(33, null);
                woyouService.printText("Comments:" + orderDetail.order_description + "\n", null);
                woyouService.sendRAWData(ESCUtil.boldOff(), null);

                woyouService.setFontSize(20, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            }

            woyouService.setFontSize(33, null);
            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.printText("Cust Name: " + orderDetail.customer_name + "\n", null);

            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                woyouService.printText("Cust No: " + orderDetail.customer_phone + "\n", null);
            }
            woyouService.sendRAWData(ESCUtil.boldOff(), null);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            if (orderType == 1) {

                String address = orderDetail.address + "\n";
                String[] parts = address.split("[\\\\s,]+");
                StringBuilder str = new StringBuilder();

                for (String name : parts) {
                    str.append(name).append("\n");
                }
                woyouService.setFontSize(33, null);
                woyouService.sendRAWData(ESCUtil.boldOn(), null);

                woyouService.printText("Del. address: " + address, null);
                woyouService.sendRAWData(ESCUtil.boldOff(), null);

                woyouService.setFontSize(20, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            }

            if (orderType >= 0) {

                if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                    woyouService.setFontSize(36, null);
                    woyouService.printText("Confirmed for: ", null);
                    woyouService.printText("" + orderDetail.preparation + "\n", null);
                    woyouService.setFontSize(20, null);
                    woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
                }
            }

            woyouService.setFontSize(36, null);
            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.printText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", null);
            woyouService.sendRAWData(ESCUtil.boldOff(), null);


            woyouService.setFontSize(22, null);
            String paymentName = "";
            if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
            if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
            if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                paymentName = "WALLET";
            if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";
            woyouService.printText(" Payment Type : " + paymentName + "\n", null);

            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            woyouService.sendRAWData(ESCUtil.boldOn(), null);

            woyouService.setFontSize(32, null);
            woyouService.printText("Receipt Time:\n", null);
            woyouService.printText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", null);
            woyouService.sendRAWData(ESCUtil.boldOff(), null);

            woyouService.printText("Order status: " + orderDetail.status + "\n", null);
            if (orderDetail.status.equalsIgnoreCase("failed")) {
                woyouService.printText("Reason: " + orderDetail.failed_reason + "\n", null);
            }

            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.setFontSize(28, null);

            woyouService.printText(loggedInRestaurant.restaurant_name + ", " + loggedInRestaurant.contact_address + "\n", null);
            woyouService.printText("Thanks!\n", null);

            woyouService.lineWrap(3, null);
            woyouService.sendRAWData(ESCUtil.cutPaper(), null);

        } catch (Exception e) {
            System.out.println(e);
        }

    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = containsTwoDots(part) ? part.split("::") :part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }
                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(parts1[1].trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }

                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(part.trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();

            }

        }
        return subAddonName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private void writeToFile(String data, Context context) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(context.openFileOutput("print.txt", Context.MODE_PRIVATE));
            outputStreamWriter.write(data);
            outputStreamWriter.close();
        } catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }

    public void printFoodHubFullReport(Bitmap tiffintomLogo, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        try {
            if (tiffintomLogo != null) {
                //AidlUtil.getInstance().printBitmap(tiffintomLogo);
            }
           // AidlUtil.getInstance().printText(header, 32, true, false, headerAlignment);
            if (!Validators.isNullOrEmpty(title))
                AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            if (!Validators.isNullOrEmpty(date)) {
                AidlUtil.getInstance().printText("Date: " + date, 32, true, false, AidlUtil.Alignment.CENTER);
                woyouService.setFontSize(20, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            }
            if (!Validators.isNullOrEmpty(user)) {
                AidlUtil.getInstance().printText("User name: " + user, 32, true, false, AidlUtil.Alignment.CENTER);
                woyouService.setFontSize(20, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            }
            woyouService.setFontSize(20, null);
            AidlUtil.getInstance().printText(reportHeader(AidlUtil.Size.SIZE0), 20, true, false, AidlUtil.Alignment.CENTER);
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            woyouService.setFontSize(20, null);
            for (Object objct : data) {
                if (objct instanceof ReportTextModel) {
                    ReportTextModel textModel = (ReportTextModel) objct;

                    String printText;
                    if (!textModel.isHeader) {
                        if (!Validators.isNullOrEmpty(textModel.value)) {
                            if (textModel.value.contains(MyApp.getInstance().currencySymbol)) {
                                //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                                printText = reportDetail(AidlUtil.Size.SIZE0, "", textModel.value, textModel.title);
                            } else {
                                //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                                printText = reportDetail(AidlUtil.Size.SIZE0, textModel.value, "", textModel.title);
                            }
                        } else {
                            if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(textModel.orderCount)) {
                                printText = reportDetail(AidlUtil.Size.SIZE0, textModel.orderCount, textModel.totalPrice, textModel.title);
                            } else {
                                printText = getProductNameWithPad(textModel.title, "", 35);
                            }
                        }
                    } else {
                        printText = "" + textModel.title;
                    }
                    if (textModel.isHeader) {
                        woyouService.setFontSize(20, null);
                        woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
                        AidlUtil.getInstance().printText(printText, 20, textModel.isHeader, false, AidlUtil.Alignment.LEFT);
                        woyouService.setFontSize(20, null);
                        woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
                    } else {
                        AidlUtil.getInstance().printText(printText, 20, textModel.isHeader, false, AidlUtil.Alignment.LEFT);
                    }

                }
            }
            woyouService.setFontSize(20, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
/*
            AidlUtil.getInstance().printText(footerA, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footerB, 32, true, false, AidlUtil.Alignment.CENTER);*/
            AidlUtil.getInstance().CutPaper();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String reportHeader(float widthSize) {
        String orderTitle = "Orders  ";
        String priceTitle = "   Price";
        float _60Per = widthSize == AidlUtil.Size.SIZE0 ? 22 : 10;
        String orderPriceTitle = "";
        for (int emptySpace = 0; emptySpace < _60Per; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        // 2 space after orders in order to display space between orders and price
        orderPriceTitle = orderPriceTitle + orderTitle + "";
        orderPriceTitle = orderPriceTitle + priceTitle;
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }

    private String reportDetail(float widthSize, String ordersValue, String priceValue, String titleValue) {
        int _60Per = widthSize == AidlUtil.Size.SIZE0 ? 22 : 10;
        String orderPriceTitle = "";
        int titleLength = _60Per - titleValue.length();
        orderPriceTitle = titleValue + "";
        for (int emptySpace = 0; emptySpace < titleLength; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        Log.e("orderPriceTitle", "titleLengthtitleLength " + orderPriceTitle.length());
        // 2 space after orders in order to display space between orders and price
        if (Validators.isNullOrEmpty(ordersValue)) {
            int different = 8 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 8 - ordersValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + ordersValue;
            /*if(ordersValue.length()==1){
                orderPriceTitle =orderPriceTitle+ "   "+ordersValue+"   ";
            }else if(ordersValue.length()==2 || ordersValue.length()==3){
                orderPriceTitle = orderPriceTitle+"  "+ordersValue+"  ";
            }else {
                orderPriceTitle = orderPriceTitle +  ordersValue;
            }*/
        }
        orderPriceTitle = orderPriceTitle + "";
        if (Validators.isNullOrEmpty(priceValue)) {
            int different = 8 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 8 - priceValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + priceValue;
            /*if(priceValue.length()==1){
                orderPriceTitle = orderPriceTitle+"   "+priceValue+"   ";
            }else if(priceValue.length()==2 || priceValue.length()==3){
                orderPriceTitle = orderPriceTitle+"  "+priceValue+"  ";
            }else {
                orderPriceTitle = orderPriceTitle +  priceValue;
            }*/
        }
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }

    boolean containsTwoDots(String str) {
        return str.indexOf(':') != str.lastIndexOf(':');
    }
}
