package com.tiffintom.partner1.common.printer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.models.OrderProductDetail;
import com.tiffintom.partner1.models.ReportTextModel;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.models.SurChargesModel;
import com.tiffintom.partner1.models.TransactionSummary;
import com.tiffintom.partner1.storageutils.MyPreferences;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;
import com.zqprintersdk.PrinterConst;
import com.zqprintersdk.ZQPrinterSDK;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class ZoneRichPrinter {

    public static ZQPrinterSDK prn;
    public int nRet = -1;
    private Activity activity;
    Context context;
    private RestaurantUser loggedInRestaurant = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();

    public ZoneRichPrinter(Activity activity) {
        super();
        this.activity = activity;
        prn = new ZQPrinterSDK();
    }

    public void connectPrinter(String ip) {
        try {
            nRet = prn.Prn_Connect(ip + ":9100", activity);
        } catch (Exception e) {
            LogUtils.e("Zonerich Connection error", e.toString());
            ToastUtils.makeToast(activity, e.toString());
        }
    }

    private void disconnectPrinter() {
        prn.Prn_Disconnect();
    }

    public void printMerchantPaymentReport(TransactionSummary transactionSummary, Bitmap bm, String header_a, String header_b, String footer_a, String footer_b) {
        if (bm != null) {
            prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
            prn.Prn_PrintBitmap(bm, PrinterConst.BitmapSize.ZQSIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        }
        prn.Prn_PrintText(header_a + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(header_b + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("Tiffintom Partner\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        prn.Prn_PrintText("Transaction Report\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        if (!Validators.isNullOrEmpty(transactionSummary.date_range)) {
            prn.Prn_PrintText("\n\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            prn.Prn_PrintText(transactionSummary.date_range, PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        }
        prn.Prn_PrintText("\n\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        prn.Prn_PrintText("Total Transaction              :" + transactionSummary.totalTransaction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        prn.Prn_PrintText("Total Refund Amount            :" + MyApp.df.format(transactionSummary.totalRefundAmount) + " GBP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        prn.Prn_PrintText("Total Refund Transactions      :" + transactionSummary.totalRefundTransactions + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        prn.Prn_PrintText("Total Successful Amount        :" + MyApp.df.format(transactionSummary.totalSuccessfulAmount) + " GBP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        prn.Prn_PrintText("Total Successful Transactions  :" + transactionSummary.totalSuccessfulTransactions + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
//        prn.Prn_PrintText("Total Pending Transactions     :" + transactionSummary.totalPendingTransactions + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
//        prn.Prn_PrintText("Total Pending                  :" + MyApp.df.format(transactionSummary.totalPending) + " GBP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
//        prn.Prn_PrintText("Total Failed Transactions      :" + transactionSummary.totalFailedTransactions + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
//        prn.Prn_PrintText("Total Failed                   :" + MyApp.df.format(transactionSummary.totalFailed) + " GBP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

        prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(footer_a + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(footer_b + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_LineFeed(3);
        prn.Prn_CutPaper();
        disconnectPrinter();
    }

    public void printMotoReceipt(Bitmap bm, String title, String header, int headerAlignment, String amount, String main_content, String date_final, String please, String footer, String footer1) {
        try {
            if (bm != null) {
                prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                prn.Prn_PrintBitmap(bm, PrinterConst.BitmapSize.ZQSIZE0);
                prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (headerAlignment < 2)
                prn.Prn_PrintText(header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            else {
                String[] headers = header.split("\n");
                for (String h : headers) {
                    prn.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            prn.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            amount = amount.replace("£", "");
            amount = amount.replace("\n", "");
            amount = amount + " GBP";

            prn.Prn_PrintText(amount + "\n\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
            prn.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(date_final + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_LineFeed(3);
            prn.Prn_CutPaper();
            disconnectPrinter();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printMotoReceipt(Bitmap bm, String title, String header, String header1, String address, String amount, String main_content, String date_final, String please, String footer, String footer1) {
        try {
            if (bm != null) {
                prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                prn.Prn_PrintBitmap(bm, PrinterConst.BitmapSize.ZQSIZE0);
                prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            prn.Prn_PrintText(header + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(header1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(address + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            prn.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            amount = amount.replace("£", "");
            amount = amount.replace("\n", "");
            amount = amount + " GBP";

            prn.Prn_PrintText(amount + "\n\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
            prn.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(date_final + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_LineFeed(3);
            prn.Prn_CutPaper();
            disconnectPrinter();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printCardReaderReceipt(Bitmap tiffintomLogo, String title, String header, int headerAlignment, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        if (tiffintomLogo != null) {
            prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
            prn.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        }
        prn.Prn_PrintText(header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

        prn.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

        prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        if (!Validators.isNullOrEmpty(tip_amount)) {
            actual_amount = actual_amount.replace("£", "");
            actual_amount = actual_amount + " GBP";
            prn.Prn_PrintText(actual_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);

            tip_amount = tip_amount.replace("£", "");
            tip_amount = tip_amount + " GBP";
            prn.Prn_PrintText(tip_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
        }
        grand_total = grand_total.replace("£", "");
        grand_total = grand_total + " GBP";

        prn.Prn_PrintText(grand_total + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        prn.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(final_date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_LineFeed(3);
        prn.Prn_CutPaper();
        disconnectPrinter();
    }

    public void printCardReaderReceipt(Bitmap tiffintomLogo, String rePrintTitle, String title, String header, String header1, String address, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        if (tiffintomLogo != null) {
            prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
            prn.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        }
        if (!Validators.isNullOrEmpty(header)) {
            prn.Prn_PrintText(header + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        if (!Validators.isNullOrEmpty(header1)) {
            prn.Prn_PrintText(header1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        if (!Validators.isNullOrEmpty(address)) {
            prn.Prn_PrintText(address + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        if (!Validators.isNullOrEmpty(rePrintTitle)) {
            prn.Prn_PrintText(rePrintTitle + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        }
        prn.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

        prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        if (!Validators.isNullOrEmpty(tip_amount)) {
            actual_amount = actual_amount.replace("£", "");
            actual_amount = actual_amount + " GBP";
            prn.Prn_PrintText(actual_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);

            tip_amount = tip_amount.replace("£", "");
            tip_amount = tip_amount + " GBP";
            prn.Prn_PrintText(tip_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
        }
        grand_total = grand_total.replace("£", "");
        grand_total = grand_total + " GBP";

        prn.Prn_PrintText(grand_total + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        prn.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(final_date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        prn.Prn_LineFeed(3);
        prn.Prn_CutPaper();
        disconnectPrinter();
    }

    public void printReservation(Reservation reservation, Bitmap tiffintomLogo) {
        RestaurantUser loggedInRestaurant = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();
        try {
            if (tiffintomLogo != null) {
                prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                prn.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            prn.Prn_PrintText(loggedInRestaurant.restaurant_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Tel   : " + loggedInRestaurant.restaurant_phone + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Email : " + loggedInRestaurant.contact_email + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(reservation.booking_date + "/" + reservation.booking_time + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(reservation.booking_id + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Customer name     : " + reservation.customer_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Guest Count       : " + reservation.guest_count + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Booking Email     : " + reservation.booking_email + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Booking Phone     : " + reservation.booking_phone + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Booking Status    : " + reservation.status + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                prn.Prn_PrintText("Reason            : " + reservation.cancel_reason + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            prn.Prn_PrintText("Booking Date/Time : " + reservation.booking_date + "/" + reservation.booking_time + "\n\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Instructions      :" + reservation.booking_instruction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_LineFeed(3);
            prn.Prn_CutPaper();
            disconnectPrinter();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);

    public void printOrder(Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }
        formatter.applyPattern("00.00");
        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomLogo != null) {
                    prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                    prn.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                    prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                }
            } else {
                if (businessLogo != null) {
                    prn.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                    prn.Prn_PrintBitmap(businessLogo, PrinterConst.BitmapSize.ZQSIZE0);
                    prn.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                }
            }
            String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
            String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd-MM-yyyy");
            if (!todayDate.equalsIgnoreCase(orderDateString)) {
                prn.Prn_PrintText("This order is not for today" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
            }
            prn.Prn_PrintText("Tiffintom.com sent you order\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            prn.Prn_PrintText(CommonFunctions.getOrderType(orderType) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("ORDER NO:" + orderDetail.order_number + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            if (orderType > 0) {
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    prn.Prn_PrintText("ASAP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                } else {
                    prn.Prn_PrintText(CommonFunctions.convertTimeFormat(orderDetail.delivery_time) + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd-MM-yyyy") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                }
                prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }
            String itemName = "", price = "", qty = "";
            for (OrderProductDetail productDetail : orderDetail.cart_view) {
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                String productQty = String.valueOf(productDetail.quantity);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
                if (kitchenCopy)
                    itemName = getProductNameWithPad(productName, price, 20);
                else
                    itemName = getProductNameWithPad(productName, price, 35);
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                String printItem;
                printItem = qty + itemName + "\n";
                if (!kitchenCopy)
                    prn.Prn_PrintText(printItem, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                else
                    prn.Prn_PrintText(printItem, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);

                if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                    try {
                        //String[] parts = menus.get(position).getSubaddonsName().split(",");
                        String[] parts = productDetail.subaddons_name.split(",");

                        for (String subAddonPart : parts) {
                            if (!kitchenCopy) {
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                prn.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                            } else {
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                prn.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                            }
                        }
                    } catch (Exception e) {
                        Log.e("Addon_Error", e.getMessage());
                    }
                }
            }
            prn.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (orderDetail.delivery_charge > 0) {
                prn.Prn_PrintText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.offer_amount > 0) {
                prn.Prn_PrintText(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.service_charge > 0) {
                if (!"no".equalsIgnoreCase(loggedInRestaurant.service_charge_status)) {
                    prn.Prn_PrintText(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (orderDetail.driver_tip > 0) {
                prn.Prn_PrintText(padRightSpaces("Driver Tip:", 20) + MyApp.df.format(orderDetail.driver_tip) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.reward_offer > 0) {
                prn.Prn_PrintText(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if(orderDetail.surcharges!=null && !orderDetail.surcharges.isEmpty()){
                for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                    if (surChargesModel.surcharge_amount > 0) {
                        prn.Prn_PrintText(padRightSpaces(surChargesModel.surcharge_name, 20) + MyApp.df.format(surChargesModel.surcharge_amount) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            }
            prn.Prn_PrintText("Grand Total: " + MyApp.df.format(orderDetail.order_grand_total) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            prn.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                prn.Prn_PrintText("Comments:" + orderDetail.order_description + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                prn.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            prn.Prn_PrintText("Cust Name:" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                prn.Prn_PrintText("Cust No:" + orderDetail.customer_phone + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            prn.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (orderType == 1) {

                String address = orderDetail.address + "\n";
                String[] parts = address.split("[\\\\s,]+");
                StringBuilder str = new StringBuilder();

                for (String name : parts) {
                    str.append(name).append("\n");
                }
                prn.Prn_PrintText("Del. address:" + address + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                prn.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (orderType >= 0) {

                if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                    prn.Prn_PrintText("Confirmed for:" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    prn.Prn_PrintText(orderDetail.preparation + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                }
                prn.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }
            prn.Prn_PrintText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);

            String paymentName = "";
            if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
            if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
            if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                paymentName = "WALLET";
            if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";

            prn.Prn_PrintText("Payment Type:  " + paymentName + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            prn.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("Receipt Time:\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            prn.Prn_PrintText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            prn.Prn_PrintText("Order status: " + orderDetail.status + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            if (orderDetail.status.equalsIgnoreCase("failed")) {
                prn.Prn_PrintText("Reason: " + orderDetail.failed_reason + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            }

            prn.Prn_PrintText(MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().restaurant_name + ", " + MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().contact_address + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);

            prn.Prn_PrintText("Thanks!" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            prn.Prn_LineFeed(3);
            prn.Prn_CutPaper();
            prn.Prn_Disconnect();

        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public void printFoodHubFullReport(Bitmap bm, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        ZQPrinterSDK zonerich = prn;
        if (bm != null) {
          /*  zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
            zonerich.Prn_PrintBitmap(bm, PrinterConst.BitmapSize.ZQSIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);*/
        }

       /* if (headerAlignment < 2)
            zonerich.Prn_PrintText(header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        else {
            String[] headers = header.split("\n");
            for (String h : headers) {
                zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
        }*/
        if (!Validators.isNullOrEmpty(title))
            zonerich.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

        if (!Validators.isNullOrEmpty(date)) {
            zonerich.Prn_PrintText("" + date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            //zonerich.Prn_PrintText("" + CommonFunctions.formatMiliToDesireFormat(Calendar.getInstance().getTimeInMillis(),"hh:mm a") + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        //reportHeader(PrinterConst.WidthSize.SIZE0);
        if (!Validators.isNullOrEmpty(user)) {
            zonerich.Prn_PrintText("User name: " + user + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        zonerich.Prn_PrintText(reportHeader(PrinterConst.WidthSize.SIZE0) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        for (Object objct : data) {
            if (objct instanceof ReportTextModel) {
                ReportTextModel textModel = (ReportTextModel) objct;

                String printText;
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.getInstance().currencySymbol)) {
                            //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                            printText = reportDetail(PrinterConst.WidthSize.SIZE0, "", textModel.value, textModel.title);
                        } else {
                            //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                            printText = reportDetail(PrinterConst.WidthSize.SIZE0, textModel.value, "", textModel.title);
                        }
                    } else {
                        if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(textModel.orderCount)) {
                            printText = reportDetail(PrinterConst.WidthSize.SIZE0, textModel.orderCount, textModel.totalPrice, textModel.title);
                        } else {
                            printText = getProductNameWithPad(textModel.title, "", 35);
                        }
                    }
                } else {
                    printText = textModel.title;
                }
                if (textModel.isHeader) {
                    zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
        }

        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
    /*    zonerich.Prn_PrintText(footerA + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(footerB + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);*/
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_LineFeed(3);
        zonerich.Prn_CutPaper();
        disconnectPrinter();
    }

    private String reportHeader(int widthSize) {
        String orderTitle = "Orders  ";
        String priceTitle = "   Price";
        int lengthForSize = widthSize == PrinterConst.WidthSize.SIZE0 ? 48 : 24;
        float _60Per = widthSize == PrinterConst.WidthSize.SIZE0 ? 32 : 10;
        String orderPriceTitle = "";
        for (int emptySpace = 0; emptySpace < _60Per; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        // 2 space after orders in order to display space between orders and price
        orderPriceTitle = orderPriceTitle + orderTitle + "";
        orderPriceTitle = orderPriceTitle + priceTitle;
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }

    private String reportDetail(int widthSize, String ordersValue, String priceValue, String titleValue) {
        int _60Per = widthSize == PrinterConst.WidthSize.SIZE0 ? 28 : 10;
        String orderPriceTitle = "";
        int titleLength = _60Per - titleValue.length();
        orderPriceTitle = titleValue + "";
        for (int emptySpace = 0; emptySpace < titleLength; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        Log.e("orderPriceTitle", "titleLengthtitleLength " + orderPriceTitle.length());
        // 2 space after orders in order to display space between orders and price
        if (Validators.isNullOrEmpty(ordersValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - ordersValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + ordersValue;
        }
        orderPriceTitle = orderPriceTitle + "";
        if (Validators.isNullOrEmpty(priceValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - priceValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + priceValue;
            /*if(priceValue.length()==1){
                orderPriceTitle = orderPriceTitle+"   "+priceValue+"   ";
            }else if(priceValue.length()==2 || priceValue.length()==3){
                orderPriceTitle = orderPriceTitle+"  "+priceValue+"  ";
            }else {
                orderPriceTitle = orderPriceTitle +  priceValue;
            }*/
        }
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = containsTwoDots(part) ? part.split("::") :part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }
                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(parts1[1].trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }

                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(part.trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();

            }

        }
        return subAddonName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }

    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    boolean containsTwoDots(String str) {
        return str.indexOf(':') != str.lastIndexOf(':');
    }
}
