package com.tiffintom.partner1.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.tiffintom.partner1.models.CardBrandCommission;
import com.tiffintom.partner1.models.CountryCommission;

import java.util.List;

@Dao
public interface CommissionDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertCardBrands(List<CardBrandCommission> cardBrandCommissions);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertCountryCommissions(List<CountryCommission> countryCommissions);

    @Query("SELECT * FROM CardBrandCommission")
    public List<CardBrandCommission> listBrand();

    @Query("SELECT * FROM CountryCommission")
    public List<CountryCommission> listCountry();

    @Query("DELETE FROM CountryCommission")
    void nukeCountryCommission();

    @Query("DELETE FROM CardBrandCommission")
    void nukeCardBrandCommission();
}
