package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.textfield.MaterialAutoCompleteTextView;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CategoryAutoSuggestedAdapter;
import com.tiffintom.partner1.adapters.SubVarientListAdapter;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.Addon;
import com.tiffintom.partner1.models.Categories;
import com.tiffintom.partner1.models.EditSubAddon;
import com.tiffintom.partner1.models.SubAddon;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AddOrEditMenuAddonDialogFragment extends BaseBottomSheet {
    private MaterialButton btnConfirm, btnCancel;
    private DialogDismissListener deletedialogDismissListener, editdialogDismissListener;
    private SwitchCompat switchCategory;
    private TextView tvSwitch, tvTitle;
    private AppCompatEditText etMaxCount, etMinCount, etAddonName, etAddonAdmin;
    private AutoCompleteTextView tvSortOrder;
    private AppCompatEditText etSort;
    private MaterialAutoCompleteTextView etCategory;
    private Addon mainAddon;
    private LinearLayout llEdit, llAdd;
    private MaterialButton btnDelete;
    private RecyclerView rvPriceVariant;
    private ArrayList<SubAddon> subAddons = new ArrayList<>();
    private SubVarientListAdapter listAdapter;
    private ArrayList<Categories> categories = new ArrayList<>();
    private ArrayAdapter<Categories> autoadapter;
    private int selectedCategoryId = -1;
    private int min;
    private int max, sort = 0;

    public static AddOrEditMenuAddonDialogFragment getInstance(Addon addon) {
        AddOrEditMenuAddonDialogFragment fragment = new AddOrEditMenuAddonDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("addon_data", new Gson().toJson(addon));
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setDialogDismissListener(DialogDismissListener editdialogDismissListener, DialogDismissListener deletedialogDismissListener) {
        this.editdialogDismissListener = editdialogDismissListener;
        this.deletedialogDismissListener = deletedialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        try {
            if (getArguments() != null) {
                mainAddon = new Gson().fromJson(getArguments().getString("addon_data"), Addon.class);
            }
            fetchCategory();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return inflater.inflate(R.layout.fragment_add_addon_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initViews(view);
        updateViews();
    }

    private void updateViews() {
        try {
            if (mainAddon != null) {
                etCategory.setText(mainAddon.category_name);
                etAddonAdmin.setText(mainAddon.admin_name);
                etAddonName.setText(mainAddon.mainaddons_name);
                etMinCount.setText(mainAddon.mainaddons_mini_count);
                etMaxCount.setText(mainAddon.mainaddons_count);
                etSort.setText(mainAddon.sortorder);
                if (mainAddon.status.equalsIgnoreCase("true")) {
                    tvSwitch.setText("Active");
                    tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.chip_green_color));
                    switchCategory.setChecked(true);
                } else {
                    tvSwitch.setText("Inactive");
                    tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.reject_color));
                    switchCategory.setChecked(false);
                }
                subAddons.clear();
                for (SubAddon sub : mainAddon.sub_addonses) {
                    sub.selected = true;
                    subAddons.add(sub);
                }

                listAdapter.notifyDataSetChanged();
                tvTitle.setVisibility(View.GONE);
                llEdit.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    @Override
    protected void setListeners() {
        super.setListeners();
        etMinCount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                try {
                    if (!Validators.isNullOrEmpty(etMinCount.getText().toString())) {
                        min = Integer.parseInt(etMinCount.getText().toString());
                    }
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });

        etMaxCount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                try {
                    if (!Validators.isNullOrEmpty(etMaxCount.getText().toString())) {
                        max = Integer.parseInt(etMaxCount.getText().toString());
                    }
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        etSort.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                try {
                    if (!Validators.isNullOrEmpty(etSort.getText().toString())) {
                        sort = Integer.parseInt(etSort.getText().toString());
                    }
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });

        switchCategory.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) {
                tvSwitch.setText("Active");
                tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.chip_green_color));
            } else {
                tvSwitch.setText("Inactive");
                tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.reject_color));
            }
        });

        btnCancel.setOnClickListener(view -> {
            dismiss();
        });

        btnConfirm.setOnClickListener(view -> {
            if (isValid()) {
                EditSubAddon addon = new EditSubAddon();
                if (mainAddon != null && selectedCategoryId == -1) {
                    selectedCategoryId = Integer.parseInt(mainAddon.category_id);
                    addon.id = mainAddon.id;
                }
                addon.restaurant_id = myApp.getMyPreferences().getLoggedInRestaurant().id;
                addon.category_id = selectedCategoryId;
                addon.category_name = etCategory.getText().toString();
                addon.admin_name = etAddonAdmin.getText().toString();
                addon.mainaddons_name = etAddonName.getText().toString();
                addon.mainaddons_mini_count = etMinCount.getText().toString();
                addon.mainaddons_count = etMaxCount.getText().toString();
                addon.sortorder = etSort.getText().toString();
                if (tvSwitch.getText().toString().equalsIgnoreCase("active")) {
                    addon.status = "1";
                } else {
                    addon.status = "0";
                }
                if (subAddons != null && subAddons.size() > 0) {
                    for (SubAddon subAddon : subAddons) {
                        HashMap<String, String> map = new HashMap<>();
                        if (subAddon.id > 0)
                            map.put("id", String.valueOf(subAddon.id));
                        if (subAddon.mainaddons_id > 0)
                            map.put("mainaddons_id", String.valueOf(subAddon.mainaddons_id));
                        map.put("category_id", String.valueOf(selectedCategoryId));
                        map.put("subaddons_name", subAddon.subaddons_name);
                        map.put("subaddons_price", (subAddon.subaddons_price));
                        map.put("delete_status", String.valueOf(subAddon.delete_status));
                        if (subAddon.selected)
                            addon.sub_addons.add(map);
                    }
                }
                if (editdialogDismissListener != null)
                    editdialogDismissListener.onDialogDismiss(addon);
                dismiss();
            }
        });

        btnDelete.setOnClickListener(view -> {
            if (deletedialogDismissListener != null) {
                deletedialogDismissListener.onDialogDismiss(mainAddon);
            }
            dismiss();
        });

        llAdd.setOnClickListener(view -> {
            AddPriceVariantDialogFragment dialogFragment = AddPriceVariantDialogFragment.getInstance(null, "Add Sub Addon");
            dialogFragment.show(getChildFragmentManager(), "add_subaddon");
            dialogFragment.setCancelable(false);
            dialogFragment.setDialogDismissListener(o -> {
                SubAddon addon = (SubAddon) o;

                subAddons.add(addon);
                listAdapter.notifyDataSetChanged();
            });
        });
    }

    private boolean isValid() {
        etCategory.setError(null);
        etAddonAdmin.setError(null);
        etAddonName.setError(null);
        etMinCount.setError(null);
        etMaxCount.setError(null);

        if (Validators.isNullOrEmpty(etCategory.getText().toString())) {
            etCategory.setError("Please enter category name");
            etCategory.requestFocus();
            return false;
        }
        if (Validators.isNullOrEmpty(etAddonAdmin.getText().toString())) {
            etAddonAdmin.setError("Please enter addon admin name");
            etAddonAdmin.requestFocus();
            return false;
        }
        if (Validators.isNullOrEmpty(etAddonName.getText().toString())) {
            etAddonName.setError("Please enter addon name");
            etAddonName.requestFocus();
            return false;
        }
        if (Validators.isNullOrEmpty(etMinCount.getText().toString())) {
            etMinCount.setError("Please enter minimum count");
            etMinCount.requestFocus();
            return false;
        }
        if (Validators.isNullOrEmpty(etMaxCount.getText().toString())) {
            etMaxCount.setError("Please enter maximum count");
            etMaxCount.requestFocus();
            return false;
        }
        if (min > max) {
            etMinCount.setError("Minimum count should be less then maximum count");
            etMinCount.requestFocus();
            return false;
        }
        if (max < min) {
            etMaxCount.setError("Maximum count should be greater then minimum count");
            etMaxCount.requestFocus();
            return false;
        }
        if (Validators.isNullOrEmpty(etSort.getText().toString()) && sort == 0) {
            ToastUtils.makeToast(getActivity(), "Please enter Sort order");
            return false;
        }

        if (subAddons.size() == 0) {
            ToastUtils.makeToast(getActivity(), "Please add atleast one subaddon");
            llAdd.performClick();
            return false;
        }
        return true;
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        switchCategory = view.findViewById(R.id.switchCategory);
        tvSwitch = view.findViewById(R.id.tvSwitchStatus);
        btnCancel = view.findViewById(R.id.btnCancel);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        btnDelete = view.findViewById(R.id.btnDelete);
        etCategory = view.findViewById(R.id.etCategory);
        etAddonAdmin = view.findViewById(R.id.etAddonAdmin);
        etAddonName = view.findViewById(R.id.etAddonName);
        etMinCount = view.findViewById(R.id.etMinCount);
        etMaxCount = view.findViewById(R.id.etMaxCount);
        etSort = view.findViewById(R.id.etSortOrder);
        tvTitle = view.findViewById(R.id.tvTitle);
        llEdit = view.findViewById(R.id.llEdit);
        llAdd = view.findViewById(R.id.llAdd);
        rvPriceVariant = view.findViewById(R.id.rvPriceVariant);


        etCategory.setOnItemClickListener((adapterView, view1, i, l) -> {
            int indext = categories.indexOf(adapterView.getItemAtPosition(i));
            if (indext != -1) {
                selectedCategoryId = Integer.parseInt(categories.get(indext).id);
                LogUtils.e("Category name is::" + categories.get(indext).category_name + "and id::" + selectedCategoryId);
            }

        });


        listAdapter = new SubVarientListAdapter(subAddons, (position, data) -> {
            //Edit click
            SubAddon addon = (SubAddon) data;
            AddPriceVariantDialogFragment dialogFragment = AddPriceVariantDialogFragment.getInstance(addon, "Edit Addon");
            dialogFragment.show(getChildFragmentManager(), "add price variant");
            dialogFragment.setDialogDismissListener(o -> {
                SubAddon subAddon = (SubAddon) o;
                subAddons.get(position).subaddons_name = subAddon.subaddons_name;
                subAddons.get(position).subaddons_price = subAddon.subaddons_price;
/*
                if (subAddons.get(position).position == position) {
                    subAddons.remove(position);
                    subAddons.add(subAddon);
                }
*/
                listAdapter.notifyDataSetChanged();
            });
        }, (position, data) -> {
            //Item Click
            SubAddon addon = (SubAddon) data;
            if (!addon.selected) {
                subAddons.remove(position);
                listAdapter.notifyDataSetChanged();
                deleteSubAddon(addon.id);
            }
            LogUtils.e("selected subAddon" + new Gson().toJson(addon));
        });
        rvPriceVariant.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvPriceVariant.setAdapter(listAdapter);

    }

    private void deleteSubAddon(int id) {
        AndroidNetworking.delete(ApiEndPoints.addons + id + "/sub_addon")
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            LogUtils.e("responce", new Gson().toJson(response.toString()));

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        anError.printStackTrace();
                    }


                });
    }

    private void fetchCategory() {
        try {
            AndroidNetworking.get(ApiEndPoints.categories)
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Categories.class, new ParsedRequestListener<List<Categories>>() {
                        @Override
                        public void onResponse(List<Categories> response) {
                            try {
                                categories.clear();
                                categories.addAll(response);
                                etCategory.setThreshold(1);
                                autoadapter = new CategoryAutoSuggestedAdapter(getActivity(), categories);
                                etCategory.setAdapter(autoadapter);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
