package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.Categories;
import com.tiffintom.partner1.utils.ToastUtils;

public class AddOrEditMenuCategoryDialogFragment extends DialogFragment {
    private MaterialButton btnConfirm, btnCancel;
    private DialogDismissListener dialogDismissListener;
    private SwitchCompat switchCategory;
    private TextView tvSwitch, tvTitle;
    private AppCompatEditText etCategory, etDescription;
    private String[] sortorder = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private AutoCompleteTextView tvSortOrder;
    private AppCompatEditText etSort;
    private Categories categories;
    private LinearLayout llEdit,llSortCode;
    private MaterialButton btnDelete;

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    public static AddOrEditMenuCategoryDialogFragment getInstance(Categories categories) {
        AddOrEditMenuCategoryDialogFragment feedbackSubjectBottomSheetFragment = new AddOrEditMenuCategoryDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("category_data", new Gson().toJson(categories));
        feedbackSubjectBottomSheetFragment.setArguments(bundle);
        return feedbackSubjectBottomSheetFragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getArguments() != null) {
            categories = new Gson().fromJson(getArguments().getString("category_data"), Categories.class);
        }
        return inflater.inflate(R.layout.dialog_add_category, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initViews(view);
        setListeners();
        updateViews();
    }

    private void updateViews() {
        if (categories != null) {
            etCategory.setText(categories.category_name);
            etDescription.setText(categories.description);
            etSort.setText(categories.sortorder);
            if (categories.status.equalsIgnoreCase("true")) {
                tvSwitch.setText("Active");
                tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.chip_green_color));
                switchCategory.setChecked(true);
            } else {
                tvSwitch.setText("Inactive");
                tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.reject_color));
                switchCategory.setChecked(false);
            }
            tvTitle.setVisibility(View.GONE);
            llEdit.setVisibility(View.VISIBLE);
            llSortCode.setVisibility(View.VISIBLE);
        }

    }

    private void setListeners() {
        switchCategory.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) {
                tvSwitch.setText("Active");
                tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.chip_green_color));
            } else {
                tvSwitch.setText("Inactive");
                tvSwitch.setTextColor(ContextCompat.getColor(getActivity(), R.color.reject_color));
            }
        });

        btnCancel.setOnClickListener(view -> {
            dismiss();
        });

        btnConfirm.setOnClickListener(view -> {
            if (isValid()) {
                Categories category = new Categories();
                category.category_name = etCategory.getText().toString();
                category.description = etDescription.getText().toString();
                category.sortorder = etSort.getText().toString();
                category.status = tvSwitch.getText().toString();
                if (categories != null) {
                    category.id = categories.id;
                    category.action = "edit";
                }
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(category);
                }
                dismiss();
            }
        });
        btnDelete.setOnClickListener(view -> {
            categories.action = "delete";
            if (dialogDismissListener != null) {
                dialogDismissListener.onDialogDismiss(categories);
            }
            dismiss();
        });
    }

    private boolean isValid() {
        etCategory.setError(null);
        etDescription.setError(null);
        if (Validators.isNullOrEmpty(etCategory.getText().toString())) {
            etCategory.setError("Please enter category name");
            etCategory.requestFocus();
            return false;
        }

/*
        if (Validators.isNullOrEmpty(etDescription.getText().toString())) {
            etDescription.setError("Please enter description name");
            return false;
        }
*/

        /*if (Validators.isNullOrEmpty(etSort.getText().toString())) {
            ToastUtils.makeToast(getActivity(), "Please enter sort order");
            return false;
        }
*/
        return true;
    }

    private void initViews(View view) {

        switchCategory = view.findViewById(R.id.switchCategory);
        tvSwitch = view.findViewById(R.id.tvSwitchStatus);
        btnCancel = view.findViewById(R.id.btnCancel);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        etCategory = view.findViewById(R.id.etCategory);
        etDescription = view.findViewById(R.id.etDescription);
        tvSortOrder = view.findViewById(R.id.tvSortOrder);
        etSort = view.findViewById(R.id.etSortOrder);
        tvTitle = view.findViewById(R.id.tvTitle);
        llEdit = view.findViewById(R.id.llEdit);
        llSortCode = view.findViewById(R.id.llSortCode);
        btnDelete = view.findViewById(R.id.btnDelete);

        ArrayAdapter adapter = new
                ArrayAdapter(getActivity(), android.R.layout.simple_list_item_1, sortorder);

        tvSortOrder.setThreshold(1);
        tvSortOrder.setAdapter(adapter);

    }

}
