package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.models.Header;
import com.tiffintom.partner1.models.SubAddon;
import com.tiffintom.partner1.models.Variants;

import java.util.ArrayList;

public class AddPriceVariantDialogFragment extends DialogFragment {
    private DialogDismissListener dialogDismissListener;
    private AppCompatEditText etName, etAmount;
    private MaterialButton btnCancel, btnConfirm;
    private ArrayList<Header> arrayList = new ArrayList<>();
    private Variants variant;
    private int position;
    private String title;
    private TextView tvTitle;
    private SubAddon subAddon;
    private boolean isVariant = false;

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    public static AddPriceVariantDialogFragment getInstance(Variants variant, int position, boolean isVariant) {
        AddPriceVariantDialogFragment fragment = new AddPriceVariantDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("price_variant", new Gson().toJson(variant));
        bundle.putInt("position", position);
        bundle.putBoolean("is_variant", isVariant);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static AddPriceVariantDialogFragment getInstance(SubAddon addon, String title) {
        AddPriceVariantDialogFragment fragment = new AddPriceVariantDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("addon", new Gson().toJson(addon));
        bundle.putString("title", title);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getArguments() != null) {
            title = getArguments().getString("title");
            isVariant = getArguments().getBoolean("is_variant");
            subAddon = new Gson().fromJson(getArguments().getString("addon"), SubAddon.class);
        }
        return inflater.inflate(R.layout.dialog_add_price_variants, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        if (getArguments() != null) {
            variant = new Gson().fromJson(getArguments().getString("price_variant"), Variants.class);
            position = getArguments().getInt("position");
        }
        initViews(view);
        setListeners();
        updateViews();
    }

    private void updateViews() {
        if (variant != null) {
            etName.setText(variant.sub_name);
            etAmount.setText(variant.orginal_price);
        } else if (subAddon != null) {
            etName.setText(subAddon.subaddons_name);
            etAmount.setText(subAddon.subaddons_price);
        }
    }

    private void setListeners() {
        btnConfirm.setOnClickListener(view -> {
            if (isValid()) {
                if (isVariant) {
                    Variants variants = new Variants();
                    variants.sub_name = etName.getText().toString();
                    variants.orginal_price = etAmount.getText().toString();
                    variants.required = true;
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss(variants);
                        dismiss();
                    }
                } else {
                    SubAddon addon = new SubAddon();
                    addon.subaddons_name = etName.getText().toString();
                    addon.subaddons_price = etAmount.getText().toString();
                    addon.selected = true;
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss(addon);
                        dismiss();
                    }
                }
            }
        });
        btnCancel.setOnClickListener(view -> {
            dismiss();
        });
    }

    private boolean isValid() {
        etName.setError(null);
        etAmount.setError(null);

        if (Validators.isNullOrEmpty(etName.getText().toString())) {
            etName.setError("Please enter sub addon name");
            return false;
        }

        if (Validators.isNullOrEmpty(etAmount.getText().toString()) || etAmount.getText().toString().equalsIgnoreCase("0.00")) {
            etAmount.setError("Please enter amount");
            return false;
        }

        return true;
    }

    private void initViews(View view) {
        etName = view.findViewById(R.id.etName);
        etAmount = view.findViewById(R.id.etAmount);
        btnCancel = view.findViewById(R.id.btnCancel);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        tvTitle = view.findViewById(R.id.tvTitle);

        if (!Validators.isNullOrEmpty(title))
            tvTitle.setText(title);
        else
            tvTitle.setText("Add Price Variant");
        etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));


    }


}
