package com.tiffintom.partner1.fragments;

import static com.tiffintom.partner1.utils.Constants.CODE_IMAGE_PICKER;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.bumptech.glide.Glide;
import com.github.dhaval2404.imagepicker.ImagePicker;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.textfield.MaterialAutoCompleteTextView;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.makeramen.roundedimageview.RoundedImageView;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CategoryAutoSuggestedAdapter;
import com.tiffintom.partner1.adapters.PriceVarientListAdapter;
import com.tiffintom.partner1.adapters.SubAddonListAdapter;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.models.AddMainAddon;
import com.tiffintom.partner1.models.AddSubAddon;
import com.tiffintom.partner1.models.Categories;
import com.tiffintom.partner1.models.MenuAddons;
import com.tiffintom.partner1.models.MenuDetail;
import com.tiffintom.partner1.models.Price;
import com.tiffintom.partner1.models.Product;
import com.tiffintom.partner1.models.ProductMainAddon;
import com.tiffintom.partner1.models.ProductMainDetail;
import com.tiffintom.partner1.models.SubAddon;
import com.tiffintom.partner1.models.Variants;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONArray;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import worker8.com.github.radiogroupplus.RadioGroupPlus;

public class AddProductBottomSheetFragment extends BaseBottomSheet {
    private MaterialCardView cvNoImage;
    private RoundedImageView ivImage;
    private TextView tvImageText;
    private ImageView imgImage;
    private AppCompatEditText etProduct, etShortName, etProductDesc, etSortOrder, etProductDiscount, etProductPrice;
    private TextView tvSwitchStatus, tvAddImage;
    private SwitchCompat switchOrder;
    private RadioGroupPlus rbGroup, rbAddonGroup;
    private RadioButton rbSingle, rbMultiple, rbYes, rbNo;
    private MaterialButton btnCancel, btnConfirm;
    private MaterialAutoCompleteTextView etCategory;
    private LinearLayout llSingleLayout;
    private LinearLayout llAddPriceVariant, llMultipleLayout, llSubAddonLayout, llData, llLoading;
    private RecyclerView rvPriceVariant, rvSubAddon;
    private DialogDismissListener dialogDismissListener, deleteDismissListener;
    private int selectedCategoryId = -1;
    public static int selectedAllergiesCount = 0;
    private CheckBox cbVegetarians, cbContainsnut, cbMilk, cbMustard, cbSulphites, cbSulphurdioxide, cbMolluscs, cbCrustaceans, cbVegan, cbGlutenFree, cbEggs, cbFish;
    private LinearLayout llEdit,llSortCode;
    private TextView tvTitle, tvAddonNotFound;
    private MaterialButton btnDelete;

    private ArrayList<Categories> categories = new ArrayList<>();
    private ArrayAdapter<Categories> autoadapter;
    private ArrayList<Variants> priceVariants = new ArrayList<>();
    private ArrayList<Variants> variantsArrayList = new ArrayList<>();

    private Product product;
    private PriceVarientListAdapter priceVarientAdapter;
    private SubAddonListAdapter subAddonAdapter;
    private ArrayList<AddMainAddon> selectedAddonList = new ArrayList<>();
    private ArrayList<SubAddon> subAddons = new ArrayList<>();
    private ArrayList<AddMainAddon> mainAddons = new ArrayList<>();


    public static AddProductBottomSheetFragment getInstance(Product product) {
        AddProductBottomSheetFragment fragment = new AddProductBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putString("product", new Gson().toJson(product));
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener, DialogDismissListener deleteDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
        this.deleteDismissListener = deleteDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_add_product_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (product != null) {
            fetchProductDetails();
            llEdit.setVisibility(View.VISIBLE);
            llSortCode.setVisibility(View.VISIBLE);
            tvTitle.setVisibility(View.GONE);
        } else {
            llEdit.setVisibility(View.GONE);
            tvTitle.setVisibility(View.VISIBLE);
            fetchCategory();
        }
    }

    private void fetchProductDetails() {
        try {
            AndroidNetworking.get(ApiEndPoints.products + product.id)
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObject(Product.class, new ParsedRequestListener<Product>() {
                        @Override
                        public void onResponse(Product response) {
                            try {
                                product = response;
                                fetchCategory();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                product = new Gson().fromJson(getArguments().getString("product"), Product.class);
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }

    }

    private void updateViews() {
        try {
            if (product != null) {
                tvTitle.setVisibility(View.GONE);
                llEdit.setVisibility(View.VISIBLE);
                llSortCode.setVisibility(View.VISIBLE);

                if (!Validators.isNullOrEmpty(product.image_url)) {
                    imgImage.setVisibility(View.VISIBLE);
                    Glide.with(getActivity())
                            .load(product.image_url)
                            .into(imgImage);
                } else {
                    tvImageText.setVisibility(View.VISIBLE);
                    imgImage.setVisibility(View.GONE);
                }

                etProduct.setText(product.menu_name);
                etShortName.setText(product.short_name);
                etProductDesc.setText(product.menu_description);
                etSortOrder.setText(product.sortorder);
                etProductDiscount.setText(MyApp.df.format(Float.parseFloat(product.product_percentage)));

                cbVegetarians.setChecked(product.vegetarian);
                cbContainsnut.setChecked(product.contains_nuts);
                cbMilk.setChecked(product.milk);
                cbMustard.setChecked(product.mustard);
                cbEggs.setChecked(product.eggs);
                cbFish.setChecked(product.fish);
                cbGlutenFree.setChecked(product.gluten_free);
                cbMolluscs.setChecked(product.molluscs);
                cbSulphurdioxide.setChecked(product.sulphur_dioxide);
                cbSulphites.setChecked(product.sulphites);
                cbVegan.setChecked(product.vegan);
                if (product.variants.size() > 0) {
                    int position =0;
                    String orginalPrice ="";
                    for (ProductMainDetail variant : product.variants) {
                        position=position+1;
                        Variants var = new Variants();
                        var.id = variant.id;
                        var.menu_id = variant.menu_id;
                        var.sub_name = variant.sub_name;
                        var.orginal_price = variant.orginal_price;
                        if(position==1){
                            orginalPrice = variant.orginal_price;
                        }
                        if (variant.main_addons != null && variant.main_addons.size() > 0)
                            var.main_addons.addAll(variant.main_addons);
                        if (variant.menu_addons != null && variant.menu_addons.size() > 0)
                            var.menu_addons.addAll(variant.menu_addons);
                        priceVariants.add(var);
                    }
                    if(!Validators.isNullOrEmpty(orginalPrice)){
                        etProductPrice.setText(MyApp.df.format(Float.parseFloat(orginalPrice)));
                    }
                    if (priceVariants.size() > 0 && rbYes.isChecked()) {
                        variantsArrayList.clear();
                        variantsArrayList.addAll(priceVariants);
                        llSubAddonLayout.setVisibility(View.VISIBLE);
                    }
                    priceVarientAdapter.notifyDataSetChanged();
                }
                if (product.price_option.equalsIgnoreCase("multiple"))
                    rbMultiple.setChecked(true);
                else
                    rbSingle.setChecked(true);

                if (product.menu_addon.equalsIgnoreCase("yes"))
                    rbYes.setChecked(true);
                else
                    rbNo.setChecked(true);
            } else {
                llEdit.setVisibility(View.GONE);
                tvTitle.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void setListeners() {
        super.setListeners();
        try {
            tvAddImage.setOnClickListener(view -> {
                pickImage();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

        etCategory.setOnKeyListener((textView, i, keyEvent) -> {
            if (keyEvent.getAction() != KeyEvent.ACTION_DOWN)
                return true;
            if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                getActivity().onBackPressed();
            } else if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                CommonFunctions.hideKeyboard(getActivity(), etCategory);
            }
            return false;
        });
        switchOrder.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) {
                tvSwitchStatus.setText("Active");
                tvSwitchStatus.setTextColor(ContextCompat.getColor(getActivity(), R.color.chip_green_color));
            } else {
                tvSwitchStatus.setText("Inactive");
                tvSwitchStatus.setTextColor(ContextCompat.getColor(getActivity(), R.color.reject_color));
            }
        });

        llAddPriceVariant.setOnClickListener(view -> {
            try {
                AddPriceVariantDialogFragment dialogFragment = AddPriceVariantDialogFragment.getInstance(null, 0, true);
                dialogFragment.show(getChildFragmentManager(), "add price variant");
                dialogFragment.setDialogDismissListener(o -> {
                    Variants variants = (Variants) o;
                    priceVariants.add(variants);
                    variantsArrayList.clear();
                    variantsArrayList.addAll(priceVariants);
                    if (rbYes.isChecked())
                        llSubAddonLayout.setVisibility(View.VISIBLE);
                    priceVarientAdapter.notifyDataSetChanged();
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        });


        rbGroup.setOnCheckedChangeListener((group, checkedId) -> {
            switch (checkedId) {
                case R.id.rbSingle:
                    try {
                        llSingleLayout.setVisibility(View.VISIBLE);
                        llMultipleLayout.setVisibility(View.GONE);
                        Variants vr = new Variants();
                        vr.sub_name = etProduct.getText().toString();
                        vr.orginal_price = etProductPrice.getText().toString();
                        vr.required = true;
                        variantsArrayList.clear();
                        variantsArrayList.add(vr);
                        if (rbYes.isChecked())
                            llSubAddonLayout.setVisibility(View.VISIBLE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                case R.id.rbMultiple:
                    try {
                        llMultipleLayout.setVisibility(View.VISIBLE);
                        llSingleLayout.setVisibility(View.GONE);
                        if (priceVariants.size() > 0) {
                            variantsArrayList.clear();
                            variantsArrayList.addAll(priceVariants);
                            if (rbYes.isChecked())
                                llSubAddonLayout.setVisibility(View.VISIBLE);

                        } else {
                            if (rbYes.isChecked()) {
                                ToastUtils.makeToast(getActivity(), "Please add price variant");
                                llSubAddonLayout.setVisibility(View.GONE);
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
            }
            clearEditTextFocus();
        });

        rbAddonGroup.setOnCheckedChangeListener((group, checkedId) -> {
            switch (checkedId) {
                case R.id.rbYes:
                    try {
                        if (!Validators.isNullOrEmpty(etCategory.getText().toString())) {

                            if (rbSingle.isChecked()) {
                                Variants vr = new Variants();
                                vr.sub_name = etProduct.getText().toString();
                                vr.orginal_price = etProductPrice.getText().toString();
                                vr.required = true;
                                variantsArrayList.clear();
                                variantsArrayList.add(vr);
                                llSubAddonLayout.setVisibility(View.VISIBLE);
                            }
                            if (rbMultiple.isChecked() && priceVariants.size() == 0) {
                                ToastUtils.makeToast(getActivity(), "Please add price variant");
                            } else {
                                llSubAddonLayout.setVisibility(View.VISIBLE);
                            }
                        } else {
                            ToastUtils.makeToast(getActivity(), "Please select category first");
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                case R.id.rbNo:
                    try {
                        llSubAddonLayout.setVisibility(View.GONE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
            }
            clearEditTextFocus();
        });

        btnCancel.setOnClickListener(view -> {
            dismiss();
        });

        btnConfirm.setOnClickListener(view -> {
            try {
                if (isValid()) {
                    breakloop = false;
                    createMainArray();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        });
        btnDelete.setOnClickListener(view -> {
            try {
                if (deleteDismissListener != null) {
                    deleteDismissListener.onDialogDismiss(product.id);
                }
                dismiss();
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void clearEditTextFocus() {
        try {
            etProduct.clearFocus();
            etShortName.clearFocus();
            etProductDesc.clearFocus();
            etCategory.clearFocus();
            etSortOrder.clearFocus();
            etProductDiscount.clearFocus();

            CommonFunctions.hideKeyboard(getActivity(), etProduct);
            CommonFunctions.hideKeyboard(getActivity(), etShortName);
            CommonFunctions.hideKeyboard(getActivity(), etProductDesc);
            CommonFunctions.hideKeyboard(getActivity(), etCategory);
            CommonFunctions.hideKeyboard(getActivity(), etSortOrder);
            CommonFunctions.hideKeyboard(getActivity(), etProductDiscount);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean breakloop = false;

    private void createMainArray() {
        try {
            ArrayList<ProductMainDetail> mainDetailArrayList = new ArrayList<>();
            if (rbMultiple.isChecked() && variantsArrayList.size() > 0) {
                variantsArrayList.clear();
                variantsArrayList.addAll(priceVariants);
            } else {
                Variants vr = new Variants();
                vr.sub_name = etProduct.getText().toString();
                vr.orginal_price = !Validators.isNullOrEmpty(etProductPrice.getText().toString()) ? MyApp.df.format(Float.parseFloat(etProductPrice.getText().toString())) : "";
                vr.required = true;
                variantsArrayList.clear();
                variantsArrayList.add(vr);
            }

            for (int i = 0; i < variantsArrayList.size(); i++) {
                Variants variants = variantsArrayList.get(i);
                ProductMainDetail mainDetail = new ProductMainDetail();
                mainDetail.id = variants.id;
                mainDetail.menu_id = variants.menu_id;
                mainDetail.sub_name = variants.sub_name;
                mainDetail.orginal_price = variants.orginal_price;
                //selected addon is null while edit product
                if ((product != null && selectedAddonList.size() == 0) || rbSingle.isChecked()) {
                    selectedAddonList.addAll(mainAddons);
                }
                for (AddMainAddon mainAddon : selectedAddonList) {
                    ProductMainAddon productMainAddon = new ProductMainAddon();
                    productMainAddon.id = mainAddon.id;
                    productMainAddon.restaurant_id = myApp.getMyPreferences().getLoggedInRestaurant().id;
                    productMainAddon.category_id = mainAddon.category_id;
                    productMainAddon.admin_name = mainAddon.admin_name;
                    productMainAddon.mainaddons_name = mainAddon.mainaddons_name;
                    productMainAddon.mainaddons_mini_count = mainAddon.mainaddons_mini_count;
                    productMainAddon.mainaddons_count = mainAddon.mainaddons_count;
                    productMainAddon.sortorder = mainAddon.sortorder;
                    productMainAddon.status = mainAddon.status;
                    productMainAddon.delete_status = mainAddon.delete_status;

                    for (SubAddon subAddon : mainAddon.sub_addonses) {
                        AddSubAddon addSubAddon = new AddSubAddon();
                        addSubAddon.id = subAddon.id;
                        addSubAddon.mainaddons_id = subAddon.mainaddons_id;
                        addSubAddon.category_id = subAddon.category_id;
                        addSubAddon.subaddons_name = subAddon.subaddons_name;
                        addSubAddon.selected = subAddon.selected;
                        if (addSubAddon.selected) {
                            try {
                                if (subAddon.priceList.size() > 0)
                                    if (addSubAddon.id == subAddon.priceList.get(i).addonId)
                                        addSubAddon.subaddons_price = subAddon.priceList.get(i).title;
                            } catch (Exception e) {
                                e.printStackTrace();
                                breakloop = true;
                                ToastUtils.makeToast(getActivity(), "Sub addon missing!");
                            }
                        }
                        productMainAddon.sub_addonses.add(addSubAddon);


                    }

                    mainDetail.main_addons.add(productMainAddon);
                }
                if (variants.required)
                    mainDetailArrayList.add(mainDetail);

            }

            LogUtils.e("MENU DETAIL ARRAY:::::" + new Gson().toJson(mainDetailArrayList));
            MenuDetail menuDetail = new MenuDetail();
            menuDetail.id = product != null ? product.id : "";
            menuDetail.restaurant_id = loggedInRestaurant != null ? loggedInRestaurant.id : "";
            menuDetail.category_id = selectedCategoryId;
            menuDetail.menu_name = etProduct.getText().toString();
            menuDetail.is_suggest = "0";
            if (mainDetailArrayList.size() > 0) {
                if (rbSingle.isChecked()) {
                    menuDetail.price_option = "single";
                } else if (rbMultiple.isChecked()) {
                    menuDetail.price_option = "multiple";
                }
                if (rbYes.isChecked()) {
                    menuDetail.menu_addon = "Yes";
                } else if (rbNo.isChecked()) {
                    menuDetail.menu_addon = "No";
                }
            } else {
                menuDetail.price_option = "single";
                menuDetail.menu_addon = "No";
            }
            if (!Validators.isNullOrEmpty(etProductPrice.getText().toString())) {
                menuDetail.orginal_price = etProductPrice.getText().toString();
            } else {
                menuDetail.orginal_price = "";
            }
            menuDetail.menu_description = etProductDesc.getText().toString();
            menuDetail.menu_image = userImageFile != null ? userImageFile : null;
            menuDetail.menu_type = "";

            menuDetail.popular_dish = "";
            menuDetail.featured = "";
            menuDetail.spicy_dish = "";
            menuDetail.favourite = "";

            if (tvSwitchStatus.getText().toString().equalsIgnoreCase("active")) {
                menuDetail.status = "1";
            } else {
                menuDetail.status = "0";
            }
            menuDetail.delete_status = "";
       /* product.created = "";
        product.modified = "";*/
            menuDetail.sortorder = etSortOrder.getText().toString();
            menuDetail.short_name = etShortName.getText().toString();
            menuDetail.vegetarian = cbVegetarians.isChecked() ? 1 : 0;
            menuDetail.contains_nuts = cbContainsnut.isChecked() ? 1 : 0;
            menuDetail.milk = cbMilk.isChecked() ? 1 : 0;
            menuDetail.mustard = cbMustard.isChecked() ? 1 : 0;
            menuDetail.eggs = cbEggs.isChecked() ? 1 : 0;
            menuDetail.fish = cbFish.isChecked() ? 1 : 0;
            menuDetail.gluten_free = cbGlutenFree.isChecked() ? 1 : 0;
            menuDetail.halal = 0;
            menuDetail.koshar = 0;
            menuDetail.vegan = cbVegan.isChecked() ? 1 : 0;
            menuDetail.crustaceans = cbCrustaceans.isChecked() ? 1 : 0;
            menuDetail.molluscs = cbMolluscs.isChecked() ? 1 : 0;
            menuDetail.sulphur_dioxide = cbSulphurdioxide.isChecked() ? 1 : 0;
            menuDetail.sulphites = cbSulphites.isChecked() ? 1 : 0;
            menuDetail.product_percentage = !Validators.isNullOrEmpty(etProductDiscount.getText().toString()) ? MyApp.df.format(Float.parseFloat(etProductDiscount.getText().toString())) : "";
            menuDetail.category_name = etCategory.getText().toString();
            //product.image_url = userImageFile;
            // product.thumb_url = null;*/
            menuDetail.menu_details.clear();
            menuDetail.menu_details.addAll(mainDetailArrayList);

            if (!breakloop)
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(menuDetail);
                    dismiss();
                }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {
        etProduct.setError(null);
        etShortName.setError(null);

        if (Validators.isNullOrEmpty(etProduct.getText().toString())) {
            etProduct.setError("Please enter product name");
            etProduct.requestFocus();
            return false;
        }

        if (Validators.isNullOrEmpty(etShortName.getText().toString())) {
            etShortName.setError("Please enter product short name");
            etShortName.requestFocus();
            return false;
        }

        if (Validators.isNullOrEmpty(etProductDesc.getText().toString())) {
            etProductDesc.setError("Please enter product description");
            etProductDesc.requestFocus();
            return false;
        }

        if (Validators.isNullOrEmpty(etCategory.getText().toString())) {
            etCategory.setError("Please enter category name");
            etCategory.requestFocus();
            return false;
        }
/*
        if (Validators.isNullOrEmpty(etSortOrder.getText().toString())) {
            etSortOrder.setError("Please enter sort order");
            etSortOrder.requestFocus();
            return false;
        }*/

        if (rbSingle.isChecked() && Validators.isNullOrEmpty(etProductPrice.getText().toString()) || etProductPrice.getText().toString().equalsIgnoreCase("0.00")) {
            etProductPrice.setError("Please enter product price");
            etProductPrice.requestFocus();
            return false;
        }

        if (rbMultiple.isChecked() && priceVariants.size() == 0) {
            ToastUtils.makeToast(getActivity(), "Please add product price");
            return false;
        }

        return true;

    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llData = view.findViewById(R.id.llData);
        llLoading = view.findViewById(R.id.llLoading);
        llAddPriceVariant = view.findViewById(R.id.ll_PriceVariants);
        llMultipleLayout = view.findViewById(R.id.llMultipleLayout);
        llSingleLayout = view.findViewById(R.id.llSingleLayout);
        llSubAddonLayout = view.findViewById(R.id.llSubAddonLayout);
        rvPriceVariant = view.findViewById(R.id.rvPriceVariant);

        tvImageText = view.findViewById(R.id.tvImageText);
        imgImage = view.findViewById(R.id.imgImage);
        rvSubAddon = view.findViewById(R.id.rvSubAddon);
        tvAddImage = view.findViewById(R.id.tvAddImage);
        cvNoImage = view.findViewById(R.id.cvNoImage);
        etCategory = view.findViewById(R.id.etCategory);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        btnCancel = view.findViewById(R.id.btnCancel);
        rbNo = view.findViewById(R.id.rbNo);
        rbYes = view.findViewById(R.id.rbYes);
        rbSingle = view.findViewById(R.id.rbSingle);
        rbMultiple = view.findViewById(R.id.rbMultiple);
        rbGroup = view.findViewById(R.id.rbGroup);
        rbAddonGroup = view.findViewById(R.id.rbAddonGroup);
        switchOrder = view.findViewById(R.id.switchOrders);
        tvSwitchStatus = view.findViewById(R.id.tvSwitchStatus);
        etProductPrice = view.findViewById(R.id.etProductPrice);
        etProductDiscount = view.findViewById(R.id.etProductDiscount);
        etSortOrder = view.findViewById(R.id.etSortOrder);
        etProduct = view.findViewById(R.id.etProduct);
        etShortName = view.findViewById(R.id.etShortName);
        etProductDesc = view.findViewById(R.id.etDescription);
        ivImage = view.findViewById(R.id.ivImage);

        cbSulphites = view.findViewById(R.id.cbSulphites);
        cbSulphurdioxide = view.findViewById(R.id.cbSulphurdioxide);
        cbMolluscs = view.findViewById(R.id.cbMolluscs);
        cbCrustaceans = view.findViewById(R.id.cbCrustaceans);
        cbVegan = view.findViewById(R.id.cbVegan);
        cbGlutenFree = view.findViewById(R.id.cbGlutenFree);
        cbFish = view.findViewById(R.id.cbFish);
        cbEggs = view.findViewById(R.id.cbEggs);
        cbMustard = view.findViewById(R.id.cbMustard);
        cbMilk = view.findViewById(R.id.cbMilk);
        cbContainsnut = view.findViewById(R.id.cbContainsnut);
        cbVegetarians = view.findViewById(R.id.cbVegetarians);

        llEdit = view.findViewById(R.id.llEdit);
        llSortCode = view.findViewById(R.id.llSortCode);
        tvTitle = view.findViewById(R.id.tvTitle);
        btnDelete = view.findViewById(R.id.btnDelete);
        tvAddonNotFound = view.findViewById(R.id.tvAddonNotFound);

        etProductPrice.addTextChangedListener(new MoneyTextWatcher(etProductPrice));
        etProductDiscount.addTextChangedListener(new MoneyTextWatcher(etProductDiscount));
        etCategory.setOnItemClickListener((adapterView, view1, i, l) -> {
            try {
                int indext = categories.indexOf(adapterView.getItemAtPosition(i));
                if (indext != -1) {
                    selectedCategoryId = Integer.parseInt(categories.get(indext).id);
                    fetchData(selectedCategoryId);

                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }

        });

        priceVarientAdapter = new PriceVarientListAdapter(priceVariants, (position, data) -> {
            if (data instanceof Variants) try {
                {
                    Variants variant = (Variants) data;
                    AddPriceVariantDialogFragment dialogFragment = AddPriceVariantDialogFragment.getInstance(variant, position, true);
                    dialogFragment.show(getChildFragmentManager(), "add price variant");
                    dialogFragment.setDialogDismissListener(o -> {
                        Variants variants = (Variants) o;
                        priceVariants.get(position).sub_name = variants.sub_name;
                        priceVariants.get(position).orginal_price = variants.orginal_price;

                        /*if (priceVariants.get(position).position == position) {
                            priceVariants.remove(position);
                            priceVariants.add(variants);
                        }*/
                        priceVarientAdapter.notifyDataSetChanged();
                        CommonFunctions.hideKeyboard(getActivity(), etCategory);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }, (position, data) -> {
            Variants variants = (Variants) data;
            priceVariants.get(position).required = variants.required;
            priceVarientAdapter.notifyDataSetChanged();
        });

        rvPriceVariant.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvPriceVariant.setAdapter(priceVarientAdapter);

        subAddonAdapter = new SubAddonListAdapter(subAddons, (position, data) -> {
            try {
                SubAddon addon = (SubAddon) data;
                AddProductSubAddonBottomSheetFragment dialogFragment = AddProductSubAddonBottomSheetFragment.getInstance(variantsArrayList, addon);
                dialogFragment.show(getChildFragmentManager(), "add price variant");
                dialogFragment.setDialogDismissListener(o -> {
                    SubAddon subAddon = (SubAddon) o;
                    selectedAddonList.clear();
                    for (AddMainAddon mainAddon : mainAddons) {
                        if (subAddon.mainaddons_id == Integer.parseInt(mainAddon.id)) {
                            for (SubAddon subAddon1 : mainAddon.sub_addonses) {
                                if (subAddon1.id == subAddon.id) {
                                    subAddon1.selected = true;
                                    subAddon1.priceList.clear();
                                    subAddon1.priceList.addAll(subAddon.priceList);
                                }
                            }
                        }
                        selectedAddonList.add(mainAddon);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }, (position, data) -> {

        });

        rvSubAddon.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvSubAddon.setAdapter(subAddonAdapter);


    }

    private void fetchData(int selectedCategoryId) {
        fetchAddons(selectedCategoryId);
    }

    private void fetchCategory() {
        try {
            AndroidNetworking.get(ApiEndPoints.categories)
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Categories.class, new ParsedRequestListener<List<Categories>>() {
                        @Override
                        public void onResponse(List<Categories> response) {
                            try {
                                categories.clear();
                                categories.addAll(response);
                                etCategory.setThreshold(1);
                                autoadapter = new CategoryAutoSuggestedAdapter(getActivity(), categories);
                                etCategory.setAdapter(autoadapter);

                                if (product != null) {
                                    if (!Validators.isNullOrEmpty(product.id))
                                        for (Categories category : categories)
                                            if (product.category_id == Integer.parseInt(category.id)) {
                                                etCategory.setText(category.category_name);
                                                selectedCategoryId = product.category_id;
                                                fetchData(selectedCategoryId);
                                            }
                                    updateViews();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    ArrayList<AddMainAddon> addonArrayList = new ArrayList<>();

    private void fetchAddons(int selectedCategoryId) {
        try {
            AndroidNetworking.get(ApiEndPoints.addons)
                    .addQueryParameter("category_id", String.valueOf(selectedCategoryId))
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                if (getActivity() != null)
                                    getActivity().runOnUiThread(() -> {
                                        rvSubAddon.setVisibility(View.VISIBLE);
                                        tvAddonNotFound.setVisibility(View.GONE);
                                    });
                                mainAddons.clear();
                                Type type = new TypeToken<List<AddMainAddon>>() {
                                }.getType();
                                mainAddons.addAll(new Gson().fromJson(response.toString(), type));
                                CommonFunctions.hideKeyboard(getActivity(), etCategory);


                                if (product != null) {
                                    for (AddMainAddon mainAddon : mainAddons) {
                                        for (Variants variants : priceVariants)
                                            for (MenuAddons productMenuAddon : variants.menu_addons) {
                                                for (SubAddon subAddon : mainAddon.sub_addonses) {
                                                    if (subAddon.id == Integer.parseInt(productMenuAddon.subaddons_id)) {
                                                        Price header = new Price();
                                                        header.addonId = Integer.parseInt(productMenuAddon.subaddons_id);
                                                        header.title = Float.parseFloat(productMenuAddon.subaddons_price);
                                                        subAddon.selected = true;
                                                        subAddon.priceList.add(header);
                                                    }
                                                }
                                            }
                                        addonArrayList.add(mainAddon);
                                    }
                                } else {
                                    addonArrayList.addAll(mainAddons);
                                }

                                subAddons.clear();
                                for (AddMainAddon mainAddon : addonArrayList) {
                                    for (SubAddon subAddon : mainAddon.sub_addonses) {
                                        subAddon.subaddons_name = mainAddon.mainaddons_name + " " + subAddon.subaddons_name;
                                        subAddons.add(subAddon);
                                    }
                                }
                                subAddonAdapter.notifyDataSetChanged();

                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null)
                                    getActivity().runOnUiThread(() -> {
                                        rvSubAddon.setVisibility(View.GONE);
                                        tvAddonNotFound.setVisibility(View.VISIBLE);
                                    });

                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });

        } catch (Exception e) {
            e.printStackTrace();

        }

    }

    private void pickImage() {
        try {
            ImagePicker.Companion.with(this)
                    .crop()                    //Crop image(Optional), Check Customization for more option
                    .compress(1024)            //Final image size will be less than 1 MB(Optional)
                    .maxResultSize(1080, 1080)    //Final image resolution will be less than 1080 x 1080(Optional)
                    .start(CODE_IMAGE_PICKER);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    Uri fileUri;
    File userImageFile;

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == CODE_IMAGE_PICKER) {
                if (data != null) {
                    userImageFile = ImagePicker.Companion.getFile(data);
                    if (userImageFile != null && userImageFile.exists()) {
                        imgImage.setImageURI(Uri.fromFile(userImageFile));
                        imgImage.setVisibility(View.VISIBLE);
                        tvImageText.setVisibility(View.GONE);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        try {
            if (grantResults.length > 0) {
                boolean StoragePermission = grantResults[0] ==
                        PackageManager.PERMISSION_GRANTED;

                if (!StoragePermission) {
                    ToastUtils.makeToast(getActivity(), "Permissions denied");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}

