package com.tiffintom.partner1.fragments;

import android.content.res.Resources;
import android.os.Bundle;
import android.text.InputType;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.models.Price;
import com.tiffintom.partner1.models.SubAddon;
import com.tiffintom.partner1.models.Variants;
import com.tiffintom.partner1.utils.ToastUtils;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class AddProductSubAddonBottomSheetFragment extends BaseBottomSheet {
    private DialogDismissListener dialogDismissListener;
    private TextView etSubAddon;
    private RecyclerView rvPrice;
    private MaterialButton btnCancel, btnConfirm;
    private ArrayList<Price> priceCount = new ArrayList<>();
    private ArrayList<Price> selectedPriceList = new ArrayList<>();
    private ArrayList<Variants> priceVariant = new ArrayList<>();

    private SubAddon subAddon;
    private LinearLayout llEdiTextLayout, llDynamicLayout;
    private TextView tvHeader;
    private EditText ed;
    ArrayList<EditText> list = new ArrayList<>();

    public static AddProductSubAddonBottomSheetFragment getInstance(ArrayList<Variants> priceVariant, SubAddon subAddon) {
        AddProductSubAddonBottomSheetFragment fragment = new AddProductSubAddonBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putString("price_variants", new Gson().toJson(priceVariant));
        bundle.putString("sub_addon", new Gson().toJson(subAddon));
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_add_product_subaddon, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        updateViews();
    }

    @Override
    protected void setListeners() {
        super.setListeners();
        btnCancel.setOnClickListener(view -> dismiss());

        btnConfirm.setOnClickListener(view -> {
            try {
                //To retrieve EditText
                if (!Validators.isNullOrEmpty(ed.getText().toString())) {
                    for (EditText editText : list) {
                        Price price = new Price();
                        price.title = Float.parseFloat(editText.getText().toString());
                        price.addonId = subAddon.id;
                        selectedPriceList.add(price);

                    }
                    subAddon.selected = true;

                    if (selectedPriceList.size() > 0) {
                        subAddon.priceList.clear();
                        subAddon.priceList.addAll(selectedPriceList);
                    }
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(subAddon);
                    dismiss();
                } else {
                    ToastUtils.makeToast(getActivity(), "Please enter price");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });

    }

    private void updateViews() {
        try {

            if (priceVariant.size() != 0) {
                priceCount.clear();
                for (int i = 1; i <= priceVariant.size(); i++) {
                    Price header = new Price();
                    header.total = "Price " + i;
                    priceCount.add(header);
                }
            }

            if (priceCount.size() > 0) {
                for (int i = 0; i < priceCount.size(); i++) {

                    llDynamicLayout = new LinearLayout(getContext());
                    llDynamicLayout.setOrientation(LinearLayout.VERTICAL);
                    llDynamicLayout.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

                    tvHeader = new TextView(getContext());
                    ViewGroup.LayoutParams lparams = new TableLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, 1f);
                    tvHeader.setLayoutParams(lparams);
                    tvHeader.setPadding(8, 8, 8, 8);
                    tvHeader.setText(priceCount.get(i).total);
                    tvHeader.setTextColor(getActivity().getResources().getColor(R.color.reason_normal_text));

                    llDynamicLayout.addView(tvHeader);

                    ed = new EditText(getContext());
                    ed.setId(i);
                    ed.setLayoutParams(lparams);
                    ed.setBackground(getActivity().getResources().getDrawable(R.drawable.input_login_round_corner_border));
                    ed.setPadding(22, 32, 22, 32);
                    ed.setScrollContainer(true);
                    ed.setTextSize(14);
                    ed.setInputType(InputType.TYPE_CLASS_NUMBER);
                    //  ed.setHintTextColor(context.getResources().getColor(R.color.colorTextHint));
                    ed.setHint("0.00");
                    ed.addTextChangedListener(new MoneyTextWatcher(ed));
                    llDynamicLayout.addView(ed);
                    llEdiTextLayout.addView(llDynamicLayout);
                    list.add(ed);
                }
                if (subAddon != null) {
                    etSubAddon.setText(subAddon.subaddons_name);
                    if (subAddon.priceList.size() > 0) {
                        for (int i = 0; i < subAddon.priceList.size(); i++) {
                            list.get(i).setText(MyApp.df.format(subAddon.priceList.get(i).title));
                        }
                    }
                }
            }
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                Type type = new TypeToken<List<Variants>>() {
                }.getType();
                priceVariant = new Gson().fromJson(getArguments().getString("price_variants"), type);
                subAddon = new Gson().fromJson(getArguments().getString("sub_addon"), SubAddon.class);
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        etSubAddon = view.findViewById(R.id.autoSubAddon);
        rvPrice = view.findViewById(R.id.rvPrice);
        btnCancel = view.findViewById(R.id.btnCancel);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        llEdiTextLayout = view.findViewById(R.id.llEditTextLayout);
        etSubAddon.setClickable(false);

    }
}
