package com.tiffintom.partner1.fragments;


import android.animation.Animator;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;

import com.airbnb.lottie.LottieAnimationView;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class AnimatedConfirmationDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String title, info, positiveButton, negativeButton;
    private boolean reject;
    private int type; //0 neutral, 1 success,2 reject
    private MaterialButton btnConfirm, btnCancel;
    private TextView tvInfo, tvTitle,tvDesc;
    private boolean noConfirm=false;
    private DialogDismissListener dialogDismissListener;
    private LottieAnimationView animationView;

    public static AnimatedConfirmationDialogFragment getInstance(String title, String info, int type, String positiveButton, String negativeButton) {
        AnimatedConfirmationDialogFragment rejectReasonDialog = new AnimatedConfirmationDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_animated_confirmation_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            title = getArguments().getString("title");
            info = getArguments().getString("info");
            positiveButton = getArguments().getString("positive_button");
            negativeButton = getArguments().getString("negative_button");
            type = getArguments().getInt("type");

            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            tvInfo = view.findViewById(R.id.tvInfo);
            tvTitle = view.findViewById(R.id.tvTitle);
            tvDesc= view.findViewById(R.id.tvDesc);
            animationView = view.findViewById(R.id.animation_view);

            if (Validators.isNullOrEmpty(title)) {
                tvTitle.setVisibility(View.GONE);
            } else
                tvTitle.setText(title);
            if (Validators.isNullOrEmpty(info)) {
                tvInfo.setVisibility(View.GONE);
            } else
                tvInfo.setText(info);
            if (type == 2) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
            } else if (type == 1) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_accept));
            }
            if (Validators.isNullOrEmpty(negativeButton)) {
                btnCancel.setVisibility(View.GONE);
            } else {
                btnCancel.setVisibility(View.VISIBLE);
                btnCancel.setText(negativeButton);
            }
            if (Validators.isNullOrEmpty(positiveButton)) {
                btnConfirm.setVisibility(View.GONE);
            } else {
                if (positiveButton.equalsIgnoreCase("NoConfirm")) {
                    noConfirm=true;
                    btnConfirm.setVisibility(View.GONE);
                } else {
                    noConfirm=false;
                    btnConfirm.setVisibility(View.VISIBLE);
                }
                btnConfirm.setText(positiveButton);
            }

            //set animation
            if (type == 1) {
                animationView.setAnimation(R.raw.payment_successful);
            } else if (type == 2) {
                animationView.setAnimation(R.raw.payment_failed);
            } else {
                animationView.setVisibility(View.GONE);
            }
            if(!noConfirm)
            {
                btnConfirm.setVisibility(View.VISIBLE);
            }
            if(info!=null&&info.equalsIgnoreCase("")&&info.contains("£"))
            {
                tvInfo.setVisibility(View.GONE);
                tvDesc.setVisibility(View.VISIBLE);
                tvTitle.setText("Payment Approved");
                tvDesc.setText(info);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            animationView.addAnimatorListener(new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(Animator animation) {

                }

                @Override
                public void onAnimationEnd(Animator animation) {
    //                btnConfirm.performClick();
    //                animationView.cancelAnimation();
                }

                @Override
                public void onAnimationCancel(Animator animation) {

                }

                @Override
                public void onAnimationRepeat(Animator animation) {

                }
            });
            btnConfirm.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("confirm");
                dismiss();
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("cancel");
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
