package com.tiffintom.partner1.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.button.MaterialButton;
import com.lwj.widget.viewpagerindicator.ViewPagerIndicator;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.SplashActivity;
import com.tiffintom.partner1.adapters.AppInfoViewPagerAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.models.AppInfoModel;

import java.util.ArrayList;

public class AppInfoFragment extends BaseFragment {

    private ViewPager vpAppInfo;
    private ViewPagerIndicator pagerIndicator;
    private MaterialButton btnBack, btnNext;
    private AppInfoViewPagerAdapter vpAdapter;
    private int currentItem;
    private ArrayList<AppInfoModel> infoArrayList = new ArrayList<>();

    public static AppInfoFragment getInstance() {
        return new AppInfoFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_app_info, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        setupViews();
        setListners();
    }

    private void setupViews() {

        AppInfoModel model = new AppInfoModel();
        model.title = "Orders";
        model.image = R.drawable.info_1;
        model.description = R.string.dashboard_description;
        infoArrayList.add(model);

        model = new AppInfoModel();
        model.title = "Overview";
        model.image = R.drawable.info_2;
        model.description = R.string.analytics_description;
        infoArrayList.add(model);

        model = new AppInfoModel();
        model.title = "Managment";
        model.image = R.drawable.info_3;
        model.description = R.string.management_description;
        infoArrayList.add(model);

        model = new AppInfoModel();
        model.title = "Chat";
        model.image = R.drawable.info_4;
        model.description = R.string.chat_description;
        infoArrayList.add(model);

        model = new AppInfoModel();
        model.title = "Review";
        model.image = R.drawable.info_5;
        model.description = R.string.reviews_description;
        infoArrayList.add(model);
        vpAdapter.notifyDataSetChanged();
        pagerIndicator.setViewPager(vpAppInfo, infoArrayList.size());
    }

    private void setListners() {
        btnNext.setOnClickListener(v -> {
            currentItem = vpAppInfo.getCurrentItem() + 1;
            if (currentItem < infoArrayList.size()) {
                vpAppInfo.setCurrentItem(currentItem);
            } else {
                myApp.getMyPreferences().saveAppIntroDone(true);
                startActivity(new Intent(getActivity(), SplashActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
            }
        });

        btnBack.setOnClickListener(v -> {
            currentItem = vpAppInfo.getCurrentItem() - 1;
            if (currentItem < 0) {
//                startActivity(new Intent(getActivity(), LoginActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
            } else {
                vpAppInfo.setCurrentItem(currentItem);
            }
        });

    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        vpAppInfo = view.findViewById(R.id.vpAppinfo);
        pagerIndicator = view.findViewById(R.id.lineIndicator);
        btnBack = view.findViewById(R.id.btnBack);
        btnNext = view.findViewById(R.id.btnNext);

        vpAdapter = new AppInfoViewPagerAdapter(getActivity(), infoArrayList);
        vpAppInfo.setAdapter(vpAdapter);
    }
}
