package com.tiffintom.partner1.fragments;

import android.app.DatePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.widget.NestedScrollView;

import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.Offer;

import java.util.Calendar;

/**
 * Created by Amrish on 22-12-2020.
 */
public class AutodiscountEditBottomFragment extends BaseBottomSheet {
    public static AutodiscountEditBottomFragment getInstance(Offer offer) {
        AutodiscountEditBottomFragment voucherCodeEditBottomFragment = new AutodiscountEditBottomFragment();
        Bundle bundle = new Bundle();
        bundle.putString("offer", new Gson().toJson(offer));
        voucherCodeEditBottomFragment.setArguments(bundle);
        return voucherCodeEditBottomFragment;
    }

    DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    Offer offer;
    CheckBox cbDelivery, cbDinein, cbCollection;
    RadioGroup rgDevices, rgUses, rgOffer;
    RadioButton rbApp, rbWeb, rbSingle, rbMultiple, rbPrice, rbPercentage, rbFreeDelivery;
    AppCompatEditText etCode, etMultipleTimes, etOfferValue, etMinimumValue;

    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private Calendar today = Calendar.getInstance();
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private TextView tvToDate, tvFromDate;
    private RelativeLayout llFromDate, llToDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    View shadowDivider;
    NestedScrollView nestedScrollView;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            offer = new Gson().fromJson(getArguments().getString("offer"), Offer.class);
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_edit_autodiscount, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        shadowDivider = view.findViewById(R.id.shadowDivider);
        nestedScrollView = view.findViewById(R.id.nestedScroll);
        tvToDate = view.findViewById(R.id.tvToDate);
        tvFromDate = view.findViewById(R.id.tvFromDate);
        llToDate = view.findViewById(R.id.llToDate);
        llFromDate = view.findViewById(R.id.llFromDate);

        cbCollection = view.findViewById(R.id.cbCollection);
        cbDinein = view.findViewById(R.id.cbDinein);
        cbDelivery = view.findViewById(R.id.cbDelivery);

        rgDevices = view.findViewById(R.id.rgDevices);
        rgUses = view.findViewById(R.id.rgUses);
        rgOffer = view.findViewById(R.id.rgOffer);

        rbApp = view.findViewById(R.id.rbApp);
        rbWeb = view.findViewById(R.id.rbWeb);
        rbSingle = view.findViewById(R.id.rbSingle);
        rbMultiple = view.findViewById(R.id.rbMultiple);
        rbPrice = view.findViewById(R.id.rbPrice);
        rbPercentage = view.findViewById(R.id.rbPercentage);
        rbFreeDelivery = view.findViewById(R.id.rbFreeDelivery);

        etCode = view.findViewById(R.id.etCode);
        etMultipleTimes = view.findViewById(R.id.etMultipleTimes);
        etOfferValue = view.findViewById(R.id.etOfferValue);
        etMinimumValue = view.findViewById(R.id.etMin);
    }

    @Override
    protected void setListeners() {
        super.setListeners();
        nestedScrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener) (v, scrollX, scrollY, oldScrollX, oldScrollY) -> {
            if (scrollY == 0) {
                shadowDivider.setVisibility(View.INVISIBLE);
            } else {
                shadowDivider.setVisibility(View.VISIBLE);
            }
        });
        rgOffer.setOnCheckedChangeListener((radioGroup, i) -> {
            if (i == R.id.rbFreeDelivery && rbFreeDelivery.isChecked()) {
                etOfferValue.setVisibility(View.GONE);
                etOfferValue.setText("");
            } else {
                etOfferValue.setVisibility(View.VISIBLE);
            }
        });
        rgUses.setOnCheckedChangeListener((radioGroup, i) -> {
            if (i == R.id.rbSingle && rbSingle.isChecked()) {
                etMultipleTimes.setVisibility(View.GONE);
                etMultipleTimes.setText("");
            } else {
                etMultipleTimes.setVisibility(View.VISIBLE);
            }
        });
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                fromDay = d;
                fromMonth = m;
                fromYear = y;
                fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                fromCalendar.set(y, m, d);
                tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(toDate)) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                toDay = d;
                toMonth = m;
                toYear = y;
                toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                toCalendar.set(y, m, d);
                tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(fromDate)) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
    }

    private void updateViews() {
        if (offer != null) {
            fromCalendar.setTime(CommonFunctions.convertStringDateToDate(offer.offer_from, "yyyy-MM-dd"));
            toCalendar.setTime(CommonFunctions.convertStringDateToDate(offer.offer_to, "yyyy-MM-dd"));

        } else {
            toCalendar.add(Calendar.DAY_OF_MONTH, +6);

        }
        fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
        toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

        tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));

    }
}
