package com.tiffintom.partner1.fragments;

import static com.tiffintom.partner1.utils.Constants.TAPTOPAY;

import android.Manifest;
import android.app.Activity;
import android.app.Dialog;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TableLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.tabs.TabLayout;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.stripeterminal.Terminal;
import com.stripe.stripeterminal.external.models.Reader;
import com.tiffintom.partner1.BuildConfig;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.interfaces.DialogDismissDataListener;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonGetPinModel;
import com.tiffintom.partner1.models.MerchantCardReader;
import com.tiffintom.partner1.models.SiteSetting;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;


public class CardReaderPaymentFragment extends BaseFragment {

    private EditText etAmount, etTip;
    private MaterialButton btnPay, btnCancel;
    private float tipAmount = 0, amount = 0, grandTotal = 0;
    private MerchantCardReader selectedCardReader;
    private SunmiPrinter sunmiPrinter;
    private LinearLayout llTip, linear_battery_level;
    private TextView txt_battery_level, txtTitle, tvNoData;
    Button btnStartBank;
    private ZoneRichPrinter zoneRichPrinter;
    private CS20PrintHelper cs20PrintHelper;
    private BluetoothPrinter bluetoothPrinter;
    private ConstraintLayout llMainLayout;
    private SiteSetting headerAlignmentSetting;
    private int headerAlignment = 0;
    private String stripe_mode, stripe_private_key, stripe_public_key;
    private String selectedConnectivity = "";
    private Stripe stripe;
    private TabLayout tabsLayout,tabsTap2Pay;
    private NestedScrollView nestedScroll;
    private ConstraintLayout constNoData;
    private Dialog dialogRequestWalletDialog;
    private boolean isTapToPaEnabled = false,isCs30Device = false;
    private int tapToPayCount = 0;
    private boolean isFromTheme2 = false;

    public static CardReaderPaymentFragment getInstance() {
        return new CardReaderPaymentFragment();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            isCs30Device = myApp.getMyPreferences().getDefaultPrinter()!=null && Objects.equals(myApp.getMyPreferences().getDefaultPrinter(), getString(R.string.ubsidi_cs30));
            isTapToPaEnabled = MyApp.getInstance().getMyPreferences().getDeviceRegistration().is_tap_to_pay;
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (!Validators.isNullOrEmpty(myApp.getMyPreferences().getPrinterIP())) {
                zoneRichPrinter = new ZoneRichPrinter(getActivity());
            }
            if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper = new CS20PrintHelper();
            }
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            doubleFormat.setMinimumFractionDigits(2);
            tabsLayout = view.findViewById(R.id.tabsLayout);
            tabsTap2Pay = view.findViewById(R.id.tabsTap2Pay);
            nestedScroll = view.findViewById(R.id.nestedScroll);
            constNoData = view.findViewById(R.id.constNoData);
            llMainLayout = view.findViewById(R.id.llMainLayout);
            etAmount = view.findViewById(R.id.etAmount);
            etTip = view.findViewById(R.id.etTip);
            btnPay = view.findViewById(R.id.btnPay);
            btnCancel = view.findViewById(R.id.btnCancel);
            llTip = view.findViewById(R.id.llTip);
            linear_battery_level = view.findViewById(R.id.linear_battery_level);
            txt_battery_level = view.findViewById(R.id.txt_battery_level);
            txtTitle = view.findViewById(R.id.txtTitle);
            tvNoData = view.findViewById(R.id.tvNoData);
            if (merchantBusiness.tip) {
                llTip.setVisibility(View.VISIBLE);
            } else {
                llTip.setVisibility(View.GONE);
                etAmount.setImeOptions(EditorInfo.IME_ACTION_DONE);
            }
            btnStartBank = view.findViewById(R.id.btnStartBank);
            btnStartBank.setOnClickListener(view1 -> showRequestWalletDialog());
            if(isCs30Device){
                tabsTap2Pay.setVisibility(View.VISIBLE);
                tabsLayout.setVisibility(View.GONE);
                txtTitle.setText(getString(R.string.tap_to_payment));
                if (!isTapToPaEnabled) {
                    nestedScroll.setVisibility(View.GONE);
                    constNoData.setVisibility(View.VISIBLE);
                    updateCount(tapToPayCount);
                }
            }
            tabsLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
                @Override
                public void onTabSelected(TabLayout.Tab tab) {
                    if (tab.getPosition() == 0) {
                        selectedCardReader = null;
                        nestedScroll.setVisibility(View.VISIBLE);
                        constNoData.setVisibility(View.GONE);
                        txtTitle.setText(getString(R.string.card_reader_payment));
                    } else {
                        txtTitle.setText(getString(R.string.tap_to_payment));
                        if (!isTapToPaEnabled) {
                            nestedScroll.setVisibility(View.GONE);
                            constNoData.setVisibility(View.VISIBLE);
                            updateCount(tapToPayCount);
                        }
                    }
                }

                @Override
                public void onTabUnselected(TabLayout.Tab tab) {

                }

                @Override
                public void onTabReselected(TabLayout.Tab tab) {

                }
            });
            tabsTap2Pay.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
                @Override
                public void onTabSelected(TabLayout.Tab tab) {
                    if (tab.getPosition() == 1) {
                        selectedCardReader = null;
                        nestedScroll.setVisibility(View.VISIBLE);
                        constNoData.setVisibility(View.GONE);
                        txtTitle.setText(getString(R.string.card_reader_payment));
                    } else {
                        txtTitle.setText(getString(R.string.tap_to_payment));
                        if (!isTapToPaEnabled) {
                            nestedScroll.setVisibility(View.GONE);
                            constNoData.setVisibility(View.VISIBLE);
                            updateCount(tapToPayCount);
                        }
                    }
                }

                @Override
                public void onTabUnselected(TabLayout.Tab tab) {

                }

                @Override
                public void onTabReselected(TabLayout.Tab tab) {

                }
            });
            isFromTheme2 = false;
            if(getArguments()!=null && getArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT)!=null){
                tabsLayout.setVisibility(View.GONE);
                tabsTap2Pay.setVisibility(View.GONE);
                etAmount.setText(getArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT));
                isFromTheme2 = true;
                if(getArguments().getBoolean(Constants.IS_TAP2_PAY,false)){
                    if(!isCs30Device){
                        tabsLayout.selectTab(tabsLayout.getTabAt(1));
                    }
                }else {
                    if(isCs30Device){
                        tabsTap2Pay.selectTab(tabsLayout.getTabAt(1));
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_cardreader_payment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
        setBatteryLevel();
        getTapToPayCount();
        if(isFromTheme2){
            btnPay.performClick();
        }
    }

    private void setBatteryLevel() {
        try {
            if (Terminal.isInitialized()) {
                Reader connectedReader = Terminal.getInstance().getConnectedReader();
                if (connectedReader != null) {
                    if (linear_battery_level != null && txt_battery_level != null) {
                        linear_battery_level.setVisibility(View.VISIBLE);
                        if (myApp.getMyPreferences().getBatteryLevel() > 0) {
                            txt_battery_level.setText("Battery Level:- " + (myApp.getMyPreferences().getBatteryLevel() * 100f) + "%");
                        } else if (connectedReader.getBatteryLevel() == null) {
                            txt_battery_level.setText("");
                        } else {
                            txt_battery_level.setText("Battery Level:- " + (connectedReader.getBatteryLevel() * 100f) + "%");
                        }
                    }
                } else {
                    if (linear_battery_level != null) {
                        linear_battery_level.setVisibility(View.GONE);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private void setUpMposTerminal(boolean isFromTapToPay) {
        try {
            if (merchantBusiness.card_readers != null && merchantBusiness.card_readers.size() == 1) {
                if(!isFromTapToPay){
                    selectedCardReader = merchantBusiness.card_readers.get(0);
                }
            }
            if (selectedCardReader != null) {

                if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet") || selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("posbluetooth")
                        || selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase(TAPTOPAY)) {
                    //stripe_mode = merchantBusiness.stripe_mode;
                    stripe_mode = ApiEndPoints.ubsidiBuild ? "live" : "test";

                    //if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(merchantBusiness.connect_stripe_public_key)) {
                    if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                        //stripe_private_key = merchantBusiness.connect_stripe_private_key;
                        stripe_private_key = BuildConfig.connect_stripe_private_key;
                        //stripe_public_key = merchantBusiness.connect_stripe_public_key;
                        stripe_public_key = BuildConfig.connect_stripe_public_key;
                    } else {
                        if (stripe_mode.equalsIgnoreCase("live")) {
                            //stripe_private_key = merchantBusiness.stripe_private_key_live;
                            stripe_private_key = BuildConfig.stripe_private_key_live;
                            //stripe_public_key = merchantBusiness.stripe_public_key_live;
                            stripe_public_key = BuildConfig.stripe_public_key_live;
                        } else {
                            //stripe_private_key = merchantBusiness.stripe_private_key_test;
                            stripe_private_key = BuildConfig.stripe_private_key_test;
                            //stripe_public_key = merchantBusiness.stripe_public_key_test;
                            stripe_public_key = BuildConfig.stripe_public_key_test;
                        }
                    }
                    PaymentConfiguration.init(getActivity(), stripe_public_key);
                    stripe = new Stripe(getActivity(), stripe_public_key);
                    openStripeReaders(selectedCardReader);
                } else {

                }

            } else {
                SelectCardReaderDialogFragment selectCardReaderDialogFragment = SelectCardReaderDialogFragment.getInstance();
                selectCardReaderDialogFragment.show(getChildFragmentManager(), "card_readers");
                selectCardReaderDialogFragment.setCancelable(false);
                selectCardReaderDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof MerchantCardReader) {
                        selectedCardReader = (MerchantCardReader) o;
                        myApp.getMyPreferences().saveDefaultCardReader(selectedCardReader);
                        setUpMposTerminal(false);
                    } else {
                        goBackAfterPrint();
                    }
                });
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void openStripeReaders(MerchantCardReader selectedCardReader) {
        try {
            if (selectedCardReader.s_location_id == null) {
                selectedCardReader.s_location_id = merchantBusiness.s_location_id;
            }
            selectedConnectivity = "";
            if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet")) {
                selectedConnectivity = selectedCardReader.connectivity;
                askForPermission("internet");
              /*  String url = ApiEndPoints.CARD_READER_PAYMENT + "?s_location_id=" + selectedCardReader.s_location_id + "&s_terminal_id=" + selectedCardReader.s_terminal_id + "&amount=" + (grandTotal * 100) + "&business_id=" + merchantBusiness.id;
                startActivityForResult(new Intent(getActivity(), InternetCardReaderPaymentActivity.class).putExtra("url", url), Constants.CODE_WEBVIEW_INTENT);
    */
            } else if (selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("posbluetooth")
                    || selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase(TAPTOPAY)) {
                selectedConnectivity = selectedCardReader.connectivity;
                askForPermission("bluetooth");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForPermission(String discoverymethod) {
        try {
            final int locationPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.ACCESS_FINE_LOCATION);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                final int scanPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH_SCAN);
                final int connectPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH_CONNECT);
                if (locationPermission == PackageManager.PERMISSION_GRANTED && scanPermission == PackageManager.PERMISSION_GRANTED && connectPermission == PackageManager.PERMISSION_GRANTED) {
                    if (verifyGpsEnabled()) {
                        if (discoverymethod.equals("bluetooth")) {
                            showStripeBluetoothReaderDialog();
                        } else {
                            showStripInternetReaderDialog();
                        }

                    }
                } else {
                    // If we don't have them yet, request them before doing anything else
                    final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.BLUETOOTH_CONNECT, Manifest.permission.BLUETOOTH_SCAN, Manifest.permission.BLUETOOTH_ADMIN};
                    requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
                }
            } else {
                if (locationPermission == PackageManager.PERMISSION_GRANTED) {
                    if (verifyGpsEnabled()) {
                        if (discoverymethod.equals("bluetooth")) {
                            showStripeBluetoothReaderDialog();
                        } else {
                            showStripInternetReaderDialog();
                        }

                    }
                } else {
                    // If we don't have them yet, request them before doing anything else
                    final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION};
                    requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showStripeBluetoothReaderDialog() {
        try {
            StripeBluetoothCardReaderPaymentFragment stripeBluetoothCardReaderPaymentFragment = StripeBluetoothCardReaderPaymentFragment.getInstance(selectedCardReader, grandTotal,
                    !Validators.isNullOrEmpty(selectedConnectivity) && selectedConnectivity.equalsIgnoreCase(TAPTOPAY));
            stripeBluetoothCardReaderPaymentFragment.show(getChildFragmentManager(), "card_reader");
            stripeBluetoothCardReaderPaymentFragment.setCancelable(false);
            stripeBluetoothCardReaderPaymentFragment.setDialogDismissListener(new DialogDismissDataListener() {
                @Override
                public void onDialogDismiss(Object o, String cardName, String number, boolean isPaymentDeclined, boolean isCancelled,String tipFromCardReader) {
                    if (isPaymentDeclined) {
                        CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Payment Declined");
                        myApp.startPaymentFailedSound();
                        if (getActivity() != null) getActivity().runOnUiThread(() -> {
                            progressDialog.dismiss();
                        });
                        if (getActivity() != null) getActivity().runOnUiThread(() -> {
                            AnimatedConfirmationDialogFragmentNew animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragmentNew.getInstance("Payment Declined", "", 2, "Okay", null);
                            animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
                            animatedConfirmationDialogFragment.setDialogDismissListener(dismissListener -> {
                                managePaymentResponse("Declined", "", "", "Declined",tipFromCardReader);
                            });
                        });
                    } else if (isCancelled) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity(), R.style.AppDialog);
                        builder.setTitle("Payment was cancelled, Do you want print?");
                        builder.setPositiveButton("OK", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            managePaymentResponse("Cancelled", "", "", "Cancelled",tipFromCardReader);
                        });
                        builder.setNegativeButton("Cancel", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            goBackAfterPrint();
                        });
                        builder.setCancelable(false);
                        builder.show();
                    } else {
                        etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                        etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                        if (o instanceof com.stripe.stripeterminal.external.models.PaymentIntent) {
                            retrivePaymentIntentAndPrintWithId(((com.stripe.stripeterminal.external.models.PaymentIntent) o).getClientSecret(), cardName, number,tipFromCardReader);
                        } else if (o instanceof String) {
                            myApp.startPaymentFailedSound();
                            CommonFunctions.showSnackBar(CardReaderPaymentFragment.this.getActivity(), llMainLayout, (String) o);
                        } else {
                            myApp.startPaymentFailedSound();
                            CommonFunctions.showSnackBar(CardReaderPaymentFragment.this.getActivity(), llMainLayout, "Transaction was declined, aborted, or failed");

                        }
                    }
                }

                @Override
                public void onDialogDismissPaymentFailed() {
                    setBatteryLevel();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showStripInternetReaderDialog() {
        try {
            StripeInternetCardReaderPaymentFragment stripeInternetCardReaderPaymentFragment = StripeInternetCardReaderPaymentFragment.getInstance(selectedCardReader, grandTotal);
            stripeInternetCardReaderPaymentFragment.show(getChildFragmentManager(), "card_reader");
            stripeInternetCardReaderPaymentFragment.setCancelable(false);
            stripeInternetCardReaderPaymentFragment.setDialogDismissListener(new DialogDismissDataListener() {
                @Override
                public void onDialogDismiss(Object o, String cardName, String number, boolean isPaymentDeclined, boolean isCancelled,String tipFromCardReader) {
                    if (isPaymentDeclined) {
                        CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Payment Declined");
                        myApp.startPaymentFailedSound();
                        if (getActivity() != null) getActivity().runOnUiThread(() -> {
                            progressDialog.dismiss();
                        });
                        if (getActivity() != null) getActivity().runOnUiThread(() -> {
                            AnimatedConfirmationDialogFragmentNew animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragmentNew.getInstance("Payment Declined", "", 2, "Okay", null);
                            animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
                            animatedConfirmationDialogFragment.setDialogDismissListener(dismissListener -> {
                                managePaymentResponse("Declined", "", "", "Declined",tipFromCardReader);
                            });
                        });
                    } else if (isCancelled) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity(), R.style.AppDialog);
                        builder.setTitle("Payment was cancelled, Do you want print?");
                        builder.setPositiveButton("OK", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            managePaymentResponse("Cancelled", "", "", "Cancelled",tipFromCardReader);
                        });
                        builder.setNegativeButton("Cancel", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            goBackAfterPrint();
                        });
                        builder.setCancelable(false);
                        builder.show();
                    } else {
                        if (o instanceof Integer) {
                            if (((Integer) o) == 0) {
                                goBackAfterPrint();
                            }
                        } else {
                            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                            etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                            if (o instanceof com.stripe.stripeterminal.external.models.PaymentIntent) {
                                retrivePaymentIntentAndPrintWithId(((com.stripe.stripeterminal.external.models.PaymentIntent) o).getClientSecret(), cardName, number,tipFromCardReader);
                            } else if (o instanceof String) {
                                myApp.startPaymentFailedSound();
                                CommonFunctions.showSnackBar(CardReaderPaymentFragment.this.getActivity(), llMainLayout, (String) o);
                            } else {
                                myApp.startPaymentFailedSound();
                                CommonFunctions.showSnackBar(CardReaderPaymentFragment.this.getActivity(), llMainLayout, "Transaction was declined, aborted, or failed");
                            }
                        }
                    }
                }

                @Override
                public void onDialogDismissPaymentFailed() {
                    setBatteryLevel();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private boolean verifyGpsEnabled() {
        final LocationManager locationManager = (LocationManager) getActivity().getSystemService(Context.LOCATION_SERVICE);

        boolean gpsEnabled = false;
        if (locationManager == null) {
            ToastUtils.makeToast(getActivity(), "Location manager null");
        }
        try {
            gpsEnabled = locationManager != null &&
                    locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        } catch (Exception exception) {
            ToastUtils.makeLongToast(getActivity(), exception.getMessage());
            exception.printStackTrace();
        }

        if (!gpsEnabled) {
            // notify user
            new AlertDialog.Builder(new ContextThemeWrapper(getActivity(), R.style.Theme_MaterialComponents_DayNight_DarkActionBar))
                    .setMessage("Please enable location services")
                    .setCancelable(false)
                    .setPositiveButton("Open location settings", (dialog, which) -> {
                        startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                    })
                    .create()
                    .show();
        }

        return gpsEnabled;
    }

    public static boolean checkGPSStatus(Context context) {
        LocationManager manager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
        return manager.isProviderEnabled(LocationManager.GPS_PROVIDER);
    }

    private HashMap<String, String> generateFeeParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("amount", MyApp.df.format(grandTotal * 100));
        params.put("currency", "GBP");
        params.put("transaction_type", merchantBusiness.connect_service ? "connect" : "merchant");
        params.put("business_id", merchantBusiness.id);
        return params;
    }

    private void setListeners() {
        try {
            if (merchantBusiness.card_readers != null && merchantBusiness.card_readers.size() == 1) {
                selectedCardReader = merchantBusiness.card_readers.get(0);
                /*if (!Terminal.isInitialized()) {
                    Terminal.initTerminal(getActivity(), LogLevel.VERBOSE, new CustomTokenProvider(selectedCardReader.s_location_id, merchantBusiness.id), new CustomTerminalEventListener(getActivity()));
                } else {
                    LogUtils.e("Terminal already initialized");
                }*/
            }
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
            btnPay.setOnClickListener(view -> {
                if (Validators.isNullOrEmpty(etAmount.getText().toString()) || etAmount.getText().toString().equals("0.00")) {
                    etAmount.setError("Please enter amount");
                } else {
                    float totalAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                    if (totalAmount <= 0.30) {
                        etAmount.setError("Amount should be greater than 0.30");
                    } else {
                        if (!Validators.isNullOrEmpty(etTip.getText().toString()))
                            tipAmount = Float.parseFloat(etTip.getText().toString().replace(",", ""));
                        amount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                        grandTotal = tipAmount + amount;
                        etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                        etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                        if((tabsLayout.getSelectedTabPosition()==1 && !isCs30Device) || (isCs30Device && tabsTap2Pay.getSelectedTabPosition()==0)){
                            ArrayList<MerchantCardReader> card_readers = merchantBusiness.card_readers;
                            for (int i=0; i<card_readers.size(); i++){
                                MerchantCardReader obj = card_readers.get(i);
                                if(obj.connectivity!=null && obj.connectivity.equalsIgnoreCase(TAPTOPAY)){
                                    selectedCardReader = obj;
                                }
                            }
                            setUpMposTerminal(true);
                        }else {
                            ArrayList<MerchantCardReader> card_readers = merchantBusiness.card_readers;
                            if(card_readers.size()==2){
                                for (int i = 0; i < card_readers.size(); i++) {
                                    MerchantCardReader obj = card_readers.get(i);
                                    if (obj.connectivity != null && (obj.connectivity.equalsIgnoreCase("stripebluetooth") || obj.connectivity.equalsIgnoreCase("posbluetooth"))) {
                                        selectedCardReader = obj;
                                    }
                                }
                            }
                            setUpMposTerminal(false);
                        }
                    }
                }
            });
            btnCancel.setOnClickListener(view -> {
                if (getActivity() != null) {
                    getActivity().onBackPressed();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    DecimalFormat doubleFormat = new DecimalFormat("###,###,##0.00");

    /**
     * Receive the result of our permissions check, and initialize if we can
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        // If we receive a response to our permission check, initialize
        if (requestCode == Constants.PERMISSION_CODE_LOCATION && verifyGpsEnabled()) {
            showStripeBluetoothReaderDialog();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == 5) {
                if (resultCode == Activity.RESULT_OK)
                    showStripeBluetoothReaderDialog();
            }
            if (requestCode == Constants.CODE_WEBVIEW_INTENT) {
                if (data != null) {
                    etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                    etTip.addTextChangedListener(new MoneyTextWatcher(etTip));

                    String status = data.getStringExtra("status");
                    if (Validators.isNullOrEmpty(status) || status.equalsIgnoreCase("0")) {
                        myApp.startPaymentFailedSound();
                        CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Transaction was declined, aborted, or failed");
                        return;
                    }

                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> progressDialog.show());
                    }
                    String paymentIntentId = data.getStringExtra("payment_intent_id");
                    String client_secret = data.getStringExtra("client_secret");
                    retrivePaymentIntentAndPrint(client_secret);
                } else {

                    myApp.startPaymentFailedSound();
                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Transaction was declined, aborted, or failed");

                    etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                    etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void retrivePaymentIntentAndPrint(String clientSecret) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                progressDialog.show();
            });
            stripe.retrievePaymentIntent(clientSecret, new ApiResultCallback<PaymentIntent>() {
                @Override
                public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                    new Thread(() -> {
                        try {
                            //PaymentMethod paymentMethod = PaymentMethod.retrieve(paymentIntent.getPaymentMethodId());
                            PaymentMethod paymentMethod = paymentIntent.getPaymentMethod();
                            boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                            CommonFunctions.showSnackBar(getActivity(), llMainLayout, paymentSuccess ? "Payment Approved" : "Payment Declined");
                            if (paymentSuccess) myApp.startPaymentSuccessSound();
                            else myApp.startPaymentFailedSound();
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                            });
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                AnimatedConfirmationDialogFragmentNew animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragmentNew.getInstance(paymentSuccess ? "Payment Approved" : "Payment Declined", "", paymentSuccess ? 1 : 2, "Okay", null);
                                animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
                                animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                                    managePaymentResponse("Merchant Copy", paymentIntent, paymentMethod.card != null ? paymentMethod.card.brand.getDisplayName() : "", paymentMethod.card != null ? paymentMethod.card.last4 : "", paymentSuccess);
                                });
                            });

                        } catch (Exception e) {
                            e.printStackTrace();
                            boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                            CommonFunctions.showSnackBar(getActivity(), llMainLayout, paymentSuccess ? "Payment Approved" : "Payment Declined");
                            if (paymentSuccess) myApp.startPaymentSuccessSound();
                            else myApp.startPaymentFailedSound();
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                            });
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                AnimatedConfirmationDialogFragmentNew animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragmentNew.getInstance(paymentSuccess ? "Payment Approved" : "Payment Declined", "", paymentSuccess ? 1 : 2, "Okay", null);
                                animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
                                animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                                    managePaymentResponse("Merchant Copy", paymentIntent, "", "", paymentSuccess);
                                });
                            });
                        }

                    }).start();

                }

                @Override
                public void onError(@NotNull Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // Getting name and number from API response
    private void retrivePaymentIntentAndPrintWithId(String clientSecret, String cardName, String number,String tipFromCardReader) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                progressDialog.show();
            });
            stripe.retrievePaymentIntent(clientSecret, new ApiResultCallback<PaymentIntent>() {
                @Override
                public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                    new Thread(() -> {
                        try {
                            boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                            CommonFunctions.showSnackBar(getActivity(), llMainLayout, paymentSuccess ? "Payment Approved" : "Payment Declined");
                            if (paymentSuccess) myApp.startPaymentSuccessSound();
                            else myApp.startPaymentFailedSound();
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                            });
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                new Handler().post(() -> {
                                    AnimatedConfirmationDialogFragmentNew animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragmentNew.getInstance(paymentSuccess ? "Payment Approved" : "Payment Declined", "", paymentSuccess ? 1 : 2, "Okay", null);
                                    animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
                                    animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                                        managePaymentResponse("Merchant Copy", paymentIntent, cardName != null ? cardName : "", number != null ? number : "", paymentSuccess);
                                    });
                                });
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                            boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                            CommonFunctions.showSnackBar(getActivity(), llMainLayout, paymentSuccess ? "Payment Approved" : "Payment Declined");
                            if (paymentSuccess) myApp.startPaymentSuccessSound();
                            else myApp.startPaymentFailedSound();
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                            });
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                AnimatedConfirmationDialogFragmentNew animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragmentNew.getInstance(paymentSuccess ? "Payment Approved" : "Payment Declined", "", paymentSuccess ? 1 : 2, "Okay", null);
                                animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
                                animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                                    managePaymentResponse("Merchant Copy", paymentIntent, "", "", paymentSuccess);
                                });
                            });
                        }

                    }).start();
                }

                @Override
                public void onError(@NotNull Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goBackAfterPrint(){
        if (getActivity() != null) getActivity().runOnUiThread(() -> {
            if(isFromTheme2){
                changeFragment(new Theme2PaymentSelection());
            }else {
                getActivity().onBackPressed();
            }
        });
    }

    private void changeFragment(Fragment fragment) {
        FragmentManager manager = requireActivity().getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        Fragment payment_type_selection = manager.findFragmentByTag("payment_type_selection");
        Fragment theme2_payment_selection = manager.findFragmentByTag("theme2_payment_selection");
        if(payment_type_selection!=null){
            manager.beginTransaction().remove(payment_type_selection).commit();
            manager.popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        }
        if(theme2_payment_selection!=null){
            manager.beginTransaction().remove(theme2_payment_selection).commit();
            manager.popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        }
        transaction.replace(R.id.nav_host_fragment, fragment);
        transaction.commit();
        //transaction.addToBackStack(null);
    }
    private void managePaymentResponse(String title, String cardBrand, String cardNumber, String status1,String tipFromCardReader) {

        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.dismiss());
            }
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("mobile")) {
                goBackAfterPrint();
                return;
            }
            LogUtils.e("Printing");
            String payment_type = "";
            if (payment_type.equals("PIN")) {
                payment_type = "EMV";
            } else {
                payment_type = "Contactless";
            }
            String headerA = "", headerB = "", resAddress = "";
            if (merchantBusiness != null) {
                headerA = merchantBusiness.header_a;
                headerB = merchantBusiness.header_b;
            }
            if(!Validators.isNullOrEmpty(tipFromCardReader)){
                float fTipFromCardReader = Float.parseFloat(tipFromCardReader);
                tipAmount = tipAmount + fTipFromCardReader;
                grandTotal = grandTotal + fTipFromCardReader;
            }
            String actualAmount = "£" + MyApp.df.format(amount);
            String tip_amount = "Tip £" + MyApp.df.format(tipAmount);

            String printTotal = "£" + MyApp.df.format(grandTotal);

            /*String card = Validators.isNullOrEmpty(cardBrand) ? "" : "Card                    " + cardBrand;
            String account =Validators.isNullOrEmpty(cardBrand) ? "": "Account      " + cardNumber;
            String stripe_id = Validators.isNullOrEmpty(cardBrand) ? "" : "TID  " + "";*/
            String entry_mode = "Entry Mode         " + payment_type;
            String status = "Status            " + status1; //+ (paymentSuccess ? "Approved" : "Declined");
            String please = "Please Retain Receipt\nFor Your Record";

            String Time = new SimpleDateFormat("hh:mm:ss a").format(new Date());
            String date_final = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a");

            //String main_content = card + "\n" + account + "\n" + stripe_id + "\n" + entry_mode + "\n" + status + "\n";
            String main_content = entry_mode + "\n" + status + "\n";

            String footer = "";
            String footer1 = "";

            if (merchantBusiness != null) {
                footer = Validators.isNullOrEmpty(merchantBusiness.footer_a) ? "" : merchantBusiness.footer_a;
                footer1 = Validators.isNullOrEmpty(merchantBusiness.footer_b) ? "" : merchantBusiness.footer_b;
            }
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                myApp.iMinPrinterUtils.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
            } else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                if (zoneRichPrinter == null) {
                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
                } else {
                    zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                    zoneRichPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
                }
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                try {
                    if (bluetoothPrinter != null) {
                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                        if (device != null) {
                            CommonFunctions.functionThatDelay(200);
                            bluetoothPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
                        } else {
                            ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                sunmiPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
            }

            if (title.toLowerCase().contains("customer")) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                builder.setTitle("Is Merchant Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    //managePaymentResponse("Merchant Copy", paymentIntent, cardBrand, cardNumber, paymentSuccess);
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    goBackAfterPrint();
                });
                builder.setCancelable(false);
                builder.show();

            } else {
                goBackAfterPrint();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void managePaymentResponse(String title, PaymentIntent paymentIntent, String cardBrand, String cardNumber, boolean paymentSuccess) {

        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.dismiss());
            }
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("mobile")) {
                goBackAfterPrint();
                return;
            }
            LogUtils.e("Printing");
            if (title.toLowerCase().contains("merchant")) {
                if (merchantBusiness.auto_merchant_print != null && (merchantBusiness.auto_merchant_print.equalsIgnoreCase("true") || merchantBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                    printReceipt(title, paymentIntent, cardBrand, cardNumber, paymentSuccess);
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                    builder.setTitle("Is Merchant Copy Required ?");
                    builder.setPositiveButton("OK", (dialogInterface, i) -> {
                        dialogInterface.dismiss();
                        printReceipt(title, paymentIntent, cardBrand, cardNumber, paymentSuccess);
                    });
                    builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                        dialogInterface.dismiss();
                        printCustomerCopy(title, paymentIntent, cardBrand, cardNumber, paymentSuccess);
                    });
                    builder.setCancelable(false);
                    builder.show();
                }
            } else {
                printReceipt(title, paymentIntent, cardBrand, cardNumber, paymentSuccess);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCustomerCopy(String title, PaymentIntent paymentIntent, String cardBrand, String cardNumber, boolean paymentSuccess) {
        if (title.toLowerCase().contains("merchant")) {
            if (merchantBusiness.auto_customer_print != null && (merchantBusiness.auto_customer_print.equalsIgnoreCase("true") || merchantBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                managePaymentResponse("Customer Copy", paymentIntent, cardBrand, cardNumber, paymentSuccess);
            } else {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                builder.setTitle("Is Customer Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    managePaymentResponse("Customer Copy", paymentIntent, cardBrand, cardNumber, paymentSuccess);
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    goBackAfterPrint();
                });
                builder.setCancelable(false);
                builder.show();
            }

        } else {
            goBackAfterPrint();
        }
    }

    private void printReceipt(String title, PaymentIntent paymentIntent, String cardBrand, String cardNumber, boolean paymentSuccess) {
        String payment_type = "";
        if (payment_type.equals("PIN")) {
            payment_type = "EMV";
        } else {
            payment_type = "Contactless";
        }
        String headerA = "", headerB = "", resAddress = "";
        if (merchantBusiness != null) {
            headerA = merchantBusiness.header_a;
            headerB = merchantBusiness.header_b;
        }
        String actualAmount = "£" + MyApp.df.format(amount);
        String tip_amount = "Tip £" + MyApp.df.format(tipAmount);

        String printTotal = "£" + MyApp.df.format(grandTotal);

        String card = "Card                    " + cardBrand;
        String account = "Account      " + cardNumber;
        String stripe_id = "TID  " + paymentIntent.getId();
        String entry_mode = "Entry Mode         " + payment_type;
        String status = "Status            " + (paymentSuccess ? "Approved" : "Declined");
        String please = "Please Retain Receipt\nFor Your Record";

        String Time = new SimpleDateFormat("hh:mm:ss a").format(new Date());
        String date_final = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a");

        String main_content = card + "\n" + account + "\n" + stripe_id + "\n" + entry_mode + "\n" + status + "\n";

        String footer = "";
        String footer1 = "";

        if (merchantBusiness != null) {
            footer = merchantBusiness.footer_a;
            footer1 = merchantBusiness.footer_b;
        }
        if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
            myApp.iMinPrinterUtils.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
        } else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
            cs20PrintHelper.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
        } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
            if (zoneRichPrinter == null) {
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
            } else {
                zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                zoneRichPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
            }
        } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
            try {
                if (bluetoothPrinter != null) {
                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                    if (device != null) {
                        CommonFunctions.functionThatDelay(200);
                        bluetoothPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
                    } else {
                        ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            sunmiPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
        }

        if (title.toLowerCase().contains("merchant")) {
            printCustomerCopy(title, paymentIntent, cardBrand, cardNumber, paymentSuccess);
        } else {
            goBackAfterPrint();
        }
    }

    private void managePaymentResponse(String title, com.stripe.stripeterminal.external.models.PaymentIntent paymentIntent, String cardBrand, String cardNumber, boolean paymentSuccess) {

        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.dismiss());
            }
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("mobile")) {
                goBackAfterPrint();
                return;
            }
            LogUtils.e("Printing");
            String payment_type = "";
            if (payment_type.equals("PIN")) {
                payment_type = "EMV";
            } else {
                payment_type = "Contactless";
            }
            String headerA = "", headerB = "", resAddress = "";
            if (merchantBusiness != null) {
                headerA = merchantBusiness.header_a;
                headerB = merchantBusiness.header_b;
            }
            String actualAmount = "£" + MyApp.df.format(amount);
            String tip_amount = "Tip £" + MyApp.df.format(tipAmount);

            String printTotal = "£" + MyApp.df.format(grandTotal);

            String card = "Card                    " + cardBrand;
            String account = "Account      " + cardNumber;
            String stripe_id = "TID  " + paymentIntent.getId();
            String entry_mode = "Entry Mode         " + payment_type;
            String status = "Status            " + (paymentSuccess ? "Approved" : "Declined");
            String please = "Please Retain Receipt\nFor Your Record";

            String Time = new SimpleDateFormat("hh:mm:ss a").format(new Date());
            String date_final = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a");

            String main_content = card + "\n" + account + "\n" + stripe_id + "\n" + entry_mode + "\n" + status + "\n";

            String footer = "";
            String footer1 = "";

            if (merchantBusiness != null) {
                footer = merchantBusiness.footer_a;
                footer1 = merchantBusiness.footer_b;
            }
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                myApp.iMinPrinterUtils.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
            } else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                if (zoneRichPrinter == null) {
                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
                } else {
                    zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                    zoneRichPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
                }
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                try {
                    if (bluetoothPrinter != null) {
                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                        if (device != null) {
                            CommonFunctions.functionThatDelay(200);
                            bluetoothPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
                        } else {
                            ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                sunmiPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footer, footer1);
            }

            if (title.toLowerCase().contains("customer")) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                builder.setTitle("Is Merchant Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    managePaymentResponse("Merchant Copy", paymentIntent, cardBrand, cardNumber, paymentSuccess);
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    goBackAfterPrint();
                });
                builder.setCancelable(false);
                builder.show();

            } else {
                goBackAfterPrint();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStop() {
        CommonFunctions.hideKeyboard(getActivity(), etAmount);
        super.onStop();
    }

    private void bankingRequestApiCall(HashMap<String, String> hashMap) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.TAP_TO_PAY_REQUESTS;
            AndroidNetworking.post(url)
                    .addBodyParameter(hashMap)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                //ToastUtils.makeLongToast(requireActivity(), response.message);
                                progressDialog.dismiss();
                                if (dialogRequestWalletDialog != null) {
                                    dialogRequestWalletDialog.dismiss();
                                }
                                updateCount(1);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    //ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void updateCount(int count) {
        tapToPayCount = count;
        if (tvNoData != null && count > 0) {
            tvNoData.setText("Your have submitted request for Tap To Pay service.");
            btnStartBank.setVisibility(View.GONE);
        }
    }

    private void showRequestWalletDialog() {
        dialogRequestWalletDialog = new Dialog(requireContext());
        dialogRequestWalletDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogRequestWalletDialog.setContentView(R.layout.dialog_request_banking);
        dialogRequestWalletDialog.setCanceledOnTouchOutside(false);
        Window window = dialogRequestWalletDialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        RadioGroup rdInterest = dialogRequestWalletDialog.findViewById(R.id.rdInterest);
        TextView txtInterest = dialogRequestWalletDialog.findViewById(R.id.txtInterest);
        TextView txt_title = dialogRequestWalletDialog.findViewById(R.id.txt_title);
        txt_title.setText("Tap To Pay Request");
        txtInterest.setVisibility(View.GONE);
        rdInterest.setVisibility(View.GONE);
        EditText etName = dialogRequestWalletDialog.findViewById(R.id.etName);
        EditText etEmail = dialogRequestWalletDialog.findViewById(R.id.etEmail);
        EditText etNotes = dialogRequestWalletDialog.findViewById(R.id.etNotes);
        EditText etPhone = dialogRequestWalletDialog.findViewById(R.id.etPhone);
        //progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialogRequestWalletDialog.findViewById(R.id.img_close);
        MaterialButton btnSubmit = dialogRequestWalletDialog.findViewById(R.id.btnSubmit);
        btnSubmit.setOnClickListener(view -> {
            if (etName.getText().toString().isEmpty()) {
                etName.setError("Please enter name");
                etName.requestFocus();
            } else if (etEmail.getText().toString().isEmpty()) {
                etEmail.setError("Please enter email");
                etEmail.requestFocus();
            } else if (!Validators.isEmail(etEmail.getText().toString())) {
                etEmail.setError("Please enter valid email");
                etEmail.requestFocus();
            } else if (etPhone.getText().toString().isEmpty()) {
                etPhone.setError("Please enter phone number");
                etPhone.requestFocus();
            } else {
                HashMap<String, String> hashMap = new HashMap<>();
                hashMap.put("name", etName.getText().toString());
                hashMap.put("email", etEmail.getText().toString());
                hashMap.put("phone", etPhone.getText().toString());
                hashMap.put("message", etNotes.getText().toString());
                hashMap.put("business_id", merchantBusiness.id);
                bankingRequestApiCall(hashMap);
            }
        });
        img_close.setOnClickListener(view -> {
            dialogRequestWalletDialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogRequestWalletDialog.show();
    }

    private void getTapToPayCount() {
        try {
            String url = ApiEndPoints.TAP_TO_PAY_REQUESTS + "/count";
            AndroidNetworking.get(url)
                    .addQueryParameter("business_id", myApp.getMyPreferences().getMerchantBusinesses().id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (response.has("tap_count")) {
                                    updateCount(response.getInt("tap_count"));
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
