package com.tiffintom.partner1.fragments;

import static android.content.Context.CLIPBOARD_SERVICE;
import static com.tiffintom.partner1.utils.Constants.DELETE_CLICKED;
import static com.tiffintom.partner1.utils.Constants.EDIT_CLICKED;
import static com.tiffintom.partner1.utils.Constants.TRANSFER_CLICKED;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Group;
import androidx.recyclerview.widget.RecyclerView;

import android.os.CountDownTimer;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.CaxTonBaneficiariesActivity;
import com.tiffintom.partner1.activities.CaxTonBankTransctionListActivity;
import com.tiffintom.partner1.activities.CaxTonStandingInstructionsActivity;
import com.tiffintom.partner1.adapters.CaxTonBankTransactionAdapter;
import com.tiffintom.partner1.adapters.CaxTonBeneficiariesAdapter;
import com.tiffintom.partner1.adapters.CaxTonStandingInstructionsAdapter;
import com.tiffintom.partner1.adapters.SizeArrayAdapter;
import com.tiffintom.partner1.adapters.TransactionReasonAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher1;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonBankTransactionResponseModel;
import com.tiffintom.partner1.models.CaxTonBeneficiaresModel;
import com.tiffintom.partner1.models.CaxTonBeneficiariesResponseModel;
import com.tiffintom.partner1.models.CaxTonGetPinModel;
import com.tiffintom.partner1.models.CaxTonStandingInstResponseModel;
import com.tiffintom.partner1.models.CaxTonStandingInstructionModel;
import com.tiffintom.partner1.models.TransactionReasonModel;
import com.tiffintom.partner1.models.WalletListModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class CaxTonBank extends BaseFragment implements View.OnClickListener {
    RecyclerView rv_beneficaires_list, rv_transaction_list, rv_instructions_list;
    ImageView img_show_hide, img_show_detail;
    Button btnStartBank;
    TextView txt_available_balance_value, tvNoData, txt_no_transaction, txt_no_beneficaires, txt_view_all_transaction, txt_view_all_beneficaires, txt_add_beneficaires, tvResendOtp, txt_view_all_instructions, txt_no_instructions;
    ConstraintLayout const_transaction_list, const_beneficaires_list, const_standing_instructions_list;
    private CaxTonBeneficiariesAdapter caxTonBeneficairesListAdapter;
    private CaxTonBankTransactionAdapter caxTonRecentTransactionAdapter;
    private CaxTonStandingInstructionsAdapter caxTonStandingInstructionsAdapter;
    private String userBankId = "", finance_user_phone_number = "";
    private ProgressBar progressBeneficiary;
    private LinearLayout llAfterOtpSend, llAfterOtpSend1;
    private ConstraintLayout constSummary, constNoData;
    private CardView card_balance;
    private EditText etBankName, etAddressLine1, etAddressLine2, etSwift;
    private Dialog dialog, dialogTransfer, dialogStanding, dialogRequestWalletDialog;
    private int beneficairesPosition = -1, transferPosition = -1;
    private boolean isClickedOnTransfer = false;
    private float minimum_transfer_charge = 0f;
    private float transfer_charge = 0f;
    private float transfer_charge_back = 0f;
    private String transfer_charge_type = "";
    ArrayList<CaxTonBeneficiaresModel> caxTonBeneficiariesResponseModels;

    public static CaxTonBank newInstance() {
        CaxTonBank fragment = new CaxTonBank();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_cax_ton_bank, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        minimum_transfer_charge = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.minimum_transfer_charge;
        transfer_charge_back = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge_back;
        transfer_charge = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge;
        transfer_charge_type = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge_type;
        userBankId = myApp.getMyPreferences().getMerchantBusinesses().finance_user_id;
        finance_user_phone_number = myApp.getMyPreferences().getMerchantBusinesses().finance_user_phone_number;
        rv_beneficaires_list = view.findViewById(R.id.rv_beneficaires_list);
        img_show_hide = view.findViewById(R.id.img_show_hide);
        img_show_detail = view.findViewById(R.id.img_show_detail);
        rv_transaction_list = view.findViewById(R.id.rv_transaction_list);
        rv_instructions_list = view.findViewById(R.id.rv_instructions_list);
        txt_available_balance_value = view.findViewById(R.id.txt_available_balance_value);
        tvNoData = view.findViewById(R.id.tvNoData);
        img_show_hide.setOnClickListener(this);
        img_show_detail.setOnClickListener(this);
        img_show_hide.setImageResource(R.mipmap.ic_hide_password);
        txt_available_balance_value.setText(getString(R.string.xxxxx));
        btnStartBank = view.findViewById(R.id.btnStartBank);
        txt_no_transaction = view.findViewById(R.id.txt_no_transaction);
        const_transaction_list = view.findViewById(R.id.const_transaction_list);
        const_beneficaires_list = view.findViewById(R.id.const_beneficaires_list);
        const_standing_instructions_list = view.findViewById(R.id.const_standing_instructions_list);
        txt_no_beneficaires = view.findViewById(R.id.txt_no_beneficaires);
        txt_view_all_transaction = view.findViewById(R.id.txt_view_all_transaction);
        txt_view_all_beneficaires = view.findViewById(R.id.txt_view_all_beneficaires);
        txt_view_all_instructions = view.findViewById(R.id.txt_view_all_instructions);
        txt_no_instructions = view.findViewById(R.id.txt_no_instructions);
        txt_add_beneficaires = view.findViewById(R.id.txt_add_beneficaires);
        card_balance = view.findViewById(R.id.card_balance);
        constNoData = view.findViewById(R.id.constNoData);
        txt_add_beneficaires.setOnClickListener(this);
        txt_view_all_beneficaires.setOnClickListener(view1 -> {
            startActivity(new Intent(requireContext(), CaxTonBaneficiariesActivity.class));
        });
        txt_view_all_instructions.setOnClickListener(view1 -> {
            startActivity(new Intent(requireContext(), CaxTonStandingInstructionsActivity.class));
        });
        txt_view_all_transaction.setOnClickListener(view1 -> {
            startActivity(new Intent(requireContext(), CaxTonBankTransctionListActivity.class));
        });
        btnStartBank.setOnClickListener(view1 -> {
            showRequestWalletDialog();
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initAdapter();
        if (!Validators.isNullOrEmpty(myApp.getMyPreferences().getMerchantBusinesses().finance_user_id)) {
            fetchBeneficiaryList();
            fetchTransactionList();
            fetchStandingInstructionsList();
            card_balance.setVisibility(View.VISIBLE);
        } else {
            card_balance.setVisibility(View.GONE);
            constNoData.setVisibility(View.VISIBLE);
        }
        //fetchBeneficiaryAllList();
    }

    private void initAdapter() {
        caxTonBeneficairesListAdapter = new CaxTonBeneficiariesAdapter(new ArrayList<>(),
                // item clicked
                (position, data, clickedViewName) -> {
                    switch (clickedViewName) {
                        case EDIT_CLICKED: {
                            beneficairesPosition = position;
                            addEditBeneficiaryDialog(true, ((CaxTonBeneficiaresModel) data));
                            break;
                        }
                        case DELETE_CLICKED: {
                            deleteConfirmationDialog(((CaxTonBeneficiaresModel) data));
                            break;
                        }
                        case TRANSFER_CLICKED: {
                            transferPosition = position;
                            isClickedOnTransfer = true;
                            getBankBalance(((CaxTonBeneficiaresModel) data));
                            break;
                        }
                    }
                });
        caxTonRecentTransactionAdapter = new CaxTonBankTransactionAdapter(new ArrayList<>(), (position, data) -> {
        });
        rv_transaction_list.setAdapter(caxTonRecentTransactionAdapter);
        rv_beneficaires_list.setAdapter(caxTonBeneficairesListAdapter);

        caxTonStandingInstructionsAdapter = new CaxTonStandingInstructionsAdapter(new ArrayList<>(),
                false,
                // item clicked
                (position, data, clickedViewName) -> {
                    switch (clickedViewName) {
                        case EDIT_CLICKED: {
                            beneficairesPosition = position;
                            addEditBeneficiaryDialog(true, ((CaxTonBeneficiaresModel) data));
                            break;
                        }
                        case DELETE_CLICKED: {
                            deleteConfirmationDialogInst(((CaxTonStandingInstructionModel) data));
                            break;
                        }
                        case TRANSFER_CLICKED: {
                            transferPosition = position;
                            isClickedOnTransfer = true;
                            getBankBalance(((CaxTonBeneficiaresModel) data));
                            break;
                        }
                    }
                });
        rv_instructions_list.setAdapter(caxTonStandingInstructionsAdapter);
    }

    public void updateCount(int count) {
        if (tvNoData != null && count > 0) {
            tvNoData.setText("Your have submitted request for banking service.");
            btnStartBank.setVisibility(View.GONE);
        }
    }

    private void deleteConfirmationDialogInst(CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        AlertDialog alertDialog = new AlertDialog.Builder(requireContext()).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
        animation_view.setVisibility(View.GONE);
        TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
        TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
        tvInfo1.setVisibility(View.INVISIBLE);
        tvInfo.setText("Are you sure you want to delete?");
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            deleteStandingApiCall(caxTonBeneficiaresModel);
            alertDialog.dismiss();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    private void deleteConfirmationDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        AlertDialog alertDialog = new AlertDialog.Builder(requireContext()).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
        animation_view.setVisibility(View.GONE);
        TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
        TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
        tvInfo1.setVisibility(View.INVISIBLE);
        tvInfo.setText("Are you sure you want to delete?");
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            deleteBeneficiaryApiCall(caxTonBeneficiaresModel);
            alertDialog.dismiss();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.img_show_hide) {
            if (img_show_hide.isActivated()) {
                img_show_hide.setActivated(false);
                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                txt_available_balance_value.setText(getString(R.string.xxxxx));
            } else {
                isClickedOnTransfer = false;
                enterPinDialog();
            }
        } else if (view.getId() == R.id.img_show_detail) {
            fetchBankDetail();
        } else if (view.getId() == R.id.txt_add_beneficaires) {
            addEditBeneficiaryDialog(false, new CaxTonBeneficiaresModel());
        }
    }

    private void fetchTransactionList() {
        try {
            String url = ApiEndPoints.BANK_TRANSACTION_LIST + userBankId + "/transactions";
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("page", String.valueOf(1));
            params.put("per_page", String.valueOf(3));
            params.put("not_status", "1");
            AndroidNetworking.get(url)
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(CaxTonBankTransactionResponseModel.class, new ParsedRequestListener<CaxTonBankTransactionResponseModel>() {
                        @Override
                        public void onResponse(CaxTonBankTransactionResponseModel response) {
                            try {
                                progressDialog.dismiss();
                                const_transaction_list.setVisibility(View.VISIBLE);
                                if (response.caxTonBankTransactionModels.isEmpty()) {
                                    txt_no_transaction.setVisibility(View.VISIBLE);
                                    rv_transaction_list.setVisibility(View.GONE);
                                    txt_view_all_transaction.setVisibility(View.GONE);
                                } else {
                                    txt_no_transaction.setVisibility(View.GONE);
                                    rv_transaction_list.setVisibility(View.VISIBLE);
                                    txt_view_all_transaction.setVisibility(View.VISIBLE);
                                    caxTonRecentTransactionAdapter.notifyList(response.caxTonBankTransactionModels);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_transaction.setVisibility(View.VISIBLE);
                                rv_transaction_list.setVisibility(View.GONE);
                                txt_view_all_transaction.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchStandingInstructionsList() {
        try {
            String url = ApiEndPoints.BANK_TRANSACTION_LIST + userBankId + "/standing-instructions";
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("page", String.valueOf(1));
            params.put("per_page", String.valueOf(3));
            params.put("not_status", "1");
            AndroidNetworking.get(url)
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(CaxTonStandingInstResponseModel.class, new ParsedRequestListener<CaxTonStandingInstResponseModel>() {
                        @Override
                        public void onResponse(CaxTonStandingInstResponseModel response) {
                            try {
                                progressDialog.dismiss();
                                const_standing_instructions_list.setVisibility(View.VISIBLE);
                                if (response.caxTonStandingInstructionModels.isEmpty()) {
                                    txt_no_instructions.setVisibility(View.VISIBLE);
                                    rv_instructions_list.setVisibility(View.GONE);
                                    txt_view_all_instructions.setVisibility(View.GONE);
                                } else {
                                    txt_no_instructions.setVisibility(View.GONE);
                                    rv_instructions_list.setVisibility(View.VISIBLE);
                                    txt_view_all_instructions.setVisibility(View.VISIBLE);
                                    caxTonStandingInstructionsAdapter.notifyList(response.caxTonStandingInstructionModels);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_instructions.setVisibility(View.VISIBLE);
                                const_standing_instructions_list.setVisibility(View.VISIBLE);
                                rv_instructions_list.setVisibility(View.GONE);
                                txt_view_all_instructions.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchBeneficiaryList() {
        try {
            String url = ApiEndPoints.BENEFICIARIES_LIST + userBankId + "/beneficiary";
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("page", String.valueOf(1));
            params.put("per_page", String.valueOf(3));
            params.put("not_status", "1");
            AndroidNetworking.get(url)
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(CaxTonBeneficiariesResponseModel.class, new ParsedRequestListener<CaxTonBeneficiariesResponseModel>() {
                        @Override
                        public void onResponse(CaxTonBeneficiariesResponseModel response) {
                            try {
                                progressDialog.dismiss();
                                const_beneficaires_list.setVisibility(View.VISIBLE);
                                if (response.caxTonBeneficiaresModels.isEmpty()) {
                                    txt_no_beneficaires.setVisibility(View.VISIBLE);
                                    rv_beneficaires_list.setVisibility(View.GONE);
                                    txt_view_all_beneficaires.setVisibility(View.GONE);
                                } else {
                                    txt_no_beneficaires.setVisibility(View.GONE);
                                    rv_beneficaires_list.setVisibility(View.VISIBLE);
                                    txt_view_all_beneficaires.setVisibility(View.VISIBLE);
                                    caxTonBeneficairesListAdapter.notifyList(response.caxTonBeneficiaresModels);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                const_beneficaires_list.setVisibility(View.VISIBLE);
                                txt_no_beneficaires.setVisibility(View.VISIBLE);
                                rv_beneficaires_list.setVisibility(View.GONE);
                                txt_view_all_beneficaires.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void deleteStandingApiCall(CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.GET_BANK_BALANCE + userBankId + "/standing-instructions/" + caxTonBeneficiaresModel.id;
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.delete(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                fetchStandingInstructionsList();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireContext(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void deleteBeneficiaryApiCall(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.GET_BANK_BALANCE + userBankId + "/beneficiary/" + caxTonBeneficiaresModel.id;
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.delete(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                fetchBeneficiaryList();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void getBankBalance(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.GET_BANK_BALANCE + userBankId + "/balance";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                String transferBalance = "0.00";
                                if (Validators.isNullOrEmpty(response.balance)) {
                                    txt_available_balance_value.setText(myApp.currencySymbol + "0.00");
                                } else {
                                    transferBalance = "" + CommonFunctions.formatTo2Digit(Float.parseFloat(response.balance));
                                    txt_available_balance_value.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(Float.parseFloat(response.balance)));
                                }
                                if (isClickedOnTransfer) {
                                    txt_available_balance_value.setText(getString(R.string.xxxxx));
                                    isClickedOnTransfer = false;
                                    showTransferDialog(caxTonBeneficiaresModel, transferBalance);
                                } else {
                                    img_show_hide.setActivated(true);
                                    img_show_hide.setImageResource(R.mipmap.ic_show_password);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void addEditStandingApiCall(boolean isFromEdit, CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        try {
            if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }
            //progressDialog.show();
            String url = isFromEdit ? ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/standing-instructions/" + caxTonBeneficiaresModel.id : ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/standing-instructions";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.post(url)
                    .addBodyParameter(caxTonBeneficiaresModel)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialogStanding != null) {
                                    dialogStanding.dismiss();
                                }
                                if (isFromEdit) {
                                    caxTonStandingInstructionsAdapter.notifyItemChanged(beneficairesPosition);
                                } else {
                                    fetchStandingInstructionsList();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireContext(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void addEditBeneficiaryApiCall(boolean isFromEdit, CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }
            //progressDialog.show();
            String url = isFromEdit ? ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/beneficiary/" + caxTonBeneficiaresModel.id : ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/beneficiary";
            Log.e("wallet_id", "wallet_id " + url);
            caxTonBeneficiaresModel.country = "GB";
            caxTonBeneficiaresModel.currency = "GBP";
            AndroidNetworking.post(url)
                    .addBodyParameter(caxTonBeneficiaresModel)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialog != null) {
                                    dialog.dismiss();
                                }
                                if (isFromEdit) {
                                    caxTonBeneficairesListAdapter.notifyItemChanged(beneficairesPosition);
                                } else {
                                    fetchBeneficiaryList();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void lookUpAccountApiCall(String sortCode, String accountNumber, String type) {
        try {
            if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }
            //progressDialog.show();
            String url = ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/beneficiary/lookup";
            HashMap<String, String> params = new HashMap<>();
            params.put("country", "GB");
            params.put("currency", "GBP");
            params.put("sortCode", sortCode);
            params.put("account_number", accountNumber);
            params.put("beneficiary_type", type);
            Log.e("wallet_id", "wallet_id " + url + " params " + params);
            AndroidNetworking.post(url)
                    .addBodyParameter(params)
                    .build()
                    .getAsObject(CaxTonBeneficiaresModel.class, new ParsedRequestListener<CaxTonBeneficiaresModel>() {
                        @Override
                        public void onResponse(CaxTonBeneficiaresModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (etSwift != null) {
                                    etSwift.setText(response.swift);
                                }
                                if (etAddressLine1 != null) {
                                    etAddressLine1.setText(response.address1);
                                }
                                if (etAddressLine2 != null) {
                                    etAddressLine2.setText(response.address2);
                                }
                                if (etBankName != null) {
                                    etBankName.setText(response.bank_name);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showTransferApiCall(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            /*if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }*/
            progressDialog.show();
            String url = ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/transfer";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.post(url)
                    .addBodyParameter(caxTonBeneficiaresModel)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialogTransfer != null) {
                                    dialogTransfer.dismiss();
                                }
                                caxTonRecentTransactionAdapter.notifyItemChanged(transferPosition);
                                fetchTransactionList();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showTransferDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel, String availableBalance) {
        Dialog dialogTransfer = new Dialog(requireContext());
        dialogTransfer.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogTransfer.setContentView(R.layout.dialog_trasfer);
        dialogTransfer.setCanceledOnTouchOutside(false);
        Window window = dialogTransfer.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        progressBeneficiary = dialogTransfer.findViewById(R.id.progress_image);
        MaterialButton btnSubmit = dialogTransfer.findViewById(R.id.btnSubmit);
        //progress_image.setVisibility(View.VISIBLE);
        ConstraintLayout llFromDate = dialogTransfer.findViewById(R.id.llFromDate);
        ImageView img_close = dialogTransfer.findViewById(R.id.img_close);
        Group groupPaymentDate = dialogTransfer.findViewById(R.id.groupPaymentDate);
        EditText etAmount = dialogTransfer.findViewById(R.id.etAmount);
        EditText etFees = dialogTransfer.findViewById(R.id.etFees);
        EditText etNotes = dialogTransfer.findViewById(R.id.etNotes);
        TextView txtFees = dialogTransfer.findViewById(R.id.txtFees);
        TextView txt_available_balance = dialogTransfer.findViewById(R.id.txt_available_balance);
        TextView tvFromDate = dialogTransfer.findViewById(R.id.tvFromDate);
        TextView txtRemainningAmount = dialogTransfer.findViewById(R.id.txtRemainningAmount);
        Spinner spinnerReason = dialogTransfer.findViewById(R.id.spinnerReason);

        ArrayList<TransactionReasonModel> transactionReasonModels = CommonFunctions.getTransactionReason();
        TransactionReasonAdapter transactionReasonAdapter = new TransactionReasonAdapter(requireContext(), transactionReasonModels);
        transactionReasonAdapter.setDropDownViewResource(R.layout.spinner_item);
        spinnerReason.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                caxTonBeneficiaresModel.transaction_reason = transactionReasonModels.get(i).id;
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
        spinnerReason.setAdapter(transactionReasonAdapter);

        groupPaymentDate.setVisibility(View.VISIBLE);
        txt_available_balance.setVisibility(View.VISIBLE);
        txt_available_balance.setText(myApp.currencySymbol + availableBalance + " Available funds");
        etAmount.addTextChangedListener(new MoneyTextWatcher1(etAmount));
        BigDecimal availableBalanceBig = BigDecimal.valueOf(Float.parseFloat(availableBalance));
        AtomicInteger fromYear = new AtomicInteger();
        AtomicInteger fromMonth = new AtomicInteger();
        AtomicInteger fromDay = new AtomicInteger();
        Calendar fromCalendar = Calendar.getInstance();
        Calendar selectedCalendar = Calendar.getInstance();
        tvFromDate.setText("" + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        caxTonBeneficiaresModel.payment_date = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(getContext(), (datePicker, y, m, d) -> {
                fromDay.set(d);
                fromMonth.set(m);
                fromYear.set(y);
                selectedCalendar.set(y, (m), d);
                if (selectedCalendar.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY || selectedCalendar.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
                    new AlertDialog.Builder(requireContext())
                            .setMessage("Bank transfers are not available on weekends.")
                            .setPositiveButton(android.R.string.ok, (dialog, which) -> {
                                dialog.dismiss();
                            })
                            .setIcon(android.R.drawable.ic_dialog_alert)
                            .show();
                }
                tvFromDate.setText("" + CommonFunctions.formatMiliToDesireFormat(selectedCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                //offer.offer_from = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
                caxTonBeneficiaresModel.payment_date = CommonFunctions.formatMiliToDesireFormat(selectedCalendar.getTimeInMillis(), "yyyy-MM-dd");
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
        });
        etAmount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (editable.length() == 0) {
                    txtFees.setVisibility(View.GONE);
                    etFees.setVisibility(View.GONE);
                    etFees.setText(myApp.currencySymbol + "0.00");
                } else {
                    txtFees.setVisibility(View.VISIBLE);
                    etFees.setVisibility(View.VISIBLE);
                    float amount = 0;
                    if (transfer_charge_type.equalsIgnoreCase("flat")) {
                        amount = amount + transfer_charge;
                        etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(amount));
                        BigDecimal trasferChargeBig = BigDecimal.valueOf(transfer_charge);
                        BigDecimal etAmountEnteredByUser = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", "")));
                        caxTonBeneficiaresModel.trasferChargeBig = trasferChargeBig;
                        caxTonBeneficiaresModel.etAmountEnteredByUser = etAmountEnteredByUser;
                        txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(trasferChargeBig))));
                    } else if (transfer_charge_type.equalsIgnoreCase("percentage")) {
                        BigDecimal trasferChargeBig = BigDecimal.valueOf(transfer_charge);
                        BigDecimal minimumTransferCharge = BigDecimal.valueOf(minimum_transfer_charge);
                        BigDecimal etAmountEnteredByUser = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", "")));
                        BigDecimal etAmountBigDecimal = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", ""))).multiply(trasferChargeBig).divide(BigDecimal.valueOf(100));
                        caxTonBeneficiaresModel.trasferChargeBig = trasferChargeBig;
                        caxTonBeneficiaresModel.etAmountEnteredByUser = etAmountEnteredByUser;
                        caxTonBeneficiaresModel.minimumTransferCharge = minimumTransferCharge;
                        if (etAmountBigDecimal.compareTo(minimumTransferCharge) > 0) {
                            etAmountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etAmountBigDecimal = etAmountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etFees.setText(myApp.currencySymbol + etAmountBigDecimal);
                            caxTonBeneficiaresModel.etFeesAmountBigDecimal = etAmountBigDecimal;
                            txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(etAmountBigDecimal))));
                        } else {
                            minimumTransferCharge.setScale(2, BigDecimal.ROUND_HALF_UP);
                            minimumTransferCharge = minimumTransferCharge.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etFees.setText(myApp.currencySymbol + minimumTransferCharge);
                            caxTonBeneficiaresModel.etFeesAmountBigDecimal = minimumTransferCharge;
                            txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(minimumTransferCharge))));
                        }
                       /* if (amount < minimum_transfer_charge) {
                            etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(minimum_transfer_charge));
                        }else {
                            etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(amount));
                        }*/
                    }
                }
            }
        });
        etNotes.setText(caxTonBeneficiaresModel.notes);
        img_close.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        btnSubmit.setOnClickListener(view -> {
            if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) == 0) {
                etAmount.setError("Amount must be greater than 0");
                etAmount.requestFocus();
            } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) < 5) {
                etAmount.setError("Entered amount must be greater than " + myApp.currencySymbol + "5.00");
                etAmount.requestFocus();
            } else {
                if (availableBalanceBig.compareTo(caxTonBeneficiaresModel.etFeesAmountBigDecimal.add(caxTonBeneficiaresModel.etAmountEnteredByUser)) > 0) {
                    caxTonBeneficiaresModel.amount = etAmount.getText().toString().replace(",", "");
                    caxTonBeneficiaresModel.transferCharger = etFees.getText().toString();
                    caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                    caxTonBeneficiaresModel.user_id = userBankId;
                    dialogTransfer.dismiss();
                    showTransferSummaryDialog(caxTonBeneficiaresModel, availableBalanceBig);
                } else {
                    etAmount.setError("Insufficient funds");
                    etAmount.requestFocus();
                }
                //showTransferApiCall(caxTonBeneficiaresModel);
            }
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogTransfer.show();
    }

    private void showTransferSummaryDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel, BigDecimal availableBalanceBig) {
        dialogTransfer = new Dialog(requireContext());
        dialogTransfer.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogTransfer.setContentView(R.layout.dialog_trasfer_summary);
        dialogTransfer.setCanceledOnTouchOutside(false);
        Window window = dialogTransfer.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        progressBeneficiary = dialogTransfer.findViewById(R.id.progress_image);
        ConstraintLayout constAmountToPay = dialogTransfer.findViewById(R.id.constAmountToPay);
        //progress_image.setVisibility(View.VISIBLE);
        TextView txtVerificationMobile = dialogTransfer.findViewById(R.id.txtVerificationMobile);
        if (finance_user_phone_number.length() > 5) {
            String first = "OTP is sent to the ";
            String second = " <font color='#3F51B5'>" + finance_user_phone_number.substring(0, 3) + "****" + finance_user_phone_number.substring((finance_user_phone_number.length() - 3), finance_user_phone_number.length()) + "</font>";
            txtVerificationMobile.setText(Html.fromHtml(first + second));
        }
        llAfterOtpSend = dialogTransfer.findViewById(R.id.llAfterOtpSend);
        llAfterOtpSend1 = dialogTransfer.findViewById(R.id.llAfterOtpSend1);
        constSummary = dialogTransfer.findViewById(R.id.constSummary);
        Button btnVerify = dialogTransfer.findViewById(R.id.btnVerify);
        EditText etOtp = dialogTransfer.findViewById(R.id.etOtp);
        tvResendOtp = dialogTransfer.findViewById(R.id.tvResendOtp);
        Button btnCancel = dialogTransfer.findViewById(R.id.btnCancel);
        ImageView img_close = dialogTransfer.findViewById(R.id.img_close);
        TextView txt_fees_value = dialogTransfer.findViewById(R.id.txt_fees_value);
        TextView txtNamevalue = dialogTransfer.findViewById(R.id.txtNamevalue);
        TextView txtBankValue = dialogTransfer.findViewById(R.id.txtBankValue);
        TextView txtNotesValue = dialogTransfer.findViewById(R.id.txtNotesValue);
        CheckBox cxPaymentInst = dialogTransfer.findViewById(R.id.cxPaymentInst);
        TextView txtAvaialbleBalanceValue = dialogTransfer.findViewById(R.id.txtAvaialbleBalanceValue);
        TextView txtDepositeCurrenyBalanceValue = dialogTransfer.findViewById(R.id.txtDepositeCurrenyBalanceValue);
        TextView txtAmountToPay = dialogTransfer.findViewById(R.id.txtAmount);
        TextView txtAmountToPayListValue = dialogTransfer.findViewById(R.id.txtAmountToPayListValue);
        txtAmountToPay.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser.add(caxTonBeneficiaresModel.etFeesAmountBigDecimal)));
        txt_fees_value.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etFeesAmountBigDecimal));
        txtAmountToPayListValue.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser));
        cxPaymentInst.setText(getString(R.string.payment_inst1) + " " + myApp.currencySymbol + CommonFunctions.formatTo2Digit(transfer_charge_back) + " " + getString(R.string.payment_inst3));
        txtNamevalue.setText(caxTonBeneficiaresModel.name);
        txtBankValue.setText(caxTonBeneficiaresModel.bank_name);
        txtNotesValue.setText(caxTonBeneficiaresModel.notes);
        txtDepositeCurrenyBalanceValue.setText("" + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(caxTonBeneficiaresModel.etAmountEnteredByUser.add(caxTonBeneficiaresModel.etFeesAmountBigDecimal))));
        txtAvaialbleBalanceValue.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig));
        img_close.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        btnCancel.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        constAmountToPay.setOnClickListener(view -> {
            if (!cxPaymentInst.isChecked()) {
                ToastUtils.makeLongToast(requireContext(), "Please select terms and condition");
            } else {
                sendOtpApi();
            }
            /*if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            } else {
                caxTonBeneficiaresModel.amount = etAmount.getText().toString();
                caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                caxTonBeneficiaresModel.user_id = userBankId;
                //showTransferApiCall(caxTonBeneficiaresModel);
            }*/
        });

        btnVerify.setOnClickListener(view -> {
            if (etOtp.getText().toString().isEmpty()) {
                etOtp.setError("Please enter otp");
                etOtp.requestFocus();
            } else {
                CommonFunctions.hideKeyboard(requireActivity(), btnVerify);
                caxTonBeneficiaresModel.otp = etOtp.getText().toString();
                caxTonBeneficiaresModel.amount = "" + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser);
                caxTonBeneficiaresModel.fee = "" + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etFeesAmountBigDecimal);
                showTransferApiCall(caxTonBeneficiaresModel);
            }
        });
        dialogTransfer.setOnDismissListener(dialogInterface -> {
            if (countDownTimer != null) {
                countDownTimer.cancel();
            }
        });
        tvResendOtp.setOnClickListener(view -> {
            sendOtpApi();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogTransfer.show();
    }

    private void sendOtpApi() {
        try {
           /* if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }*/
            progressDialog.show();
            String url = ApiEndPoints.send_otp + userBankId + "/send-otp";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                ToastUtils.makeLongToast(requireContext(), response.message);
                                if (countDownTimer != null) {
                                    countDownTimer.start();
                                }
                                if (llAfterOtpSend != null) {
                                    llAfterOtpSend.setVisibility(View.VISIBLE);
                                    llAfterOtpSend1.setVisibility(View.VISIBLE);
                                    constSummary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireContext(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    CountDownTimer countDownTimer = new CountDownTimer(30000, 1000) {

        @Override
        public void onTick(long millisUntilFinished) {
            int seconds = (int) (millisUntilFinished / 1000);
            int minutes = seconds / 60;
            seconds %= 60;
            if (tvResendOtp != null) {
                tvResendOtp.setEnabled(false);
                tvResendOtp.setText("Resend otp in " + String.format("%02d", minutes) + ":" + String.format(
                        "%02d",
                        seconds
                ));
            }
        }

        @Override
        public void onFinish() {
            if (tvResendOtp != null) {
                tvResendOtp.setEnabled(true);
                tvResendOtp.setText("Resend Otp");
            }
        }
    };

    private void addEditBeneficiaryDialog(boolean isFromEdit, CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_add_edit_beneficiary);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ImageView img_close = dialog.findViewById(R.id.img_close);
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        TextView txt_title = dialog.findViewById(R.id.txt_title);
        RadioButton rd_company = dialog.findViewById(R.id.rd_company);
        RadioButton rd_individual = dialog.findViewById(R.id.rd_individual);
        EditText etAccountNumner = dialog.findViewById(R.id.etAccountNumner);
        EditText etsortCode = dialog.findViewById(R.id.etsortCode);
        EditText etName = dialog.findViewById(R.id.etName);
        EditText etEmail = dialog.findViewById(R.id.etEmail);
        EditText etPhone = dialog.findViewById(R.id.etPhone);
        EditText etIbanNumber = dialog.findViewById(R.id.etIbanNumber);
        EditText etNotes = dialog.findViewById(R.id.etNotes);
        etSwift = dialog.findViewById(R.id.etSwift);
        etBankName = dialog.findViewById(R.id.etBankName);
        etAddressLine1 = dialog.findViewById(R.id.etAddressLine1);
        etAddressLine2 = dialog.findViewById(R.id.etAddressLine2);
        TextView txtLookUp = dialog.findViewById(R.id.txtLookUp);
        progressBeneficiary = dialog.findViewById(R.id.progressBeneficiary);
        etsortCode.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (editable.length() == 0) {
                    txtLookUp.setVisibility(View.GONE);
                } else {
                    txtLookUp.setVisibility(View.VISIBLE);
                }
            }
        });
        rd_company.setChecked(true);
        if (isFromEdit) {
            txt_title.setText(getString(R.string.edit_beneficiary));
            btnSubmit.setText(getString(R.string.edit_beneficiary));
            etAddressLine1.setText(caxTonBeneficiaresModel.address1);
            etAddressLine2.setText(caxTonBeneficiaresModel.address2);
            etAccountNumner.setText(caxTonBeneficiaresModel.account_number);
            etsortCode.setText(caxTonBeneficiaresModel.sortCode);
            etName.setText(caxTonBeneficiaresModel.name);
            etBankName.setText(caxTonBeneficiaresModel.bank_name);
            etEmail.setText(caxTonBeneficiaresModel.email);
            etPhone.setText(caxTonBeneficiaresModel.phone);
            etSwift.setText(caxTonBeneficiaresModel.swift);
            etIbanNumber.setText(caxTonBeneficiaresModel.iban);
            etNotes.setText(caxTonBeneficiaresModel.notes);
            if (caxTonBeneficiaresModel.beneficiary_type != null) {
                if (caxTonBeneficiaresModel.beneficiary_type.equalsIgnoreCase("Entity")) {
                    rd_company.setChecked(true);
                } else {
                    rd_individual.setChecked(true);
                }
            }
        }
        txtLookUp.setOnClickListener(view -> {
            CommonFunctions.hideKeyboard(requireActivity(), etsortCode);
            lookUpAccountApiCall(etsortCode.getText().toString(), etAccountNumner.getText().toString(), rd_company.isChecked() ? "Entity" : "Individual");
        });
        btnSubmit.setOnClickListener(view -> {
            if (etAccountNumner.getText().toString().isEmpty()) {
                etAccountNumner.setError("Please enter account number");
                etAccountNumner.requestFocus();
            } else if (etsortCode.getText().toString().isEmpty()) {
                etsortCode.setError("Please enter sort code");
                etsortCode.requestFocus();
            } else if (etName.getText().toString().isEmpty()) {
                etName.setError("Please enter name");
                etName.requestFocus();
            } else if (etBankName.getText().toString().isEmpty()) {
                etBankName.setError("Please enter bank name");
                etBankName.requestFocus();
            } else if (etAddressLine1.getText().toString().isEmpty()) {
                etAddressLine1.setError("Please enter address line 1");
                etAddressLine1.requestFocus();
            } else if (etAddressLine2.getText().toString().isEmpty()) {
                etAddressLine2.setError("Please enter address line 2");
                etAddressLine2.requestFocus();
            } else {
                if (rd_company.isChecked()) {
                    caxTonBeneficiaresModel.beneficiary_type = "Entity";
                } else {
                    caxTonBeneficiaresModel.beneficiary_type = "Individual";
                }
                caxTonBeneficiaresModel.bank_name = etBankName.getText().toString();
                caxTonBeneficiaresModel.address1 = etAddressLine1.getText().toString();
                caxTonBeneficiaresModel.address2 = etAddressLine2.getText().toString();
                caxTonBeneficiaresModel.name = etName.getText().toString();
                caxTonBeneficiaresModel.sortCode = etsortCode.getText().toString();
                caxTonBeneficiaresModel.account_number = etAccountNumner.getText().toString();
                caxTonBeneficiaresModel.email = etEmail.getText().toString();
                caxTonBeneficiaresModel.phone = etPhone.getText().toString();
                caxTonBeneficiaresModel.iban = etIbanNumber.getText().toString();
                caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                addEditBeneficiaryApiCall(isFromEdit, caxTonBeneficiaresModel);
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void enterPinDialog() {
        Dialog dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_enter_pin);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        EditText etPin = dialog.findViewById(R.id.etPin);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        btnSubmit.setOnClickListener(view -> {
            if (etPin.getText().toString().isEmpty()) {
                etPin.setError("Please enter pin");
                etPin.requestFocus();
            } else if (merchantBusiness.access_number == null) {
                etPin.setError("Pin does not match");
                etPin.requestFocus();
            } else if (Integer.parseInt(etPin.getText().toString()) != Integer.parseInt(merchantBusiness.access_number)) {
                etPin.setError("Pin does not match");
                etPin.requestFocus();
            } else {
                getBankBalance(new CaxTonBeneficiaresModel());
                dialog.dismiss();
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void showBankDetailDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        Dialog dialogBankDetail = new Dialog(requireContext());
        dialogBankDetail.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogBankDetail.setContentView(R.layout.dialog_view_bank_detail);
        dialogBankDetail.setCanceledOnTouchOutside(false);
        Window window = dialogBankDetail.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();

        TextView txtBankNameValue = dialogBankDetail.findViewById(R.id.txtBankNameValue);
        TextView txtHolderNameValue = dialogBankDetail.findViewById(R.id.txtHolderNameValue);
        TextView txtAccountNumber = dialogBankDetail.findViewById(R.id.txtAccountNumber);
        TextView txtSortCodeValue = dialogBankDetail.findViewById(R.id.txtSortCodeValue);
        TextView txtSwiftCodeValue = dialogBankDetail.findViewById(R.id.txtSwiftCodeValue);
        TextView txtIbanNumberValue = dialogBankDetail.findViewById(R.id.txtIbanNumberValue);
        TextView txtAddressValue2 = dialogBankDetail.findViewById(R.id.txtAddressValue2);
        TextView txtAddressValue = dialogBankDetail.findViewById(R.id.txtAddressValue);
        TextView txtAddressValue1 = dialogBankDetail.findViewById(R.id.txtAddressValue1);
        TextView txtCountryValue2 = dialogBankDetail.findViewById(R.id.txtCountryValue2);
        ImageView img_close = dialogBankDetail.findViewById(R.id.img_close);
        ImageView imgShare = dialogBankDetail.findViewById(R.id.imgShare);
        ImageView imgCopy = dialogBankDetail.findViewById(R.id.imgCopy);
        txtCountryValue2.setText(caxTonBeneficiaresModel.country);
        txtAddressValue2.setText(caxTonBeneficiaresModel.address2);
        txtAddressValue.setText(caxTonBeneficiaresModel.address);
        txtAddressValue1.setText(caxTonBeneficiaresModel.address1);
        txtIbanNumberValue.setText(caxTonBeneficiaresModel.iban_number);
        txtSwiftCodeValue.setText(caxTonBeneficiaresModel.swift_code);
        txtSortCodeValue.setText(caxTonBeneficiaresModel.sortcode);
        txtAccountNumber.setText(caxTonBeneficiaresModel.account_number);
        txtHolderNameValue.setText(caxTonBeneficiaresModel.account_name);
        txtBankNameValue.setText(caxTonBeneficiaresModel.bank_name);
        img_close.setOnClickListener(view -> {
            dialogBankDetail.dismiss();
        });
        String shareAndCopyText = "Business name: " + caxTonBeneficiaresModel.account_name + "\nAccount number: " + caxTonBeneficiaresModel.account_number + "\nSort code: " + caxTonBeneficiaresModel.sortcode + "\nSwift code: " + caxTonBeneficiaresModel.swift_code + "\nIban number: " + caxTonBeneficiaresModel.iban_number + "\nBank name: " + caxTonBeneficiaresModel.bank_name + "\nBank address: " + caxTonBeneficiaresModel.address;
        imgShare.setOnClickListener(view -> {
            shareBankDetail(shareAndCopyText);
        });
        imgCopy.setOnClickListener(view -> {
            ClipboardManager clipboard = (ClipboardManager) requireActivity().getSystemService(CLIPBOARD_SERVICE);
            ClipData clip = ClipData.newPlainText("label", shareAndCopyText);
            clipboard.setPrimaryClip(clip);
            //if (android.os.Build.VERSION.SDK_INT < android.os.Build.VERSION_CODES.S){
            ToastUtils.makeToast(requireContext(), "Text copied to clipboard");
            //}
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogBankDetail.show();
    }

    private void shareBankDetail(String shareAndCopyText) {
        Intent intent = new Intent(android.content.Intent.ACTION_SEND);
        intent.setType("text/plain");
        intent.putExtra(android.content.Intent.EXTRA_TEXT, shareAndCopyText);
        startActivity(Intent.createChooser(intent, getString(R.string.share_using)));
    }

    private void addEditStandingInstDialog(boolean isFromEdit, CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        if (caxTonBeneficiariesResponseModels != null && !caxTonBeneficiariesResponseModels.isEmpty()) {
            dialogStanding = new Dialog(requireContext());
            dialogStanding.requestWindowFeature(Window.FEATURE_NO_TITLE);
            dialogStanding.setContentView(R.layout.dialog_add_edit_standing_inst);
            dialogStanding.setCanceledOnTouchOutside(false);
            Window window = dialogStanding.getWindow();
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            ImageView img_close = dialogStanding.findViewById(R.id.img_close);
            MaterialButton btnSubmit = dialogStanding.findViewById(R.id.btnSubmit);
            TextView txt_title = dialogStanding.findViewById(R.id.txt_title);
            EditText etNotes = dialogStanding.findViewById(R.id.etNotes);
            Spinner spinnerBene = dialogStanding.findViewById(R.id.spinnerBene);
            etSwift = dialogStanding.findViewById(R.id.etSwift);
            etBankName = dialogStanding.findViewById(R.id.etBankName);
            etAddressLine1 = dialogStanding.findViewById(R.id.etAddressLine1);
            etAddressLine2 = dialogStanding.findViewById(R.id.etAddressLine2);
            progressBeneficiary = dialogStanding.findViewById(R.id.progressBeneficiary);
            TextView tvFromDate = dialogStanding.findViewById(R.id.tvFromDate);
            String selectedeneficiares = "";
            RelativeLayout llExpiryDateDate = dialogStanding.findViewById(R.id.llExpiryDateDate);
            EditText etAmount = dialogStanding.findViewById(R.id.etAmount);
            etAmount.addTextChangedListener(new MoneyTextWatcher1(etAmount));
            SizeArrayAdapter sizeArrayAdapter = new SizeArrayAdapter(requireContext(), caxTonBeneficiariesResponseModels);
            sizeArrayAdapter.setDropDownViewResource(R.layout.spinner_item);
            spinnerBene.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                    caxTonBeneficiaresModel.beneficiary_name = caxTonBeneficiariesResponseModels.get(i).name;
                    caxTonBeneficiaresModel.beneficiary_id = caxTonBeneficiariesResponseModels.get(i).id;
                }

                @Override
                public void onNothingSelected(AdapterView<?> adapterView) {

                }
            });
            spinnerBene.setAdapter(sizeArrayAdapter);
            if (isFromEdit) {
                etAmount.setText(caxTonBeneficiaresModel.amount);
                tvFromDate.setText(caxTonBeneficiaresModel.expiry_date);
                etNotes.setText(caxTonBeneficiaresModel.notes);
                int positionBene = 0;
                for (int i = 0; i < caxTonBeneficiariesResponseModels.size(); i++) {
                    if (Objects.equals(caxTonBeneficiariesResponseModels.get(i).id, caxTonBeneficiaresModel.beneficiary_id)) {
                        positionBene = i;
                    }
                }
                spinnerBene.setSelection(positionBene);
                txt_title.setText(getString(R.string.edit_stading_order));
                btnSubmit.setText(getString(R.string.edit_stading_order));
            }
            btnSubmit.setOnClickListener(view -> {
                if (etAmount.getText().toString().isEmpty()) {
                    etAmount.setError("Please enter amount");
                    etAmount.requestFocus();
                } else if (tvFromDate.getText().toString().isEmpty()) {
                    ToastUtils.makeToast(requireContext(), "Please select expiry Date");
                } else {
                    caxTonBeneficiaresModel.amount = etAmount.getText().toString().replace(",", "");
                    caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                    caxTonBeneficiaresModel.user_id = userBankId;
                    addEditStandingApiCall(isFromEdit, caxTonBeneficiaresModel);
                }
            });
            img_close.setOnClickListener(view -> {
                dialogStanding.dismiss();
            });
            llExpiryDateDate.setOnClickListener(view -> {
                Calendar nowCalender = Calendar.getInstance();
                DatePickerDialog datePickerDialog = new DatePickerDialog(requireContext(), (datePicker, y, m, d) -> {
                    nowCalender.set(y, m, d);
                    caxTonBeneficiaresModel.expiry_date = CommonFunctions.formatMiliToDesireFormat(nowCalender.getTimeInMillis(), "yyyy/MM/dd");
                    tvFromDate.setText("" + CommonFunctions.formatMiliToDesireFormat(nowCalender.getTimeInMillis(), "dd/MM/yyyy"));
                }, nowCalender.get(Calendar.YEAR), nowCalender.get(Calendar.MONTH), nowCalender.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                datePickerDialog.getDatePicker().setMinDate(nowCalender.getTimeInMillis());
            });
            window.setGravity(Gravity.CENTER);
            layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
            layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
            layoutParams.gravity = Gravity.CENTER;
            layoutParams.windowAnimations = R.style.DialogAnimation;
            window.setAttributes(layoutParams);
            window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialogStanding.show();
        } else {
            ToastUtils.makeToast(requireContext(), "Please wait while beneficiary is loading");
        }
    }

    private void fetchBankDetail() {
        try {
            String url = ApiEndPoints.BENEFICIARIES_LIST + userBankId + "/bank-details";
            progressDialog.show();
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonBeneficiaresModel.class, new ParsedRequestListener<CaxTonBeneficiaresModel>() {
                        @Override
                        public void onResponse(CaxTonBeneficiaresModel response) {
                            try {
                                progressDialog.dismiss();
                                showBankDetailDialog(response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireContext(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showRequestWalletDialog() {
        dialogRequestWalletDialog = new Dialog(requireContext());
        dialogRequestWalletDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogRequestWalletDialog.setContentView(R.layout.dialog_request_banking);
        dialogRequestWalletDialog.setCanceledOnTouchOutside(false);
        Window window = dialogRequestWalletDialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ProgressBar progress_image = dialogRequestWalletDialog.findViewById(R.id.progress_image);
        RadioGroup rdInterest = dialogRequestWalletDialog.findViewById(R.id.rdInterest);
        RadioButton rdBank = dialogRequestWalletDialog.findViewById(R.id.rdBank);
        RadioButton rdCard = dialogRequestWalletDialog.findViewById(R.id.rdCard);
        RadioButton rdBoth = dialogRequestWalletDialog.findViewById(R.id.rdBoth);
        rdBank.setChecked(true);
        EditText etName = dialogRequestWalletDialog.findViewById(R.id.etName);
        EditText etEmail = dialogRequestWalletDialog.findViewById(R.id.etEmail);
        EditText etNotes = dialogRequestWalletDialog.findViewById(R.id.etNotes);
        EditText etPhone = dialogRequestWalletDialog.findViewById(R.id.etPhone);
        //progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialogRequestWalletDialog.findViewById(R.id.img_close);
        MaterialButton btnSubmit = dialogRequestWalletDialog.findViewById(R.id.btnSubmit);
        btnSubmit.setOnClickListener(view -> {
            if (etName.getText().toString().isEmpty()) {
                etName.setError("Please enter name");
                etName.requestFocus();
            } else if (etEmail.getText().toString().isEmpty()) {
                etEmail.setError("Please enter email");
                etEmail.requestFocus();
            } else if (!Validators.isEmail(etEmail.getText().toString())) {
                etEmail.setError("Please enter valid email");
                etEmail.requestFocus();
            } else if (etPhone.getText().toString().isEmpty()) {
                etPhone.setError("Please enter phone number");
                etPhone.requestFocus();
            } else {
                HashMap<String, String> hashMap = new HashMap<>();
                hashMap.put("name", etName.getText().toString());
                hashMap.put("email", etEmail.getText().toString());
                hashMap.put("phone", etPhone.getText().toString());
                hashMap.put("message", etNotes.getText().toString());
                hashMap.put("business_id", merchantBusiness.id);
                if (rdBank.isChecked()) {
                    hashMap.put("interest", rdBank.getText().toString().toLowerCase());
                } else if (rdCard.isChecked()) {
                    hashMap.put("interest", rdCard.getText().toString().toLowerCase());
                } else {
                    hashMap.put("interest", rdBoth.getText().toString().toLowerCase());
                }
                bankingRequestApiCall(hashMap);
            }
        });
        img_close.setOnClickListener(view -> {
            dialogRequestWalletDialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogRequestWalletDialog.show();
    }

    private void bankingRequestApiCall(HashMap<String, String> hashMap) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.BANKING_REQUEST;
            AndroidNetworking.post(url)
                    .addBodyParameter(hashMap)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                //ToastUtils.makeLongToast(requireActivity(), response.message);
                                progressDialog.dismiss();
                                if (dialogRequestWalletDialog != null) {
                                    dialogRequestWalletDialog.dismiss();
                                }
                                updateCount(1);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    //ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}