package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.viewpager.widget.ViewPager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.tabs.TabLayout;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.ViewpagerAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonGetPinModel;
import com.tiffintom.partner1.models.WalletListModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

public class CaxTonCardAndBank extends BaseFragment {
    TabLayout tabLayout;
   public ViewPager viewPager;
   public CardView cvToolbar;
    ViewpagerAdapter viewpagerAdapter;
    public CaxTonWallet caxTonWallet;
    public CaxTonUbsidiWallet caxTonUbsidiWallet;
    public CaxTonBank caxTonBank;
    public static MutableLiveData<ArrayList<WalletListModel>> walletListModels = new MutableLiveData<>();
    public static CaxTonCardAndBank newInstance() {
        CaxTonCardAndBank fragment = new CaxTonCardAndBank();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_cax_ton_card_and_bank, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        tabLayout = view.findViewById(R.id.tabLayout);
        viewPager = view.findViewById(R.id.viewPager);
        cvToolbar = view.findViewById(R.id.cvToolbar);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        viewpagerAdapter = new ViewpagerAdapter(getChildFragmentManager(), FragmentPagerAdapter.BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
        caxTonWallet = CaxTonWallet.newInstance();
        caxTonBank = CaxTonBank.newInstance();
        if(merchantBusiness.pouch_service){
            caxTonUbsidiWallet = CaxTonUbsidiWallet.newInstance();
            viewpagerAdapter.addFragment(caxTonUbsidiWallet, "Wallet");
        }
        viewpagerAdapter.addFragment(caxTonWallet, "Card");
        viewpagerAdapter.addFragment(caxTonBank, "Bank");
       /* if(!Validators.isNullOrEmpty(myApp.getMyPreferences().getMerchantBusinesses().finance_user_id)){
            viewpagerAdapter.addFragment(CaxTonBank.newInstance(), "Bank");
        }else {
           // cvToolbar.setVisibility(View.GONE);
        }*/
        viewPager.setAdapter(viewpagerAdapter);
        tabLayout.setupWithViewPager(viewPager);
        getBankRequestCount();
        // observer wallet list
        walletListModels.observe(getViewLifecycleOwner(), walletListModels -> {
            if(caxTonUbsidiWallet!=null){
                caxTonUbsidiWallet.walletList(walletListModels);
            }
        });
    }

    private void getBankRequestCount() {
        try {
            progressDialog.show();
            String url = ApiEndPoints.BANKING_REQUEST+"/count";
            AndroidNetworking.get(url)
                    .addQueryParameter("business_id",myApp.getMyPreferences().getMerchantBusinesses().id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                Log.e("responseresponse","responsev "+response);
                                if(response.has("bank_count") && response.has("both_count")){
                                    int count = response.getInt("bank_count")+response.getInt("both_count");
                                    caxTonBank.updateCount(count);
                                }
                                if(response.has("card_count") && response.has("both_count")){
                                    int count = response.getInt("card_count")+response.getInt("both_count");
                                    caxTonWallet.updateCount(count);
                                }
                               // ToastUtils.makeLongToast(requireActivity(), response.message);
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}