package com.tiffintom.partner1.fragments;

import static com.tiffintom.partner1.utils.Constants.ISFROMUBSIDIWALLET;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.RecyclerView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.CaxTonCardListActivity;
import com.tiffintom.partner1.activities.CaxTonTransctionListActivity;
import com.tiffintom.partner1.adapters.CaxTonCardListAdapter;
import com.tiffintom.partner1.adapters.CaxTonRecentTransactionAdapter;
import com.tiffintom.partner1.adapters.CaxTonSelectWalletListAdapter;
import com.tiffintom.partner1.adapters.CaxTonWalletListAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher1;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonBeneficiaresModel;
import com.tiffintom.partner1.models.CaxTonCardListModel;
import com.tiffintom.partner1.models.CaxTonGetPinModel;
import com.tiffintom.partner1.models.CaxTonTransactionListModel;
import com.tiffintom.partner1.models.CaxTonWalletTransactionModel;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.WalletListModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class CaxTonUbsidiWallet extends BaseFragment implements View.OnClickListener {
    private ProgressBar progressBeneficiary;
    public RecyclerView rv_transaction_list, rv_pending_transaction_list;
    ConstraintLayout constNoData, constSummary;
    CardView card_balance;
    ImageView img_show_hide;
    public TextView txt_available_balance_value, tvNoData, txt_life_time_balance, txt_wallet, txt_pending_no_transaction, txt_no_transaction, txt_no_card, txt_view_all_transaction, tvResendOtp, txtPrice;
    public ConstraintLayout const_wallet_detail, const_transaction_list, const_pending_transaction_list;
    private CaxTonCardListAdapter caxTonCardListAdapter;
    private CaxTonRecentTransactionAdapter caxTonPendingTransactionAdapter;
    private CaxTonRecentTransactionAdapter caxTonRecentTransactionAdapter;
    public CaxTonWalletListAdapter caxTonWalletListAdapter;
    private CaxTonCardListModel caxTonCardListModel;
    private int blockUnBlockPosition = -1, walletBalancePosition = -1;
    private String wallet_id = "", walletId = "";
    //private TextView btnTransferBank,btnTransferWallet;
    private ConstraintLayout constTransferWallet, constTransferBank, constTransferLoadWallet, constRedeemBank;
    Dialog dialog;
    Button btnStart;
    private int requestCount = 0;
    private ArrayList<WalletListModel> walletListModels;
    private ArrayList<WalletListModel> walletListModelsNotBank;
    private float minimum_transfer_charge = 0f, transfer_charge = 0f, transfer_charge_back = 0f;
    private String transfer_charge_type = "", finance_user_phone_number = "", userBankId = "";
    private Dialog dialogTransfer, dialogWalletTransfer;
    private LinearLayout llAfterOtpSend, llAfterOtpSend1;
    private CaxTonBeneficiaresModel caxTonBeneficiaresModel = new CaxTonBeneficiaresModel();
    private String selectedWalletBalance = "";

    public static CaxTonUbsidiWallet newInstance() {
        CaxTonUbsidiWallet fragment = new CaxTonUbsidiWallet();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    public void walletList(ArrayList<WalletListModel> walletListModels) {
        this.walletListModels = walletListModels;
        if (walletListModels != null && !walletListModels.isEmpty()) {
            if (constTransferWallet != null) {
                constTransferWallet.setVisibility(View.VISIBLE);
            }
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_cax_ton_ubsidi_wallet, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        userBankId = merchantBusiness.finance_user_id;
        minimum_transfer_charge = merchantBusiness.business_commissions.minimum_transfer_charge;
        transfer_charge_back = merchantBusiness.business_commissions.transfer_charge_back;
        transfer_charge = merchantBusiness.business_commissions.wallet_transfer_charge;
        transfer_charge_type = merchantBusiness.business_commissions.wallet_transfer_charge_type;
        finance_user_phone_number = myApp.getMyPreferences().getMerchantBusinesses().finance_user_phone_number;
        constTransferBank = view.findViewById(R.id.constTransferBank);
        constTransferWallet = view.findViewById(R.id.constTransferWallet);
        constTransferLoadWallet = view.findViewById(R.id.constTransferLoadWallet);
        constRedeemBank = view.findViewById(R.id.constRedeemBank);
        if (walletListModels != null && !walletListModels.isEmpty()) {
            constTransferWallet.setVisibility(View.VISIBLE);
        }
        if (!Validators.isNullOrEmpty(merchantBusiness.finance_user_id)) {
            constTransferBank.setVisibility(View.VISIBLE);
        }
        if (merchantBusiness.load_bank) {
            constRedeemBank.setVisibility(View.VISIBLE);
        }
        if (merchantBusiness.load_wallet) {
            constTransferLoadWallet.setVisibility(View.VISIBLE);
        }
        btnStart = view.findViewById(R.id.btnStart);
        constNoData = view.findViewById(R.id.constNoData);
        img_show_hide = view.findViewById(R.id.img_show_hide);
        rv_transaction_list = view.findViewById(R.id.rv_transaction_list);
        rv_pending_transaction_list = view.findViewById(R.id.rv_pending_transaction_list);
        txt_available_balance_value = view.findViewById(R.id.txt_available_balance_value);
        tvNoData = view.findViewById(R.id.tvNoData);
        txt_life_time_balance = view.findViewById(R.id.txt_life_time_balance);
        txt_wallet = view.findViewById(R.id.txt_wallet);
        txt_no_transaction = view.findViewById(R.id.txt_no_transaction);
        txt_pending_no_transaction = view.findViewById(R.id.txt_pending_no_transaction);
        txt_view_all_transaction = view.findViewById(R.id.txt_view_all_transaction);
        txt_no_card = view.findViewById(R.id.txt_no_card);
        card_balance = view.findViewById(R.id.card_balance);
        const_wallet_detail = view.findViewById(R.id.const_wallet_detail);
        const_transaction_list = view.findViewById(R.id.const_transaction_list);
        const_pending_transaction_list = view.findViewById(R.id.const_pending_transaction_list);
        img_show_hide.setOnClickListener(this);
        txt_view_all_transaction.setOnClickListener(this);
        constTransferBank.setOnClickListener(this);
        constTransferWallet.setOnClickListener(this);
        constTransferLoadWallet.setOnClickListener(this);
        constRedeemBank.setOnClickListener(this);
        img_show_hide.setImageResource(R.mipmap.ic_hide_password);
        txt_available_balance_value.setText(getString(R.string.xxxxx));
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initAdapter();
        fetchWalletTransactionList();
        fetchPendingWalletTransactionList();
        fetchWalletList();
        btnStart.setOnClickListener(view1 -> showRequestWalletDialog());
    }

    public void updateCount(int count) {
        requestCount = count;
    }

    private void updateUI() {
        if (tvNoData != null && requestCount > 0) {
            tvNoData.setText("Your have submitted request for wallet service.");
            btnStart.setVisibility(View.GONE);
        } else {
            constNoData.setVisibility(View.VISIBLE);
        }
    }

    private void initAdapter() {
        caxTonWalletListAdapter = new CaxTonWalletListAdapter(new ArrayList<>(), (position, data) -> {
            if (data == null) {
                walletBalancePosition = position;
                if (caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword) {
                    caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword = !caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword;
                    caxTonWalletListAdapter.notifyItemChanged(walletBalancePosition);
                } else {
                    enterPinDialog(true);
                }
            } else {
                img_show_hide.setActivated(false);
                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                txt_available_balance_value.setText(getString(R.string.xxxxx));

                walletId = ((WalletListModel) data).wallet_id;
                wallet_id = ((WalletListModel) data).id;
                //fetchWalletTransactionList(((WalletListModel) data).wallet_id);
            }
        });
        caxTonCardListAdapter = new CaxTonCardListAdapter(false, new ArrayList<>(),
                // item clicked
                (position, data) -> {

                },
                // get pin clicked
                (position, data) -> {
                    fetchPinImage(((CaxTonCardListModel) data).id);
                },
                // block/unblock clicked
                (position, data) -> {
                    this.blockUnBlockPosition = position;
                    this.caxTonCardListModel = ((CaxTonCardListModel) data);
                    if (caxTonCardListModel.card_state.equalsIgnoreCase("Active")) {
                        blockConfirmationDialog(caxTonCardListModel.id, caxTonCardListModel.card_state);
                    } else {
                        blockCard(caxTonCardListModel.id, caxTonCardListModel.card_state);
                    }
                });
        caxTonRecentTransactionAdapter = new CaxTonRecentTransactionAdapter(new ArrayList<>(), (position, data) -> {

        });
        caxTonPendingTransactionAdapter = new CaxTonRecentTransactionAdapter(new ArrayList<>(), true, (position, data) -> {

        });
        rv_pending_transaction_list.setAdapter(caxTonPendingTransactionAdapter);
        rv_transaction_list.setAdapter(caxTonRecentTransactionAdapter);
    }

    private void blockConfirmationDialog(String cardId, String status) {
        AlertDialog alertDialog = new AlertDialog.Builder(requireContext()).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
        animation_view.setVisibility(View.GONE);
        TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
        TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
        tvInfo1.setVisibility(View.INVISIBLE);
        tvInfo.setText("Are you sure you want to blocked?");
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            blockCard(cardId, status);
            alertDialog.dismiss();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    private void fetchWalletTransactionList() {
        try {
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("page", String.valueOf(1));
            params.put("per_page", String.valueOf(3));
            params.put("is_admin", String.valueOf(0));
            Calendar fromDate = Calendar.getInstance();
            Calendar toDate = Calendar.getInstance();
            fromDate.add(Calendar.DAY_OF_MONTH, -21);
            params.put("from_date", CommonFunctions.formatMiliToDesireFormat(fromDate.getTimeInMillis(), "yyyy-MM-dd"));
            params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toDate.getTimeInMillis(), "yyyy-MM-dd"));
            AndroidNetworking.get(ApiEndPoints.POUCH_HISTORIES)
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(CaxTonWalletTransactionModel.class, new ParsedRequestListener<CaxTonWalletTransactionModel>() {
                        @Override
                        public void onResponse(CaxTonWalletTransactionModel response) {
                            try {
                                progressDialog.dismiss();
                                Log.e("onResponse", "Wallet Transaction list response is " + response.caxTonTransactionListModels);
                                card_balance.setVisibility(View.VISIBLE);
                                const_wallet_detail.setVisibility(View.VISIBLE);
                                const_transaction_list.setVisibility(View.VISIBLE);
                                //rv_wallet_list.setVisibility(View.GONE);
                                txt_wallet.setVisibility(View.GONE);
                                txt_life_time_balance.setVisibility(View.GONE);
                                if (response.caxTonTransactionListModels.isEmpty()) {
                                    txt_no_transaction.setVisibility(View.VISIBLE);
                                    rv_transaction_list.setVisibility(View.GONE);
                                    txt_view_all_transaction.setVisibility(View.GONE);
                                } else {
                                    txt_no_transaction.setVisibility(View.GONE);
                                    rv_transaction_list.setVisibility(View.VISIBLE);
                                    txt_view_all_transaction.setVisibility(View.VISIBLE);
                                    caxTonRecentTransactionAdapter.notifyList(response.caxTonTransactionListModels, true);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_transaction.setVisibility(View.VISIBLE);
                                rv_transaction_list.setVisibility(View.GONE);
                                txt_view_all_transaction.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchPendingWalletTransactionList() {
        try {
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("nopaginate", String.valueOf(1));
            params.put("wallet_transfer", String.valueOf(1));
            AndroidNetworking.get(ApiEndPoints.PAYOUT_REQUESTES)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(CaxTonTransactionListModel.class, new ParsedRequestListener<ArrayList<CaxTonTransactionListModel>>() {
                        @Override
                        public void onResponse(ArrayList<CaxTonTransactionListModel> response) {
                            try {
                                progressDialog.dismiss();
                                Log.e("onResponse", "Wallet Transaction list response is " + response);
                                card_balance.setVisibility(View.VISIBLE);
                                const_wallet_detail.setVisibility(View.VISIBLE);
                                const_pending_transaction_list.setVisibility(View.VISIBLE);
                                //rv_wallet_list.setVisibility(View.GONE);
                                txt_wallet.setVisibility(View.GONE);
                                txt_life_time_balance.setVisibility(View.GONE);
                                if (response.isEmpty()) {
                                    txt_pending_no_transaction.setVisibility(View.VISIBLE);
                                    rv_pending_transaction_list.setVisibility(View.GONE);
                                } else {
                                    txt_pending_no_transaction.setVisibility(View.GONE);
                                    rv_pending_transaction_list.setVisibility(View.VISIBLE);
                                    caxTonPendingTransactionAdapter.notifyList(response, true);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_pending_no_transaction.setVisibility(View.VISIBLE);
                                rv_pending_transaction_list.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                Log.e("onErroronError", "onErroronErroronError " + anError.getErrorDetail() + " code " + anError.getErrorCode());
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void blockCard(String cardId, String status) {
        try {
            progressDialog.show();
            String url = status.equalsIgnoreCase("Blocked") ? ApiEndPoints.CARD_UNBLOCK + cardId : ApiEndPoints.CARD_BLOCK + cardId;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                progressDialog.dismiss();
                                if (caxTonCardListModel.card_state.equalsIgnoreCase("Blocked")) {
                                    caxTonCardListModel.card_state = "Active";
                                } else {
                                    caxTonCardListModel.card_state = "Blocked";
                                }
                                if (blockUnBlockPosition != -1) {
                                    caxTonCardListAdapter.notifyItemChanged(blockUnBlockPosition);
                                    blockUnBlockPosition = -1;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void getWalletBalance(String wallet_id, RecyclerView rvWalletList, String walletId) {
        try {
            progressDialog.show();
            Log.e("wallet_id", "wallet_id " + wallet_id);
            String url = ApiEndPoints.GET_BALANCE + wallet_id;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (rvWalletList != null) {
                                    for (int i = 0; i < walletListModels.size(); i++) {
                                        if (Objects.equals(walletListModels.get(i).id, walletId)) {
                                            selectedWalletBalance = MyApp.df.format(Float.parseFloat(response.balance));
                                            walletListModels.get(i).balance = myApp.currencySymbol + MyApp.df.format(Float.parseFloat(response.balance));
                                        }
                                    }
                                    rvWalletList.getAdapter().notifyDataSetChanged();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchPinImage(String cardId) {
        try {
            Log.e("cardIdcardIdcardId", "cardIdcardId " + cardId);
            progressDialog.show();
            String url = ApiEndPoints.GET_PIN + cardId;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                progressDialog.dismiss();
                                showPinDialog(response.pin_image);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.img_show_hide) {
            if (img_show_hide.isActivated()) {
                img_show_hide.setActivated(false);
                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                txt_available_balance_value.setText(getString(R.string.xxxxx));
            } else {
                enterPinDialog(false);
            }
        } else if (view.getId() == R.id.txt_view_all_card) {
            //changeFragment(CaxTonCardList.newInstance());
            Intent intent = new Intent(requireActivity(), CaxTonCardListActivity.class);
            intent.putExtra("wallet_id", walletId);
            startActivity(intent);
        } else if (view.getId() == R.id.txt_view_all_transaction) {
            Intent intent = new Intent(requireActivity(), CaxTonTransctionListActivity.class);
            intent.putExtra(ISFROMUBSIDIWALLET, true);
            intent.putExtra("wallet_id", walletId);
            startActivity(intent);
        } else if (view.getId() == R.id.constTransferBank) {
            if (Validators.isNullOrEmpty(caxTonBeneficiaresModel.id)) {
                fetchBankDetail();
            } else {
                showTransferDialog(caxTonBeneficiaresModel, merchantBusiness.pouch_weight, false);
            }
        } else if (view.getId() == R.id.constRedeemBank) {
            getBankBalance(caxTonBeneficiaresModel);
        } else if (view.getId() == R.id.constTransferWallet) {
            showWalletTransferDialog(true);
        } else if (view.getId() == R.id.constTransferLoadWallet) {
            showWalletTransferDialog(false);
        }
    }

    private void fetchBankDetail() {
        try {
            String url = ApiEndPoints.BENEFICIARIES_LIST + userBankId + "/bank-details";
            progressDialog.show();
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonBeneficiaresModel.class, new ParsedRequestListener<CaxTonBeneficiaresModel>() {
                        @Override
                        public void onResponse(CaxTonBeneficiaresModel response) {
                            try {
                                caxTonBeneficiaresModel = response;
                                progressDialog.dismiss();
                                showTransferDialog(caxTonBeneficiaresModel, merchantBusiness.pouch_weight, false);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireContext(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void changeFragment(Fragment fragment) {
        FragmentManager manager = requireActivity().getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.replace(R.id.nav_host_fragment, fragment);
        transaction.addToBackStack("can_go_back");
        transaction.commit();
    }

    private void showPinDialog(String pinUrl) {
        Dialog dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_show_pin);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ImageView img_pin = dialog.findViewById(R.id.img_pin);
        ProgressBar progress_image = dialog.findViewById(R.id.progress_image);
        progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        Glide.with(this)
                .load(pinUrl)
                .listener(new RequestListener<Drawable>() {
                    @Override
                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        progress_image.setVisibility(View.GONE);
                        //on load failed
                        return false;
                    }

                    @Override
                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        progress_image.setVisibility(View.GONE);
                        //on load success
                        return false;
                    }
                })
                .into(img_pin);
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void enterPinDialog(boolean isFRomListBalance) {
        Dialog dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_enter_pin);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        EditText etPin = dialog.findViewById(R.id.etPin);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        btnSubmit.setOnClickListener(view -> {
            if (etPin.getText().toString().isEmpty()) {
                etPin.setError("Please enter pin");
                etPin.requestFocus();
            } else if (merchantBusiness.access_number == null) {
                etPin.setError("Pin does not match");
                etPin.requestFocus();
            } else if (Integer.parseInt(etPin.getText().toString()) != Integer.parseInt(merchantBusiness.access_number)) {
                etPin.setError("Pin does not match");
                etPin.requestFocus();
            } else {
                if (isFRomListBalance) {
                    if (walletBalancePosition != -1) {
                        caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword = !caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword;
                        caxTonWalletListAdapter.notifyItemChanged(walletBalancePosition);
                    }
                } else {
                    //getWalletBalance();
                    if (Validators.isNullOrEmpty(merchantBusiness.pouch_weight)) {
                        txt_available_balance_value.setText(myApp.currencySymbol + "0.00");
                    } else {
                        txt_available_balance_value.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(Float.parseFloat(merchantBusiness.pouch_weight)));
                    }
                    img_show_hide.setActivated(true);
                    img_show_hide.setImageResource(R.mipmap.ic_show_password);
                }
                dialog.dismiss();
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void showRequestWalletDialog() {
        dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_request_banking);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ProgressBar progress_image = dialog.findViewById(R.id.progress_image);
        RadioGroup rdInterest = dialog.findViewById(R.id.rdInterest);
        RadioButton rdBank = dialog.findViewById(R.id.rdBank);
        RadioButton rdCard = dialog.findViewById(R.id.rdCard);
        RadioButton rdBoth = dialog.findViewById(R.id.rdBoth);
        rdBank.setChecked(true);
        EditText etName = dialog.findViewById(R.id.etName);
        EditText etEmail = dialog.findViewById(R.id.etEmail);
        EditText etNotes = dialog.findViewById(R.id.etNotes);
        EditText etPhone = dialog.findViewById(R.id.etPhone);
        //progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        btnSubmit.setOnClickListener(view -> {
            if (etName.getText().toString().isEmpty()) {
                etName.setError("Please enter name");
                etName.requestFocus();
            } else if (etEmail.getText().toString().isEmpty()) {
                etEmail.setError("Please enter email");
                etEmail.requestFocus();
            } else if (!Validators.isEmail(etEmail.getText().toString())) {
                etEmail.setError("Please enter valid email");
                etEmail.requestFocus();
            } else if (etPhone.getText().toString().isEmpty()) {
                etPhone.setError("Please enter phone number");
                etPhone.requestFocus();
            } else {
                HashMap<String, String> hashMap = new HashMap<>();
                hashMap.put("name", etName.getText().toString());
                hashMap.put("email", etEmail.getText().toString());
                hashMap.put("phone", etPhone.getText().toString());
                hashMap.put("message", etNotes.getText().toString());
                hashMap.put("business_id", merchantBusiness.id);
                if (rdBank.isChecked()) {
                    hashMap.put("interest", rdBank.getText().toString().toLowerCase());
                } else if (rdCard.isChecked()) {
                    hashMap.put("interest", rdCard.getText().toString().toLowerCase());
                } else {
                    hashMap.put("interest", rdBoth.getText().toString().toLowerCase());
                }
                bankingRequestApiCall(hashMap);
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void bankingRequestApiCall(HashMap<String, String> hashMap) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.BANKING_REQUEST;
            AndroidNetworking.post(url)
                    .addBodyParameter(hashMap)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                ToastUtils.makeLongToast(requireActivity(), response.message);
                                updateCount(1);
                                progressDialog.dismiss();
                                if (dialog != null) {
                                    dialog.dismiss();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showTransferDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel, String availableBalance, boolean isFromRedeemCard) {
        Dialog dialogTransfer = new Dialog(requireContext());
        dialogTransfer.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogTransfer.setContentView(R.layout.dialog_trasfer);
        dialogTransfer.setCanceledOnTouchOutside(false);
        Window window = dialogTransfer.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        progressBeneficiary = dialogTransfer.findViewById(R.id.progress_image);
        MaterialButton btnSubmit = dialogTransfer.findViewById(R.id.btnSubmit);
        //progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialogTransfer.findViewById(R.id.img_close);
        RecyclerView rvWalletList = dialogTransfer.findViewById(R.id.rvWalletList);
        EditText etAmount = dialogTransfer.findViewById(R.id.etAmount);
        EditText etFees = dialogTransfer.findViewById(R.id.etFees);
        EditText etNotes = dialogTransfer.findViewById(R.id.etNotes);
        TextView txtFees = dialogTransfer.findViewById(R.id.txtFees);
        TextView txt_title = dialogTransfer.findViewById(R.id.txt_title);
        TextView txt_available_balance = dialogTransfer.findViewById(R.id.txt_available_balance);
        TextView txtRemainningAmount = dialogTransfer.findViewById(R.id.txtRemainningAmount);
        txt_available_balance.setVisibility(View.VISIBLE);
        txt_available_balance.setText(myApp.currencySymbol + availableBalance + " Available funds");
        etAmount.addTextChangedListener(new MoneyTextWatcher1(etAmount));
        BigDecimal availableBalanceBig = BigDecimal.valueOf(Float.parseFloat(availableBalance));
        if (!isFromRedeemCard) {
            btnSubmit.setText("Submit");
            txt_title.setText("Transfer Bank");
        } else {
            btnSubmit.setText("Submit");
            txt_title.setText("Redeem From Bank");
        }
        etAmount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (editable.length() == 0) {
                    txtFees.setVisibility(View.GONE);
                    etFees.setVisibility(View.GONE);
                    etFees.setText(myApp.currencySymbol + "0.00");
                } else {
                    txtFees.setVisibility(View.VISIBLE);
                    etFees.setVisibility(View.VISIBLE);
                    float amount = 0;
                    if (transfer_charge_type.equalsIgnoreCase("flat")) {
                        amount = amount + transfer_charge;
                        etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(amount));
                        BigDecimal trasferChargeBig = BigDecimal.valueOf(transfer_charge);
                        BigDecimal etAmountEnteredByUser = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", "")));
                        caxTonBeneficiaresModel.trasferChargeBig = trasferChargeBig;
                        caxTonBeneficiaresModel.etAmountEnteredByUser = etAmountEnteredByUser;
                        txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(trasferChargeBig))));
                    } else if (transfer_charge_type.equalsIgnoreCase("percentage")) {
                        BigDecimal trasferChargeBig = BigDecimal.valueOf(transfer_charge);
                        BigDecimal minimumTransferCharge = BigDecimal.valueOf(minimum_transfer_charge);
                        BigDecimal etAmountEnteredByUser = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", "")));
                        BigDecimal etAmountBigDecimal = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", ""))).multiply(trasferChargeBig).divide(BigDecimal.valueOf(100));
                        caxTonBeneficiaresModel.trasferChargeBig = trasferChargeBig;
                        caxTonBeneficiaresModel.etAmountEnteredByUser = etAmountEnteredByUser;
                        caxTonBeneficiaresModel.minimumTransferCharge = minimumTransferCharge;
                        if (etAmountBigDecimal.compareTo(minimumTransferCharge) > 0) {
                            etAmountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etAmountBigDecimal = etAmountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etFees.setText(myApp.currencySymbol + etAmountBigDecimal);
                            caxTonBeneficiaresModel.etFeesAmountBigDecimal = etAmountBigDecimal;
                            txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(etAmountBigDecimal))));
                        } else {
                            minimumTransferCharge.setScale(2, BigDecimal.ROUND_HALF_UP);
                            minimumTransferCharge = minimumTransferCharge.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etFees.setText(myApp.currencySymbol + minimumTransferCharge);
                            caxTonBeneficiaresModel.etFeesAmountBigDecimal = minimumTransferCharge;
                            txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(minimumTransferCharge))));
                        }
                       /* if (amount < minimum_transfer_charge) {
                            etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(minimum_transfer_charge));
                        }else {
                            etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(amount));
                        }*/
                    }
                }
            }
        });
        AtomicReference<String> selectedWalletId = new AtomicReference<>("");
        if (isFromRedeemCard) {
            if (walletListModelsNotBank == null) {
                walletListModelsNotBank = new ArrayList<>();
            }
            for (int i = 0; i < walletListModelsNotBank.size(); i++) {
                walletListModelsNotBank.get(i).balance = "";
                walletListModelsNotBank.get(i).isShowPassword = false;
            }
            rvWalletList.setVisibility(View.VISIBLE);
            boolean isFromWalletTransfer = false;
            CaxTonSelectWalletListAdapter caxTonSelectWalletListAdapter = new CaxTonSelectWalletListAdapter(isFromWalletTransfer, walletListModelsNotBank, (position, data) -> {
                if (walletListModelsNotBank != null && data != null) {
                    selectedWalletBalance = "";
                    WalletListModel walletListModel = (WalletListModel) data;
                    selectedWalletId.set(walletListModel.wallet_id);
                    for (int i = 0; i < walletListModelsNotBank.size(); i++) {
                        if (!Objects.equals(walletListModelsNotBank.get(i).id, walletListModel.id)) {
                            walletListModelsNotBank.get(i).isShowPassword = false;
                        }
                    }
                    rvWalletList.getAdapter().notifyDataSetChanged();
                }
            });
            rvWalletList.setAdapter(caxTonSelectWalletListAdapter);
        }
        etNotes.setText(caxTonBeneficiaresModel.notes);
        img_close.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        btnSubmit.setOnClickListener(view -> {
            if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) == 0) {
                etAmount.setError("Amount must be greater than 0");
                etAmount.requestFocus();
            } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) < 5 && !isFromRedeemCard) {
                etAmount.setError("Entered amount must be greater than " + myApp.currencySymbol + "5.00");
                etAmount.requestFocus();
            } else {
                if (!isFromRedeemCard) {
                    if (availableBalanceBig.compareTo(caxTonBeneficiaresModel.etFeesAmountBigDecimal.add(caxTonBeneficiaresModel.etAmountEnteredByUser)) > 0) {
                        caxTonBeneficiaresModel.amount = etAmount.getText().toString().replace(",", "");
                        caxTonBeneficiaresModel.transferCharger = etFees.getText().toString();
                        caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                        dialogTransfer.dismiss();
                        showTransferSummaryDialog(caxTonBeneficiaresModel, availableBalanceBig);
                    } else {
                        etAmount.setError("Insufficient funds");
                        etAmount.requestFocus();
                    }
                } else {
                    if (Validators.isNullOrEmpty(selectedWalletId.get())) {
                        ToastUtils.makeToast(requireContext(), "Please select wallet");
                    } else {
                        redeemFromCard(etAmount.getText().toString().replace(",", ""), etFees.getText().toString().replace(",", ""), selectedWalletId.get(), dialogTransfer);
                    }
                }
                //showTransferApiCall(caxTonBeneficiaresModel);
            }
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogTransfer.show();
    }

    private void showWalletTransferDialog(boolean isFromWalletTransfer) {
        Dialog dialogTransfer = new Dialog(requireContext());
        this.dialogWalletTransfer = dialogTransfer;
        dialogTransfer.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogTransfer.setContentView(R.layout.dialog_wallet_select_list);
        dialogTransfer.setCanceledOnTouchOutside(false);
        Window window = dialogTransfer.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        RecyclerView rvWalletList = dialogTransfer.findViewById(R.id.rvWalletList);
        TextView txt_title = dialogTransfer.findViewById(R.id.txt_title);
        TextView txtNotes = dialogTransfer.findViewById(R.id.txtNotes);
        EditText etNotes = dialogTransfer.findViewById(R.id.etNotes);
        txtPrice = dialogTransfer.findViewById(R.id.txt_available_balance);
        EditText etAmount = dialogTransfer.findViewById(R.id.etAmount);
        etAmount.addTextChangedListener(new MoneyTextWatcher1(etAmount));
        MaterialButton btnSubmit = dialogTransfer.findViewById(R.id.btnSubmit);
        ImageView img_close = dialogTransfer.findViewById(R.id.img_close);
        img_close.setOnClickListener(view -> dialogTransfer.dismiss());
        AtomicReference<String> selectedWalletId = new AtomicReference<>("");
        txtNotes.setVisibility(View.VISIBLE);
        etNotes.setVisibility(View.VISIBLE);
        if (!isFromWalletTransfer) {
            txt_title.setText(getString(R.string.redeem_from_card));
        }
        if (walletListModels == null) {
            walletListModels = new ArrayList<>();
        }
        for (int i = 0; i < walletListModels.size(); i++) {
            walletListModels.get(i).balance = "";
            walletListModels.get(i).isShowPassword = false;
        }
        CaxTonSelectWalletListAdapter caxTonSelectWalletListAdapter = new CaxTonSelectWalletListAdapter(!isFromWalletTransfer, walletListModels, (position, data) -> {
            if (walletListModels != null && data != null) {
                selectedWalletBalance = "";
                WalletListModel walletListModel = (WalletListModel) data;
                selectedWalletId.set(walletListModel.wallet_id);
                for (int i = 0; i < walletListModels.size(); i++) {
                    if (!Objects.equals(walletListModels.get(i).id, walletListModel.id)) {
                        walletListModels.get(i).isShowPassword = false;
                    }
                }
                rvWalletList.getAdapter().notifyDataSetChanged();
                if (!isFromWalletTransfer) {
                    getWalletBalance(walletListModel.id, rvWalletList, walletListModel.id);
                }
            }
        });
        btnSubmit.setOnClickListener(view -> {
            if (Validators.isNullOrEmpty(selectedWalletId.get())) {
                ToastUtils.makeToast(requireContext(), "Please select wallet");
            } else if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) == 0) {
                etAmount.setError("Amount must be greater than 0");
                etAmount.requestFocus();
            } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) < 10) {
                etAmount.setError("Entered amount must be greater than " + myApp.currencySymbol + "10.00");
                etAmount.requestFocus();
            } else if (isFromWalletTransfer && !Validators.isNullOrEmpty(merchantBusiness.pouch_weight) && Float.parseFloat(merchantBusiness.pouch_weight) < Float.parseFloat(etAmount.getText().toString().replace(",", ""))) {
                etAmount.setError("Insufficient funds");
                etAmount.requestFocus();
            } else if (!isFromWalletTransfer && !Validators.isNullOrEmpty(selectedWalletBalance) && Float.parseFloat(selectedWalletBalance) < Float.parseFloat(etAmount.getText().toString().replace(",", ""))) {
                etAmount.setError("Insufficient funds");
                etAmount.requestFocus();
            } else {
                CommonFunctions.hideKeyboard(requireActivity(), etAmount);
                walletTransferApiCall(etNotes.getText().toString(), selectedWalletId.get(), etAmount.getText().toString().replace(",", ""), isFromWalletTransfer);
            }
        });
        rvWalletList.setAdapter(caxTonSelectWalletListAdapter);
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogTransfer.show();
    }

    private void getBankBalance(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.GET_BANK_BALANCE + userBankId + "/balance";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                String transferBalance = "0.00";
                                if (Validators.isNullOrEmpty(response.balance)) {
                                    transferBalance = "0.00";
                                } else {
                                    transferBalance = "" + CommonFunctions.formatTo2Digit(Float.parseFloat(response.balance));
                                }
                                showTransferDialog(new CaxTonBeneficiaresModel(), transferBalance, true);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void walletTransferApiCall(String notes, String wallet_id, String debit_amount, boolean isFromWalletTransfer) {
        try {
            /*if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }*/
            progressDialog.show();
            String url = isFromWalletTransfer ? ApiEndPoints.POUCH_WALLET_TRANSFER : ApiEndPoints.POUCH_WALLET_LOAD;
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("business_id", merchantBusiness.id);
            hashMap.put("wallet_id", wallet_id);
            if (isFromWalletTransfer) {
                hashMap.put("debit_amount", debit_amount);
            } else {
                hashMap.put("credit_amount", debit_amount);
            }
            hashMap.put("device_id", myApp.getMyPreferences().getAndroidDeviceId());
            hashMap.put("device_type", "Android");
            hashMap.put("remark", notes);
            Log.e("jsonObject", "jsonObject " + hashMap + " url " + url);
            AndroidNetworking.post(url)
                    .addBodyParameter(hashMap)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialogWalletTransfer != null) {
                                    dialogWalletTransfer.dismiss();
                                }
                                img_show_hide.setActivated(false);
                                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                                txt_available_balance_value.setText(getString(R.string.xxxxx));

                                fetchWalletTransactionList();
                                fetchBusinesses();
                                //caxTonRecentTransactionAdapter.notifyItemChanged(transferPosition);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showTransferSummaryDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel, BigDecimal availableBalanceBig) {
        dialogTransfer = new Dialog(requireContext());
        dialogTransfer.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogTransfer.setContentView(R.layout.dialog_trasfer_summary);
        dialogTransfer.setCanceledOnTouchOutside(false);
        Window window = dialogTransfer.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        progressBeneficiary = dialogTransfer.findViewById(R.id.progress_image);
        ConstraintLayout constAmountToPay = dialogTransfer.findViewById(R.id.constAmountToPay);
        //progress_image.setVisibility(View.VISIBLE);
        TextView txtVerificationMobile = dialogTransfer.findViewById(R.id.txtVerificationMobile);
        if (finance_user_phone_number.length() > 5) {
            String first = "OTP is sent to the ";
            String second = " <font color='#3F51B5'>" + finance_user_phone_number.substring(0, 3) + "****" + finance_user_phone_number.substring((finance_user_phone_number.length() - 3), finance_user_phone_number.length()) + "</font>";
            txtVerificationMobile.setText(Html.fromHtml(first + second));
        }
        llAfterOtpSend = dialogTransfer.findViewById(R.id.llAfterOtpSend);
        llAfterOtpSend1 = dialogTransfer.findViewById(R.id.llAfterOtpSend1);
        constSummary = dialogTransfer.findViewById(R.id.constSummary);
        Button btnVerify = dialogTransfer.findViewById(R.id.btnVerify);
        EditText etOtp = dialogTransfer.findViewById(R.id.etOtp);
        tvResendOtp = dialogTransfer.findViewById(R.id.tvResendOtp);
        Button btnCancel = dialogTransfer.findViewById(R.id.btnCancel);
        ImageView img_close = dialogTransfer.findViewById(R.id.img_close);
        TextView txt_fees_value = dialogTransfer.findViewById(R.id.txt_fees_value);
        TextView txtNamevalue = dialogTransfer.findViewById(R.id.txtNamevalue);
        TextView txtBankValue = dialogTransfer.findViewById(R.id.txtBankValue);
        TextView txtNotesValue = dialogTransfer.findViewById(R.id.txtNotesValue);
        CheckBox cxPaymentInst = dialogTransfer.findViewById(R.id.cxPaymentInst);
        TextView txtAvaialbleBalanceValue = dialogTransfer.findViewById(R.id.txtAvaialbleBalanceValue);
        TextView txtDepositeCurrenyBalanceValue = dialogTransfer.findViewById(R.id.txtDepositeCurrenyBalanceValue);
        TextView txtAmountToPay = dialogTransfer.findViewById(R.id.txtAmount);
        TextView txtAmountToPayListValue = dialogTransfer.findViewById(R.id.txtAmountToPayListValue);
        txtAmountToPay.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser.add(caxTonBeneficiaresModel.etFeesAmountBigDecimal)));
        txt_fees_value.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etFeesAmountBigDecimal));
        txtAmountToPayListValue.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser));
        cxPaymentInst.setText(getString(R.string.payment_inst1) + " " + myApp.currencySymbol + CommonFunctions.formatTo2Digit(transfer_charge_back) + " " + getString(R.string.payment_inst3));
        txtNamevalue.setText(caxTonBeneficiaresModel.account_name);
        txtBankValue.setText(caxTonBeneficiaresModel.bank_name);
        txtNotesValue.setText(caxTonBeneficiaresModel.notes);
        txtDepositeCurrenyBalanceValue.setText("" + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(caxTonBeneficiaresModel.etAmountEnteredByUser.add(caxTonBeneficiaresModel.etFeesAmountBigDecimal))));
        txtAvaialbleBalanceValue.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig));
        img_close.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        btnCancel.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        constAmountToPay.setOnClickListener(view -> {
            if (!cxPaymentInst.isChecked()) {
                ToastUtils.makeLongToast(requireContext(), "Please select terms and condition");
            } else {
                sendOtpApi();
            }
            /*if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            } else {
                caxTonBeneficiaresModel.amount = etAmount.getText().toString();
                caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                caxTonBeneficiaresModel.user_id = userBankId;
                //showTransferApiCall(caxTonBeneficiaresModel);
            }*/
        });

        btnVerify.setOnClickListener(view -> {
            if (etOtp.getText().toString().isEmpty()) {
                etOtp.setError("Please enter otp");
                etOtp.requestFocus();
            } else {
                CommonFunctions.hideKeyboard(requireActivity(), btnVerify);
                caxTonBeneficiaresModel.otp = etOtp.getText().toString();
                caxTonBeneficiaresModel.amount = "" + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser);
                caxTonBeneficiaresModel.fee = "" + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etFeesAmountBigDecimal);
                showTransferApiCall(caxTonBeneficiaresModel);
            }
        });
        dialogTransfer.setOnDismissListener(dialogInterface -> {
            if (countDownTimer != null) {
                countDownTimer.cancel();
            }
        });
        tvResendOtp.setOnClickListener(view -> {
            sendOtpApi();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogTransfer.show();
    }

    CountDownTimer countDownTimer = new CountDownTimer(30000, 1000) {

        @Override
        public void onTick(long millisUntilFinished) {
            int seconds = (int) (millisUntilFinished / 1000);
            int minutes = seconds / 60;
            seconds %= 60;
            if (tvResendOtp != null) {
                tvResendOtp.setEnabled(false);
                tvResendOtp.setText("Resend otp in " + String.format("%02d", minutes) + ":" + String.format(
                        "%02d",
                        seconds
                ));
            }
        }

        @Override
        public void onFinish() {
            if (tvResendOtp != null) {
                tvResendOtp.setEnabled(true);
                tvResendOtp.setText("Resend Otp");
            }
        }
    };

    private void showTransferApiCall(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            /*if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }*/
            progressDialog.show();
            String url = ApiEndPoints.POUCH_BANK_TRANSFER;
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("business_id", merchantBusiness.id);
            hashMap.put("debit_amount", caxTonBeneficiaresModel.amount);
            hashMap.put("fee", caxTonBeneficiaresModel.fee);
            hashMap.put("description", caxTonBeneficiaresModel.notes);
            hashMap.put("otp", caxTonBeneficiaresModel.otp);
            hashMap.put("device_id", myApp.getMyPreferences().getAndroidDeviceId());
            hashMap.put("device_type", "Android");
            Log.e("jsonObject", "jsonObject " + hashMap);
            AndroidNetworking.post(url)
                    .addBodyParameter(hashMap)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialogTransfer != null) {
                                    dialogTransfer.dismiss();
                                }
                                img_show_hide.setActivated(false);
                                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                                txt_available_balance_value.setText(getString(R.string.xxxxx));

                                fetchWalletTransactionList();
                                fetchBusinesses();
                                //caxTonRecentTransactionAdapter.notifyItemChanged(transferPosition);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void redeemFromCard(String amount, String fees, String walletId, Dialog dialogTransfer) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.POUCH_BANK_LOAD;
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("business_id", merchantBusiness.id);
            hashMap.put("credit_amount", amount);
            hashMap.put("is_admin", "0");
            hashMap.put("wallet_id", walletId);
            hashMap.put("fee", "" + fees.replace("£", ""));
            Log.e("jsonObject", "jsonObject " + hashMap + " url " + url);
            AndroidNetworking.post(url)
                    .addBodyParameter(hashMap)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialogTransfer != null) {
                                    dialogTransfer.dismiss();
                                }
                                img_show_hide.setActivated(false);
                                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                                txt_available_balance_value.setText(getString(R.string.xxxxx));

                                fetchWalletTransactionList();
                                fetchBusinesses();
                                //caxTonRecentTransactionAdapter.notifyItemChanged(transferPosition);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void sendOtpApi() {
        try {
           /* if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }*/
            progressDialog.show();
            String url = ApiEndPoints.send_otp + merchantBusiness.finance_user_id + "/send-otp";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                ToastUtils.makeLongToast(requireContext(), response.message);
                                if (countDownTimer != null) {
                                    countDownTimer.start();
                                }
                                if (llAfterOtpSend != null) {
                                    llAfterOtpSend.setVisibility(View.VISIBLE);
                                    llAfterOtpSend1.setVisibility(View.VISIBLE);
                                    constSummary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireContext(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchBusinesses() {
        try {
            AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES + merchantBusiness.id)
                    .build()
                    .getAsObject(MerchantBusinesses.class, new ParsedRequestListener<MerchantBusinesses>() {
                        @Override
                        public void onResponse(MerchantBusinesses response) {
                            try {
                                merchantBusiness = response;
                                myApp.getMyPreferences().saveMerchantBusinesses(response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchWalletList() {
        try {
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("nopaginate", String.valueOf(1));
            params.put("bank", "bank");
            AndroidNetworking.get(ApiEndPoints.WALLET_LIST)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(WalletListModel.class, new ParsedRequestListener<ArrayList<WalletListModel>>() {
                        @Override
                        public void onResponse(ArrayList<WalletListModel> response) {
                            try {
                                progressDialog.dismiss();
                                Log.e("onResponse", "Walletlist response is " + response);
                                walletListModelsNotBank = response;
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}