package com.tiffintom.partner1.fragments;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.RecyclerView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.CaxTonCardListActivity;
import com.tiffintom.partner1.activities.CaxTonTransctionListActivity;
import com.tiffintom.partner1.adapters.CaxTonCardListAdapter;
import com.tiffintom.partner1.adapters.CaxTonRecentTransactionAdapter;
import com.tiffintom.partner1.adapters.CaxTonWalletListAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonCardListModel;
import com.tiffintom.partner1.models.CaxTonCardResponseModel;
import com.tiffintom.partner1.models.CaxTonGetPinModel;
import com.tiffintom.partner1.models.CaxTonWalletTransactionModel;
import com.tiffintom.partner1.models.WalletListModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class CaxTonWallet extends BaseFragment implements View.OnClickListener {
    public RecyclerView rv_card_list, rv_transaction_list, rv_wallet_list;
    ConstraintLayout constNoData;
    CardView card_balance;
    ImageView img_show_hide;
    public TextView txt_available_balance_value, tvNoData,txt_life_time_balance, txt_wallet, txt_no_transaction, txt_no_card, txt_view_all_transaction, txt_view_all_card;
    public ConstraintLayout const_wallet_detail, const_card_list, const_transaction_list;
    private CaxTonCardListAdapter caxTonCardListAdapter;
    private CaxTonRecentTransactionAdapter caxTonRecentTransactionAdapter;
    public CaxTonWalletListAdapter caxTonWalletListAdapter;
    private CaxTonCardListModel caxTonCardListModel;
    private int blockUnBlockPosition = -1,walletBalancePosition=-1;
    private String wallet_id = "", walletId = "";
    Dialog dialog;
    Button btnStart;
    private int requestCount =0;

    public static CaxTonWallet newInstance() {
        CaxTonWallet fragment = new CaxTonWallet();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_cax_ton_card, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        btnStart = view.findViewById(R.id.btnStart);
        constNoData = view.findViewById(R.id.constNoData);
        rv_card_list = view.findViewById(R.id.rv_card_list);
        img_show_hide = view.findViewById(R.id.img_show_hide);
        rv_transaction_list = view.findViewById(R.id.rv_transaction_list);
        rv_wallet_list = view.findViewById(R.id.rv_wallet_list);
        txt_available_balance_value = view.findViewById(R.id.txt_available_balance_value);
        tvNoData = view.findViewById(R.id.tvNoData);
        txt_life_time_balance = view.findViewById(R.id.txt_life_time_balance);
        txt_wallet = view.findViewById(R.id.txt_wallet);
        txt_no_transaction = view.findViewById(R.id.txt_no_transaction);
        txt_view_all_transaction = view.findViewById(R.id.txt_view_all_transaction);
        txt_view_all_card = view.findViewById(R.id.txt_view_all_card);
        txt_no_card = view.findViewById(R.id.txt_no_card);
        card_balance = view.findViewById(R.id.card_balance);
        const_wallet_detail = view.findViewById(R.id.const_wallet_detail);
        const_card_list = view.findViewById(R.id.const_card_list);
        const_transaction_list = view.findViewById(R.id.const_transaction_list);
        img_show_hide.setOnClickListener(this);
        txt_view_all_card.setOnClickListener(this);
        txt_view_all_transaction.setOnClickListener(this);
        img_show_hide.setImageResource(R.mipmap.ic_hide_password);
        txt_available_balance_value.setText(getString(R.string.xxxxx));
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initAdapter();
        fetchWalletList();
        btnStart.setOnClickListener(view1 -> showRequestWalletDialog());
    }

    public void updateCount(int count){
        requestCount =  count;
    }

    private void updateUI(){
        if(tvNoData!=null && requestCount>0){
            tvNoData.setText("Your have submitted request for wallet service.");
            btnStart.setVisibility(View.GONE);
        }else {
            constNoData.setVisibility(View.VISIBLE);
        }
    }

    private void initAdapter() {
        caxTonWalletListAdapter = new CaxTonWalletListAdapter(new ArrayList<>(), (position, data) -> {
            if(data==null){
                walletBalancePosition = position;
                if(caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword){
                    caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword = !caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword;
                    caxTonWalletListAdapter.notifyItemChanged(walletBalancePosition);
                }else {
                    enterPinDialog(true);
                }
            }else {
                img_show_hide.setActivated(false);
                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                txt_available_balance_value.setText(getString(R.string.xxxxx));

                walletId = ((WalletListModel) data).wallet_id;
                wallet_id = ((WalletListModel) data).id;
                fetchCardsList(((WalletListModel) data).wallet_id);
                fetchWalletTransactionList(((WalletListModel) data).wallet_id);
            }
        });
        rv_wallet_list.setAdapter(caxTonWalletListAdapter);
        caxTonCardListAdapter = new CaxTonCardListAdapter(false, new ArrayList<>(),
                // item clicked
                (position, data) -> {

                },
                // get pin clicked
                (position, data) -> {
                    fetchPinImage(((CaxTonCardListModel) data).id);
                },
                // block/unblock clicked
                (position, data) -> {
                    this.blockUnBlockPosition = position;
                    this.caxTonCardListModel = ((CaxTonCardListModel) data);
                    if(caxTonCardListModel.card_state.equalsIgnoreCase("Active")){
                        blockConfirmationDialog(caxTonCardListModel.id, caxTonCardListModel.card_state);
                    }else{
                        blockCard(caxTonCardListModel.id, caxTonCardListModel.card_state);
                    }
                });
        caxTonRecentTransactionAdapter = new CaxTonRecentTransactionAdapter(new ArrayList<>(), (position, data) -> {

        });
        rv_transaction_list.setAdapter(caxTonRecentTransactionAdapter);
        rv_card_list.setAdapter(caxTonCardListAdapter);
    }

    private void blockConfirmationDialog(String cardId, String status) {
        AlertDialog alertDialog = new AlertDialog.Builder(requireContext()).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
        animation_view.setVisibility(View.GONE);
        TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
        TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
        tvInfo1.setVisibility(View.INVISIBLE);
        tvInfo.setText("Are you sure you want to blocked?");
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            blockCard(cardId, status);
            alertDialog.dismiss();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    private void fetchCardsList(String wallet_id) {
        try {
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("wallet_id", wallet_id);
            params.put("page", String.valueOf(1));
            params.put("per_page", String.valueOf(3));
            params.put("not_status", "1");
            AndroidNetworking.get(ApiEndPoints.CARDS_LIST)
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(CaxTonCardResponseModel.class, new ParsedRequestListener<CaxTonCardResponseModel>() {
                        @Override
                        public void onResponse(CaxTonCardResponseModel response) {
                            try {
                                progressDialog.dismiss();
                                Log.e("onResponse", "Walletlist response is " + response.caxTonCardListModels);
                                card_balance.setVisibility(View.VISIBLE);
                                const_card_list.setVisibility(View.VISIBLE);
                                const_wallet_detail.setVisibility(View.VISIBLE);
                                rv_wallet_list.setVisibility(View.GONE);
                                txt_wallet.setVisibility(View.GONE);
                                txt_life_time_balance.setVisibility(View.GONE);
                                if (response.caxTonCardListModels.isEmpty()) {
                                    txt_no_card.setVisibility(View.VISIBLE);
                                    rv_card_list.setVisibility(View.GONE);
                                    txt_view_all_card.setVisibility(View.GONE);
                                } else {
                                    txt_no_card.setVisibility(View.GONE);
                                    rv_card_list.setVisibility(View.VISIBLE);
                                    txt_view_all_card.setVisibility(View.VISIBLE);
                                    caxTonCardListAdapter.notifyList(response.caxTonCardListModels);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_card.setVisibility(View.VISIBLE);
                                rv_card_list.setVisibility(View.GONE);
                                txt_view_all_card.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchWalletTransactionList(String wallet_id) {
        try {
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("wallet_id", wallet_id);
            params.put("page", String.valueOf(1));
            params.put("per_page", String.valueOf(3));
            Calendar fromDate = Calendar.getInstance();
            Calendar toDate = Calendar.getInstance();
            fromDate.add(Calendar.DAY_OF_MONTH, -21);
            params.put("from_date",CommonFunctions.formatMiliToDesireFormat(fromDate.getTimeInMillis(), "yyyy-MM-dd"));
            params.put("to_date",CommonFunctions.formatMiliToDesireFormat(toDate.getTimeInMillis(), "yyyy-MM-dd"));
            AndroidNetworking.get(ApiEndPoints.WALLET_TRANSACTION)
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(CaxTonWalletTransactionModel.class, new ParsedRequestListener<CaxTonWalletTransactionModel>() {
                        @Override
                        public void onResponse(CaxTonWalletTransactionModel response) {
                            try {
                                progressDialog.dismiss();
                                Log.e("onResponse", "Wallet Transaction list response is " + response.caxTonTransactionListModels);
                                card_balance.setVisibility(View.VISIBLE);
                                const_card_list.setVisibility(View.VISIBLE);
                                const_wallet_detail.setVisibility(View.VISIBLE);
                                const_transaction_list.setVisibility(View.VISIBLE);
                                rv_wallet_list.setVisibility(View.GONE);
                                txt_wallet.setVisibility(View.GONE);
                                txt_life_time_balance.setVisibility(View.GONE);
                                if (response.caxTonTransactionListModels.isEmpty()) {
                                    txt_no_transaction.setVisibility(View.VISIBLE);
                                    rv_transaction_list.setVisibility(View.GONE);
                                    txt_view_all_transaction.setVisibility(View.GONE);
                                } else {
                                    txt_no_transaction.setVisibility(View.GONE);
                                    rv_transaction_list.setVisibility(View.VISIBLE);
                                    txt_view_all_transaction.setVisibility(View.VISIBLE);
                                    caxTonRecentTransactionAdapter.notifyList(response.caxTonTransactionListModels);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_transaction.setVisibility(View.VISIBLE);
                                rv_transaction_list.setVisibility(View.GONE);
                                txt_view_all_transaction.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchWalletList() {
        try {
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("nopaginate", String.valueOf(1));
            params.put("bank","not_bank");
            AndroidNetworking.get(ApiEndPoints.WALLET_LIST)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(WalletListModel.class, new ParsedRequestListener<ArrayList<WalletListModel>>() {
                        @Override
                        public void onResponse(ArrayList<WalletListModel> response) {
                            try {
                                progressDialog.dismiss();
                                Log.e("onResponse", "Walletlist response is " + response);
                                if(response.size()==1){
                                    walletId = response.get(0).wallet_id;
                                    wallet_id =response.get(0).id;
                                    fetchCardsList(response.get(0).wallet_id);
                                    fetchWalletTransactionList(response.get(0).wallet_id);
                                    rv_wallet_list.setVisibility(View.GONE);
                                }
                                CaxTonCardAndBank.walletListModels.setValue(response);
                                caxTonWalletListAdapter.notifyList(response);
                                if(response.isEmpty()){
                                   updateUI();
                                    rv_wallet_list.setVisibility(View.GONE);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                updateUI();
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void blockCard(String cardId, String status) {
        try {
            progressDialog.show();
            String url = status.equalsIgnoreCase("Blocked") ? ApiEndPoints.CARD_UNBLOCK + cardId : ApiEndPoints.CARD_BLOCK + cardId;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                progressDialog.dismiss();
                                if (caxTonCardListModel.card_state.equalsIgnoreCase("Blocked")) {
                                    caxTonCardListModel.card_state = "Active";
                                } else {
                                    caxTonCardListModel.card_state = "Blocked";
                                }
                                if (blockUnBlockPosition != -1) {
                                    caxTonCardListAdapter.notifyItemChanged(blockUnBlockPosition);
                                    blockUnBlockPosition = -1;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void getWalletBalance() {
        try {
            progressDialog.show();
            Log.e("wallet_id", "wallet_id " + wallet_id);
            String url = ApiEndPoints.GET_BALANCE + wallet_id;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                img_show_hide.setActivated(true);
                                if(Validators.isNullOrEmpty(response.balance)){
                                    txt_available_balance_value.setText(myApp.currencySymbol + "0.00");
                                }else{
                                    txt_available_balance_value.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(Float.parseFloat(response.balance)));
                                }
                                img_show_hide.setImageResource(R.mipmap.ic_show_password);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchPinImage(String cardId) {
        try {
            Log.e("cardIdcardIdcardId", "cardIdcardId " + cardId);
            progressDialog.show();
            String url = ApiEndPoints.GET_PIN + cardId;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                progressDialog.dismiss();
                                showPinDialog(response.pin_image);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.img_show_hide) {
            if (img_show_hide.isActivated()) {
                img_show_hide.setActivated(false);
                img_show_hide.setImageResource(R.mipmap.ic_hide_password);
                txt_available_balance_value.setText(getString(R.string.xxxxx));
            } else {
                enterPinDialog(false);
            }
        } else if (view.getId() == R.id.txt_view_all_card) {
            //changeFragment(CaxTonCardList.newInstance());
            Intent intent = new Intent(requireActivity(), CaxTonCardListActivity.class);
            intent.putExtra("wallet_id", walletId);
            startActivity(intent);
        } else if (view.getId() == R.id.txt_view_all_transaction) {
            Intent intent = new Intent(requireActivity(), CaxTonTransctionListActivity.class);
            intent.putExtra("wallet_id", walletId);
            startActivity(intent);
        }
    }

    private void changeFragment(Fragment fragment) {
        FragmentManager manager = requireActivity().getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.replace(R.id.nav_host_fragment, fragment);
        transaction.addToBackStack("can_go_back");
        transaction.commit();
    }

    private void showPinDialog(String pinUrl) {
        Dialog dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_show_pin);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ImageView img_pin = dialog.findViewById(R.id.img_pin);
        ProgressBar progress_image = dialog.findViewById(R.id.progress_image);
        progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        Glide.with(this)
                .load(pinUrl)
                .listener(new RequestListener<Drawable>() {
                    @Override
                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        progress_image.setVisibility(View.GONE);
                        //on load failed
                        return false;
                    }

                    @Override
                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        progress_image.setVisibility(View.GONE);
                        //on load success
                        return false;
                    }
                })
                .into(img_pin);
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void enterPinDialog(boolean isFRomListBalance) {
        Dialog dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_enter_pin);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        EditText etPin = dialog.findViewById(R.id.etPin);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        btnSubmit.setOnClickListener(view -> {
            if(etPin.getText().toString().isEmpty()){
                etPin.setError("Please enter pin");
                etPin.requestFocus();
            }else if(merchantBusiness.access_number==null){
                etPin.setError("Pin does not match");
                etPin.requestFocus();
            }else if(Integer.parseInt(etPin.getText().toString())!=Integer.parseInt(merchantBusiness.access_number)){
                etPin.setError("Pin does not match");
                etPin.requestFocus();
            }else {
                if(isFRomListBalance){
                    if(walletBalancePosition!=-1){
                        caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword = !caxTonWalletListAdapter.getList().get(walletBalancePosition).isShowPassword;
                        caxTonWalletListAdapter.notifyItemChanged(walletBalancePosition);
                    }
                }else{
                    getWalletBalance();
                }
                dialog.dismiss();
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void showRequestWalletDialog() {
        dialog = new Dialog(requireContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_request_banking);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ProgressBar progress_image = dialog.findViewById(R.id.progress_image);
        RadioGroup rdInterest = dialog.findViewById(R.id.rdInterest);
        RadioButton rdBank = dialog.findViewById(R.id.rdBank);
        RadioButton rdCard = dialog.findViewById(R.id.rdCard);
        RadioButton rdBoth = dialog.findViewById(R.id.rdBoth);
        rdBank.setChecked(true);
        EditText etName = dialog.findViewById(R.id.etName);
        EditText etEmail = dialog.findViewById(R.id.etEmail);
        EditText etNotes = dialog.findViewById(R.id.etNotes);
        EditText etPhone = dialog.findViewById(R.id.etPhone);
        //progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        btnSubmit.setOnClickListener(view -> {
            if (etName.getText().toString().isEmpty()) {
                etName.setError("Please enter name");
                etName.requestFocus();
            } else if (etEmail.getText().toString().isEmpty()) {
                etEmail.setError("Please enter email");
                etEmail.requestFocus();
            } else if (!Validators.isEmail(etEmail.getText().toString())) {
                etEmail.setError("Please enter valid email");
                etEmail.requestFocus();
            }else if (etPhone.getText().toString().isEmpty()) {
                etPhone.setError("Please enter phone number");
                etPhone.requestFocus();
            } else {
                HashMap<String,String>  hashMap = new HashMap<>();
                hashMap.put("name",etName.getText().toString());
                hashMap.put("email",etEmail.getText().toString());
                hashMap.put("phone",etPhone.getText().toString());
                hashMap.put("message",etNotes.getText().toString());
                hashMap.put("business_id",merchantBusiness.id);
                if (rdBank.isChecked()) {
                    hashMap.put("interest",rdBank.getText().toString().toLowerCase());
                }else if (rdCard.isChecked()) {
                    hashMap.put("interest",rdCard.getText().toString().toLowerCase());
                } else {
                    hashMap.put("interest",rdBoth.getText().toString().toLowerCase());
                }
                bankingRequestApiCall(hashMap);
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void bankingRequestApiCall(HashMap<String,String> hashMap) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.BANKING_REQUEST;
            AndroidNetworking.post(url)
                    .addBodyParameter(hashMap)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                ToastUtils.makeLongToast(requireActivity(), response.message);
                                updateCount(1);
                                progressDialog.dismiss();
                                if(dialog!=null){
                                    dialog.dismiss();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(requireActivity(), "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(requireActivity(), apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(requireActivity(), "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}