package com.tiffintom.partner1.fragments;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.TransportActivity;
import com.tiffintom.partner1.adapters.ChatListAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.Chat;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


/**
 * Created by Amrish on 13-11-2020.
 */
public class ChatHistoryFragment extends BaseFragment {
    private RecyclerView rvChats;
    private ChatListAdapter chatListAdapter;
    private ArrayList<Chat> chats = new ArrayList<>();
    private ArrayList<Chat> searchedChats = new ArrayList<>();
    private SwipeRefreshLayout swipeRefreshLayout;
    private AppCompatEditText etSearch;
    private MaterialButton btnRecentCustomers;
    private LinearLayout llComposeMessage;
    private BroadcastReceiver broadcastReceiver;

    public static ChatHistoryFragment getInstance() {
        return new ChatHistoryFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_chat_history, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            llComposeMessage = view.findViewById(R.id.llCompose);
            rvChats = view.findViewById(R.id.rvChats);
            etSearch = view.findViewById(R.id.etSearch);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            btnRecentCustomers = view.findViewById(R.id.btnCompose);
            chatListAdapter = new ChatListAdapter(searchedChats, (position, data) -> {
                Chat chat = (Chat) data;
                startActivity(new Intent(getActivity(), TransportActivity.class).putExtra("order_id", chat.order_id).putExtra("customer_name", chat.user.first_name).putExtra("customer_phone", chat.user.phone_number).putExtra("customer_id", chat.customer_id).putExtra("customer_logo", chat.user.image_url).putExtra("destination", "chat"));
            });
            rvChats.setAdapter(chatListAdapter);
            rvChats.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    searchedChats.clear();
                    searchedChats.addAll(searchChat());
                    chatListAdapter.notifyDataSetChanged();
                }
            });
            swipeRefreshLayout.setOnRefreshListener(this::fetchData);
            btnRecentCustomers.setOnClickListener(view -> {
                SelectCustomerBottomSheetFragment selectCustomerBottomSheetFragment = SelectCustomerBottomSheetFragment.getInstance();
                selectCustomerBottomSheetFragment.show(getChildFragmentManager(), "select_customer");
            });
            llComposeMessage.setOnClickListener(view -> {
                SelectCustomerBottomSheetFragment selectCustomerBottomSheetFragment = SelectCustomerBottomSheetFragment.getInstance();
                selectCustomerBottomSheetFragment.show(getChildFragmentManager(), "select_customer");
            });
            broadcastReceiver = new BroadcastReceiver() {
                public void onReceive(Context context, Intent intent) {

                    boolean refresh = intent.getBooleanExtra("refresh", false);
                    boolean forChat = intent.getBooleanExtra("chat", false);
                    if (refresh & forChat) {
                        swipeRefreshLayout.setRefreshing(true);
                        fetchData();
                    }
                }
            };
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        new Thread(this::fetchChatHistory).start();
    }

    private void fetchChatHistory() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> swipeRefreshLayout.setRefreshing(true));
            }
            AndroidNetworking.get(ApiEndPoints.orders_help)
                    .addQueryParameter(getOrdersParameters()).setPriority(Priority.IMMEDIATE)
                    .build()
                    .getAsObjectList(Chat.class, new ParsedRequestListener<List<Chat>>() {
                        @Override
                        public void onResponse(List<Chat> response) {
                            try {
                                if (response!=null) {
                                    chats.clear();
                                    chats.addAll(response);
                                    searchedChats.clear();
                                    searchedChats.addAll(chats);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                    chatListAdapter.notifyDataSetChanged();
                                });
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> swipeRefreshLayout.setRefreshing(false));
                                }
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private HashMap<String, String> getOrdersParameters() {
        HashMap<String, String> params = new HashMap<>();
        params.put("user_group", "1");
        params.put("nopaginate", "1");
        params.put("restaurant_id", loggedInRestaurant.id);
        return params;
    }

    private ArrayList<Chat> searchChat() {
        if (etSearch.getText().toString().isEmpty()) {
            return chats;
        }
        ArrayList<Chat> searchedRest = new ArrayList<>();
        for (Chat r : chats) {
            if (r.user!=null && r.user.first_name != null && r.user.first_name.toLowerCase().contains(etSearch.getText().toString().toLowerCase())) {
                searchedRest.add(r);
            }
        }
        return searchedRest;

    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            fetchData();
            if (getActivity() != null && broadcastReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(broadcastReceiver, new IntentFilter(Constants.NOTIFICATION));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStop() {
        try {
            CommonFunctions.hideKeyboard(getActivity(), etSearch);
            if (getActivity() != null && broadcastReceiver != null)
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(broadcastReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();
    }
}
