package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class ConfirmationExitDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private MaterialButton btnConfirm, btnCancel;
    private DialogDismissListener dialogDismissListener;

    public static ConfirmationExitDialogFragment getInstance() {
        ConfirmationExitDialogFragment rejectReasonDialog = new ConfirmationExitDialogFragment();
        Bundle bundle = new Bundle();

        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_confirm_exit_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("confirm");
                dismiss();
            });
            btnCancel.setOnClickListener(view -> {
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
