package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class CustomDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String title, info;
    private boolean error;
    private MaterialButton btnConfirm;
    private TextView tvInfo, tvTitle;
    private DialogDismissListener dialogDismissListener;

    public static CustomDialogFragment getInstance(String title, String info, boolean error) {
        CustomDialogFragment rejectReasonDialog = new CustomDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putBoolean("error", error);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_custom_fragmnet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            title = getArguments().getString("title");
            info = getArguments().getString("info");
            error = getArguments().getBoolean("error");
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            tvInfo = view.findViewById(R.id.tvInfo);
            tvTitle = view.findViewById(R.id.tvTitle);

            tvTitle.setText(title);
            tvInfo.setText(info);
            if (error) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
            } else {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_accept));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("confirm");
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
