package com.tiffintom.partner1.fragments;

import android.app.DatePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.FilterDialogDismissListener;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.Calendar;

/**
 * Created by Amrish on 11-11-2020.
 */
public class DateRangePickerDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String title;
    private MaterialButton btnConfirm, btnCancel;
    private LinearLayout llToDate, llFromDate;
    private TextView tvInfo, tvTitle, tvFromDate, tvToDate;
    private FilterDialogDismissListener dialogDismissListener;
    private String fromDateString, toDateString;
    private Calendar today = Calendar.getInstance();
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private Calendar fromCalender = Calendar.getInstance();
    private Calendar toCalender = Calendar.getInstance();

    public static DateRangePickerDialogFragment getInstance(String title, String fromDate, String toDate) {
        DateRangePickerDialogFragment rejectReasonDialog = new DateRangePickerDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("fromDate", fromDate);
        bundle.putString("toDate", toDate);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(FilterDialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_date_picker, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            title = getArguments().getString("title");
            fromDateString = getArguments().getString("fromDate");
            toDateString = getArguments().getString("toDate");
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            tvTitle = view.findViewById(R.id.tvTitle);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            tvToDate = view.findViewById(R.id.tvToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            llToDate = view.findViewById(R.id.llToDate);
            tvTitle.setText(title);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            llFromDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                    fromDay = d;
                    fromMonth = m;
                    fromYear = y;
                    fromDateString = String.format("%02d", y) + "/" + String.format("%02d", (m + 1)) + "/" + String.format("%02d", d);
                    tvFromDate.setText(fromDateString);
                    fromCalender.set(y, m, d);
                }, today.get(Calendar.YEAR), today.get(Calendar.MONTH), today.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                if (!Validators.isNullOrEmpty(toDateString)) {
                    datePickerDialog.getDatePicker().setMaxDate(toCalender.getTimeInMillis());
                }

            });
            llToDate.setOnClickListener(view -> {
                if (!Validators.isNullOrEmpty(fromDateString)) {
                    DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                        toDateString = String.format("%02d", y) + "/" + String.format("%02d", (m + 1)) + "/" + String.format("%02d", d);
                        toDay = d;
                        toMonth = m;
                        toYear = y;
                        tvToDate.setText(toDateString);
                        toCalender.set(y, m, d);
                    }, toYear > 0 ? toYear : today.get(Calendar.YEAR), toMonth > 0 ? toMonth : today.get(Calendar.MONTH), toDay > 0 ? toDay : today.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.getDatePicker().setMinDate(fromCalender.getTimeInMillis());
                    datePickerDialog.show();
                }
            });
            btnConfirm.setOnClickListener(view -> {
                if (Validators.isNullOrEmpty(fromDateString) || Validators.isNullOrEmpty(toDateString)) {
                    ToastUtils.makeToast(getActivity(), "Please select date range");
                } else {
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(fromDateString, toDateString);
                    dismiss();
                }
            });
            btnCancel.setOnClickListener(view -> {
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
