package com.tiffintom.partner1.fragments;

import android.content.res.Resources;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

public class EditRestaurantDescriptionBottomsheet extends BaseBottomSheet {

    private AppCompatEditText etDecription;
    private TextView tvWordCounter;
    private MaterialButton btnCancel, btnUpdate;
    private String description;
    private DialogDismissListener dialogDismissListener;
    RestaurantUser restaurantUser = myApp.getMyPreferences().getLoggedInRestaurant();

    public static EditRestaurantDescriptionBottomsheet getInstance(String description) {
        EditRestaurantDescriptionBottomsheet descriptionBottomsheet = new EditRestaurantDescriptionBottomsheet();
        Bundle bundle = new Bundle();
        bundle.putString("description", description);
        descriptionBottomsheet.setArguments(bundle);
        return descriptionBottomsheet;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_edit_description_bottomsheet, container, false);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (intentExtrasData.containsKey("description")) {
            description = String.valueOf(intentExtrasData.get("description"));
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
        setListener();
    }

    private void setListener() {
        super.setListeners();
        try {
            etDecription.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    tvWordCounter.setText(etDecription.length() + "/300");
                    if (etDecription.length() > 300) {
                        tvWordCounter.setTextColor(getResources().getColor(R.color.red));
                    } else {
                        tvWordCounter.setTextColor(getResources().getColor(R.color.black));
                    }
                }
            });

            btnCancel.setOnClickListener(v -> dismiss());
            btnUpdate.setOnClickListener(view -> {
                if (etDecription.length() > 300) {
                    ToastUtils.makeToast(getActivity(), "Description length should not more than 300 characters");
                } else {
                    updateRestaurantDescription();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateRestaurantDescription() {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                progressDialog.show();
            });
            AndroidNetworking.post(ApiEndPoints.restaurants + restaurantUser.id)
                    //  .addBodyParameter("user_id", restaurantUser.id)
                    //   .addQueryParameter("action", "EditStoreDescription")
                    .addQueryParameter("restaurant_about", etDecription.getText().toString())
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                            });
                            try {
                                restaurantUser.restaurant_about = etDecription.getText().toString();
                                    myApp.getMyPreferences().saveLoggedInRestaurant(restaurantUser);
                                    if (dialogDismissListener != null) {
                                        dialogDismissListener.onDialogDismiss(null);
                                    }
                                    dismiss();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                progressDialog.show();
                            });
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            ivClose = view.findViewById(R.id.ivClose);
            etDecription = view.findViewById(R.id.etDecription);
            tvWordCounter = view.findViewById(R.id.tvWordCounter);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnUpdate = view.findViewById(R.id.btnUpdate);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            etDecription.setText(description);
            etDecription.setSelection(etDecription.getText().length());
            tvWordCounter.setText(etDecription.length() + "/300");
            tvWordCounter.setTextColor(getResources().getColor(R.color.black));
            if (etDecription.length() > 300) {
                tvWordCounter.setTextColor(getResources().getColor(R.color.red));
            } else {
                tvWordCounter.setTextColor(getResources().getColor(R.color.black));
            }
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStop() {
        CommonFunctions.hideKeyboard(getActivity(), etDecription);
        super.onStop();
    }
}
