package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class EnterIPDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private MaterialButton btnConfirm, btnCancel;
    private AppCompatEditText etIP;
    private TextView tvInfo;
    private DialogDismissListener dialogDismissListener;
    private AlertDialog progressDialog;
    private MyApp myApp = MyApp.getInstance();

    public static EnterIPDialogFragment getInstance() {
        EnterIPDialogFragment rejectReasonDialog = new EnterIPDialogFragment();
        Bundle bundle = new Bundle();
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_enter_ipaddress, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    private void initViews(View view) {
        try {
            progressDialog = CommonFunctions.customProgressDialog(getActivity(), "");
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            etIP = view.findViewById(R.id.etIP);
            tvInfo = view.findViewById(R.id.tvInfo);
            if (myApp.getMyPreferences().getPrinterIP() != null) {
                etIP.setText(myApp.getMyPreferences().getPrinterIP());
                etIP.setSelection(etIP.getText().toString().length());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                etIP.setError(null);
                if (!Patterns.IP_ADDRESS.matcher(etIP.getText().toString()).matches()) {
                    etIP.setError("Please enter IP address");
                } else {
                    myApp.getMyPreferences().savePrinterIP(etIP.getText().toString());
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(etIP.getText().toString());
                    dismiss();
                }
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(null);
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
