package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.Merchant;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.util.HashMap;


/**
 * Created by Amrish on 11-11-2020.
 */
public class EnterPasswordDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String forWhat, yes_no, title, info;
    private MaterialButton btnConfirm, btnCancel;
    private AppCompatEditText etPassword;
    private TextView tvInfo, tvTitle;
    private DialogDismissListener dialogDismissListener;
    private AlertDialog progressDialog;
    protected Merchant loggedInMerchant;

    public static EnterPasswordDialogFragment getInstance(String for_what, String yes_no) {
        EnterPasswordDialogFragment rejectReasonDialog = new EnterPasswordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("for_what", for_what);
        bundle.putString("yes_no", yes_no);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public static EnterPasswordDialogFragment getInstance(String for_what, String title, String info) {
        EnterPasswordDialogFragment rejectReasonDialog = new EnterPasswordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("for_what", for_what);
        bundle.putString("title", title);
        bundle.putString("info", info);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_enter_password, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            forWhat = getArguments().getString("for_what");
            yes_no = getArguments().getString("yes_no");
            info = getArguments().getString("info");
            title = getArguments().getString("title");
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            progressDialog = CommonFunctions.customProgressDialog(getActivity(), "");
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            etPassword = view.findViewById(R.id.etPassword);
            tvInfo = view.findViewById(R.id.tvInfo);
            tvTitle = view.findViewById(R.id.tvTitle);

            if (forWhat.equalsIgnoreCase("online_order")) {
                if (yes_no.equalsIgnoreCase("yes"))
                    tvInfo.setText("Please enter your password to turn on online orders");
                else tvInfo.setText("Please enter your password to turn off online orders");
            } else if (forWhat.equalsIgnoreCase("booking_status")) {
                if (yes_no.equalsIgnoreCase("yes"))
                    tvInfo.setText("Please enter your password to turn on reservations");
                else tvInfo.setText("Please enter your password to turn off reservations");
            } else {
                tvInfo.setText(info);
                tvTitle.setText(title);
            }

            loggedInMerchant = MyApp.getInstance().getMyPreferences().getLoggedInMerchant();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                etPassword.setError(null);
                if (!Validators.isNullOrEmpty(forWhat))
                    if (etPassword.getText().toString().isEmpty()) {
                        etPassword.setError("Please enter password");
                    } else {
                        changeStatus();
                    }
                else {
                    CommonFunctions.hideKeyboard(getActivity(), etPassword);
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(etPassword.getText().toString());
                    dismiss();
                }
            });
            btnCancel.setOnClickListener(view ->

            {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(null);
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void changeStatus() {
        try {

            if(loggedInMerchant!=null&&!loggedInMerchant.password.equalsIgnoreCase(etPassword.getText().toString()))
            {
                ToastUtils.makeToast(getActivity(), "Password does not match.");
                return;
            }

            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }

            HashMap<String, String> params = new HashMap<>();
            if (forWhat.equalsIgnoreCase("online_order")) {
                params.put("online_order", yes_no);
            }
            if (forWhat.equalsIgnoreCase("booking_status")) {
                params.put("booking_status", yes_no);
            }
            AndroidNetworking.post(ApiEndPoints.restaurants + MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().id)
                    .addApplicationJsonBody(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                try {
                                    RestaurantUser restaurantUser = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();
                                    if (forWhat.equalsIgnoreCase("online_order")) {
                                        restaurantUser.online_order = yes_no;
                                    }
                                    if (forWhat.equalsIgnoreCase("booking_status")) {
                                        restaurantUser.booking_status = yes_no;
                                    }
                                    MyApp.getInstance().getMyPreferences().saveLoggedInRestaurant(restaurantUser);
                                    ToastUtils.makeToast(getActivity(), "Status changed successfully.");
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (dialogDismissListener != null)
                                    dialogDismissListener.onDialogDismiss(null);
                                dismiss();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                LogUtils.e("Error in status change::");
                                if (!CommonFunctions.isConnected(getActivity())) {
                                    MyApp.getInstance().noInternet(getActivity());
                                } else {
                                    ToastUtils.makeToast(getActivity(), "Unknown error occurred!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
