package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.interfaces.FilterDialogDismissListener;

import java.util.Date;

/**
 * Created by Amrish on 25-11-2020.
 */
public class FilterSelectionFragment extends BaseBottomSheet {
    private String fromDate, toDate;

    public static FilterSelectionFragment getInstance(String fromDate, String toDate) {
        FilterSelectionFragment filterSelectionFragment = new FilterSelectionFragment();
        Bundle bundle = new Bundle();
        bundle.putString("fromDate", fromDate);
        bundle.putString("toDate", toDate);
        filterSelectionFragment.setArguments(bundle);
        return filterSelectionFragment;
    }

    private TextView tvToday, tvWeek, tvMonth, tvYear, tvCustomDate, tvDateRange;
    private FilterDialogDismissListener filterDialogDismissListener;

    public void setFilterDialogDismissListener(FilterDialogDismissListener filterDialogDismissListener) {
        this.filterDialogDismissListener = filterDialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_filters_selection, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        fromDate = getArguments().getString("fromDate");
        toDate = getArguments().getString("toDate");
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            tvToday = view.findViewById(R.id.tvToday);
            tvWeek = view.findViewById(R.id.tvWeek);
            tvMonth = view.findViewById(R.id.tvMonth);
            tvYear = view.findViewById(R.id.tvYear);
            tvCustomDate = view.findViewById(R.id.tvCustomDate);
            tvDateRange = view.findViewById(R.id.tvDateRange);
            ivClose = view.findViewById(R.id.ivClose);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setListeners() {
        super.setListeners();
        tvToday.setOnClickListener(view -> {
            if (filterDialogDismissListener != null) {
                filterDialogDismissListener.onDialogDismiss("Today", null, null);
                dismiss();
            }
        });
        tvWeek.setOnClickListener(view -> {
            if (filterDialogDismissListener != null) {
                filterDialogDismissListener.onDialogDismiss("This Week", null, null);
                dismiss();
            }
        });
        tvMonth.setOnClickListener(view -> {
            if (filterDialogDismissListener != null) {
                filterDialogDismissListener.onDialogDismiss("This Month", null, null);
                dismiss();
            }
        });
        tvYear.setOnClickListener(view -> {
            if (filterDialogDismissListener != null) {
                filterDialogDismissListener.onDialogDismiss("This Year", null, null);
                dismiss();
            }
        });
        tvDateRange.setOnClickListener(view -> {
            DateRangePickerDialogFragment dateRangePickerDialogFragment = DateRangePickerDialogFragment.getInstance("Select date range", fromDate, toDate);
            dateRangePickerDialogFragment.show(getChildFragmentManager(), "date_range");
            dateRangePickerDialogFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    if (filterDialogDismissListener != null) {
                        filterDialogDismissListener.onDialogDismiss("custom", from, to);
                        dismiss();
                    }
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
    }
}
