package com.tiffintom.partner1.fragments;

import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.formatter.IndexAxisValueFormatter;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.card.MaterialCardView;
import com.google.gson.reflect.TypeToken;
import com.iarcuschin.simpleratingbar.SimpleRatingBar;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.MediaAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.printer.AidlUtil;
import com.tiffintom.partner1.models.Invoice;
import com.tiffintom.partner1.models.OverViewModel;
import com.tiffintom.partner1.models.PartnerMedia;
import com.tiffintom.partner1.models.PartnerMessages;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import ru.tinkoff.scrollingpagerindicator.ScrollingPagerIndicator;

public class HomeFragment extends BaseFragment {

    private TextView tvCashFlow, tvCashFlowPreviousPercentage, tvOrdersCount, tvOrdersPercentage, tvAvgNewRatingCount, tvAvgRating, tvTotalReviews, tvViewAllReview;
    private SimpleRatingBar ratingBar;
    private OverViewModel overViewModel;
    private MaterialButtonToggleGroup flowButtonToggle, flowRangeButtonToggle, orderButtonToggle, orderRangeButtonToggle;
    private LinearLayout llNewReview, llCashFlowTimeFrame, llOrdersTimeFrame;
    private RelativeLayout rlNewRating;
    private SwipeRefreshLayout swipeRefreshLayout;
    private BarChart barChart;
    private MaterialButtonToggleGroup btnRange;
    private MaterialButton btnThisMonth, btnLastMonth, btnThisYear, btnOrdersDaily, btnOrdersWeekly, btnOrdersMonthly, btnCashFlowDaily, btnCashFlowWeekly, btnCashFlowMonthly;
    private TextView tvSelectedTab, tvTotal, tvPreviousPercent, tvMessage, tvCashFlowTimeFrame, tvOrdersTimeFrame;
    private MaterialCardView cvCloseInstructions;
    private TextView tvCloseInstructions;
    private RecyclerView rvMedia;
    private RelativeLayout llMedia;
    private ScrollingPagerIndicator mediaIndicator;
    private MediaAdapter mediaAdapter;
    private ArrayList<PartnerMedia> mediaArrayList = new ArrayList<>();

    public static HomeFragment getInstance() {
        return new HomeFragment();
    }

    private ArrayList<PartnerMessages> massageArraylist = new ArrayList<>();
    private Type messageType = new TypeToken<List<PartnerMessages>>() {
    }.getType();

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_home, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (loggedInRestaurant != null)
                fetchData();
            fetchMessage();
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            cvCloseInstructions = view.findViewById(R.id.cvCloseInstructions);
            tvCloseInstructions = view.findViewById(R.id.tvCloseInstructions);
            tvSelectedTab = view.findViewById(R.id.tvSelectedTab);
            tvPreviousPercent = view.findViewById(R.id.tvPreviousPercent);
            tvTotal = view.findViewById(R.id.tvTotal);
            tvMessage = view.findViewById(R.id.tvMessage);

            llMedia = view.findViewById(R.id.llMedia);
            rvMedia = view.findViewById(R.id.rvMedia);
            mediaIndicator = view.findViewById(R.id.mediaIndicators);
            mediaAdapter = new MediaAdapter(mediaArrayList);
            rvMedia.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.HORIZONTAL, false));
            rvMedia.setAdapter(mediaAdapter);
            SnapHelper helper = new PagerSnapHelper();
            helper.attachToRecyclerView(rvMedia);
            mediaIndicator.attachToRecyclerView(rvMedia);
            llMedia.setVisibility(View.GONE);

            barChart = view.findViewById(R.id.barChart);
            barChart.setDrawValueAboveBar(true);
            barChart.setFitBars(false);
            barChart.setDescription(null);
            barChart.getLegend().setEnabled(false);

            barChart.getAxisLeft().setDrawLabels(false);
            barChart.getAxisLeft().setDrawGridLines(false);
            barChart.getAxisLeft().setDrawAxisLine(false);

            barChart.getAxisRight().setDrawLabels(false);
            barChart.getAxisRight().setDrawGridLines(false);
            barChart.getAxisRight().setDrawAxisLine(false);

            barChart.getXAxis().setDrawAxisLine(false);
            barChart.getXAxis().setDrawGridLines(false);
            barChart.getXAxis().setGranularity(1);
            barChart.getXAxis().setPosition(XAxis.XAxisPosition.BOTTOM);
            barChart.setDoubleTapToZoomEnabled(false);
            barChart.setDoubleTapToZoomEnabled(false);
            barChart.setPinchZoom(false);
            barChart.setScaleEnabled(false);

            btnRange = view.findViewById(R.id.btnRangeGroup);
            btnThisMonth = view.findViewById(R.id.btnThisMonth);
            btnLastMonth = view.findViewById(R.id.btnLastMonth);
            btnThisYear = view.findViewById(R.id.btnThisYear);
            tvCashFlow = view.findViewById(R.id.tvCashFlow);
            tvCashFlowPreviousPercentage = view.findViewById(R.id.tvCashFlowPreviousPercentage);

            tvOrdersCount = view.findViewById(R.id.tvOrdersCount);
            tvOrdersPercentage = view.findViewById(R.id.tvOrdersPercentage);

            flowRangeButtonToggle = view.findViewById(R.id.flow_range_toggle_button_group);
            flowButtonToggle = view.findViewById(R.id.flow_toggle_button_group);
            tvCashFlowTimeFrame = view.findViewById(R.id.tvCashFlowTimeFrame);
            llCashFlowTimeFrame = view.findViewById(R.id.llCashFlowTimeFrame);

            orderButtonToggle = view.findViewById(R.id.orders_toggle_button_group);
            orderRangeButtonToggle = view.findViewById(R.id.orders_range_toggle_button_group);
            tvOrdersTimeFrame = view.findViewById(R.id.tvOrdersTimeFrame);
            llOrdersTimeFrame = view.findViewById(R.id.llOrdersTimeFrame);

            btnCashFlowDaily = view.findViewById(R.id.btnCashFlowDaily);
            btnCashFlowWeekly = view.findViewById(R.id.btnCashFlowWeekly);
            btnCashFlowMonthly = view.findViewById(R.id.btnCashFlowMonthly);

            btnOrdersDaily = view.findViewById(R.id.btnOrdersDaily);
            btnOrdersWeekly = view.findViewById(R.id.btnOrdersWeekly);
            btnOrdersMonthly = view.findViewById(R.id.btnOrdersMonthly);

            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            rlNewRating = view.findViewById(R.id.rlAvgUnreadCount);
            llNewReview = view.findViewById(R.id.llNewReview);
            tvAvgRating = view.findViewById(R.id.tvRating);
            tvAvgNewRatingCount = view.findViewById(R.id.tvAvgNewReview);
            ratingBar = view.findViewById(R.id.rating);
            tvViewAllReview = view.findViewById(R.id.tvViewAll);
            tvTotalReviews = view.findViewById(R.id.tvTotalreview);
            cvCloseInstructions.setVisibility(View.GONE);
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }

    }

    private void updateViews() {
        try {
            if (overViewModel != null) {
                tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(overViewModel.cod_price)));
                tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.previous_cod_percentage)));
                updateCashFlowStats();

                tvOrdersCount.setText(overViewModel.cod_count);
                tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.previous_cod_count)));
                updateOrderStats();

                tvAvgNewRatingCount.setText("New review (" + overViewModel.new_review_count + ")");
                if (overViewModel.new_review_count > 0) {
                    rlNewRating.setVisibility(View.VISIBLE);
                    tvAvgNewRatingCount.setVisibility(View.VISIBLE);
                    llNewReview.setBackgroundResource(R.drawable.bottom_rounded_filled);
                } else {
                    rlNewRating.setVisibility(View.INVISIBLE);
                    tvAvgNewRatingCount.setVisibility(View.INVISIBLE);
                    llNewReview.setBackgroundResource(R.drawable.bottom_rounded_filled_grey);
                }
                ratingBar.setRating(overViewModel.final_review);
                tvTotalReviews.setText(overViewModel.total_rating + " total reviews");
                tvAvgRating.setText(overViewModel.final_review + "/5");

                int checkedId = btnRange.getCheckedButtonId();

                if (checkedId == R.id.btnThisMonth) {
                    setUpThisMonthChart();
                } else if (checkedId == R.id.btnLastMonth) {
                    setUpLastMonthChart();
                } else if (checkedId == R.id.btnThisYear) {
                    setUpThisYearChart();
                }
            }
            String closeInstruction = "";
            boolean closed = false;
            if (CommonFunctions.getTodayDay().equalsIgnoreCase("monday")) {
                if (!loggedInRestaurant.monday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_monday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup and delivery ");
                    closed = true;
                } else if (!loggedInRestaurant.monday_status.equalsIgnoreCase("") && loggedInRestaurant.restaurant_timing.pick_monday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for delivery ");
                    closed = true;
                } else if (loggedInRestaurant.monday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_monday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup ");
                    closed = true;
                }
            } else if (CommonFunctions.getTodayDay().equalsIgnoreCase("tuesday")) {
                if (!loggedInRestaurant.tuesday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_tuesday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup and delivery ");
                    closed = true;
                } else if (!loggedInRestaurant.tuesday_status.equalsIgnoreCase("") && loggedInRestaurant.restaurant_timing.pick_tuesday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for delivery ");
                    closed = true;
                } else if (loggedInRestaurant.tuesday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_tuesday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup ");
                    closed = true;
                }
            } else if (CommonFunctions.getTodayDay().equalsIgnoreCase("wednesday")) {
                if (!loggedInRestaurant.wednesday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_wednesday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup and delivery ");
                    closed = true;
                } else if (!loggedInRestaurant.wednesday_status.equalsIgnoreCase("") && loggedInRestaurant.restaurant_timing.pick_wednesday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for delivery ");
                    closed = true;
                } else if (loggedInRestaurant.wednesday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_wednesday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup ");
                    closed = true;
                }
            } else if (CommonFunctions.getTodayDay().equalsIgnoreCase("thursday")) {
                if (!loggedInRestaurant.thursday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_thursday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup and delivery ");
                    closed = true;
                } else if (!loggedInRestaurant.thursday_status.equalsIgnoreCase("") && loggedInRestaurant.restaurant_timing.pick_thursday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for delivery ");
                    closed = true;
                } else if (loggedInRestaurant.thursday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_thursday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup ");
                    closed = true;
                }
            } else if (CommonFunctions.getTodayDay().equalsIgnoreCase("friday")) {
                if (!loggedInRestaurant.friday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_friday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup and delivery ");
                    closed = true;
                } else if (!loggedInRestaurant.friday_status.equalsIgnoreCase("") && loggedInRestaurant.restaurant_timing.pick_friday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for delivery ");
                    closed = true;
                } else if (loggedInRestaurant.friday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_friday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup ");
                    closed = true;
                }
            } else if (CommonFunctions.getTodayDay().equalsIgnoreCase("saturday")) {
                if (!loggedInRestaurant.saturday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_saturday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup and delivery ");
                    closed = true;
                } else if (!loggedInRestaurant.saturday_status.equalsIgnoreCase("") && loggedInRestaurant.restaurant_timing.pick_saturday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for delivery ");
                    closed = true;
                } else if (loggedInRestaurant.saturday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_saturday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup ");
                    closed = true;
                }
            } else if (CommonFunctions.getTodayDay().equalsIgnoreCase("sunday")) {
                if (!loggedInRestaurant.sunday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_sunday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup and delivery ");
                    closed = true;
                } else if (!loggedInRestaurant.sunday_status.equalsIgnoreCase("") && loggedInRestaurant.restaurant_timing.pick_sunday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for delivery ");
                    closed = true;
                } else if (loggedInRestaurant.sunday_status.equalsIgnoreCase("") && !loggedInRestaurant.restaurant_timing.pick_sunday_status.equalsIgnoreCase("")) {
                    closeInstruction = ("Currently closed for pickup ");
                    closed = true;
                }
            }
            if (closed) {
                cvCloseInstructions.setVisibility(View.VISIBLE);
                tvCloseInstructions.setText(closeInstruction);
            } else {
                cvCloseInstructions.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpMedia() {
        mediaArrayList.clear();
        if (overViewModel.partner_medias != null && overViewModel.partner_medias.size() > 0) {
            llMedia.setVisibility(View.VISIBLE);
            mediaArrayList.addAll(overViewModel.partner_medias);
        } else {
            llMedia.setVisibility(View.GONE);
        }
        mediaAdapter.notifyDataSetChanged();
    }

    private void setListeners() {
        flowButtonToggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
            if (isChecked) {
                updateCashFlowStats();
            }
        });
        flowRangeButtonToggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
            if (isChecked) {
                updateCashFlowStats();
            }
        });
        orderButtonToggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
            if (isChecked) {
                updateOrderStats();
            }
        });
        orderRangeButtonToggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
            if (isChecked) {
                updateOrderStats();
            }
        });
        swipeRefreshLayout.setOnRefreshListener(this::fetchData);
        llNewReview.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, ReviewListFragment.getInstance(), "Reviews");
            ft.addToBackStack("reviews");
            ft.commit();
        });
        btnRange.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
            if (isChecked) {

                if (checkedId == R.id.btnThisMonth) {
                    setUpThisMonthChart();
                } else if (checkedId == R.id.btnLastMonth) {
                    setUpLastMonthChart();
                } else if (checkedId == R.id.btnThisYear) {
                    setUpThisYearChart();
                }
            }
        });
        llOrdersTimeFrame.setOnClickListener(view -> {
            String selectedFilter = "daily";
            if (orderRangeButtonToggle.getCheckedButtonId() == R.id.btnOrdersDaily) {
                selectedFilter = "daily";
            } else if (orderRangeButtonToggle.getCheckedButtonId() == R.id.btnOrdersWeekly) {
                selectedFilter = "weekly";
            } else if (orderRangeButtonToggle.getCheckedButtonId() == R.id.btnOrdersMonthly) {
                selectedFilter = "daily";
            }
            OverviewFilterSelectionFragment overviewFilterSelectionFragment = OverviewFilterSelectionFragment.getInstance(selectedFilter);
            overviewFilterSelectionFragment.show(getActivity().getSupportFragmentManager(), "filter");
            overviewFilterSelectionFragment.setDialogDismissListener((o) -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("daily")) {
                        btnOrdersDaily.setChecked(true);
                        tvOrdersTimeFrame.setText("Daily");
                    } else if (((String) o).equalsIgnoreCase("weekly")) {
                        btnOrdersWeekly.setChecked(true);
                        tvOrdersTimeFrame.setText("Weekly");
                    } else if (((String) o).equalsIgnoreCase("monthly")) {
                        btnOrdersMonthly.setChecked(true);
                        tvOrdersTimeFrame.setText("Monthly");
                    }
                }
            });
        });
        llCashFlowTimeFrame.setOnClickListener(view -> {
            String selectedFilter = "daily";
            if (flowRangeButtonToggle.getCheckedButtonId() == R.id.btnCashFlowDaily) {
                selectedFilter = "daily";
            } else if (flowRangeButtonToggle.getCheckedButtonId() == R.id.btnCashFlowWeekly) {
                selectedFilter = "weekly";
            } else if (flowRangeButtonToggle.getCheckedButtonId() == R.id.btnCashFlowMonthly) {
                selectedFilter = "daily";
            }
            OverviewFilterSelectionFragment overviewFilterSelectionFragment = OverviewFilterSelectionFragment.getInstance(selectedFilter);
            overviewFilterSelectionFragment.show(getActivity().getSupportFragmentManager(), "filter");
            overviewFilterSelectionFragment.setDialogDismissListener((o) -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("daily")) {
                        btnCashFlowDaily.setChecked(true);
                        tvCashFlowTimeFrame.setText("Daily");
                    } else if (((String) o).equalsIgnoreCase("weekly")) {
                        btnCashFlowWeekly.setChecked(true);
                        tvCashFlowTimeFrame.setText("Weekly");
                    } else if (((String) o).equalsIgnoreCase("monthly")) {
                        btnCashFlowMonthly.setChecked(true);
                        tvCashFlowTimeFrame.setText("Monthly");
                    }
                }
            });
        });
    }

    private void updateCashFlowStats() {
        try {
            int rangeCheckedId = flowRangeButtonToggle.getCheckedButtonId();
            int paymentCheckedId = flowButtonToggle.getCheckedButtonId();
            if (paymentCheckedId == R.id.btnCashFlowCod) {

                if (rangeCheckedId == R.id.btnCashFlowDaily) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.cod.daily.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.cod.daily.previous_percentage)));
                } else if (rangeCheckedId == R.id.btnCashFlowWeekly) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.cod.weekly.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.cod.weekly.previous_percentage)));
                } else if (rangeCheckedId == R.id.btnCashFlowMonthly) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.cod.monthly.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.cod.monthly.previous_percentage)));
                }
            } else if (paymentCheckedId == R.id.btnCashFlowPayPal) {
                tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.previous_paypal_percentage)));
                if (rangeCheckedId == R.id.btnCashFlowDaily) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.paypal.daily.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.paypal.daily.previous_percentage)));
                } else if (rangeCheckedId == R.id.btnCashFlowWeekly) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.paypal.weekly.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.paypal.weekly.previous_percentage)));
                } else if (rangeCheckedId == R.id.btnCashFlowMonthly) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.paypal.monthly.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.paypal.monthly.previous_percentage)));
                }
            } else if (paymentCheckedId == R.id.btnCashFlowCard) {
                tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.previous_card_percentage)));
                if (rangeCheckedId == R.id.btnCashFlowDaily) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.card.daily.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.card.daily.previous_percentage)));
                } else if (rangeCheckedId == R.id.btnCashFlowWeekly) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.card.weekly.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.card.weekly.previous_percentage)));
                } else if (rangeCheckedId == R.id.btnCashFlowMonthly) {
                    tvCashFlow.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(Float.parseFloat(overViewModel.card.monthly.price))));
                    tvCashFlowPreviousPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.card.monthly.previous_percentage)));
                }
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void updateOrderStats() {
        try {
            int rangeCheckedId = orderRangeButtonToggle.getCheckedButtonId();
            int paymentCheckedId = orderButtonToggle.getCheckedButtonId();
            if (paymentCheckedId == R.id.btnOrdersCod) {

                if (rangeCheckedId == R.id.btnOrdersDaily) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.cod.daily.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.cod.daily.previous_count)));
                } else if (rangeCheckedId == R.id.btnOrdersWeekly) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.cod.weekly.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.cod.weekly.previous_count)));
                } else if (rangeCheckedId == R.id.btnOrdersMonthly) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.cod.monthly.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.cod.monthly.previous_count)));
                }
            } else if (paymentCheckedId == R.id.btnOrdersPayPal) {
                if (rangeCheckedId == R.id.btnOrdersDaily) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.paypal.daily.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.paypal.daily.previous_count)));
                } else if (rangeCheckedId == R.id.btnOrdersWeekly) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.paypal.weekly.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.paypal.weekly.previous_count)));
                } else if (rangeCheckedId == R.id.btnOrdersMonthly) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.paypal.monthly.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.paypal.monthly.previous_count)));
                }
            } else if (paymentCheckedId == R.id.btnOrdersCard) {
                if (rangeCheckedId == R.id.btnOrdersDaily) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.card.daily.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.card.daily.previous_count)));
                } else if (rangeCheckedId == R.id.btnOrdersWeekly) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.card.weekly.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.card.weekly.previous_count)));
                } else if (rangeCheckedId == R.id.btnOrdersMonthly) {
                    tvOrdersCount.setText(String.format("%s", (overViewModel.card.monthly.count)));
                    tvOrdersPercentage.setText(String.format("%s%% from previous", MyApp.df.format(overViewModel.card.monthly.previous_count)));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        new Thread(this::fetchOverviews).start();
    }

    private void fetchOverviews() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                });
            }
            AndroidNetworking.get(ApiEndPoints.overview)
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .build()
                    .getAsObject(OverViewModel.class, new ParsedRequestListener<OverViewModel>() {
                        @Override
                        public void onResponse(OverViewModel response) {
                            try {
                                overViewModel = response;
                                updateViews();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchMessage() {
        new Thread(this::fetchPartnerMessage).start();
    }

    private void fetchPartnerMessage() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                });
            }
            AndroidNetworking.get(ApiEndPoints.partner_message).addQueryParameter("nopaginate","1")
                    .build()
                    .getAsObjectList(PartnerMessages.class, new ParsedRequestListener<List<PartnerMessages>>() {
                        @Override
                        public void onResponse(List<PartnerMessages> response) {
                            try {
                                    tvMessage.setVisibility(View.VISIBLE);
                                    massageArraylist.clear();
                                    String message = "";
                                    massageArraylist.addAll(response);
                                    for (int i = 0; i < massageArraylist.size(); i++) {
                                        message = message + (massageArraylist.get(i).message);
                                        if (i != massageArraylist.size() - 1) {
                                            message = message + ", ";
                                        }
                                        tvMessage.setTextColor(Color.parseColor(massageArraylist.get(i).font_color));
                                        tvMessage.setBackgroundColor(Color.parseColor(massageArraylist.get(i).bg_color));
                                    }
                                    tvMessage.setText(message);
                                    tvMessage.postDelayed(() -> tvMessage.setSelected(true), 1000);

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpThisMonthChart() {
        try {
            List<BarEntry> barEntries = new ArrayList<>();
            float count = 0;
            ArrayList<String> dates = new ArrayList<>();
            if (overViewModel.this_month_invoices != null) {
                for (Invoice invoice : overViewModel.this_month_invoices) {
                    barEntries.add(new BarEntry(count, invoice.grand_total));
                    if (!Validators.isNullOrEmpty(invoice.end_date))
                        dates.add(CommonFunctions.formatUnknownDateTime(invoice.end_date, MyApp.DEL_TIMEFORMAT, "dd/MM"));
                    else if (!Validators.isNullOrEmpty(invoice.start_date)) {
                        dates.add(CommonFunctions.formatUnknownDateTime(invoice.start_date, MyApp.DEL_TIMEFORMAT, "dd/MM"));
                    } else {
                        dates.add("01/01");
                    }
                    count++;
                }
            }
            BarDataSet barDataSet = new BarDataSet(barEntries, "Dates");
            if (getActivity() != null)
                barDataSet.setColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
            barDataSet.setValueFormatter(new ValueFormatter() {
                @Override
                public String getFormattedValue(float value) {
                    return (value == 0) ? "" : myApp.getCurrencySymbol() + value;
                }
            });
            barDataSet.setValueTextSize(12);
            BarData barData = new BarData(barDataSet);
            barData.setBarWidth(0.9f);
            barChart.setData(barData);

            XAxis xAxis = barChart.getXAxis();
            xAxis.setValueFormatter(new IndexAxisValueFormatter(dates));
            barChart.invalidate();

            tvPreviousPercent.setVisibility(View.VISIBLE);
            tvSelectedTab.setText("This Month");
            tvPreviousPercent.setText(MyApp.df.format(overViewModel.this_month_percentage) + "% from previous");
            tvTotal.setText(myApp.getCurrencySymbol() + MyApp.df.format(Float.parseFloat(overViewModel.this_month_grand_total)));
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void setUpLastMonthChart() {
        try {
            List<BarEntry> barEntries = new ArrayList<>();
            ArrayList<String> dates = new ArrayList<>();
            int count = 0;
            if (overViewModel.previous_month_invoices != null) {

                for (Invoice invoice : overViewModel.previous_month_invoices) {
                    barEntries.add(new BarEntry(count, invoice.grand_total));
                    if (!Validators.isNullOrEmpty(invoice.end_date))
                        dates.add(CommonFunctions.formatUnknownDateTime(invoice.end_date, MyApp.DEL_TIMEFORMAT, "dd/MM"));
                    else if (!Validators.isNullOrEmpty(invoice.start_date)) {
                        dates.add(CommonFunctions.formatUnknownDateTime(invoice.start_date, MyApp.DEL_TIMEFORMAT, "dd/MM"));
                    } else {
                        dates.add("01/01");
                    }
                    count++;
                }
            }
            BarDataSet barDataSet = new BarDataSet(barEntries, "Dates");
            if (getActivity() != null)
                barDataSet.setColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
            barDataSet.setValueFormatter(new ValueFormatter() {
                @Override
                public String getFormattedValue(float value) {
                    return (value == 0) ? "" : myApp.getCurrencySymbol() + value;
                }
            });
            barDataSet.setValueTextSize(12);
            BarData barData = new BarData(barDataSet);
            barData.setBarWidth(0.9f);
            barChart.setData(barData);

            XAxis xAxis = barChart.getXAxis();
            xAxis.setValueFormatter(new IndexAxisValueFormatter(dates));
            barChart.invalidate();

            tvPreviousPercent.setVisibility(View.GONE);
            tvSelectedTab.setText("Last Month");
            tvTotal.setText(myApp.getCurrencySymbol() + MyApp.df.format(Float.parseFloat(overViewModel.previous_month_grand_total)));
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void setUpThisYearChart() {
        try {
            List<BarEntry> barEntries = new ArrayList<>();
            ArrayList<String> dates = new ArrayList<String>();
            int count = 0;
            if (overViewModel.this_year_invoices != null) {

                for (Invoice invoice : overViewModel.this_year_invoices) {
                    barEntries.add(new BarEntry(count, invoice.grand_total));
                    if (!Validators.isNullOrEmpty(invoice.end_date))
                        dates.add(CommonFunctions.formatUnknownDateTime(invoice.end_date, MyApp.DEL_TIMEFORMAT, "dd/MM"));
                    else if (!Validators.isNullOrEmpty(invoice.start_date)) {
                        dates.add(CommonFunctions.formatUnknownDateTime(invoice.start_date, MyApp.DEL_TIMEFORMAT, "dd/MM"));
                    } else {
                        dates.add("01/01");
                    }
                    count++;
                }
            }
            BarDataSet barDataSet = new BarDataSet(barEntries, "Dates");
            if (getActivity() != null)
                barDataSet.setColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
            barDataSet.setValueFormatter(new ValueFormatter() {
                @Override
                public String getFormattedValue(float value) {
                    return (value == 0) ? "" : myApp.getCurrencySymbol() + value;
                }
            });
            barDataSet.setValueTextSize(12);
            BarData barData = new BarData(barDataSet);
            barData.setBarWidth(0.9f);
            barChart.setData(barData);

            XAxis xAxis = barChart.getXAxis();
            xAxis.setValueFormatter(new IndexAxisValueFormatter(dates));
            barChart.invalidate();

            tvPreviousPercent.setVisibility(View.GONE);
            tvSelectedTab.setText("This Year");
            tvTotal.setText(myApp.getCurrencySymbol() + MyApp.df.format(Float.parseFloat(overViewModel.this_year_grand_total)));
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStop() {
        try {
            if (getActivity() != null && progressDialog != null) {
                progressDialog.dismiss();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (!AidlUtil.getInstance().isConnect())
                AidlUtil.getInstance().connectPrinterService(getActivity());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}