package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class LogoutOptionsDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private LinearLayout llLogout, llOrderingService, llPaymentService;
    private RadioButton rbOrderingService, rbPaymentService;
    private DialogDismissListener dialogDismissListener;
    String selected_option = "restaurant";
    private ImageView ivClose;

    public static LogoutOptionsDialogFragment getInstance() {
        LogoutOptionsDialogFragment rejectReasonDialog = new LogoutOptionsDialogFragment();
        Bundle bundle = new Bundle();

        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_logout_options, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    private void initViews(View view) {
        ivClose = view.findViewById(R.id.ivClose);
        llLogout = view.findViewById(R.id.llLogout);
        rbOrderingService = view.findViewById(R.id.rbOrderingService);
        rbPaymentService = view.findViewById(R.id.rbPaymentService);
        llOrderingService = view.findViewById(R.id.llOrderingService);
        llPaymentService = view.findViewById(R.id.llPaymentService);
        if (MyApp.getInstance().getMyPreferences().getLoggedInRestaurant() != null) {
            llOrderingService.setVisibility(View.VISIBLE);
            llOrderingService.performClick();
            rbOrderingService.setChecked(true);
        } else {
            llOrderingService.setVisibility(View.GONE);
        }
        if (MyApp.getInstance().getMyPreferences().getLoggedInMerchant() != null) {
            llPaymentService.setVisibility(View.VISIBLE);
            if (llOrderingService.getVisibility() == View.GONE) {
                llPaymentService.performClick();
                rbPaymentService.setChecked(true);
            }
        } else {
            llPaymentService.setVisibility(View.GONE);
        }
    }

    private void setListeners() {
        llLogout.setOnClickListener(view -> {
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss(selected_option);
            dismiss();
        });
        ivClose.setOnClickListener(view -> {
            if (dialogDismissListener != null) {
                dialogDismissListener.onDialogDismiss(null);
            }
            dismiss();
        });
        llPaymentService.setOnClickListener(view -> {
            rbPaymentService.setChecked(true);
            rbOrderingService.setChecked(false);
            selected_option = "merchant";
        });
        llOrderingService.setOnClickListener(view -> {
            rbPaymentService.setChecked(false);
            rbOrderingService.setChecked(true);
            selected_option = "restaurant";
        });
    }


}
