package com.tiffintom.partner1.fragments

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ProgressBar
import com.google.android.material.button.MaterialButton
import com.google.firebase.ktx.Firebase
import com.google.firebase.remoteconfig.ConfigUpdate
import com.google.firebase.remoteconfig.ConfigUpdateListener
import com.google.firebase.remoteconfig.FirebaseRemoteConfig
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException
import com.google.firebase.remoteconfig.ktx.remoteConfig
import com.google.firebase.remoteconfig.ktx.remoteConfigSettings
import com.tiffintom.partner1.R
import com.tiffintom.partner1.activities.SplashActivity
import com.tiffintom.partner1.base.BaseFragment


class Maintenance : BaseFragment() {
    private  var btnRefresh: MaterialButton? = null
    private  var progressMaintenance: ProgressBar? = null
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_maintenance, container, false)
    }

    override fun initViews(view: View?) {
        super.initViews(view)
        btnRefresh = requireView().findViewById(R.id.btnRefresh)
        progressMaintenance = requireView().findViewById(R.id.progress_maintenance)
        btnRefresh!!.setOnClickListener {
            readFirebaseConfig()
        }
    }

    companion object{
        fun getInstance(): Maintenance {
            return Maintenance()
        }
    }

    private fun readFirebaseConfig() {
        progressMaintenance!!.visibility = View.VISIBLE
        val remoteConfig: FirebaseRemoteConfig = Firebase.remoteConfig
        val configSettings = remoteConfigSettings {}
        remoteConfig.setConfigSettingsAsync(configSettings)
        remoteConfig.fetchAndActivate()
            .addOnCompleteListener(requireActivity()) { task ->
                if (task.isSuccessful) {
                    progressMaintenance!!.visibility = View.GONE
                    Log.e("remoteConfig","remoteConfig ${remoteConfig.getBoolean("is_in_maintenance")}")
                    if (remoteConfig != null && remoteConfig.getBoolean("is_in_maintenance")) {
                        if (remoteConfig.getBoolean("is_in_maintenance")) {

                        }else{
                            startActivity(
                                Intent(activity, SplashActivity::class.java).addFlags(
                                    Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK or Intent.FLAG_ACTIVITY_CLEAR_TOP
                                )
                            )
                        }
                    }

                }
            }
        remoteConfig.addOnConfigUpdateListener(object : ConfigUpdateListener {
            override fun onUpdate(configUpdate: ConfigUpdate) {
                remoteConfig.activate()
                    .addOnCompleteListener {
                        if (it.isSuccessful) {
                            Log.w("TAG", "isSuccessful update error with code: " + it.isSuccessful)
                        }
                    }
            }

            override fun onError(error: FirebaseRemoteConfigException) {
                Log.w("TAG", "Config update error with code: " + error.code, error)
            }
        })
    }
}