package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CategoryAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.Addon;
import com.tiffintom.partner1.models.Categories;
import com.tiffintom.partner1.models.EditSubAddon;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class MenuAddonFragment extends BaseFragment {


    private LinearLayout llMainSearch, llSearch, llAdd, llData;
    private TextView tvMenu, tvCancel;
    private AppCompatImageView ivSearch;
    private AppCompatEditText etSearch;
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView rvMenu;
    private ArrayList<String> menus = new ArrayList<>();
    private TextView tvEditDelete;
    private LottieAnimationView animationView;
    private CategoryAdapter categoryAdapter;
    private ArrayList<Addon> addons = new ArrayList<>();
    private ArrayList<Object> filteredList = new ArrayList<>();
    private String title;

    public static MenuAddonFragment getInstance(String title) {
        MenuAddonFragment fragment = new MenuAddonFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_menu_categories, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
        fetchAddons();
    }

    private void setListeners() {
        swipeRefreshLayout.setOnRefreshListener(() -> {
            fetchAddons();
        });
        ivSearch.setOnClickListener(view -> {
            llMainSearch.setVisibility(View.GONE);
            llSearch.setVisibility(View.VISIBLE);
        });

        tvCancel.setOnClickListener(view -> {
            etSearch.setText(null);
            filteredList.clear();
            filteredList.addAll(addons);
            categoryAdapter.notifyDataSetChanged();
            llMainSearch.setVisibility(View.VISIBLE);
            llSearch.setVisibility(View.GONE);
        });

        etSearch.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                filteredList.clear();
                filteredList.addAll(searchAddon());
                categoryAdapter.notifyDataSetChanged();
            }
        });
        llAdd.setOnClickListener(view -> {
            AddOrEditMenuAddonDialogFragment fragment = AddOrEditMenuAddonDialogFragment.getInstance(null);
            fragment.show(getChildFragmentManager(), "Add Category");
            fragment.setCancelable(false);
            fragment.setDialogDismissListener(o -> {
                EditSubAddon addon = (EditSubAddon) o;
                LogUtils.e("Add Addon ::" + new Gson().toJson(addon));
                addAddon(addon, "Add");
            }, o -> {

            });


        });
    }

    private void addAddon(EditSubAddon addon, String action) {
        AndroidNetworking.post(ApiEndPoints.addons)
                .addBodyParameter("restaurant_id", addon.restaurant_id)
                .addBodyParameter("category_id", String.valueOf(addon.category_id))
                .addBodyParameter("category_name", addon.category_name)
                .addBodyParameter("admin_name", addon.admin_name)
                .addBodyParameter("mainaddons_name", addon.mainaddons_name)
                .addBodyParameter("mainaddons_mini_count", addon.mainaddons_mini_count)
                .addBodyParameter("mainaddons_count", addon.mainaddons_count)
                .addBodyParameter("sortorder", addon.sortorder)
                .addBodyParameter("status", addon.status)
                .addBodyParameter("sub_addons", new Gson().toJson(addon.sub_addons))
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    fetchAddons();
                                    categoryAdapter.notifyDataSetChanged();
                                });
                                LogUtils.e("add addons responce::" + new Gson().toJson(response));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                    CommonFunctions.hideKeyboard(getActivity(), etSearch);
                                    LogUtils.e("ERROR IN ADDING OR EDIT ADDON::" + new Gson().toJson(anError.getErrorBody()));
                                    fetchAddons();
                                });
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                });
    }

    private void editAddon(EditSubAddon addon, String action) {
        AndroidNetworking.post(ApiEndPoints.addons + addon.id)
                .addBodyParameter("id", addon.id)
                .addBodyParameter("restaurant_id", addon.restaurant_id)
                .addBodyParameter("category_id", String.valueOf(addon.category_id))
                .addBodyParameter("category_name", addon.category_name)
                .addBodyParameter("admin_name", addon.admin_name)
                .addBodyParameter("mainaddons_name", addon.mainaddons_name)
                .addBodyParameter("mainaddons_mini_count", addon.mainaddons_mini_count)
                .addBodyParameter("mainaddons_count", addon.mainaddons_count)
                .addBodyParameter("sortorder", addon.sortorder)
                .addBodyParameter("status", addon.status)
                .addBodyParameter("sub_addons", new Gson().toJson(addon.sub_addons))
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    fetchAddons();
                                    categoryAdapter.notifyDataSetChanged();
                                });
                                LogUtils.e("add addons responce::" + new Gson().toJson(response));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                    CommonFunctions.hideKeyboard(getActivity(), etSearch);
                                    LogUtils.e("ERROR IN ADDING OR EDIT ADDON::" + new Gson().toJson(anError.getErrorBody()));
                                    fetchAddons();
                                });
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                });
    }

    private ArrayList<Addon> searchAddon() {
        if (etSearch.getText().toString().isEmpty()) {
            return addons;
        }
        ArrayList<Addon> searchedRest = new ArrayList<>();
        for (Addon r : addons) {
            if (r.mainaddons_name != null && r.mainaddons_name.toLowerCase().contains(etSearch.getText().toString().toLowerCase())) {
                searchedRest.add(r);
            }
        }
        return searchedRest;

    }

    private void fetchAddons() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llData.setVisibility(View.VISIBLE);
                    swipeRefreshLayout.setRefreshing(true);
                    animationView.setVisibility(View.GONE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.addons)
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Addon.class, new ParsedRequestListener<List<Addon>>() {
                        @Override
                        public void onResponse(List<Addon> response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llData.setVisibility(View.VISIBLE);
                                        swipeRefreshLayout.setRefreshing(false);
                                        animationView.setVisibility(View.GONE);
                                    });

                                    etSearch.setText(null);
                                    addons.clear();
                                    addons.addAll(response);
                                    filteredList.clear();
                                    filteredList.addAll(response);
                                    categoryAdapter.notifyDataSetChanged();

                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llData.setVisibility(View.GONE);
                                        swipeRefreshLayout.setRefreshing(false);
                                        animationView.setVisibility(View.VISIBLE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(false);
                });
            }

        }

    }


    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            title = getArguments().getString("title");
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
        llMainSearch = view.findViewById(R.id.llMainSearch);
        llSearch = view.findViewById(R.id.llSearchLayout);
        tvMenu = view.findViewById(R.id.tvMenu);
        ivSearch = view.findViewById(R.id.ivSearch);
        llAdd = view.findViewById(R.id.llAdd);
        etSearch = view.findViewById(R.id.etSearch);
        tvCancel = view.findViewById(R.id.tvCancel);
        rvMenu = view.findViewById(R.id.rvCategories);
        animationView = view.findViewById(R.id.animation_view);
        llData = view.findViewById(R.id.llRootData);

        if (!Validators.isNullOrEmpty(title))
            tvMenu.setText(title);
        categoryAdapter = new CategoryAdapter(filteredList, (position, data) -> {

            if (data instanceof Addon) {
                Addon addon = (Addon) data;
                openEditAddonDialog(addon);

            }
        }, (position, data) -> {
            Addon addon = (Addon) data;
            deleteItem(addon.id);
        }, (position, data) -> {
            // call active/inactive api
            callActiveInActiveApi(position, (Addon) data);
        });
        rvMenu.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvMenu.setNestedScrollingEnabled(false);
        rvMenu.setAdapter(categoryAdapter);

    }

    private void callActiveInActiveApi(int position, Addon categories) {
        try {
            String enableDisabled = categories.status.equalsIgnoreCase("true") ? "/disable" : "/enable";
            AndroidNetworking.post(ApiEndPoints.addons + categories.id + enableDisabled)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Log.e("responseresponse", "callActiveInActiveApi request is " + ApiEndPoints.products + categories.id + enableDisabled + " Response is " + response);
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> fetchAddons());
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openEditAddonDialog(Addon addon) {
        AddOrEditMenuAddonDialogFragment fragment = AddOrEditMenuAddonDialogFragment.getInstance(addon);
        fragment.show(getChildFragmentManager(), "Edit Addon");
        fragment.setCancelable(false);
        fragment.setDialogDismissListener(o -> {
            EditSubAddon addon1 = (EditSubAddon) o;

            editAddon(addon1, "Edit");
        }, o -> {
            Addon addon1 = (Addon) o;
            deleteItem(addon1.id);
        });
    }

    private void deleteItem(String id) {
        AndroidNetworking.delete(ApiEndPoints.addons + id)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    fetchAddons();
                                });
                                ToastUtils.makeToast(getActivity(), "Addon Deleted");
                                LogUtils.e("delete addon responce::" + new Gson().toJson(response));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                });

    }

}

