package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CategoryAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.Categories;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class MenuCategoriesFragment extends BaseFragment {


    private LinearLayout llMainSearch, llSearch, llAdd, llData;
    private TextView tvMenu, tvCancel;
    private AppCompatImageView ivSearch;
    private AppCompatEditText etSearch;
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView rvMenu;
    private CategoryAdapter categoryAdapter;
    private ArrayList<Categories> categories = new ArrayList<>();
    private ArrayList<Object> filteredList = new ArrayList<>();
    private TextView tvEditDelete;
    private LottieAnimationView animationView;
    private String title;

    public static MenuCategoriesFragment getInstance(String title) {
        MenuCategoriesFragment fragment = new MenuCategoriesFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_menu_categories, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
        fetchCategory();
    }

    private void setListeners() {
        swipeRefreshLayout.setOnRefreshListener(() -> {
            fetchCategory();
        });
        ivSearch.setOnClickListener(view -> {
            llMainSearch.setVisibility(View.GONE);
            llSearch.setVisibility(View.VISIBLE);
        });

        tvCancel.setOnClickListener(view -> {
            etSearch.setText(null);
            filteredList.clear();
            filteredList.addAll(categories);
            categoryAdapter.notifyDataSetChanged();
            llMainSearch.setVisibility(View.VISIBLE);
            llSearch.setVisibility(View.GONE);
        });

        etSearch.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                filteredList.clear();
                filteredList.addAll(searchCategory());
                categoryAdapter.notifyDataSetChanged();
            }
        });
        llAdd.setOnClickListener(view -> {
            AddOrEditMenuCategoryDialogFragment fragment = AddOrEditMenuCategoryDialogFragment.getInstance(null);
            fragment.show(getChildFragmentManager(), "Add Category");
            fragment.setCancelable(false);
            fragment.setDialogDismissListener(o -> {
                Categories categories = (Categories) o;
                addOrEditCategory(categories);
            });


        });
    }

    private void addOrEditCategory(Categories categories) {
        String url = null;
        if (!Validators.isNullOrEmpty(categories.action) && categories.action.equalsIgnoreCase("edit"))
            url = ApiEndPoints.categories + categories.id;
        else
            url = ApiEndPoints.categories;
        AndroidNetworking.post(url)
                .addBodyParameter("id", !Validators.isNullOrEmpty(categories.id) ? categories.id : "")
                .addBodyParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                .addBodyParameter("category_name", categories.category_name)
                .addBodyParameter("category_seo", "")
                .addBodyParameter("sortorder", categories.sortorder)
                .addBodyParameter("description", categories.description)
                .addBodyParameter("status", categories.status.equalsIgnoreCase("active") ? "1" : "0")
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    fetchCategory();
                                    categoryAdapter.notifyDataSetChanged();
                                });
                                LogUtils.e("add category responce::" + new Gson().toJson(response));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                });
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();

        if (getArguments() != null) {
            title = getArguments().getString("title");
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
        llMainSearch = view.findViewById(R.id.llMainSearch);
        llSearch = view.findViewById(R.id.llSearchLayout);
        tvMenu = view.findViewById(R.id.tvMenu);
        ivSearch = view.findViewById(R.id.ivSearch);
        llAdd = view.findViewById(R.id.llAdd);
        etSearch = view.findViewById(R.id.etSearch);
        tvCancel = view.findViewById(R.id.tvCancel);
        rvMenu = view.findViewById(R.id.rvCategories);
        animationView = view.findViewById(R.id.animation_view);
        llData = view.findViewById(R.id.llRootData);

        if (!Validators.isNullOrEmpty(title))
            tvMenu.setText(title);
        categoryAdapter = new CategoryAdapter(filteredList, (position, data) -> {

            if (data instanceof Categories) {
                Categories categories = (Categories) data;
                openEditCategoryDialog(categories);

            }
        }, (position, data) -> {
            Categories categories = (Categories) data;
            deleteItem(categories.id);
        }, (position, data) -> {
            // call active/inactive api
            if (data instanceof Categories) {
                callActiveInActiveApi(position, (Categories) data);
            }
        });
        rvMenu.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvMenu.setNestedScrollingEnabled(false);
        rvMenu.setAdapter(categoryAdapter);

    }

    private void openEditCategoryDialog(Categories categories) {
        AddOrEditMenuCategoryDialogFragment dialogFragment = AddOrEditMenuCategoryDialogFragment.getInstance(categories);
        dialogFragment.show(getChildFragmentManager(), "Edit Category");
        dialogFragment.setCancelable(false);
        dialogFragment.setDialogDismissListener(new DialogDismissListener() {
            @Override
            public void onDialogDismiss(Object o) {
                Categories category = (Categories) o;
                if (!Validators.isNullOrEmpty(category.action) && category.action.equalsIgnoreCase("delete"))
                    deleteItem(category.id);
                else addOrEditCategory(category);
            }
        });
    }

    private void deleteItem(String id) {
        AndroidNetworking.delete(ApiEndPoints.categories + id)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    fetchCategory();
                                });
                                LogUtils.e("delete category responce::" + new Gson().toJson(response));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                });

    }

    private void callActiveInActiveApi(int position, Categories categories) {
        try {
            String enableDisabled = categories.status.equalsIgnoreCase("true") ? "/disable" : "/enable";
            AndroidNetworking.post(ApiEndPoints.categories + categories.id + enableDisabled)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Log.e("responseresponse", "callActiveInActiveApi request is " + ApiEndPoints.products + categories.id + enableDisabled + " Response is " + response);
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> fetchCategory());
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchCategory() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llData.setVisibility(View.VISIBLE);
                    swipeRefreshLayout.setRefreshing(true);
                    animationView.setVisibility(View.GONE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.categories)
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Categories.class, new ParsedRequestListener<List<Categories>>() {
                        @Override
                        public void onResponse(List<Categories> response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llData.setVisibility(View.VISIBLE);
                                        swipeRefreshLayout.setRefreshing(false);
                                        animationView.setVisibility(View.GONE);
                                    });
                                    etSearch.setText(null);
                                    categories.clear();
                                    categories.addAll(response);
                                    filteredList.clear();
                                    filteredList.addAll(response);
                                    categoryAdapter.notifyDataSetChanged();

                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llData.setVisibility(View.GONE);
                                        swipeRefreshLayout.setRefreshing(false);
                                        animationView.setVisibility(View.VISIBLE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llData.setVisibility(View.GONE);
                    swipeRefreshLayout.setRefreshing(false);
                    animationView.setVisibility(View.VISIBLE);
                });
            }

        }

    }


    private ArrayList<Categories> searchCategory() {
        if (etSearch.getText().toString().isEmpty()) {
            return categories;
        }
        ArrayList<Categories> searchedRest = new ArrayList<>();
        for (Categories r : categories) {
            if (r.category_name != null && r.category_name.toLowerCase().contains(etSearch.getText().toString().toLowerCase())) {
                searchedRest.add(r);
            }
        }
        return searchedRest;

    }

}

