package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.MenuListAdapter;
import com.tiffintom.partner1.base.BaseFragment;

import java.util.ArrayList;

public class MenuFragment extends BaseFragment {

    private TextView tvMenu;
    private RecyclerView rvMenu;
    private MenuListAdapter menuAdapter;
    private ArrayList<String> menus = new ArrayList<>();

    public static MenuFragment getInstance() {
        return new MenuFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_menu, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }


    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        rvMenu = view.findViewById(R.id.rvMenus);
        tvMenu = view.findViewById(R.id.tvMenu);


        menus = new ArrayList<>();
        menus.add("Category");
        menus.add("Product");
        menus.add("Add ons");
        menuAdapter = new MenuListAdapter(menus, (position, data) -> {
            String menu = (String) data;
            if (menu.equalsIgnoreCase("category")) {
                FragmentTransaction ft = getFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MenuCategoriesFragment.getInstance("Category"), "menu_categories");
                ft.addToBackStack("let_go_back");
                ft.commit();
            } else if (menu.equalsIgnoreCase("product")) {
                FragmentTransaction ft = getFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MenuProductsFragment.getInstance("Product"), "menu_product");
                ft.addToBackStack("let_go_back");
                ft.commit();
            } else if (menu.equalsIgnoreCase("add ons")) {
                FragmentTransaction ft = getFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MenuAddonFragment.getInstance("Add ons"), "menu_addons");
                ft.addToBackStack("let_go_back");
                ft.commit();
            }
        });
        rvMenu.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvMenu.setNestedScrollingEnabled(false);
        rvMenu.setAdapter(menuAdapter);
        menuAdapter.notifyDataSetChanged();
    }

    private void openFragment(Fragment instance) {

    }

}
