package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CategoryAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Categories;
import com.tiffintom.partner1.models.MenuDetail;
import com.tiffintom.partner1.models.Product;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class MenuProductsFragment extends BaseFragment {


    private LinearLayout llMainSearch, llSearch, llAdd, llData;
    private TextView tvMenu, tvCancel;
    private AppCompatImageView ivSearch;
    private AppCompatEditText etSearch;
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView rvMenu;
    private ArrayList<Product> products = new ArrayList<>();
    private ArrayList<Object> filteredList = new ArrayList<>();
    private String title;
    private CategoryAdapter productAdapter;
    private LottieAnimationView animationView;
    private LinearLayoutManager menuLayoutManager;

    public static MenuProductsFragment getInstance(String title) {
        MenuProductsFragment fragment = new MenuProductsFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_menu_categories, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
        fetchProduct();
    }

    private void fetchProduct() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llData.setVisibility(View.VISIBLE);
                    swipeRefreshLayout.setRefreshing(true);
                    animationView.setVisibility(View.GONE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.products)
                    .addQueryParameter("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Product.class, new ParsedRequestListener<List<Product>>() {
                        @Override
                        public void onResponse(List<Product> response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llData.setVisibility(View.VISIBLE);
                                        swipeRefreshLayout.setRefreshing(false);
                                        animationView.setVisibility(View.GONE);
                                    });
                                    etSearch.setText(null);
                                    products.clear();
                                    products.addAll(response);
                                    filteredList.clear();
                                    filteredList.addAll(response);
                                    productAdapter.notifyDataSetChanged();

                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llData.setVisibility(View.GONE);
                                        swipeRefreshLayout.setRefreshing(false);
                                        animationView.setVisibility(View.VISIBLE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(false);
                });
            }

        }
    }

    private void setListeners() {

        swipeRefreshLayout.setOnRefreshListener(() -> {
            fetchProduct();
        });
        ivSearch.setOnClickListener(view -> {
            llMainSearch.setVisibility(View.GONE);
            llSearch.setVisibility(View.VISIBLE);
        });

        tvCancel.setOnClickListener(view -> {
            llMainSearch.setVisibility(View.VISIBLE);
            llSearch.setVisibility(View.GONE);
        });

        llAdd.setOnClickListener(view -> {
            AddProductBottomSheetFragment fragment = AddProductBottomSheetFragment.getInstance(null);
            fragment.show(getChildFragmentManager(), "add product");
            fragment.setCancelable(false);
            fragment.setDialogDismissListener(o -> {
                MenuDetail product = (MenuDetail) o;
                LogUtils.e("MENU DETAILS::" + new Gson().toJson(product.orginal_price));
                addOrEditProduct(product, "add");
            }, o -> {

            });
        });
        tvCancel.setOnClickListener(view -> {
            etSearch.setText(null);
            filteredList.clear();
            filteredList.addAll(products);
            productAdapter.notifyDataSetChanged();
            llMainSearch.setVisibility(View.VISIBLE);
            llSearch.setVisibility(View.GONE);
        });

        etSearch.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                try {
                    filteredList.clear();
                    filteredList.addAll(searchCategory());
                    productAdapter.notifyDataSetChanged();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void addOrEditProduct(MenuDetail product, String action) {
        try {
            String urls = null;

            if (action.equalsIgnoreCase("edit"))
                urls = ApiEndPoints.products + product.id;

            else
                urls = ApiEndPoints.products;
            String price = "";
            if(product.price_option!="multiple"){
                price = product.orginal_price;
            }
            ANRequest.MultiPartBuilder anRequest = AndroidNetworking.upload(urls)
                    .addMultipartParameter("category_id", String.valueOf(product.category_id))
                    .addMultipartParameter("restaurant_id", product.restaurant_id)
                    .addMultipartParameter("orginal_price",price)
                    .addMultipartParameter("category_name", product.category_name)
                    .addMultipartParameter("contains_nuts", String.valueOf(product.contains_nuts))
                    .addMultipartParameter("crustaceans", String.valueOf(product.crustaceans))
                    .addMultipartParameter("delete_status", product.delete_status)
                    .addMultipartParameter("eggs", String.valueOf(product.eggs))
                    .addMultipartParameter("favourite", product.favourite)
                    .addMultipartParameter("featured", product.featured)
                    .addMultipartParameter("fish", String.valueOf(product.fish))
                    .addMultipartParameter("gluten_free", String.valueOf(0))
                    .addMultipartParameter("halal", String.valueOf(0))
                    .addMultipartParameter("is_suggest", String.valueOf(0))
                    .addMultipartParameter("koshar", String.valueOf(product.koshar))
                    .addMultipartParameter("menu_addon", product.menu_addon)
                    .addMultipartParameter("menu_description", product.menu_description)
                    .addMultipartParameter("menu_name", product.menu_name)
                    .addMultipartParameter("menu_type", product.menu_type)
                    .addMultipartParameter("milk", String.valueOf(product.milk))
                    .addMultipartParameter("molluscs", String.valueOf(product.molluscs))
                    .addMultipartParameter("mustard", String.valueOf(product.mustard))
                    .addMultipartParameter("popular_dish", product.popular_dish)
                    .addMultipartParameter("price_option", product.price_option)
                    .addMultipartParameter("product_percentage", product.product_percentage)
                    .addMultipartParameter("short_name", product.short_name)
                    .addMultipartParameter("sortorder", product.sortorder)
                    .addMultipartParameter("spicy_dish", product.spicy_dish)
                    .addMultipartParameter("status", product.status)
                    .addMultipartParameter("sulphites", String.valueOf(product.sulphites))
                    .addMultipartParameter("sulphur_dioxide", String.valueOf(product.sulphur_dioxide))
                    .addMultipartParameter("vegan", String.valueOf(product.vegan))
                    .addMultipartParameter("vegetarian", String.valueOf(product.vegetarian))
                    .addMultipartParameter("menu_details", new Gson().toJson(product.menu_details));
            if (product.menu_image != null) {
                anRequest.addMultipartFile("menu_image", product.menu_image);
            } else {
                anRequest.addMultipartParameter("menu_image", "");
            }
            anRequest.build().getAsJSONObject(new JSONObjectRequestListener() {
                @Override
                public void onResponse(JSONObject response) {
                    try {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                fetchProduct();
                                productAdapter.notifyDataSetChanged();
                            });
                            if (action.equalsIgnoreCase("add"))
                                ToastUtils.makeToast(getActivity(), "Product added!!");
                            LogUtils.e("add product responce::" + new Gson().toJson(response));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }

                @Override
                public void onError(ANError anError) {
                    try {
                        anError.printStackTrace();
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                swipeRefreshLayout.setRefreshing(false);
                                CommonFunctions.hideKeyboard(getActivity(), etSearch);
                                LogUtils.e("ERROR IN ADDING OR EDIT PRODUCT::" + new Gson().toJson(anError.getErrorBody()));
                                fetchProduct();
                            });
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                title = getArguments().getString("title");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainSearch = view.findViewById(R.id.llMainSearch);
        llSearch = view.findViewById(R.id.llSearchLayout);
        tvMenu = view.findViewById(R.id.tvMenu);
        ivSearch = view.findViewById(R.id.ivSearch);
        llAdd = view.findViewById(R.id.llAdd);
        etSearch = view.findViewById(R.id.etSearch);
        tvCancel = view.findViewById(R.id.tvCancel);
        rvMenu = view.findViewById(R.id.rvCategories);
        swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
        animationView = view.findViewById(R.id.animation_view);
        llData = view.findViewById(R.id.llRootData);

        try {
            if (!Validators.isNullOrEmpty(title))
                tvMenu.setText(title);
            productAdapter = new CategoryAdapter(filteredList, (position, data) -> {

                if (data instanceof Product) {
                    Product product = (Product) data;
                    openEditProductDialog(product);

                }
            }, new RecyclerViewItemClickListener() {
                @Override
                public void onItemClick(int position, Object data) {
                    Product product = (Product) data;
                    deleteProduct(product.id);
                }
            }, (position, data) -> {
                // call active/inactive api
                callActiveInActiveApi(position, (Product) data);
            });
            menuLayoutManager = new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false);
            rvMenu.setLayoutManager(menuLayoutManager);
            rvMenu.setNestedScrollingEnabled(false);
            rvMenu.setAdapter(productAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    private void callActiveInActiveApi(int position, Product categories) {
        try {
            String enableDisabled = categories.status.equalsIgnoreCase("true") ? "/disable" : "/enable";
            AndroidNetworking.post(ApiEndPoints.products + categories.id + enableDisabled)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Log.e("responseresponse", "callActiveInActiveApi request is " + ApiEndPoints.products + categories.id + enableDisabled + " Response is " + response);
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> fetchProduct());
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openEditProductDialog(Product product) {
        try {
            AddProductBottomSheetFragment fragment = AddProductBottomSheetFragment.getInstance(product);
            fragment.show(getChildFragmentManager(), "add product");
            fragment.setCancelable(false);
            fragment.setDialogDismissListener(o -> {
                MenuDetail product1 = (MenuDetail) o;
                //LogUtils.e("MENU DETAILS::" + new Gson().toJson(product1));
                LogUtils.e("MENU DETAILS::" + new Gson().toJson(product1.orginal_price));
                addOrEditProduct(product1, "edit");
            }, o -> {
                //delete product
                String id = (String) o;
                deleteProduct(id);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteProduct(String id) {
        try {
            AndroidNetworking.delete(ApiEndPoints.products + id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        fetchProduct();
                                    });
                                    ToastUtils.makeToast(getActivity(), "Product Deleted!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<Product> searchCategory() {
        ArrayList<Product> searchedRest = null;
        try {
            if (etSearch.getText().toString().isEmpty()) {
                return products;
            }
            searchedRest = new ArrayList<>();
            for (Product r : products) {
                if (r.menu_name != null && r.menu_name.toLowerCase().contains(etSearch.getText().toString().toLowerCase())) {
                    searchedRest.add(r);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return searchedRest;

    }

}

