package com.tiffintom.partner1.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.HomeActivity;
import com.tiffintom.partner1.activities.RegisterDeviceActivity;
import com.tiffintom.partner1.activities.SplashActivity;
import com.tiffintom.partner1.activities.TransportActivity;
import com.tiffintom.partner1.adapters.MerchantBusinessSelectionAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CardBrandCommission;
import com.tiffintom.partner1.models.CountryCommission;
import com.tiffintom.partner1.models.DeviceRegistration;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Amrish on 07-12-2020.
 */
public class MerchantBusinessSelectionFragment extends BaseFragment {

    public static MerchantBusinessSelectionFragment getInstance() {
        return new MerchantBusinessSelectionFragment();
    }

    public static MerchantBusinessSelectionFragment getInstance(boolean is_from_business_change) {
        MerchantBusinessSelectionFragment merchantBusinessSelectionFragment = new MerchantBusinessSelectionFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("is_from_business_change", is_from_business_change);
        merchantBusinessSelectionFragment.setArguments(bundle);
        return merchantBusinessSelectionFragment;
    }

    private RecyclerView rvBusinesses;
    private MerchantBusinessSelectionAdapter businessAdapter;
    private ArrayList<MerchantBusinesses> merchantBusinesses = new ArrayList<>();
    private MaterialButton btnDone;
    private MerchantBusinesses selectedBusinesse;
    private boolean is_from_business_change;

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_restaurants, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            if (getArguments() != null) {
                is_from_business_change = getArguments().getBoolean("is_from_business_change", false);
            }
            fetchBusinesses();
            rvBusinesses = view.findViewById(R.id.rvRestaurants);
            btnDone = view.findViewById(R.id.btnDone);
            businessAdapter = new MerchantBusinessSelectionAdapter(merchantBusinesses, (position, data) -> {
                if (data instanceof MerchantBusinesses) {
                    btnDone.setEnabled(true);
                    selectedBusinesse = (MerchantBusinesses) data;
                }
            });
            rvBusinesses.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvBusinesses.setAdapter(businessAdapter);
            if (myApp.getMyPreferences().getMerchantBusinesses() != null) {
                selectedBusinesse = myApp.getMyPreferences().getMerchantBusinesses();
                businessAdapter.selectedMerchantBusinessId = selectedBusinesse.id;
                businessAdapter.notifyDataSetChanged();
                btnDone.setEnabled(true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            btnDone.setOnClickListener(view1 -> {
                if (selectedBusinesse == null) {
                    //ToastUtils.makeToast(getActivity(), "Please select restaurant first");
                    ToastUtils.makeToast(getActivity(), "Please select business first");
                } else {
                    myApp.getMyPreferences().saveMerchantBusinesses(selectedBusinesse);
                    myApp.getMyPreferences().saveBusinessId(selectedBusinesse.id);
                    getFcmToken();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchBusinesses() {
        try {
            progressDialog.show();
            AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES)
                    .addQueryParameter("request_for", "admin")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(MerchantBusinesses.class, new ParsedRequestListener<List<MerchantBusinesses>>() {

                        @Override
                        public void onResponse(List<MerchantBusinesses> response) {
                            try {
                                merchantBusinesses.addAll(response);
                                businessAdapter.notifyDataSetChanged();
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getFcmToken() {
        try {
            FirebaseMessaging.getInstance().getToken()
                    .addOnCompleteListener(task -> {
                        if (!task.isSuccessful()) {
                            Log.w("TAG", "Fetching FCM registration token failed", task.getException());
                            Toast.makeText(getActivity(), "Failed to generate FCM token, Please try again later.", Toast.LENGTH_SHORT).show();
                            saveMerchantDeviceId();
                            return;
                        }
                        // Get new FCM registration token
                        String token = task.getResult();

                        if (!token.equalsIgnoreCase("")) {
                            Log.e("Instance", " ; " + token);
                            MyApp.getInstance().getMyPreferences().setUserFCMToken(token);
                            if (!MyApp.getInstance().getMyPreferences().getUserFCMToken().equalsIgnoreCase("")) {
                                saveMerchantDeviceId();
                            }
                        } else {
                            if (is_from_business_change) {
                                saveMerchantDeviceId();
                            }
                            Toast.makeText(getActivity(), "Fcm token not found.", Toast.LENGTH_SHORT).show();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveMerchantDeviceId() {
        try {
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressDialog.show());

            AndroidNetworking.post(ApiEndPoints.MERCHANT_DEVICE_REGISTRATION)
                    .addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addBodyParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addBodyParameter("device_id", (Validators.isNullOrEmpty(myApp.getMyPreferences().getAndroidDeviceId()) ? "" : myApp.getMyPreferences().getAndroidDeviceId()))
                    .addBodyParameter("device_type", "Android")
                    .addBodyParameter("service_type", "Merchant")
                    .addBodyParameter("device_token", myApp.getMyPreferences().getUserFCMToken())
                    .build()
                    .getAsObject(DeviceRegistration.class, new ParsedRequestListener<DeviceRegistration>() {
                        @Override
                        public void onResponse(DeviceRegistration response) {
                            try {
                                if (getActivity() != null)
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());

                                myApp.getMyPreferences().saveDeviceRegistration(response);

                                if (selectedBusinesse.online_service && !Validators.isNullOrEmpty(selectedBusinesse.restaurant_id)) {
                                    fetchRestaurantDetails(selectedBusinesse.restaurant_id);
                                } else {
                                    continueNextScreen();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null)
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                            }
                            if (selectedBusinesse.online_service && !Validators.isNullOrEmpty(selectedBusinesse.restaurant_id)) {
                                fetchRestaurantDetails(selectedBusinesse.restaurant_id);
                            } else {
                                continueNextScreen();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchCountryCommission() {
        try {
            AndroidNetworking.get(ApiEndPoints.businesses + "/" + myApp.getMyPreferences().getBusinessId() + "/card-brand-commissions/")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                progressDialog.dismiss();
                                ArrayList<CardBrandCommission> list = new ArrayList<>();
                                try {
                                    for (int i = 0; i < response.length(); i++) {
                                        JSONObject jsonObject = response.getJSONObject(i);
                                        CardBrandCommission cardBrandCommission = new CardBrandCommission();
                                        cardBrandCommission.id = jsonObject.getInt("id");
                                        cardBrandCommission.card_brand_id = jsonObject.getInt("card_brand_id");
                                        cardBrandCommission.business_id = jsonObject.getInt("business_id");
                                        cardBrandCommission.card_brand_id = jsonObject.getInt("card_brand_id");
                                        cardBrandCommission.stripe_percentage = jsonObject.getInt("stripe_percentage");
                                        cardBrandCommission.stripe_fixed = jsonObject.getInt("stripe_fixed");
                                        cardBrandCommission.other = jsonObject.getBoolean("other");
                                        cardBrandCommission.created_at = jsonObject.getString("created_at");
                                        JSONObject brand = jsonObject.getJSONObject("card_brand");
                                        cardBrandCommission.brand_name = brand.getString("name");
                                        list.add(cardBrandCommission);
                                    }
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                myApp.appDatabase.commissionDao().nukeCardBrandCommission();
                                myApp.appDatabase.commissionDao().insertCardBrands(list);
                                continueNextScreen();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                progressDialog.dismiss();
                                continueNextScreen();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            progressDialog.dismiss();
            continueNextScreen();
        }
    }

    private void fetchCountryBrandCommission() {
        try {
            AndroidNetworking.get(ApiEndPoints.businesses + "/" + myApp.getMyPreferences().getBusinessId() + "/country-commissions/")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                myApp.appDatabase.commissionDao().nukeCountryCommission();
                                ArrayList<CountryCommission> list = new ArrayList<>();
                                try {
                                    for (int i = 0; i < response.length(); i++) {
                                        JSONObject jsonObject = response.getJSONObject(i);
                                        CountryCommission cardBrandCommission = new CountryCommission();
                                        cardBrandCommission.id = jsonObject.getInt("id");
                                        cardBrandCommission.paypal_percentage = jsonObject.getInt("paypal_percentage");
                                        cardBrandCommission.paypal_fixed = jsonObject.getInt("paypal_fixed");
                                        cardBrandCommission.stripe_percentage = jsonObject.getInt("stripe_percentage");
                                        cardBrandCommission.stripe_fixed = jsonObject.getInt("stripe_fixed");
                                        cardBrandCommission.business_id = jsonObject.getInt("business_id");
                                        cardBrandCommission.other = jsonObject.getBoolean("other");
                                        cardBrandCommission.created_at = jsonObject.getString("created_at");
                                        if (!cardBrandCommission.other) {
                                            cardBrandCommission.country_id = jsonObject.getInt("country_id");
                                            JSONObject brand = jsonObject.getJSONObject("country");
                                            cardBrandCommission.name = brand.getString("name");
                                            cardBrandCommission.iso = brand.getString("iso");
                                            cardBrandCommission.currency_code = brand.getString("currency_code");
                                        } else {
                                            cardBrandCommission.country_id = 0;
                                            cardBrandCommission.name = "";
                                            cardBrandCommission.iso = "";
                                            cardBrandCommission.currency_code = "";
                                        }
                                        list.add(cardBrandCommission);
                                    }
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                myApp.appDatabase.commissionDao().insertCountryCommissions(list);
                                fetchCountryCommission();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                fetchCountryCommission();
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            fetchCountryCommission();
            progressDialog.dismiss();
        }
    }

    private void fetchRestaurantDetails(String resId) {
        try {
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressDialog.show());
            AndroidNetworking.get(ApiEndPoints.restaurants + resId)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                myApp.getMyPreferences().saveLoggedInRestaurant(new Gson().fromJson(response.toString(), RestaurantUser.class));
                                myApp.getMyPreferences().saveSiteSettings(myApp.getMyPreferences().getLoggedInRestaurant().site_setting);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            updateRestaurantToken(resId);
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            continueNextScreen();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateRestaurantToken(String resId) {
        try {
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressDialog.show());

            HashMap<String, String> params = new HashMap<>();
            params.put("device_id", myApp.getMyPreferences().getUserFCMToken());
            AndroidNetworking.post(ApiEndPoints.restaurants + resId)
                    .addQueryParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            fetchCountryBrandCommission();
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            progressDialog.dismiss();
                            continueNextScreen();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void continueNextScreen() {
        try {
           /* if (myApp.getMyPreferences().getDeviceRegistration() != null && myApp.getMyPreferences().getDeviceRegistration().status != null && !myApp.getMyPreferences().getDeviceRegistration().status.equalsIgnoreCase("approved")) {
                Intent intent = new Intent(getActivity(), RegisterDeviceActivity.class);
                startActivity(intent);
            } else {*/
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressDialog.dismiss());
            if (is_from_business_change) {
                StripeBluetoothCardReaderPaymentFragment.triggerRebirth(requireContext());
            } else {
                if (myApp.getMyPreferences().getDefaultPrinter() == null) {
                    Intent intent = new Intent(getActivity(), TransportActivity.class).putExtra("destination", "printer_selection");
                    startActivity(intent);
                } else {
                    Intent intent = new Intent(getActivity(), SplashActivity.class);
                    startActivity(intent);
                    if (getActivity() != null)
                        getActivity().finish();
                }
            }
            //}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
