package com.tiffintom.partner1.fragments;

import static com.tiffintom.partner1.utils.Constants.LOGIN_UPDATE;
import static com.tiffintom.partner1.utils.Constants.ROLE_MERCHANT_ADMIN;
import static com.tiffintom.partner1.utils.Constants.ROLE_MERCHANT_SUPERVISOR;
import static com.tiffintom.partner1.utils.Constants.ROLE_MERCHANT_USER;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.formatter.IndexAxisValueFormatter;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.MerchantRecentTransactionsAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.DeviceRegistration;
import com.tiffintom.partner1.models.Header;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.MerchantCardTransaction;
import com.tiffintom.partner1.models.MerchantStatement;
import com.tiffintom.partner1.models.MerchantUserPermission;
import com.tiffintom.partner1.models.TransactionSummary;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Amrish on 21-12-2020.
 */
public class MerchantDashboardFragment extends BaseFragment {
    public static MerchantDashboardFragment getInstance() {
        return new MerchantDashboardFragment();
    }
    private CS20PrintHelper cs20PrintHelper;
    BarChart barMerchantPayments;
    SwipeRefreshLayout swipeRefreshLayout;
    CardView cvPaymentChart, cvRecentPayment;
    ArrayList<Header> monthsHeader = new ArrayList<>();
    ArrayList<MerchantCardTransaction> merchantTransactions = new ArrayList<>();
    RecyclerView rvRecentPayments;
    MerchantRecentTransactionsAdapter recentTransactionsAdapter;
    int merchantRole = myApp.getMyPreferences().getMerchantRole();
    BroadcastReceiver loginUpdateReceiver;
    private LinearLayout llMerchantTransactionsViewAll, llMerchantTransactions, llArchivedTransactions, llPrintReport, llRefundedTransactions, llStatements, llTransactions, llRecentPaymentsChart;
    private MerchantBusinesses selectedBusiness = myApp.getMyPreferences().getMerchantBusinesses();
    private SunmiPrinter sunmiPrinter;
    private ZoneRichPrinter zoneRichPrinter;
    private BluetoothPrinter bluetoothPrinter;
    private LinearLayout llMainLayout;
    private MaterialButtonToggleGroup btnRangeToggle;
    private String toDateString, fromDateString;
    ArrayList<MerchantStatement> statements = new ArrayList<>();
    private MerchantUserPermission permission;
    private TextView tvError;
    private MaterialButton btnRefresh;

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (!Validators.isNullOrEmpty(myApp.getMyPreferences().getPrinterIP())) {
                zoneRichPrinter = new ZoneRichPrinter(getActivity());
            }
            if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper = new CS20PrintHelper();
            }
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            cvPaymentChart = view.findViewById(R.id.cvPaymentChart);
            cvRecentPayment = view.findViewById(R.id.cvRecentPayments);
            llMainLayout = view.findViewById(R.id.llMainLayout);
            llMerchantTransactionsViewAll = view.findViewById(R.id.llMerchantTransactionsViewAll);
            llMerchantTransactions = view.findViewById(R.id.llMerchantTransactions);
            llArchivedTransactions = view.findViewById(R.id.llArchives);
            llRefundedTransactions = view.findViewById(R.id.llRefundTransactions);
            llPrintReport = view.findViewById(R.id.llPrintReport);
            llStatements = view.findViewById(R.id.llMerchantStatement);
            btnRangeToggle = view.findViewById(R.id.btnRangeGroup);
            tvError = view.findViewById(R.id.tvErrorMessage);
            btnRefresh = view.findViewById(R.id.btnRefresh);

            barMerchantPayments = view.findViewById(R.id.barMerchantPayments);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            rvRecentPayments = view.findViewById(R.id.rvRecentTransactions);

            rvRecentPayments.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            recentTransactionsAdapter = new MerchantRecentTransactionsAdapter(getActivity(), merchantTransactions, (view1, position, data) -> {

            });
            rvRecentPayments.setAdapter(recentTransactionsAdapter);
            initBarChart();
            setVisibilities();

            Calendar calendar = Calendar.getInstance();
            calendar.set(Calendar.DAY_OF_MONTH, 1);
            fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

            calendar = Calendar.getInstance();
            calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
            toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setVisibilities() {
        try {
            merchantRole = myApp.getMyPreferences().getMerchantRole();
            if (merchantRole == 1) {
                permission = selectedBusiness.supervisor_permissions;
            } else if (merchantRole == 2) {
                permission = selectedBusiness.admin_permissions;
            } else {
                permission = null;
            }

            if (permission != null && permission.statement) {
                llStatements.setVisibility(View.VISIBLE);
            } else {
                llStatements.setVisibility(View.GONE);
            }

            if (myApp.getMyPreferences().getChartPermission(merchantRole)) {
                cvPaymentChart.setVisibility(View.VISIBLE);
            } else {
                cvPaymentChart.setVisibility(View.GONE);
            }
            if (myApp.getMyPreferences().getMerchantTransactionPermission(merchantRole)) {
                llMerchantTransactions.setVisibility(View.VISIBLE);
                cvRecentPayment.setVisibility(View.VISIBLE);
            } else {
                llMerchantTransactions.setVisibility(View.GONE);
                cvRecentPayment.setVisibility(View.GONE);
            }
            if (myApp.getMyPreferences().getPrintReportPermission(merchantRole)) {
                llPrintReport.setVisibility(View.VISIBLE);
            } else {
                llPrintReport.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initBarChart() {
        try {
            barMerchantPayments.setDrawValueAboveBar(true);
            barMerchantPayments.setFitBars(false);
            barMerchantPayments.setDescription(null);
            barMerchantPayments.getLegend().setEnabled(false);

            barMerchantPayments.getAxisLeft().setDrawLabels(false);
            barMerchantPayments.getAxisLeft().setDrawGridLines(false);
            barMerchantPayments.getAxisLeft().setDrawAxisLine(false);

            barMerchantPayments.getAxisRight().setDrawLabels(false);
            barMerchantPayments.getAxisRight().setDrawGridLines(false);
            barMerchantPayments.getAxisRight().setDrawAxisLine(false);

            barMerchantPayments.getXAxis().setDrawAxisLine(false);
            barMerchantPayments.getXAxis().setDrawGridLines(false);
            barMerchantPayments.getXAxis().setGranularity(1);
            barMerchantPayments.getXAxis().setPosition(XAxis.XAxisPosition.BOTTOM);
            barMerchantPayments.setDoubleTapToZoomEnabled(false);
            barMerchantPayments.setDoubleTapToZoomEnabled(false);
            barMerchantPayments.setPinchZoom(false);
            barMerchantPayments.setScaleEnabled(false);
            barMerchantPayments.getLegend().setTextSize(18);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_dashboard, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            updateDeviceStatusUI();
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateDeviceStatusUI() {
        try {
            AndroidNetworking.get(ApiEndPoints.devices).addPathParameter("business_id",myApp.getMyPreferences().getBusinessId())
                    .addPathParameter("device_id",myApp.getMyPreferences().getAndroidDeviceId())
                    .build()
                    .getAsObject(DeviceRegistration.class, new ParsedRequestListener<DeviceRegistration>() {
                        @Override
                        public void onResponse(DeviceRegistration response) {
                            try {
                                myApp.getMyPreferences().saveDeviceRegistration(response);
                                if (!Validators.isNullOrEmpty(response.status)&&!response.status.equalsIgnoreCase("approved")) {
                                    tvError.setText("Your device " + myApp.getMyPreferences().getAndroidDeviceId() + " is not approved yet, Please contact service provider to activate");
                                    tvError.setVisibility(View.VISIBLE);
                                    btnRefresh.setVisibility(View.VISIBLE);
                                    swipeRefreshLayout.setVisibility(View.GONE);
                                } else {
                                    tvError.setVisibility(View.GONE);
                                    btnRefresh.setVisibility(View.GONE);
                                    swipeRefreshLayout.setVisibility(View.VISIBLE);
                                    updatePermissionViews();
                                    setListeners();
                                    new Thread(() -> {
                                        fetchMerchantTransactions();
                                    }).start();
                                    fetchStatements();
                                    LocalBroadcastManager.getInstance(getActivity()).registerReceiver(loginUpdateReceiver, new IntentFilter(LOGIN_UPDATE));
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (myApp.getMyPreferences().getDeviceRegistration() != null && myApp.getMyPreferences().getDeviceRegistration().status != null && !myApp.getMyPreferences().getDeviceRegistration().status.equalsIgnoreCase("approved")) {
                                    tvError.setText("Your device " + myApp.getMyPreferences().getAndroidDeviceId() + " is not approved yet, Please contact service provider to activate");
                                    tvError.setVisibility(View.VISIBLE);
                                    btnRefresh.setVisibility(View.VISIBLE);
                                    swipeRefreshLayout.setVisibility(View.GONE);
                                } else {
                                    tvError.setVisibility(View.GONE);
                                    btnRefresh.setVisibility(View.GONE);
                                    swipeRefreshLayout.setVisibility(View.VISIBLE);
                                    updatePermissionViews();
                                    setListeners();
                                    new Thread(() -> {
                                        fetchMerchantTransactions();
                                    }).start();
                                    fetchStatements();
                                    LocalBroadcastManager.getInstance(getActivity()).registerReceiver(loginUpdateReceiver, new IntentFilter(LOGIN_UPDATE));
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }



    private void setListeners() {
        try {
            swipeRefreshLayout.setOnRefreshListener(() -> {
                new Thread(this::fetchMerchantTransactions).start();
            });
            btnRefresh.setOnClickListener(v -> {
                updateDeviceStatusUI();
            });
            loginUpdateReceiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context context, Intent intent) {
                    if (intent.getBooleanExtra("refresh", false)) {
                        merchantRole = myApp.getMyPreferences().getMerchantRole();
                        updatePermissionViews();
                    }
                }
            };
            llMerchantTransactions.setOnClickListener(view1 -> {
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MerchantPaymentTransactionsFragment.getInstance(false, false), "Merchant Transactions");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });

            llStatements.setOnClickListener(v -> {
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, PaymentStatementsFragment.getInstance(), "Statments");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });

            llMerchantTransactionsViewAll.setOnClickListener(view1 -> {
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MerchantPaymentTransactionsFragment.getInstance(false, false), "Merchant Transactions");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });
            llRefundedTransactions.setOnClickListener(v -> {
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MerchantPaymentTransactionsFragment.getInstance(false, true), "Refund Transactions");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });

            llArchivedTransactions.setOnClickListener(v -> {
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MerchantPaymentTransactionsFragment.getInstance(true, false), "Archives");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });

            llPrintReport.setOnClickListener(view -> {
                showPrintReportOptionsDialog();
            });

            btnRangeToggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
                if (isChecked) {

                    if (checkedId == R.id.btnThisMonth) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(Calendar.DAY_OF_MONTH, 1);
                        fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

                        calendar = Calendar.getInstance();
                        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                        toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
                        fetchStatements();

                    } else if (checkedId == R.id.btnLastMonth) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(Calendar.DAY_OF_MONTH, 1);
                        calendar.add(Calendar.MONTH, -1);
                        fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

                        calendar = Calendar.getInstance();
                        calendar.add(Calendar.MONTH, -1);
                        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                        toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
                        fetchStatements();
                    } else if (checkedId == R.id.btnThisYear) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(Calendar.DAY_OF_MONTH, 1);
                        calendar.set(Calendar.MONTH, 0);
                        fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

                        calendar = Calendar.getInstance();
                        calendar.set(Calendar.DAY_OF_YEAR, calendar.getActualMaximum(Calendar.DAY_OF_YEAR));
                        toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
                        fetchStatements();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchMerchantTransactions() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                });
            }
            ANRequest.GetRequestBuilder anBuilder = AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES_TRANSACTIONS);
            anBuilder.addPathParameter("business_id", myApp.getMyPreferences().getBusinessId());
            anBuilder.build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }

                                monthsHeader.clear();
                                merchantTransactions.clear();
                                try {
                                    Type type = new TypeToken<List<MerchantCardTransaction>>() {
                                    }.getType();
                                    merchantTransactions.addAll(new Gson().fromJson(response.getJSONArray("data").toString(), type));
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                recentTransactionsAdapter.notifyDataSetChanged();
                                if (merchantTransactions.size() == 0) {
                                    ToastUtils.makeToast(getActivity(), "Transactions not found");
                                }
                            } catch (JsonSyntaxException e) {
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchStatements() {
        try {
            AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES_STATEMENT)
                    .addQueryParameter("from_date", fromDateString)
                    .addQueryParameter("to_date", toDateString)
                    .addQueryParameter("nopaginate", "1")
                    .addPathParameter("business_id", selectedBusiness.id)
                    .build()
                    .getAsObjectList(MerchantStatement.class, new ParsedRequestListener<List<MerchantStatement>>() {
                        @Override
                        public void onResponse(List<MerchantStatement> response) {
                            try {
                                statements.clear();
                                statements.addAll(response);
                                updateChart();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    statements.clear();
                                    updateChart();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateChart() {
        try {
            float total = 0;

            LinkedHashMap<String, ArrayList<MerchantStatement>> listLinkedHashMap = new LinkedHashMap<>();
            for (MerchantStatement statement : statements) {
                total = total + statement.net_total;
                ArrayList<MerchantStatement> merchantStatements = new ArrayList<>();
                if (!listLinkedHashMap.containsKey(statement.to_date)) {
                    for (MerchantStatement sub_statement : statements) {
                        if (statement.to_date.equalsIgnoreCase(sub_statement.to_date)) {
                            merchantStatements.add(sub_statement);
                        }
                    }
                    listLinkedHashMap.put(statement.to_date, merchantStatements);
                }
            }
            ArrayList<MerchantStatement> merchantStatementsModified = new ArrayList<>();
            for (Map.Entry<String, ArrayList<MerchantStatement>> entry : listLinkedHashMap.entrySet()) {
                MerchantStatement merchantStatement = new MerchantStatement();
                merchantStatement.to_date = entry.getKey();
                for (MerchantStatement statement : entry.getValue()) {
                    merchantStatement.net_total = statement.net_total + merchantStatement.net_total;
                }
                merchantStatementsModified.add(merchantStatement);
            }

            List<BarEntry> barEntries = new ArrayList<>();
            int count = 0;
            ArrayList<String> xValues = new ArrayList<String>();
            Collections.reverse(merchantStatementsModified);
            for (MerchantStatement merchantStatement : merchantStatementsModified) {
                barEntries.add(new BarEntry(count, merchantStatement.net_total));
                xValues.add(CommonFunctions.formatUnknownDateTime(merchantStatement.to_date, "yyyy-MM-dd", "dd/MM/yy"));
                count++;
            }

            BarDataSet barDataSet = new BarDataSet(barEntries, "Dates");
            if (getActivity() != null)
                barDataSet.setColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
            barDataSet.setValueFormatter(new ValueFormatter() {
                @Override
                public String getFormattedValue(float value) {
                    return (value == 0) ? "" : MyApp.getInstance().currencySymbol + value;
                }
            });
            barDataSet.setValueTextSize(16);
            BarData barData = new BarData(barDataSet);
            barData.setBarWidth(0.9f);
            barMerchantPayments.setData(barData);
            barMerchantPayments.getLegend().setTextSize(18f);
            barMerchantPayments.setExtraBottomOffset(5);
            XAxis xAxis = barMerchantPayments.getXAxis();
            xAxis.setTextSize(14f);
            xAxis.setValueFormatter(new IndexAxisValueFormatter(xValues));
            barMerchantPayments.invalidate();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void updatePermissionViews() {
        try {
            merchantRole = myApp.getMyPreferences().getMerchantRole();
            if (merchantRole == 1) {
                permission = selectedBusiness.supervisor_permissions;
            } else if (merchantRole == 2) {
                permission = selectedBusiness.admin_permissions;
            } else {
                permission = null;
            }

            if (myApp.getMyPreferences().getChartPermission(merchantRole)) {
                cvPaymentChart.setVisibility(View.VISIBLE);
            } else {
                cvPaymentChart.setVisibility(View.GONE);
            }

            if (myApp.getMyPreferences().getPrintReportPermission(merchantRole)) {
                llPrintReport.setVisibility(View.VISIBLE);
            } else {
                llPrintReport.setVisibility(View.GONE);
            }

            if (merchantRole == ROLE_MERCHANT_USER) {
                llArchivedTransactions.setVisibility(View.GONE);
                llRefundedTransactions.setVisibility(View.GONE);
                llStatements.setVisibility(View.GONE);
            }
            if (merchantRole == ROLE_MERCHANT_SUPERVISOR) {
    //                if (supervisorDetails.supervisor_payworks.equalsIgnoreCase("no")) {
    //                    llCardReaderPayment.setVisibility(View.GONE);
    //                } else llCardReaderPayment.setVisibility(View.VISIBLE);
                llMerchantTransactions.setVisibility(View.VISIBLE);

                if (!selectedBusiness.supervisor_permissions.archive_list) {
                    llArchivedTransactions.setVisibility(View.GONE);
                } else llArchivedTransactions.setVisibility(View.VISIBLE);

                if (!selectedBusiness.supervisor_permissions.refund_list) {
                    llRefundedTransactions.setVisibility(View.GONE);
                } else llRefundedTransactions.setVisibility(View.VISIBLE);

                if (!selectedBusiness.supervisor_permissions.statement) {
                    llStatements.setVisibility(View.GONE);
                } else {
                    llStatements.setVisibility(View.VISIBLE);
                }
                if (selectedBusiness.supervisor_permissions.recent_list) {
                    cvRecentPayment.setVisibility(View.VISIBLE);
                } else {
                    cvRecentPayment.setVisibility(View.GONE);
                }
            }
            if (merchantRole == ROLE_MERCHANT_ADMIN) {
                llMerchantTransactions.setVisibility(View.VISIBLE);
                llPrintReport.setVisibility(View.VISIBLE);
                cvPaymentChart.setVisibility(View.VISIBLE);

                if (!selectedBusiness.admin_permissions.archive_list) {
                    llArchivedTransactions.setVisibility(View.GONE);
                } else llArchivedTransactions.setVisibility(View.VISIBLE);

                if (!selectedBusiness.admin_permissions.refund_list) {
                    llRefundedTransactions.setVisibility(View.GONE);
                } else llRefundedTransactions.setVisibility(View.VISIBLE);


                if (selectedBusiness.admin_permissions.recent_list) {
                    cvRecentPayment.setVisibility(View.VISIBLE);
                } else {
                    cvRecentPayment.setVisibility(View.GONE);
                }
                if (!selectedBusiness.admin_permissions.statement) {
                    llStatements.setVisibility(View.GONE);
                } else {
                    llStatements.setVisibility(View.VISIBLE);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showPrintReportOptionsDialog() {
        PrintReportOptionsDialogFragment printReportOptionsDialogFragment = PrintReportOptionsDialogFragment.getInstance();
        printReportOptionsDialogFragment.show(getChildFragmentManager(), "options");
        printReportOptionsDialogFragment.setDialogDismissListener(o -> {
            if (o instanceof TransactionSummary) {
                performPrint((TransactionSummary) o);
            }
        });
    }

    private void performPrint(TransactionSummary transactionSummary) {
        try {
            String footer_a = selectedBusiness.footer_a;
            String footer_b = selectedBusiness.footer_b;
            String header_a = selectedBusiness.header_a;
            String header_b = selectedBusiness.header_b;

            if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                    myApp.iMinPrinterUtils.printMerchantPaymentReport(transactionSummary, myApp.merchantLogo, header_a, header_b, footer_a, footer_b);
                }else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                    cs20PrintHelper.printMerchantPaymentReport(transactionSummary, myApp.merchantLogo, header_a, header_b, footer_a, footer_b);
                } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                    if (zoneRichPrinter == null) {
                        CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
                    } else {
                        zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                        zoneRichPrinter.printMerchantPaymentReport(transactionSummary, myApp.merchantLogo, header_a, header_b, footer_a, footer_b);
                    }
                } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                    try {
                        if (bluetoothPrinter != null) {
                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                            if (device != null) {
                                CommonFunctions.functionThatDelay(200);
                                bluetoothPrinter.printMerchantPaymentReport(transactionSummary, myApp.merchantLogo, header_a, header_b, footer_a, footer_b);
                            } else {
                               // ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "No bluetooth device found.");
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        sunmiPrinter.printMerchantPaymentReport(transactionSummary, myApp.merchantLogo, header_a, header_b, footer_a, footer_b);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStop() {
        LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(loginUpdateReceiver);
        super.onStop();
    }
}
