package com.tiffintom.partner1.fragments;

import static com.tiffintom.partner1.utils.Constants.DAY_BEFORE_YESTERDAY_CLICKED;
import static com.tiffintom.partner1.utils.Constants.LOGIN_UPDATE;
import static com.tiffintom.partner1.utils.Constants.TODAY_CLICKED;
import static com.tiffintom.partner1.utils.Constants.YESTERDAY_CLICKED;
import static com.tiffintom.partner1.utils.Constants._2_DAY_BEFORE_YESTERDAY_CLICKED;

import android.app.DatePickerDialog;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Paint;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.MerchantTransactionsAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.Header;
import com.tiffintom.partner1.models.MerchantBusinessesAllTransaction;
import com.tiffintom.partner1.models.MerchantCardTransaction;
import com.tiffintom.partner1.models.MerchantExpandableModal;
import com.tiffintom.partner1.models.MerchantOrderTransaction;
import com.tiffintom.partner1.models.MerchantPaypalTransaction;
import com.tiffintom.partner1.models.MerchantUserPermission;
import com.tiffintom.partner1.models.SiteSetting;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MerchantPaymentTransactionsFragment extends BaseFragment {

    private ArrayList<Object> transactions = new ArrayList<>();
    private ArrayList<Header> rawHeaders = new ArrayList<>();
    private ArrayList<MerchantExpandableModal> expandableModals = new ArrayList<>();
    private ArrayList<Object> expandableModalsForPagingCompare = new ArrayList<>();
    private ExpandableListView rvTransactions;
    private boolean isLoading = false;
    private MerchantTransactionsAdapter merchantTransactionsAdapter;
    private List<Header> _listDataHeader = new ArrayList<>(); // header titles
    // child data in format of header title, child title
    private HashMap<Header, List<MerchantCardTransaction>> _listDataChild = new HashMap<>();

    private CardView cvCalender;
    private SwipeRefreshLayout swipeRefreshLayout;
    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private Calendar today = Calendar.getInstance();
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private TextView tvToDate, tvFromDate, tvSelectTransactions, tvErrorMessage;
    private RelativeLayout llFromDate, llToDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private ArrayList<String> checkedStripeIds = new ArrayList<>();
    private ArrayList<String> checkedPaypalIds = new ArrayList<>();
    private ArrayList<String> checkedOrderIds = new ArrayList<>();
    private LinearLayout llArchiveActions;
    private TextView tvSelectedTransactions, tvMonth, tvTotal;
    private MaterialButton btnCancel, btnArchive, btnDayBeforeYesterday, btnYesterday, btnToday, btn2DayBeforeYesterday;
    private TextView tvTitle;
    private boolean archivedTransactions = false, refundedTransactions = false;
    private int lastCheckedPosition = -1;
    private ImageView ivBack, ivExpand;
    private ZoneRichPrinter zoneRichPrinter;
    private CS20PrintHelper cs20PrintHelper;
    private BluetoothPrinter bluetoothPrinter;
    private SunmiPrinter sunmiPrinter;
    private int merchantRole = myApp.getMyPreferences().getMerchantRole();
    private LinearLayout llMainLayout;
    private MerchantUserPermission permission;
    private SiteSetting headerAlignmentSetting;
    private int headerAlignment = 0;
    private int currentPage = 1, limit = 100;

    public static MerchantPaymentTransactionsFragment getInstance(boolean archivedTransactions, boolean refunded) {
        MerchantPaymentTransactionsFragment fragment = new MerchantPaymentTransactionsFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("archived", archivedTransactions);
        bundle.putBoolean("refunded", refunded);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_transactions, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            //updateViews();
            setListeners();
            //getData();
            loadMoreListener();
            setBtnDate();
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(loginUpdateReceiver, new IntentFilter(LOGIN_UPDATE));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMoreListener() {
        rvTransactions.setOnScrollListener(new AbsListView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(AbsListView absListView, int i) {

            }

            @Override
            public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (!isLoading && totalItemCount > 0) {
                    Log.e("firstVisibleItem", "firstVisibleItem " + firstVisibleItem + " visibleItemCount " + visibleItemCount + " totalItemCount " + totalItemCount + " isLoading " + isLoading);
                    int lastInScreen = firstVisibleItem + visibleItemCount;
                    if (lastInScreen == totalItemCount) {
                        //bottom of list!
                        currentPage++;
                        isLoading = true;
                        fetchTransactions();
                    }
                }
            }
        });
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                archivedTransactions = getArguments().getBoolean("archived");
                refundedTransactions = getArguments().getBoolean("refunded");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            sunmiPrinter = new SunmiPrinter(getActivity());
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            if (!Validators.isNullOrEmpty(myApp.getMyPreferences().getPrinterIP())) {
                zoneRichPrinter = new ZoneRichPrinter(getActivity());
            }
            if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper = new CS20PrintHelper();
            }
            if (merchantRole == 2) {
                permission = merchantBusiness.admin_permissions;
            } else if (merchantRole == 1) {
                permission = merchantBusiness.supervisor_permissions;
            } else {
                permission = null;
            }
            llMainLayout = view.findViewById(R.id.llMainLayout);
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);
            tvTitle = view.findViewById(R.id.tvTitle);
            tvSelectTransactions = view.findViewById(R.id.tvSelectTransactions);
            tvSelectedTransactions = view.findViewById(R.id.tvSelectedTransactions);
            tvTotal = view.findViewById(R.id.tvTotal);
            tvMonth = view.findViewById(R.id.tvMonth);
            llArchiveActions = view.findViewById(R.id.llArchiveAction);
            btnArchive = view.findViewById(R.id.btnArchive);
            btnDayBeforeYesterday = view.findViewById(R.id.btnDayBeforeYesterday);
            btn2DayBeforeYesterday = view.findViewById(R.id.btn2DayBeforeYesterday);
            btnYesterday = view.findViewById(R.id.btnYesterday);
            btnToday = view.findViewById(R.id.btnToday);
            btnCancel = view.findViewById(R.id.btnCancel);

            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            cvCalender = view.findViewById(R.id.cvCalender);
            ivBack = view.findViewById(R.id.ivBack);
            ivExpand = view.findViewById(R.id.ivExpand);
            ivExpand.setVisibility(View.GONE);
            rvTransactions = view.findViewById(R.id.rvTransactions);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            setMerchantTransactionAdapter();

            if (archivedTransactions) {
                btnArchive.setText("Unarchive");
                tvTitle.setText("Archived Transactions");
            }

            cvCalender.setVisibility(View.GONE);
            llArchiveActions.setVisibility(View.GONE);
            tvSelectTransactions.setEnabled(false);
            if (refundedTransactions) {
                tvSelectTransactions.setVisibility(View.GONE);
            }
            if (archivedTransactions) {
                tvTitle.setText("Archived Transactions");
                btnArchive.setText("Unarchive");
            }
            if (refundedTransactions) {
                tvTitle.setText("Refunded Transactions");
            }
            tvSelectTransactions.setPaintFlags(tvSelectTransactions.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    int lastCheckedGroupPosition = -1, lastCheckedChildPosition = -1;

    private void setMerchantTransactionAdapter() {
        try {
            merchantTransactionsAdapter = new MerchantTransactionsAdapter(myApp.getMyPreferences().getDefaultPrinter(),getActivity(), expandableModals, (groupPosition, childPosition, data) -> {
                if (data instanceof MerchantCardTransaction) {
                    MerchantCardTransaction merchantTransaction = (MerchantCardTransaction) merchantTransactionsAdapter.getChild(groupPosition, childPosition);
                    if (merchantTransaction.checked) {
                        if (!checkedStripeIds.contains(merchantTransaction.id)) {
                            if (archivedTransactions || refundedTransactions) {
                                if (lastCheckedGroupPosition != -1) {
                                    Object checkableObject = expandableModals.get(lastCheckedGroupPosition).merchantTransactions.get(lastCheckedChildPosition);
                                    if (checkableObject instanceof MerchantCardTransaction) {
                                        ((MerchantCardTransaction) checkableObject).checked = false;
                                    }

                                }

                                checkedStripeIds.clear();
                                if (lastCheckedChildPosition != -1) {
                                    merchantTransaction.checked = true;

                                }
                            }
                            checkedStripeIds.add(merchantTransaction.id);
                        }
                        lastCheckedChildPosition = childPosition;
                        lastCheckedGroupPosition = groupPosition;
                    } else {
                        lastCheckedChildPosition = -1;
                        lastCheckedGroupPosition = -1;
                        checkedStripeIds.remove(merchantTransaction.id);
                    }
                }
                if (data instanceof MerchantPaypalTransaction) {
                    MerchantPaypalTransaction merchantTransaction = (MerchantPaypalTransaction) merchantTransactionsAdapter.getChild(groupPosition, childPosition);
                    if (merchantTransaction.checked) {
                        if (!checkedPaypalIds.contains(merchantTransaction.id)) {
                            if (archivedTransactions || refundedTransactions) {
                                if (lastCheckedGroupPosition != -1) {
                                    Object checkableObject = expandableModals.get(lastCheckedGroupPosition).merchantTransactions.get(lastCheckedChildPosition);

                                    if (checkableObject instanceof MerchantPaypalTransaction) {
                                        ((MerchantPaypalTransaction) checkableObject).checked = false;
                                    }
                                }
                                checkedPaypalIds.clear();
                                if (lastCheckedChildPosition != -1) {
                                    merchantTransaction.checked = true;

                                }
                            }
                            checkedPaypalIds.add(merchantTransaction.id);
                        }
                        lastCheckedChildPosition = childPosition;
                        lastCheckedGroupPosition = groupPosition;
                    } else {
                        lastCheckedChildPosition = -1;
                        lastCheckedGroupPosition = -1;
                        checkedPaypalIds.remove(merchantTransaction.id);
                    }

                }
                if (data instanceof MerchantOrderTransaction) {
                    MerchantOrderTransaction merchantTransaction = (MerchantOrderTransaction) merchantTransactionsAdapter.getChild(groupPosition, childPosition);
                    if (merchantTransaction.checked) {
                        if (!checkedOrderIds.contains(merchantTransaction.id)) {
                            if (archivedTransactions || refundedTransactions) {
                                if (lastCheckedGroupPosition != -1) {
                                    Object checkableObject = expandableModals.get(lastCheckedGroupPosition).merchantTransactions.get(lastCheckedChildPosition);

                                    if (checkableObject instanceof MerchantOrderTransaction) {
                                        ((MerchantOrderTransaction) checkableObject).checked = false;
                                    }
                                }
                                checkedOrderIds.clear();
                                if (lastCheckedChildPosition != -1) {
                                    merchantTransaction.checked = true;

                                }
                            }
                            checkedOrderIds.add(merchantTransaction.id);
                        }
                        lastCheckedChildPosition = childPosition;
                        lastCheckedGroupPosition = groupPosition;
                    } else {
                        lastCheckedChildPosition = -1;
                        lastCheckedGroupPosition = -1;
                        checkedOrderIds.remove(merchantTransaction.id);
                    }

                }
                if ((checkedStripeIds.size() + checkedPaypalIds.size() + checkedOrderIds.size()) > 0) {
                    llArchiveActions.setVisibility(View.VISIBLE);
                    if ((checkedStripeIds.size() + checkedPaypalIds.size() + checkedOrderIds.size()) == 1)
                        if (archivedTransactions) {
                            tvSelectedTransactions.setText("Are you sure you want unarchive?");
                        } else if (refundedTransactions) {
                            tvSelectedTransactions.setText("Are you sure you want refund?");
                        } else
                            tvSelectedTransactions.setText((checkedStripeIds.size() + checkedPaypalIds.size() + checkedOrderIds.size()) + " transaction selected");
                    else
                        tvSelectedTransactions.setText((checkedStripeIds.size() + checkedPaypalIds.size() + checkedOrderIds.size()) + " transaction selected");
                } else {
                    llArchiveActions.setVisibility(View.GONE);
                }
                merchantTransactionsAdapter.notifyDataSetChanged();
            }, (groupPosition, childPosition, data) -> {
                //Refund click
                if (data instanceof MerchantCardTransaction) {
                    MerchantCardTransaction merchantTransaction = (MerchantCardTransaction) merchantTransactionsAdapter.getChild(groupPosition, childPosition);
                    openRefundAmountDialog(merchantTransaction);
                }
                if (data instanceof MerchantPaypalTransaction) {
                    openRefundAmountDialog((MerchantPaypalTransaction) data);
                }
            }, (groupPosition, childPosition, data) -> {
                // print click
                if (data instanceof MerchantCardTransaction) {
                    MerchantCardTransaction merchantTransaction = (MerchantCardTransaction) merchantTransactionsAdapter.getChild(groupPosition, childPosition);
                    printTransaction("Merchant Copy", merchantTransaction, getString(R.string.re_print));
                }
            }, (groupPosition, childPosition, data) -> {
                // send receipt
                if (data instanceof MerchantCardTransaction) {
                    SendReceiptFragment sendReceiptFragment = SendReceiptFragment.getInstance((MerchantCardTransaction) data);
                    sendReceiptFragment.show(requireActivity().getSupportFragmentManager(), "send_receipt");
                }
            });
            rvTransactions.setAdapter(merchantTransactionsAdapter);
            if (permission != null && permission.refund) {
                merchantTransactionsAdapter.canRefund = !refundedTransactions;
                merchantTransactionsAdapter.notifyDataSetChanged();
            } else {
                merchantTransactionsAdapter.canRefund = false;
            }
            rvTransactions.setOnGroupClickListener((parent, v, groupPosition, id) -> {
                // This way the expander cannot be collapsed
                return true;
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openRefundAmountDialog(MerchantCardTransaction merchantTransaction) {
        try {
            EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(MyApp.df.format(merchantTransaction.amount / 100), "Enter amount you want to refund");
            enterAmountDialogFragment.show(getActivity().getSupportFragmentManager(), "enter_amount");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    String amount = (String) o;
                    EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("", "Please enter password", "Please enter to refund transaction.");
                    enterPasswordDialogFragment.show(getActivity().getSupportFragmentManager(), "password");
                    enterPasswordDialogFragment.setDialogDismissListener(obj -> {
                        if (obj instanceof String) {
                            String password = (String) obj;
                            refundTransaction(merchantTransaction, Float.parseFloat(amount), password);
                        }
                    });


                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openRefundAmountDialog(MerchantPaypalTransaction paypalTransaction) {
        try {
            EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(MyApp.df.format(paypalTransaction.transaction_amount), "Enter amount you want to refund");
            enterAmountDialogFragment.show(getActivity().getSupportFragmentManager(), "enter_amount");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    String amount = (String) o;
                    EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("", "Please enter password", "Please enter to refund transaction.");
                    enterPasswordDialogFragment.show(getActivity().getSupportFragmentManager(), "password");
                    enterPasswordDialogFragment.setDialogDismissListener(obj -> {
                        if (obj instanceof String) {
                            String password = (String) obj;
                            refundTransaction(paypalTransaction, Float.parseFloat(amount), password);
                        }
                    });
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBtnDate() {
        try {
            String fromDate;
            Calendar cal = Calendar.getInstance();
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM");
            btnToday.setText(fromDate);

            cal = Calendar.getInstance();
            cal.add(Calendar.DAY_OF_MONTH, -1);
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM");
            btnYesterday.setText(fromDate);

            cal = Calendar.getInstance();
            cal.add(Calendar.DAY_OF_MONTH, -2);
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM");
            btnDayBeforeYesterday.setText(fromDate);

            cal = Calendar.getInstance();
            cal.add(Calendar.DAY_OF_MONTH, -3);
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM");
            btn2DayBeforeYesterday.setText(fromDate);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");
            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            swipeRefreshLayout.setOnRefreshListener(this::getData);
            llFromDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                    fromDay = d;
                    fromMonth = m;
                    fromYear = y;
                    fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    fromCalendar.set(y, m, d);
                    tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                    fetchTransactions();
                }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                if (!Validators.isNullOrEmpty(toDate)) {
                    datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
                }

            });
            llToDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                    toDay = d;
                    toMonth = m;
                    toYear = y;
                    toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    toCalendar.set(y, m, d);
                    tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                    fetchTransactions();
                }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                if (!Validators.isNullOrEmpty(fromDate)) {
                    datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
                }

            });
            tvSelectTransactions.setOnClickListener(view -> {
                merchantTransactionsAdapter.showCheck = !merchantTransactionsAdapter.showCheck;
                merchantTransactionsAdapter.notifyDataSetChanged();
                if (merchantTransactionsAdapter.showCheck) {
                    tvSelectTransactions.setText("Cancel");
                } else {
                    tvSelectTransactions.setText("Select");
                    unSelectAll();
                }
            });
            btnCancel.setOnClickListener(view -> {
                tvSelectTransactions.performClick();
            });

            btnArchive.setOnClickListener(view -> {
                {
                    archiveUnArchiveTransactions();
                }
            });
            btnToday.setOnClickListener(view -> setButtonTintForButton(TODAY_CLICKED));
            btnYesterday.setOnClickListener(view -> setButtonTintForButton(YESTERDAY_CLICKED));
            btnDayBeforeYesterday.setOnClickListener(view -> setButtonTintForButton(DAY_BEFORE_YESTERDAY_CLICKED));
            btn2DayBeforeYesterday.setOnClickListener(view -> setButtonTintForButton(_2_DAY_BEFORE_YESTERDAY_CLICKED));
            ivBack.setOnClickListener(v -> getActivity().onBackPressed());
            // perform today click for call api for today
            btnToday.performClick();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setButtonTintForButton(String isFromButton) {
        if (Objects.equals(isFromButton, TODAY_CLICKED)) {
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.green));
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
        } else if (Objects.equals(isFromButton, YESTERDAY_CLICKED)) {
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.green));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
            fromCalendar.add(Calendar.DAY_OF_MONTH, -1);
            toCalendar.add(Calendar.DAY_OF_MONTH, -1);
        } else if (Objects.equals(isFromButton, _2_DAY_BEFORE_YESTERDAY_CLICKED)) {
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.green));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
            fromCalendar.add(Calendar.DAY_OF_MONTH, -3);
            toCalendar.add(Calendar.DAY_OF_MONTH, -3);
        } else {
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.green));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
            fromCalendar.add(Calendar.DAY_OF_MONTH, -2);
            toCalendar.add(Calendar.DAY_OF_MONTH, -2);
        }
        expandableModals.clear();
        merchantTransactionsAdapter.notifyDataSetChanged();
        updateViews();
        currentPage = 1;
        tvMonth.setVisibility(View.GONE);
        tvTotal.setVisibility(View.GONE);
        fetchTransactions();
    }

    private void refundTransaction(MerchantCardTransaction merchantTransaction, float amount, String password) {
        try {
            progressDialog.show();
            AndroidNetworking.post(ApiEndPoints.MERCHANT_REFUND_TRANSACTIONS)
                    .addBodyParameter("amount", String.valueOf(amount))
                    .addBodyParameter("password", password)
                    .addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addPathParameter("id", merchantTransaction.id)
                    .build()
                    .getAsObject(MerchantCardTransaction.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            try {
                                if (response != null) {
                                    merchantTransaction.reporting_category = "refund";
                                    merchantTransaction.amount = amount * 100;
                                    ToastUtils.makeLongToast(getActivity(), "Transaction refunded successfully");
                                    progressDialog.dismiss();
                                    fetchTransactions();
                                    printTransaction("Merchant Copy", merchantTransaction, "");
                                } else {
                                    refundResponseDialog("Payment could not refund");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeLongToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refundTransaction(MerchantPaypalTransaction merchantTransaction, float amount, String password) {
        try {
            progressDialog.show();
            AndroidNetworking.post(ApiEndPoints.MERCHANT_REFUND_PAYPAL_TRANSACTIONS)
                    .addBodyParameter("amount", String.valueOf(amount))
                    .addBodyParameter("password", password)
                    .addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addPathParameter("id", merchantTransaction.id)
                    .build()
                    .getAsObject(MerchantCardTransaction.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            try {
                                if (response != null) {
                                    merchantTransaction.sale_state = "refunded";
                                    merchantTransaction.transaction_amount = amount;
                                    ToastUtils.makeLongToast(getActivity(), "Transaction refunded successfully");
                                    progressDialog.dismiss();
                                    fetchTransactions();
                                } else {
                                    refundResponseDialog("Payment could not refund");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeLongToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refundResponseDialog(String message) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                    builder.setTitle(message);
                    builder.setPositiveButton("OK", (dialogInterface, i) -> {
                        dialogInterface.dismiss();
                    });
                    builder.show();
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unSelectAll() {
        try {
            for (Object object : transactions) {
                if (object instanceof MerchantCardTransaction) {
                    ((MerchantCardTransaction) object).checked = false;
                }
                if (object instanceof MerchantPaypalTransaction) {
                    ((MerchantPaypalTransaction) object).checked = false;
                }
                if (object instanceof MerchantOrderTransaction) {
                    ((MerchantOrderTransaction) object).checked = false;
                }
            }
            checkedStripeIds.clear();
            checkedOrderIds.clear();
            checkedPaypalIds.clear();
            tvSelectedTransactions.setText("0 transactions selected");
            merchantTransactionsAdapter.notifyDataSetChanged();
            llArchiveActions.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void getData() {
        currentPage = 1;
        new Thread(this::fetchTransactions).start();
    }

    private HashMap<String, String> generateTransactionParams() {
        HashMap<String, String> params = new HashMap<>();
        params.put("from_date", fromDate);
        params.put("to_date", toDate);
        //params.put("nopaginate", "1");
        params.put("page", String.valueOf(currentPage));
        params.put("per_page", String.valueOf(limit));
        if (archivedTransactions) {
            params.put("filter", "archived");
        }
        if (refundedTransactions) {
            params.put("filter", "refunded");
        }
        return params;
    }

    private void fetchTransactions() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                    tvErrorMessage.setVisibility(View.GONE);
                });
            }

            ANRequest.GetRequestBuilder anBuilder = AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES_ALL_TRANSACTIONS);
            anBuilder.addPathParameter("business_id", myApp.getMyPreferences().getBusinessId());
            anBuilder.addQueryParameter(generateTransactionParams());
            anBuilder.build()
                    .getAsObject(MerchantBusinessesAllTransaction.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            try {
                                MerchantBusinessesAllTransaction allTransaction = (MerchantBusinessesAllTransaction) response;
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }

                                ArrayList<Object> objectArrayList = new ArrayList<>();
                                objectArrayList.addAll(allTransaction.card_transactions.card_transactions);
                                //objectArrayList.addAll(allTransaction.paypal_transactions.paypal_transactions);
                                objectArrayList.addAll(allTransaction.order_transactions.order_transactions);

                                Collections.sort(objectArrayList, (o1, o2) -> {
                                    Long d1 = 0L;
                                    Long d2 = 0L;
                                    if (o1 instanceof MerchantCardTransaction) {
                                        d1 = CommonFunctions.convertStringDateToDate(((MerchantCardTransaction) o1).transaction_date_time, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }
                                    if (o2 instanceof MerchantCardTransaction) {
                                        d2 = CommonFunctions.convertStringDateToDate(((MerchantCardTransaction) o2).transaction_date_time, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }

                                    if (o1 instanceof MerchantOrderTransaction) {
                                        d1 = CommonFunctions.convertStringDateToDate(((MerchantOrderTransaction) o1).order_date, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }
                                    if (o2 instanceof MerchantOrderTransaction) {
                                        d2 = CommonFunctions.convertStringDateToDate(((MerchantOrderTransaction) o2).order_date, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }

                                    if (o1 instanceof MerchantPaypalTransaction) {
                                        d1 = CommonFunctions.convertStringDateToDate(((MerchantPaypalTransaction) o1).sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'").getTime();
                                    }
                                    if (o2 instanceof MerchantPaypalTransaction) {
                                        d2 = CommonFunctions.convertStringDateToDate(((MerchantPaypalTransaction) o2).sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'").getTime();
                                    }
                                    return d2.compareTo(d1);
                                });

                                if (currentPage == 1) {
                                    expandableModalsForPagingCompare.clear();
                                    rawHeaders.clear();
                                    expandableModals.clear();
                                    checkedStripeIds.clear();
                                }
                                LinkedHashMap<String, ArrayList<Object>> datesHeader = new LinkedHashMap<>();
                                for (Object transaction : objectArrayList) {
                                    String dateKey = "";
                                    if (transaction instanceof MerchantCardTransaction) {
                                        MerchantCardTransaction txn = (MerchantCardTransaction) transaction;
                                        dateKey = CommonFunctions.formatMiliToDesireFormat(Long.parseLong(txn.created + "000"), "dd MMM yyyy");
                                        if (!Validators.isNullOrEmpty(txn.transaction_date_time))
                                            dateKey = CommonFunctions.formatUnknownDateTime(txn.transaction_date_time, MyApp.PHP_TIMEFORMAT, "dd MMM yyyy");
                                    }
                                    if (transaction instanceof MerchantPaypalTransaction) {
                                        MerchantPaypalTransaction txn = (MerchantPaypalTransaction) transaction;
                                        dateKey = CommonFunctions.formatUnknownDateTime(txn.sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'", "dd MMM yyyy");
                                    }
                                    if (transaction instanceof MerchantOrderTransaction) {
                                        MerchantOrderTransaction txn = (MerchantOrderTransaction) transaction;
                                        dateKey = CommonFunctions.formatUnknownDateTime(txn.order_date, "yyyy-MM-dd HH:mm:ss", "dd MMM yyyy");
                                    }

                                    ArrayList<Object> datedTransactions = new ArrayList<>();
                                    if (!datesHeader.containsKey(dateKey)) {
                                        for (Object sub_transaction : objectArrayList) {
                                            if (sub_transaction instanceof MerchantCardTransaction) {
                                                MerchantCardTransaction businessesTransaction = (MerchantCardTransaction) sub_transaction;
                                                String subDateKey = CommonFunctions.formatMiliToDesireFormat(Long.parseLong(businessesTransaction.created + "000"), "dd MMM yyyy");
                                                if (!Validators.isNullOrEmpty(businessesTransaction.transaction_date_time))
                                                    subDateKey = CommonFunctions.formatUnknownDateTime(businessesTransaction.transaction_date_time, MyApp.PHP_TIMEFORMAT, "dd MMM yyyy");
                                                if (dateKey.equalsIgnoreCase(subDateKey)) {
                                                    datedTransactions.add(businessesTransaction);
                                                }

                                            }
                                            if (sub_transaction instanceof MerchantPaypalTransaction) {
                                                MerchantPaypalTransaction paypalTransaction = (MerchantPaypalTransaction) sub_transaction;
                                                String subDateKey = CommonFunctions.formatUnknownDateTime(paypalTransaction.sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'", "dd MMM yyyy");
                                                if (dateKey.equalsIgnoreCase(subDateKey)) {
                                                    datedTransactions.add(paypalTransaction);
                                                }
                                            }
                                            if (sub_transaction instanceof MerchantOrderTransaction) {
                                                MerchantOrderTransaction orderTransaction = (MerchantOrderTransaction) sub_transaction;
                                                String subDateKey = CommonFunctions.formatUnknownDateTime(orderTransaction.order_date, "yyyy-MM-dd HH:mm:ss", "dd MMM yyyy");
                                                if (dateKey.equalsIgnoreCase(subDateKey)) {
                                                    datedTransactions.add(orderTransaction);
                                                }
                                            }
                                        }
                                        datesHeader.put(dateKey, datedTransactions);
                                    }
                                }
                                for (Map.Entry<String, ArrayList<Object>> entry : datesHeader.entrySet()) {
                                    float total = 0;
                                    /*for (Object tran : entry.getValue()) {
                                        if (tran instanceof MerchantCardTransaction) {
                                            MerchantCardTransaction txn = (MerchantCardTransaction) tran;
                                            if (refundedTransactions) {
                                                total = (txn.amount * -1) / 100 + total;
                                            } else {
                                                total = txn.amount / 100 + total;
                                            }
                                        }
                                        if (tran instanceof MerchantPaypalTransaction) {
                                            MerchantPaypalTransaction txn = (MerchantPaypalTransaction) tran;
                                            total = txn.transaction_amount + total;
                                        }
                                        if (tran instanceof MerchantOrderTransaction) {
                                            MerchantOrderTransaction txn = (MerchantOrderTransaction) tran;
                                            if (txn.calculated_fees != null) {
                                                total = (-1 * txn.calculated_fees.total_fee) + total;
                                            } else {
                                                total = txn.grand_total + total;
                                            }
                                        }
                                    }*/
                                    Header header = new Header(entry.getKey(), MyApp.df.format(total));
                                    tvMonth.setText(header.title);
                                    tvTotal.setText(allTransaction.total_amount);
                                    if (currentPage == 1 || expandableModals.size() == 0) {
                                        expandableModals.add(new MerchantExpandableModal(header.title, header.total, entry.getValue()));
                                        expandableModalsForPagingCompare.addAll(entry.getValue());
                                    } else {
                                        expandableModals.get(0).title = header.title;
                                        expandableModals.get(0).total = MyApp.df.format(Float.parseFloat(expandableModals.get(0).total) + total);
                                        expandableModals.get(0).merchantTransactions.addAll(entry.getValue());
                                        expandableModalsForPagingCompare.addAll(entry.getValue());
                                    }
                                }

                                if (expandableModalsForPagingCompare.size() != 0) {
                                    tvMonth.setVisibility(View.VISIBLE);
                                    tvTotal.setVisibility(View.VISIBLE);
                                } else {
                                    tvMonth.setVisibility(View.GONE);
                                    tvTotal.setVisibility(View.GONE);
                                }

                                tvSelectTransactions.setEnabled(true);
                                llArchiveActions.setVisibility(View.GONE);
                                if (refundedTransactions) {
                                    isLoading = (!Validators.isNullOrEmpty(allTransaction.card_transactions.total) && (expandableModalsForPagingCompare.size() == (Integer.parseInt(allTransaction.card_transactions.total))));
                                } else {
                                    isLoading = (!Validators.isNullOrEmpty(allTransaction.card_transactions.total) && !Validators.isNullOrEmpty(allTransaction.order_transactions.total)
                                            && (expandableModalsForPagingCompare.size() == (Integer.parseInt(allTransaction.card_transactions.total) + Integer.parseInt(allTransaction.order_transactions.total))));
                                }
                                merchantTransactionsAdapter.notifyDataSetChanged();
                                int count = merchantTransactionsAdapter.getGroupCount();
                                for (int i = 0; i < count; i++) {
                                    rvTransactions.expandGroup(i);
                                }
                                if (permission != null && permission.archive && expandableModals.size() > 0)
                                    tvSelectTransactions.setVisibility(View.VISIBLE);
                                else tvSelectTransactions.setVisibility(View.GONE);
                            } catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                isLoading = false;
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }

                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void archiveUnArchiveTransactions() {
        try {
            String url = ApiEndPoints.MERCHANT_BUSINESS_ALL_TRANSACTIONS_ARCHIVE;
            if (archivedTransactions) {
                url = ApiEndPoints.MERCHANT_BUSINESS_ALL_TRANSACTIONS_UNARCHIVE;
            }
            progressDialog.show();
            AndroidNetworking.post(url)
                    .addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addBodyParameter("stripe_ids", new Gson().toJson(checkedStripeIds))
                    .addBodyParameter("paypal_ids", new Gson().toJson(checkedPaypalIds))
                    .addBodyParameter("order_ids", new Gson().toJson(checkedOrderIds))
                    .build()
                    .getAsString(new StringRequestListener() {
                        @Override
                        public void onResponse(String response) {
                            progressDialog.dismiss();
                            unSelectAll();
                            fetchTransactions();
                            ToastUtils.makeSnackToast(getActivity(), archivedTransactions ? "Transactions unarchived" : "Transactions archived");
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ToastUtils.makeSnackToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printTransaction(String title, MerchantCardTransaction merchantTransaction, String rePrintTitle) {

        try {
            String headerA = "", headerB = "", resAddress = "";
            if (merchantBusiness != null) {
                headerA = merchantBusiness.header_a;
                headerB = merchantBusiness.header_b;
            }

            String actualAmount = "£" + MyApp.df.format(merchantTransaction.amount / 100);

            String card = "Card                 " + merchantTransaction.card_brand;
            String account = "Account      " + merchantTransaction.card_number;
            String stripe_id = "TID  " + merchantTransaction.source;
            String status = "Status            " + (merchantTransaction.reporting_category.equalsIgnoreCase("charge") ? "Approved" : "Refund");
            String please = "Please Retain Receipt\nFor Your Record";

            String date_final = (CommonFunctions.formatMiliToDesireFormat(Long.parseLong(merchantTransaction.created + "000"), "dd/MM/yyyy hh:mm a"));
            if (!Validators.isNullOrEmpty(merchantTransaction.transaction_date_time))
                date_final = CommonFunctions.formatUnknownDateTime(merchantTransaction.transaction_date_time, MyApp.PHP_TIMEFORMAT, "dd/MM/yyyy hh:mm a");

            String main_content = card + "\n" + account + "\n" + stripe_id + "\n" + status + "\n";

            String footer = merchantBusiness.footer_a;
            String footer1 = merchantBusiness.footer_b;
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().equalsIgnoreCase("mobile")) {
                LogUtils.e("PRINT SKIPPED");
                return;
            }
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                myApp.iMinPrinterUtils.printCardReaderReceipt(myApp.merchantLogo, rePrintTitle, title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
            } else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper.printCardReaderReceipt(myApp.merchantLogo, rePrintTitle, title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                if (zoneRichPrinter == null) {
                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
                } else {
                    zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                    zoneRichPrinter.printCardReaderReceipt(myApp.merchantLogo, rePrintTitle, title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
                }
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                try {
                    if (bluetoothPrinter != null) {
                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                        if (device != null) {
                            CommonFunctions.functionThatDelay(200);
                            bluetoothPrinter.printCardReaderReceipt(myApp.merchantLogo, rePrintTitle, title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
                        } else {
                            ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                sunmiPrinter.printCardReaderReceipt(myApp.merchantLogo, rePrintTitle, title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
            }
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = ConfirmationDialogFragment.getInstance("Print", "Is customer copy required?", false);
                confirmationDialogFragment.setCancelable(false);
                confirmationDialogFragment.show(getChildFragmentManager(), "action");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm") && getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                printTransaction("Customer Copy", merchantTransaction, rePrintTitle);
                            });
                        }
                    }
                });
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void printTransaction(String title, MerchantPaypalTransaction merchantTransaction) {

        String headerA = "", headerB = "", resAddress = "";
        if (merchantBusiness != null) {
            headerA = merchantBusiness.header_a;
            headerB = merchantBusiness.header_b;
        }

        String actualAmount = "£" + MyApp.df.format(merchantTransaction.transaction_amount);


        String account = "Account      " + merchantTransaction.email;
        String stripe_id = "TID  " + merchantTransaction.payment_id;
        String status = "Status            " + (merchantTransaction.sale_state.equalsIgnoreCase("completed") ? "Completed" : "Refund");
        String please = "Please Retain Receipt\nFor Your Record";

        String date_final = CommonFunctions.formatUnknownDateTime(merchantTransaction.sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'", "dd/MM/yyyy hh:mm a");

        String main_content = account + "\n" + stripe_id + "\n" + status + "\n";

        String footer = merchantBusiness.footer_a;
        String footer1 = merchantBusiness.footer_b;
        if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().equalsIgnoreCase("mobile")) {
            LogUtils.e("PRINT SKIPPED");
            return;
        }
        if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
            if (zoneRichPrinter == null) {
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
            } else {
                zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                zoneRichPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
            }
        } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
            try {
                if (bluetoothPrinter != null) {
                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                    if (device != null) {
                        CommonFunctions.functionThatDelay(200);
                        bluetoothPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
                    } else {
                        ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            sunmiPrinter.printCardReaderReceipt(myApp.merchantLogo, "", title, headerA, headerB, resAddress, actualAmount, null, actualAmount, main_content, please, date_final, footer, footer1);
        }
        if (title.toLowerCase().contains("merchant")) {
            ConfirmationDialogFragment confirmationDialogFragment = ConfirmationDialogFragment.getInstance("Print", "Is customer copy required?", false);
            confirmationDialogFragment.setCancelable(false);
            confirmationDialogFragment.show(getChildFragmentManager(), "action");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("confirm") && getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            printTransaction("Customer Copy", merchantTransaction);
                        });
                    }
                }
            });
        }
    }

    @Override
    public void onStop() {
        LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(loginUpdateReceiver);
        super.onStop();
    }

    BroadcastReceiver loginUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    merchantRole = myApp.getMyPreferences().getMerchantRole();
                    merchantTransactionsAdapter.notifyDataSetChanged();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
}
