package com.tiffintom.partner1.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.SplashActivity;
import com.tiffintom.partner1.adapters.MerchantPrinterAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;

/**
 * Created by Amrish on 07-12-2020.
 */
public class MerchantPrintersFragment extends BaseFragment {

    public static MerchantPrintersFragment getInstance() {
        return new MerchantPrintersFragment();
    }

    private RecyclerView rvPrinters;
    private MerchantPrinterAdapter printersAdapter;
    private ArrayList<String> merchantPrinters = new ArrayList<>();
    private MaterialButton btnDone;
    private String restaurantsIntent;
    private String selectedPrinter;

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_printers, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            merchantPrinters.addAll(myApp.getPrinters());
            if (myApp.getMyPreferences().getDefaultPrinter() != null) {
                selectedPrinter = myApp.getMyPreferences().getDefaultPrinter();
            }
            rvPrinters = view.findViewById(R.id.rvRestaurants);
            btnDone = view.findViewById(R.id.btnDone);
            printersAdapter = new MerchantPrinterAdapter(merchantPrinters, (position, data) -> {
                if (data instanceof String) {
                    btnDone.setEnabled(true);
                    selectedPrinter = (String) data;
                }
            });
            rvPrinters.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvPrinters.setAdapter(printersAdapter);
            printersAdapter.selectedMerchantPrinter = selectedPrinter;
            printersAdapter.notifyDataSetChanged();

            if (!Validators.isNullOrEmpty(selectedPrinter))
                btnDone.setEnabled(true);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            btnDone.setOnClickListener(view1 -> {
                if (selectedPrinter == null) {
                    ToastUtils.makeToast(getActivity(), "Please select printer first");
                } else {
                    if (selectedPrinter.toLowerCase().contains("ip printer")) {
                        EnterIPDialogFragment enterIPDialogFragment = EnterIPDialogFragment.getInstance();
                        enterIPDialogFragment.show(getChildFragmentManager(), "enter_ip");
                        enterIPDialogFragment.setDialogDismissListener(o -> {
                            if (o == null) {
                                ToastUtils.makeToast(getActivity(), "Please enter IP address of your IP printer");
                            } else {
                                myApp.getMyPreferences().saveDefaultPrinter(selectedPrinter);
                                startActivity(new Intent(getActivity(), SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                            }
                        });
                    } else {
                        myApp.getMyPreferences().saveDefaultPrinter(selectedPrinter);
                        startActivity(new Intent(getActivity(), SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
