package com.tiffintom.partner1.fragments;

import static com.tiffintom.partner1.utils.Constants.ROLE_MERCHANT_SUPERVISOR;
import static com.tiffintom.partner1.utils.Constants.ROLE_MERCHANT_USER;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.utils.LogUtils;

public class MerchantSettingsFragment extends BaseFragment {

    private SwitchCompat switchChartUser, switchChartSupervisor, switchTransactionsSupervisor, switchTransactionsUser, switchPrintReportSupervisor, switchPrintReportUser, switchOnlineOrderUser;
    private MaterialButton btnUpdate;
    private ImageView ivBack;
    private LinearLayout llMainLayout, llOnlineOrder;


    public static MerchantSettingsFragment getInstance() {
        return new MerchantSettingsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_settings, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
        setListeners();
    }

    private void updateViews() {
        switchChartSupervisor.setChecked(myApp.getMyPreferences().getChartPermission(ROLE_MERCHANT_SUPERVISOR));
        switchChartUser.setChecked(myApp.getMyPreferences().getChartPermission(ROLE_MERCHANT_USER));

        switchPrintReportSupervisor.setChecked(myApp.getMyPreferences().getPrintReportPermission(ROLE_MERCHANT_SUPERVISOR));
        switchPrintReportUser.setChecked(myApp.getMyPreferences().getPrintReportPermission(ROLE_MERCHANT_USER));

        switchTransactionsSupervisor.setChecked(myApp.getMyPreferences().getMerchantTransactionPermission(ROLE_MERCHANT_SUPERVISOR));
        switchTransactionsUser.setChecked(myApp.getMyPreferences().getMerchantTransactionPermission(ROLE_MERCHANT_USER));

    }

    private void setListeners() {
        switchChartUser.setOnCheckedChangeListener((compoundButton, b) -> {

        });
        switchChartSupervisor.setOnCheckedChangeListener((compoundButton, b) -> {

        });
        switchOnlineOrderUser.setOnCheckedChangeListener(checkedChangeListener);
        btnUpdate.setOnClickListener(view -> {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Settings saved");
            myApp.getMyPreferences().saveChartPermission(ROLE_MERCHANT_SUPERVISOR, switchChartSupervisor.isChecked());
            myApp.getMyPreferences().saveChartPermission(ROLE_MERCHANT_USER, switchChartUser.isChecked());

            myApp.getMyPreferences().saveMerchantTransactionPermission(ROLE_MERCHANT_SUPERVISOR, switchTransactionsSupervisor.isChecked());
            myApp.getMyPreferences().saveMerchantTransactionPermission(ROLE_MERCHANT_USER, switchTransactionsUser.isChecked());

            myApp.getMyPreferences().savePrintReportPermission(ROLE_MERCHANT_SUPERVISOR, switchPrintReportSupervisor.isChecked());
            myApp.getMyPreferences().savePrintReportPermission(ROLE_MERCHANT_USER, switchPrintReportUser.isChecked());

            if (switchOnlineOrderUser.isChecked()) {
                myApp.getMyPreferences().saveOnlineOrderStatusAndEnable(true);
            } else {
                myApp.getMyPreferences().saveOnlineOrderStatusAndEnable(false);
            }

            LogUtils.e("online order::::::::::::::" + myApp.getMyPreferences().isOnlineOrderEnable());
        });


    }

    CompoundButton.OnCheckedChangeListener checkedChangeListener = (compoundButton, b) -> {
        try {
            myApp.getMyPreferences().saveAdminChangesForOnline(true);

          /*  EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("online_order", b ? "Yes" : "No");
            enterPasswordDialogFragment.show(getChildFragmentManager(), "enter_password");
            enterPasswordDialogFragment.setCancelable(false);
            enterPasswordDialogFragment.setDialogDismissListener(changeOrderAcceptingStatusDialogListener);*/
        } catch (Exception e) {
            e.printStackTrace();
        }
    };

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        switchChartUser = view.findViewById(R.id.switchChartUser);
        switchChartSupervisor = view.findViewById(R.id.switchChartSupervisor);
        switchTransactionsSupervisor = view.findViewById(R.id.switchTransactionsSupervisor);
        switchTransactionsUser = view.findViewById(R.id.switchTransactionsUser);
        switchPrintReportSupervisor = view.findViewById(R.id.switchReportPrintSupervisor);
        switchPrintReportUser = view.findViewById(R.id.switchReportPrintUser);
        switchOnlineOrderUser = view.findViewById(R.id.switchOnlineOrderUser);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        llOnlineOrder = view.findViewById(R.id.llOnlineOrder);

        if (myApp.getMyPreferences().getMerchantBusinesses().online_service) {
            llOnlineOrder.setVisibility(View.VISIBLE);
        } else {
            llOnlineOrder.setVisibility(View.GONE);
        }
        if (myApp.getMyPreferences().isOnlineOrderEnable()) {
            switchOnlineOrderUser.setChecked(true);
            myApp.getMyPreferences().saveOnlineOrderStatusAndEnable(true);
        } else {
            switchOnlineOrderUser.setChecked(false);
            myApp.getMyPreferences().saveOnlineOrderStatusAndEnable(false);
        }
    }

}
