package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.tabs.TabLayout;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.ViewpagerAdapter;
import com.tiffintom.partner1.base.BaseFragment;

/**
 * Created by Amrish on 20-01-2021.
 */
public class MotoAndPaymentLinkTabFragment extends BaseFragment {
    public static MotoAndPaymentLinkTabFragment getInstance() {
        return new MotoAndPaymentLinkTabFragment();
    }

    TabLayout tabLayout;
    ViewPager viewPager;
    ViewpagerAdapter viewpagerAdapter;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_moto_payment_links_tabs, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        tabLayout = view.findViewById(R.id.tabLayout);
        viewPager = view.findViewById(R.id.viewPager);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        viewpagerAdapter = new ViewpagerAdapter(getChildFragmentManager(), FragmentPagerAdapter.BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
        viewpagerAdapter.addFragment(PaymentLinkFragment.getInstance(), "Pay by link");
        viewpagerAdapter.addFragment(MotoPaymentFragment.getInstance(), "Moto");
        if(merchantBusiness.qr_permission){
            viewpagerAdapter.addFragment(new QRCodeFragment(), "QR");
        }
        viewPager.setAdapter(viewpagerAdapter);
        tabLayout.setupWithViewPager(viewPager);

    }
}
