package com.tiffintom.partner1.fragments;

import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.Stripe;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.StripeIntent;
import com.tiffintom.partner1.BuildConfig;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.NoInternetActivity;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.ccwatchers.CreditCardEditText;
import com.tiffintom.partner1.common.ccwatchers.OtherCardTextWatcher;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CardBrandCommission;
import com.tiffintom.partner1.models.CountryCommission;
import com.tiffintom.partner1.models.MerchantUserPermission;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;


public class MotoPaymentFragment extends BaseFragment {
    private boolean isFromTheme2 = false;
    private EditText etExpDate, etCvv, etAmount, etAddress, etTip, etPostalCode;
    private CreditCardEditText etCardNumber;
    private MaterialButton btnPay, btnCancel;
    private Stripe stripe;
    private SunmiPrinter sunmiPrinter;
    private ZoneRichPrinter zoneRichPrinter;
    private CS20PrintHelper cs20PrintHelper;
    private BluetoothPrinter bluetoothPrinter;
    private float totalAmount;
    private LinearLayout llMainLayout, llTip;
    private ImageView ivBack;
    final long MIN_CLICK_INTERVAL = 25000; //in millis
    long lastClickTime = 0;
    String stripe_private_key, stripe_public_key, stripe_mode;
    private MerchantUserPermission permission;
    int merchantRole = 0;
    private int headerAlignment = 0;
    private boolean isApiError = false;

    public static MotoPaymentFragment getInstance() {
        return new MotoPaymentFragment();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        try {
            merchantRole = myApp.getMyPreferences().getMerchantRole();
            //stripe_mode = merchantBusiness.stripe_mode;
            stripe_mode = ApiEndPoints.ubsidiBuild ? "live" : "test";
            //if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(merchantBusiness.connect_stripe_public_key)) {
            if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                //stripe_private_key = merchantBusiness.connect_stripe_private_key;
                stripe_private_key = BuildConfig.connect_stripe_private_key;
                // stripe_public_key = merchantBusiness.connect_stripe_public_key;
                stripe_public_key = BuildConfig.connect_stripe_public_key;
            } else {
                if (stripe_mode.equalsIgnoreCase("live")) {
                    //  stripe_private_key = merchantBusiness.stripe_private_key_live;
                    stripe_private_key = BuildConfig.stripe_private_key_live;
                    //stripe_public_key = merchantBusiness.stripe_public_key_live;
                    stripe_public_key = BuildConfig.stripe_public_key_live;
                } else {
                    //stripe_private_key = merchantBusiness.stripe_private_key_test;
                    stripe_private_key = BuildConfig.stripe_private_key_test;
                    //stripe_public_key = merchantBusiness.stripe_public_key_test;
                    stripe_public_key = BuildConfig.stripe_public_key_test;
                }
            }
            PaymentConfiguration.init(getActivity(), stripe_public_key);
            stripe = new Stripe(getActivity(), stripe_public_key);
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (!Validators.isNullOrEmpty(myApp.getMyPreferences().getPrinterIP())) {
                zoneRichPrinter = new ZoneRichPrinter(getActivity());
            }
            if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper = new CS20PrintHelper();
            }
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            llMainLayout = view.findViewById(R.id.llMainLayout);
            etExpDate = view.findViewById(R.id.etExpDate);
            etAmount = view.findViewById(R.id.etAmount);
            etAddress = view.findViewById(R.id.etAddress);
            etCardNumber = view.findViewById(R.id.etCardNumber);
            etCvv = view.findViewById(R.id.etCvv);
            btnPay = view.findViewById(R.id.btnPay);
            btnCancel = view.findViewById(R.id.btnCancel);
            ivBack = view.findViewById(R.id.ivBack);
            llTip = view.findViewById(R.id.llTip);
            etTip = view.findViewById(R.id.etTip);
            etPostalCode = view.findViewById(R.id.etPostalCode);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_moto_payment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    private void setListeners() {
        try {
            ivBack.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    getActivity().onBackPressed();
                }
            });
            etExpDate.addTextChangedListener(new TextWatcher() {
                int previousLength = 0;
                String previousText = "";

                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    previousLength = etExpDate.getText().toString().length();
                    previousText = charSequence.toString();
                }

                @Override
                public void onTextChanged(CharSequence charSequence, int start, int before, int i2) {
                    String current = charSequence.toString();
                    if (charSequence.length() == 1) {
                        int n = Integer.parseInt(current);
                        if (n > 1) {
                            etExpDate.setText("0" + current + "/");
                            etExpDate.setSelection(current.length() + 2);
                        } else {
                            if (current.length() == 2 && start == 1) {
                                etExpDate.setText(current + "/");
                                etExpDate.setSelection(current.length() + 1);
                            } else if (current.length() == 2 && before == 1) {
                                current = current.substring(0, 1);
                                etExpDate.setText(current);
                                etExpDate.setSelection(current.length());
                            }
                        }
                    } else {
                        if (charSequence.length() == 2) {
                            int n = Integer.parseInt(current);
                            if (n > 12) {
                                etExpDate.setText(previousText);
                                etExpDate.setSelection(etExpDate.getText().toString().length());
                                return;
                            }
                        }
                        if (current.length() == 2 && start == 1) {
                            etExpDate.setText(current + "/");
                            etExpDate.setSelection(current.length() + 1);
                        } else if (current.length() == 2 && before == 1) {
                            current = current.substring(0, 1);
                            etExpDate.setText(current);
                            etExpDate.setSelection(current.length());
                        }
                    }
                    if (etExpDate.getText().toString().length() == 5) {
                        etCvv.requestFocus();
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });
            etCardNumber.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    if (etCardNumber.getText().toString().length() == 19) {
                        etExpDate.requestFocus();
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });
            etCvv.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    if (etCvv.getText().toString().length() == 3) {
                        etAmount.requestFocus();
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });
            etCardNumber.addTextChangedListener(new OtherCardTextWatcher(etCardNumber, null));
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            isFromTheme2 = false;
            if(getArguments()!=null && getArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT)!=null){
                isFromTheme2 = true;
                etAmount.setText(getArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT));
                etCardNumber.requestFocus();
                CommonFunctions.openKeyboard(requireActivity(),etCardNumber);
            }
            etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
            btnPay.setOnClickListener(view -> {
                if (isValid()) {
                    if (!CommonFunctions.isConnected(getActivity())) {
                        Intent i = new Intent(getActivity(), NoInternetActivity.class);
                        getActivity().startActivity(i);
                        return;
                    }
                    long currentTime = SystemClock.elapsedRealtime();
                    /*if (currentTime - lastClickTime > MIN_CLICK_INTERVAL) {
                        lastClickTime = currentTime;
                        createStripeCall();
                    } else {
                        LogUtils.e("Button blocked");
                    }*/
                    if (btnPay.isEnabled()) {
                        btnPay.setEnabled(false);
                        createStripeCall();
                    }
                }
            });
            btnCancel.setOnClickListener(view -> {
                if (getActivity() != null) {
                    getActivity().onBackPressed();
                }
            });

            if (merchantBusiness.connect_service && merchantBusiness.tip) {
                llTip.setVisibility(View.VISIBLE);
            } else {
                llTip.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    CardParams cardParams;

    private boolean isValid() {
        if (Validators.isNullOrEmpty(etCardNumber.getText().toString())) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please enter card number");
            return false;
        }

        if (Validators.isNullOrEmpty(etExpDate.getText().toString())) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please enter card expiry");
            return false;
        }
        if (Validators.isNullOrEmpty(etCvv.getText().toString())) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please enter card cvv");
            return false;
        }
        if (Validators.isNullOrEmpty(etAmount.getText().toString())) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please enter amount");
            return false;
        }
        String exp = etExpDate.getText().toString();
        String[] data = exp.split("/");
        if (!isNumberChar(data[0])) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Invalid expiry month");
            return false;
        }
        if (data.length == 1) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please enter expiry year");
            return false;
        }
        if (data.length > 1 && !isNumberChar(data[1])) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Invalid expiry year");
            return false;
        }
        if (Validators.isNullOrEmpty(etCvv.getText().toString())) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please enter card cvv");
            return false;
        }
        if (Validators.isNullOrEmpty(etPostalCode.getText().toString())) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please enter postal code");
            return false;
        }
        String address = "";
        if (!Validators.isNullOrEmpty(etAddress.getText().toString())) {
            address = etAddress.getText().toString();
        }
        Address addressPostalCode = new Address.Builder()
                .setPostalCode(etPostalCode.getText().toString())
                .build();
        cardParams = new CardParams(etCardNumber.getText().toString().replace(" ", ""), Integer.parseInt(data[0]), Integer.parseInt(data[1]), etCvv.getText().toString(), "", addressPostalCode, "gbp");

        return true;
    }

    private boolean isNumberChar(String string) {
        return string.matches(".*\\d.*");
    }

    String paymentMethodId;

    private void createStripeCall() {
        try {
            PaymentMethodCreateParams params = PaymentMethodCreateParams.createCard(cardParams);
            if (params == null) {
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Invalid Details");
                return;
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressDialog.show();
                    if (llTip.getVisibility() == View.VISIBLE) {
                        totalAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                        if (!Validators.isNullOrEmpty(etTip.getText().toString()) && Float.parseFloat(etTip.getText().toString().replace(",", "")) >= 0) {
                            totalAmount = totalAmount + Float.parseFloat(etTip.getText().toString().replace(",", ""));
                        }
                    } else {
                        totalAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                    }

                });
            }
            // Configure the SDK with your Stripe publishable key so that it can make requests to the Stripe API
            if (merchantBusiness.s_account_id != null && merchantBusiness.connect_service) {
                createPaymentMethod(params);
            } else {
                createCardToken(cardParams);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPaymentMethod(PaymentMethodCreateParams params) {
        try {
            stripe.createPaymentMethod(params, new ApiResultCallback<PaymentMethod>() {
                @Override
                public void onSuccess(@NonNull PaymentMethod result) {
                    try {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        paymentMethodId = result.id;
                        createPaymentIntent();
                    } catch (Exception e) {
                        btnPay.setEnabled(true);
                        e.printStackTrace();
                    }
                    //PaymentMetthod id is authenticated card id with stripe. if we use its multiline card input UI, it will create automatically and set in params
                    // but here we are using our own card input layout so we need this key.
                    // Send paymentMethodId to your server for the next steps if you want to save card otherwise generate paymentIntentClientSecret.
                }

                @Override
                public void onError(@NonNull Exception e) {
                    // Display the error to the user
                    try {
                        e.printStackTrace();
                        LogUtils.e(e.getMessage());
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                                btnPay.setEnabled(true);
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, e.getMessage());
                            });
                        }
                    } catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createCardToken(CardParams cardParams) {
        try {
            /*stripe.createCardToken(cardParams, new ApiResultCallback<Token>() {
                @Override
                public void onSuccess(@NotNull Token token) {
                    try {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                                CommonFunctions.hideKeyboard(getActivity(), etTip);
                            });
                        }
                        String descriptor = merchantBusiness.statement_descriptor;
                        if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service) {
                            descriptor = merchantBusiness.statement_descriptor;
                        }
                        Stripe.apiKey = "" + stripe_private_key;
                        Map<String, Object> params = new HashMap<String, Object>();
                        Map<String, Object> params1 = new HashMap<String, Object>();
                        DecimalFormat doubleFormat = new DecimalFormat("#.##");
                        doubleFormat.setMinimumFractionDigits(0);
                        String price = doubleFormat.format((totalAmount) * 100);
                        params.put("amount", "" + price);
                        params.put("currency", "gbp");
                        params.put("capture", true);
                        params.put("source", token.getId());

                        float amount = doCalculateAmountFee();
                        Log.e("doCalculateAmountFee", " " + amount);
                        if (amount > 0) {
                            float formattedValue = Float.parseFloat(MyApp.df.format(amount));
                            Log.e("Amount", " " + formattedValue);
                            int fee = (int) (formattedValue * 100);
                            params.put("application_fee_amount", fee);
                            Log.e("application_fee_amount", " " + fee);
                            Map<String, Object> transferDataParams = new HashMap<>();
                            transferDataParams.put("destination", merchantBusiness.s_account_id);
                            params.put("transfer_data", transferDataParams);
                        }

                        params.put("description", merchantBusiness.statement_description);
                        params.put("statement_descriptor", descriptor);
                        params1.put("limit", "3");
                        new Thread(() -> {
                            try {
                                Charge charge = Charge.create(params);
                                Charge.list(params1);
                                manageChargeResponse(charge);
                            } catch (StripeException e) {
                                e.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        if (getActivity() != null) {
                                            getActivity().runOnUiThread(() -> btnPay.setEnabled(true));
                                        }
                                        progressDialog.dismiss();
                                        myApp.startPaymentFailedSound();
                                        etCardNumber.setText("");
                                        etAmount.setText("");
                                        etTip.setText("");
                                        etCvv.setText("");
                                        etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                                        etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                                        etExpDate.setText("");
                                        etPostalCode.setText("");
                                        CustomDialogFragment customDialogFragment = CustomDialogFragment.getInstance("Error", "Payment declined", true);
                                        customDialogFragment.show(getActivity().getSupportFragmentManager(), "error");
                                    });
                                }
                            }

                        }).start();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onError(@NotNull Exception e) {
                    try {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> btnPay.setEnabled(true));
                        }
                        e.printStackTrace();
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                                etCardNumber.setText(null);
                                etAmount.setText(null);
                                etTip.setText(null);
                                etCvv.setText(null);
                                etExpDate.setText(null);
                                etPostalCode.setText(null);
                                myApp.startPaymentFailedSound();
                                etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                                etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                                CustomDialogFragment customDialogFragment = CustomDialogFragment.getInstance("Error", "Payment declined", true);
                                customDialogFragment.show(getActivity().getSupportFragmentManager(), "error");
                            });
                        }
                    } catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });*/
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // Calculate fee to pass to Stripe method when server is not working
    private float doCalculateAmountFee() {
        float amount = 0;
        try {
            List<CardBrandCommission> listBrand = myApp.appDatabase.commissionDao().listBrand();
            List<CountryCommission> listCountry = myApp.appDatabase.commissionDao().listCountry();
            if (listBrand != null && listBrand.size() > 0) {
                for (int i = 0; i < listBrand.size(); i++) {
                    if (listBrand.get(i).brand_name.equalsIgnoreCase(cardParams.getBrand().name())) {
                        amount = amount + listBrand.get(i).stripe_fixed;
                        amount = amount + ((totalAmount * listBrand.get(i).stripe_percentage) / 100);
                    }
                }
            }
            if (listCountry != null && listCountry.size() > 0) {
                for (int j = 0; j < listCountry.size(); j++) {
                    if (listCountry.get(j).currency_code.equalsIgnoreCase(cardParams.getCurrency())) {
                        amount = amount + listBrand.get(j).stripe_fixed;
                        amount = amount + ((totalAmount * listCountry.get(j).stripe_percentage) / 100);
                    }
                }
            }
            if (merchantBusiness.s_account_id != null) {
                if (merchantBusiness.business_commissions.connect_card_auth_fee_type != null) {
                    if (merchantBusiness.business_commissions.connect_card_auth_fee_type.equalsIgnoreCase("flat")) {
                        amount = amount + merchantBusiness.business_commissions.connect_card_auth_fee;
                    } else if (merchantBusiness.business_commissions.connect_card_auth_fee_type.equalsIgnoreCase("percentage")) {
                        amount = amount + ((totalAmount * merchantBusiness.business_commissions.connect_card_auth_fee) / 100);
                    }
                    if (merchantBusiness.business_commissions.connect_card_processing_fee_type.equalsIgnoreCase("flat")) {
                        amount = amount + merchantBusiness.business_commissions.connect_card_processing_fee;
                    } else if (merchantBusiness.business_commissions.connect_card_processing_fee_type.equalsIgnoreCase("percentage")) {
                        amount = amount + ((totalAmount * merchantBusiness.business_commissions.connect_card_processing_fee) / 100);
                    }
                }
            } else {
                if (merchantBusiness.business_commissions.merchant_card_auth_fee_type != null) {
                    if (merchantBusiness.business_commissions.merchant_card_auth_fee_type.equalsIgnoreCase("flat")) {
                        amount = amount + merchantBusiness.business_commissions.merchant_card_auth_fee;
                    } else if (merchantBusiness.business_commissions.merchant_card_auth_fee_type.equalsIgnoreCase("percentage")) {
                        amount = amount + ((totalAmount * merchantBusiness.business_commissions.merchant_card_auth_fee) / 100);
                    }
                    if (merchantBusiness.business_commissions.merchant_card_processing_fee_type.equalsIgnoreCase("flat")) {
                        amount = amount + merchantBusiness.business_commissions.merchant_card_processing_fee;
                    } else if (merchantBusiness.business_commissions.merchant_card_processing_fee_type.equalsIgnoreCase("percentage")) {
                        amount = amount + ((totalAmount * merchantBusiness.business_commissions.merchant_card_processing_fee) / 100);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return amount;
    }

    boolean autoConfirm = false;

    private HashMap<String, String> generatePaymentIntentParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("amount", MyApp.df.format(totalAmount * 100));
        params.put("currency", "GBP");
        params.put("transaction_type", merchantBusiness.connect_service ? "connect" : "merchant");
        params.put("stripe_secrete_key", stripe_private_key);
        params.put("business_id", merchantBusiness.id);
        params.put("payment_method_id", paymentMethodId);
        params.put("auto_confirm", autoConfirm ? "1" : "0");

        return params;
    }

    private void createPaymentIntent() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressDialog.show();
                    etAmount.setText(null);
                    etTip.setText(null);
                    etCardNumber.setText(null);
                    etAddress.setText(null);
                    etExpDate.setText(null);
                    etCvv.setText(null);
                    etPostalCode.setText(null);
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> btnPay.setEnabled(true));
                    }
                });
            }
            if (isApiError) {
                // reset keys if it's set to resource strings due to API error
                // if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(merchantBusiness.connect_stripe_public_key)) {
                if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                    //stripe_private_key = merchantBusiness.connect_stripe_private_key;
                    stripe_private_key = BuildConfig.connect_stripe_private_key;
                    // stripe_public_key = merchantBusiness.connect_stripe_public_key;
                    stripe_public_key = BuildConfig.connect_stripe_public_key;
                } else {
                    if (stripe_mode.equalsIgnoreCase("live")) {
                        //stripe_private_key = merchantBusiness.stripe_private_key_live;
                        stripe_private_key = BuildConfig.stripe_private_key_live;
                        //stripe_public_key = merchantBusiness.stripe_public_key_live;
                        stripe_public_key = BuildConfig.stripe_public_key_live;
                    } else {
                        //stripe_private_key = merchantBusiness.stripe_private_key_test;
                        stripe_private_key = BuildConfig.stripe_private_key_test;
                        //stripe_public_key = merchantBusiness.stripe_public_key_test;
                        stripe_public_key = BuildConfig.stripe_public_key_test;
                    }
                }
            }
            AndroidNetworking.post(ApiEndPoints.PAYMENT_INTENT)
                    .addBodyParameter(generatePaymentIntentParams())
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                if (response.has("payment_intent")) {
                                    isApiError = false;
                                    JSONObject paymentIntent = response.getJSONObject("payment_intent");
                                    String paymentSecret = paymentIntent.getString("client_secret");
                                    if (!autoConfirm)
                                        performStripePayment(paymentSecret);
                                    else {
                                        if (getActivity() != null) {
                                            getActivity().runOnUiThread(() -> progressDialog.show());
                                        }
                                        stripe.retrievePaymentIntent(paymentSecret, new ApiResultCallback<PaymentIntent>() {
                                            @Override
                                            public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                                                if (getActivity() != null) {
                                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                                }
                                                managePaymentResponse(paymentIntent);
                                            }

                                            @Override
                                            public void onError(@NotNull Exception e) {
                                                if (getActivity() != null) {
                                                    getActivity().runOnUiThread(() -> btnPay.setEnabled(true));
                                                }
                                            }
                                        });
                                    }
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> btnPay.setEnabled(true));
                                }
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                LogUtils.e("MOTO PAYMENT ERROR");
                                LogUtils.e(anError.getErrorBody());
                                if (getActivity() != null) {
                                    btnPay.setEnabled(true);
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, apiError.getMessage());
                                    // if error occurs from server, call stripe method
                                    isApiError = true;
                                    //paymentWithStripe();
                                } else {
                                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Unknown Error");
                                    // if error occurs from server, call stripe method
                                    isApiError = true;
                                    //paymentWithStripe();
                                }


                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void paymentWithStripe() {
        try {
            if (merchantBusiness != null) {
                // if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(merchantBusiness.connect_stripe_public_key)) {
                if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && merchantBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                    //stripe_private_key = merchantBusiness.connect_stripe_private_key;
                    stripe_private_key = BuildConfig.connect_stripe_private_key;
                    //stripe_public_key = merchantBusiness.connect_stripe_public_key;
                    stripe_public_key = BuildConfig.connect_stripe_public_key;
                } else {
                    if (stripe_mode.equalsIgnoreCase("live")) {
                        //  stripe_private_key = merchantBusiness.stripe_private_key_live;
                        stripe_private_key = BuildConfig.stripe_private_key_live;
                        //stripe_public_key = merchantBusiness.stripe_public_key_live;
                        stripe_public_key = BuildConfig.stripe_public_key_live;
                    } else {
                        //stripe_private_key = merchantBusiness.stripe_private_key_test;
                        stripe_private_key = BuildConfig.stripe_private_key_test;
                        //stripe_public_key = merchantBusiness.stripe_public_key_test;
                        stripe_public_key = BuildConfig.stripe_public_key_test;
                    }
                }
            }
            // restart configuration with new keys
            PaymentConfiguration.init(getActivity(), stripe_public_key);
            stripe = new Stripe(getActivity(), stripe_public_key);
            createCardToken(cardParams);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performStripePayment(String paymentIntentSecret) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            ConfirmPaymentIntentParams confirmParams = ConfirmPaymentIntentParams
                    .createWithPaymentMethodId(paymentMethodId, paymentIntentSecret);
//        stripe = new Stripe(getContext(), stripe_public_key);
            stripe.confirmPayment(this, confirmParams);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null) {
            stripe.onPaymentResult(requestCode, data, new PaymentResultCallback(this));
        }
    }

    private static final class PaymentResultCallback1
            implements ApiResultCallback<PaymentIntentResult> {
        @NonNull
        private final WeakReference<MotoPaymentFragment> activityRef;

        PaymentResultCallback1(@NonNull MotoPaymentFragment activity) {
            activityRef = new WeakReference<>(activity);
        }

        @Override
        public void onSuccess(@NonNull PaymentIntentResult result) {
            try {
                final MotoPaymentFragment activity = activityRef.get();
                if (activity == null) {
                    return;
                }
                PaymentIntent paymentIntent = result.getIntent();
                PaymentIntent.Status status = paymentIntent.getStatus();
                if (status == PaymentIntent.Status.Succeeded) {
                    // Payment completed successfully
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    activity.displayAlert(
                            "Payment completed",
                            gson.toJson(paymentIntent)
                    );
                } else if (status == PaymentIntent.Status.RequiresPaymentMethod) {
                    // Payment failed – allow retrying using a different payment method
                    activity.displayAlert(
                            "Payment failed",
                            Objects.requireNonNull(paymentIntent.getLastPaymentError()).getMessage()
                    );
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            final MotoPaymentFragment activity = activityRef.get();
            if (activity == null) {
                return;
            }
            // Payment request failed – allow retrying using the same payment method

        }
    }

    private void displayAlert(@NonNull String title,
                              @Nullable String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity())
                .setTitle(title)
                .setMessage(message);
        builder.setPositiveButton("Ok", null);
        builder.create().show();
    }

    private static final class PaymentResultCallback
            implements ApiResultCallback<PaymentIntentResult> {

        @NonNull
        private final WeakReference<MotoPaymentFragment> activityRef;

        PaymentResultCallback(MotoPaymentFragment activity) {
            activityRef = new WeakReference<MotoPaymentFragment>(activity);
            final MotoPaymentFragment a = activityRef.get();
            if (activity.getActivity() != null && !activity.getActivity().isFinishing())
                a.progressDialog.show();
        }


        @Override
        public void onSuccess(@NonNull PaymentIntentResult result) {
            try {
                final MotoPaymentFragment activity = activityRef.get();
                if (activity == null) {
                    return;
                }
                PaymentIntent paymentIntent = result.getIntent();
                activity.managePaymentResponse(paymentIntent);
                activity.myApp.startPaymentSuccessSound();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            try {
                final MotoPaymentFragment activity = activityRef.get();
                if (activity == null) {
                    return;
                }
                e.printStackTrace();
                if (activity.getActivity() != null && !activity.getActivity().isFinishing())
                    activity.progressDialog.dismiss();
                // Payment request failed – allow retrying using the same payment method
                activity.myApp.startPaymentFailedSound();
                activity.getActivity().runOnUiThread(() -> activity.btnPay.setEnabled(true));
                CommonFunctions.showSnackBar(activity.getActivity(), activity.llMainLayout, "Payment request failed");
                AnimatedConfirmationDialogFragment animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragment.getInstance("Payment request failed\n"+e.getMessage(), "", 2, "Okay", null);
                animatedConfirmationDialogFragment.show(activity.getChildFragmentManager(), "show_confirm");
            } catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    String title;
    String headerA = "", headerB = "", resAddress = "";
    String amount;
    String card_____;
    String account__;
    String stripe_id;
    String entry_mod;
    String status___;
    String please;
    String date_final;
    String footerA;
    String footerB;
    String main_content;
    String print_amount, print_card = "", print_card_number = "", print_stripe_id, print_payment_mode, print_status;

    private void managePaymentResponse(PaymentIntent paymentIntent) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                btnPay.setEnabled(true);
                progressDialog.dismiss();
            });
            PaymentIntent.Status paymentIntentStatus = paymentIntent.getStatus();
            print_stripe_id = paymentIntent.getId();
            print_amount = MyApp.df.format(totalAmount);

            if (paymentIntent.getPaymentMethod() != null && paymentIntent.getPaymentMethod().card != null)
                print_card = paymentIntent.getPaymentMethod().card.brand.getDisplayName();

            if (paymentIntent.getPaymentMethod() != null && paymentIntent.getPaymentMethod().card != null)
                print_card_number = paymentIntent.getPaymentMethod().card.last4;

            print_payment_mode = "MOTO";
            if (paymentIntentStatus == null) {
                print_status = "Declined";
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Payment declined");
                myApp.startPaymentFailedSound();
            } else if (paymentIntentStatus == PaymentIntent.Status.Succeeded) {
                // Payment completed successfully
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Payment successful");
                myApp.startPaymentSuccessSound();
                print_status = "Approved";

            } else if (paymentIntentStatus == PaymentIntent.Status.RequiresPaymentMethod) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Card authentication failed, Please retry");
            } else if (paymentIntentStatus == StripeIntent.Status.Canceled) {
                print_status = "Declined";
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Payment declined");
                myApp.startPaymentFailedSound();
            } else {
                print_status = "Declined";
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Payment declined");
                myApp.startPaymentFailedSound();
            }

            title = "" + "Customer Copy" + "\n";

            if (merchantBusiness != null) {
                headerA = merchantBusiness.header_a;
                headerB = merchantBusiness.header_b;
            }

            amount = "£" + print_amount + "\n";

            card_____ = "Card       :" + print_card;
            account__ = "Account    :" + print_card_number;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";

            if (merchantBusiness != null) {
                footerA = merchantBusiness.footer_a;
                footerB = merchantBusiness.footer_b;
            }

            main_content = card_____ + "\n" + account__ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";
            AnimatedConfirmationDialogFragment animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragment.getInstance(print_status, "", print_status.equalsIgnoreCase("approved") ? 1 : 2, "Okay", null);
            animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
            animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                        if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                            printIMin("Customer Copy");
                        } else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                            printCs20("Merchant Copy");
                        } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                            if (zoneRichPrinter == null) {
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
                            } else {
                                printZonrich("Merchant Copy");
                            }
                        } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        CommonFunctions.functionThatDelay(200);
                                        printBT("Customer Copy");
                                    } else {
                                        ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            printReceipt();
                        }
                    } else {
                        try {
                            Thread.sleep(200);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        goBackAfterPrint();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goBackAfterPrint(){
        if (getActivity() != null) getActivity().runOnUiThread(() -> {
            if(isFromTheme2){
                changeFragment(new Theme2PaymentSelection());
            }else {
                getActivity().onBackPressed();
            }
        });
    }

    private void changeFragment(Fragment fragment) {
        FragmentManager manager = requireActivity().getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        Fragment payment_type_selection = manager.findFragmentByTag("payment_type_selection");
        Fragment theme2_payment_selection = manager.findFragmentByTag("theme2_payment_selection");
        if(payment_type_selection!=null){
            manager.beginTransaction().remove(payment_type_selection).commit();
            manager.popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        }
        if(theme2_payment_selection!=null){
            manager.beginTransaction().remove(theme2_payment_selection).commit();
            manager.popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        }
        transaction.replace(R.id.nav_host_fragment, fragment);
        transaction.commit();
    }

    /*private void manageChargeResponse(Charge charge) {
        try {
            String transactionId = charge.getId();
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> {
                    btnPay.setEnabled(true);
                    progressDialog.dismiss();
                });

            print_stripe_id = transactionId;
            print_amount = MyApp.df.format(totalAmount);

            if (charge.getPaymentMethodDetails() != null)
                print_card = charge.getPaymentMethodDetails().getCard().getBrand().toString();

            if (charge.getPaymentMethodDetails() != null && charge.getPaymentMethodDetails().getCard() != null)
                print_card_number = charge.getPaymentMethodDetails().getCard().getLast4().toString();

            print_payment_mode = "MOTO";
            if (charge.getStatus().equalsIgnoreCase("Succeeded")) {
                // Payment completed successfully
                myApp.startPaymentSuccessSound();
                print_status = "Approved";

            } else if (charge.getStatus().equalsIgnoreCase("RequiresPaymentMethod")) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
            } else if (charge.getStatus().equalsIgnoreCase("Canceled")) {
                print_status = "Declined";
                myApp.startPaymentFailedSound();
            }

            title = "" + "Customer Copy" + "\n";

            if (merchantBusiness != null) {
                headerA = merchantBusiness.header_a;
                headerB = merchantBusiness.header_b;
            }

            amount = "£" + print_amount + "\n";

            card_____ = "Card       :" + print_card;
            account__ = "Account    :" + print_card_number;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";

            if (merchantBusiness != null) {
                footerA = merchantBusiness.footer_a;
                footerB = merchantBusiness.footer_b;
            }

            main_content = card_____ + "\n" + account__ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";
            AnimatedConfirmationDialogFragment animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragment.getInstance(print_status, "", print_status.equalsIgnoreCase("approved") ? 1 : 2, "Okay", null);
            animatedConfirmationDialogFragment.show(getChildFragmentManager(), "show_confirm");
            animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                        if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                            if (zoneRichPrinter == null) {
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Printer is null");
                            } else {
                                printZonrich("Customer Copy");
                            }
                        } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        CommonFunctions.functionThatDelay(200);
                                        printBT("Customer Copy");
                                    } else {
                                        ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            printReceipt();
                        }
                    } else {
                        try {
                            Thread.sleep(200);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (getActivity() != null) getActivity().runOnUiThread(() -> {
                            getActivity().onBackPressed();
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }*/

    private void printReceipt() {
        print_v1("Merchant Copy");
    }

    public void print_v1(String title_copy) {
        try {
            String title = "" + title_copy + "\n";
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    if (title_copy.equalsIgnoreCase("merchant copy")) {
                        if (merchantBusiness.auto_merchant_print != null && (merchantBusiness.auto_merchant_print.equalsIgnoreCase("true") || merchantBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                            sunmiPrinter.printMotoReceiptAidlUtil(myApp.merchantLogo, title, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                            printSunmiZoneRich(title_copy);
                        } else {
                            AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                            builder.setTitle("Is Merchant Copy Required ?");
                            builder.setPositiveButton("OK", (dialogInterface, i) -> {
                                sunmiPrinter.printMotoReceiptAidlUtil(myApp.merchantLogo, title, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                                printSunmiZoneRich(title_copy);
                                dialogInterface.dismiss();
                            });
                            builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                                printSunmiZoneRich(title_copy);
                                dialogInterface.dismiss();
                            });
                            builder.setCancelable(false);
                            builder.show();
                        }
                    } else {
                        sunmiPrinter.printMotoReceiptAidlUtil(myApp.merchantLogo, title, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                        goBackAfterPrint();
                    }
                });
            }
        } catch (Exception e) {
            try {
                e.printStackTrace();
                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                    progressDialog.dismiss();
                });
            } catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void printSunmiZoneRich(String title) {
        if (title.toLowerCase().contains("merchant copy")) {
            if (merchantBusiness.auto_customer_print != null && (merchantBusiness.auto_customer_print.equalsIgnoreCase("true") || merchantBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                print_v1("Customer Copy");
            } else {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                builder.setTitle("Is Customer Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    print_v1("Customer Copy");
                    dialogInterface.dismiss();
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    goBackAfterPrint();
                });
                builder.setCancelable(false);
                builder.show();
            }
        }
    }

    public void printIMin(String title) {
        try {
            title = title + "\n";
            if (getActivity() != null) {
                String finalTitle = title;
                getActivity().runOnUiThread(() -> {
                    please = "Please Retain Receipt\nFor Your Record";
                    myApp.iMinPrinterUtils.printMotoReceipt(myApp.merchantLogo, "Customer Copy", headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                    if (!finalTitle.toLowerCase().contains("merchant copy")) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                        builder.setTitle("Is Merchant Copy Required ?");
                        builder.setPositiveButton("OK", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            myApp.iMinPrinterUtils.printMotoReceipt(myApp.merchantLogo, "Merchant Copy", headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                        });
                        builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            goBackAfterPrint();
                        });
                        builder.setCancelable(false);
                        builder.show();
                    } else {
                        goBackAfterPrint();
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printZonrich(String title) {
        try {
            title = title + "\n";
            if (getActivity() != null) {
                String finalTitle = title;
                getActivity().runOnUiThread(() -> {
                    zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                    if (finalTitle.toLowerCase().contains("merchant copy")) {
                        if (merchantBusiness.auto_merchant_print != null && (merchantBusiness.auto_merchant_print.equalsIgnoreCase("true") || merchantBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                            zoneRichPrinter.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                            printZoneRich(finalTitle);
                        } else {
                            AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                            builder.setTitle("Is Merchant Copy Required ?");
                            builder.setPositiveButton("OK", (dialogInterface, i) -> {
                                zoneRichPrinter.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                                printZoneRich(finalTitle);
                                dialogInterface.dismiss();
                            });
                            builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                                printZoneRich(finalTitle);
                                dialogInterface.dismiss();
                            });
                            builder.setCancelable(false);
                            builder.show();
                        }
                    } else {
                        zoneRichPrinter.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                        goBackAfterPrint();
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printZoneRich(String title) {
        if (title.toLowerCase().contains("merchant copy")) {
            if (merchantBusiness.auto_customer_print != null && (merchantBusiness.auto_customer_print.equalsIgnoreCase("true") || merchantBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printZonrich("Customer Copy");
            } else {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                builder.setTitle("Is Customer Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printZonrich("Customer Copy");
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    goBackAfterPrint();
                });
                builder.setCancelable(false);
                builder.show();
            }
        }
    }

    public void printBT(String title) {
        try {
            title = title + "\n";
            if (getActivity() != null) {
                String finalTitle = title;
                getActivity().runOnUiThread(() -> {
                    bluetoothPrinter.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                    if (!finalTitle.toLowerCase().contains("merchant copy")) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                        builder.setTitle("Is Merchant Copy Required ?");
                        builder.setPositiveButton("OK", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            printBT("Merchant Copy");
                        });
                        builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            goBackAfterPrint();
                        });
                        builder.setCancelable(false);
                        builder.show();
                    } else {
                        goBackAfterPrint();
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printCs20(String title) {
        try {
            title = title + "\n";
            if (getActivity() != null) {
                String finalTitle = title;
                getActivity().runOnUiThread(() -> {
                    if (finalTitle.toLowerCase().contains("merchant copy")) {
                        if (merchantBusiness.auto_merchant_print != null && (merchantBusiness.auto_merchant_print.equalsIgnoreCase("true") || merchantBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                            cs20PrintHelper.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                            printCS20(finalTitle);
                        } else {
                            AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                            builder.setTitle("Is Merchant Copy Required ?");
                            builder.setPositiveButton("OK", (dialogInterface, i) -> {
                                cs20PrintHelper.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                                printCS20(finalTitle);
                                dialogInterface.dismiss();
                            });
                            builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                                printCS20(finalTitle);
                                dialogInterface.dismiss();
                            });
                            builder.setCancelable(false);
                            builder.show();
                        }
                    } else {
                        cs20PrintHelper.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                        goBackAfterPrint();
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printCS20(String title) {
        if (title.toLowerCase().contains("merchant copy")) {
            if (merchantBusiness.auto_customer_print != null && (merchantBusiness.auto_customer_print.equalsIgnoreCase("true") || merchantBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printCs20("Customer Copy");
            } else {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AppDialog);
                builder.setTitle("Is Customer Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printCs20("Customer Copy");
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    goBackAfterPrint();
                });
                builder.setCancelable(false);
                builder.show();
            }
        }
    }

    @Override
    public void onStop() {
        try {
            CommonFunctions.hideKeyboard(getActivity(), etAmount);
            CommonFunctions.hideKeyboard(getActivity(), etTip);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();
    }
}
