package com.tiffintom.partner1.fragments;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.FullReportAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.FullReport;
import com.tiffintom.partner1.models.ReportOrderPaymentMethod;
import com.tiffintom.partner1.models.ReportOrderType;
import com.tiffintom.partner1.models.ReportTextModel;
import com.tiffintom.partner1.models.SiteSetting;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class OReportFragment extends BaseFragment {
    private ArrayList<Object> reports = new ArrayList<>();
    private TextView tvSelectedDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private Chip chipBack;
    private Calendar fromCalender = Calendar.getInstance();
    private Calendar toCalender = Calendar.getInstance();
    private LinearLayout llToDate, llFromDate;
    private TextView tvFromDate, tvToDate;
    private MaterialButton btnToday, btnThisWeek, btnThisMonth, btnCustom;
    private MaterialButtonToggleGroup btnGroup;
    private MaterialCardView cvCustom;
    private RecyclerView rvReports;
    private MaterialButton btnPrint;
    private FullReportAdapter reportAdapter;
    private String fromDateString, toDateString;
    private Date startDate, endDate;
    Calendar c = Calendar.getInstance();
    int year = c.get(Calendar.YEAR);
    int month = c.get(Calendar.MONTH);
    private LinearLayout llProgress, llData;
    int day = 1;
    private DatePickerDialog fromPicker, toPicker;
    int selectedButton = 0;
    private ZoneRichPrinter zoneRichPrinter;
    private CS20PrintHelper cs20PrintHelper;
    private SunmiPrinter sunmiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private SiteSetting ticketHeaderSetting, ticketHeaderTypeSetting, footerASetting, footerBSetting;
    private int headerAlignment = 0;
    String defaultPrinter;
    private TextView tvTitle;
    private LinearLayout llUsers;
    private LinearLayout llToday, llThisWeek, llThisMonth, llCustom;
    private TextView tvToday, tvThisWeek, tvThisMonth, tvCustom;
    private View vToday, vThisWeek, vThisMonth, vCustom;
    private String transaction_value = "";

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_o_report, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper = new CS20PrintHelper();
            }
            loadSettings();
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            defaultPrinter = myApp.getMyPreferences().getDefaultPrinter();
            //zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            tvTitle = view.findViewById(R.id.tvTitle);

            chipBack = view.findViewById(R.id.chipBack);
            btnToday = view.findViewById(R.id.btnToday);
            btnThisWeek = view.findViewById(R.id.btnThisWeek);
            btnThisMonth = view.findViewById(R.id.btnThisMonth);
            btnCustom = view.findViewById(R.id.btnCustom);
            btnGroup = view.findViewById(R.id.btnGroup);

            cvCustom = view.findViewById(R.id.cvCustom);
            rvReports = view.findViewById(R.id.rvReports);
            btnPrint = view.findViewById(R.id.btnPrint);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llProgress = view.findViewById(R.id.llProgress);
            llData = view.findViewById(R.id.llData);
            tvSelectedDate = view.findViewById(R.id.tvSelectedDate);

            llToday = view.findViewById(R.id.llToday);
            llThisWeek = view.findViewById(R.id.llThisWeek);
            llThisMonth = view.findViewById(R.id.llThisMonth);
            llCustom = view.findViewById(R.id.llCustom);

            tvToday = view.findViewById(R.id.tvToday);
            tvThisWeek = view.findViewById(R.id.tvThisWeek);
            tvThisMonth = view.findViewById(R.id.tvThisMonth);
            tvCustom = view.findViewById(R.id.tvCustom);

            vToday = view.findViewById(R.id.vToday);
            vThisWeek = view.findViewById(R.id.vThisWeek);
            vThisMonth = view.findViewById(R.id.vThisMonth);
            vCustom = view.findViewById(R.id.vCustom);

            chekedBtn(llToday);
            cvCustom.setVisibility(View.GONE);
            reportAdapter = new FullReportAdapter(reports);
            rvReports.setLayoutManager(new WrapContentLinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvReports.setItemAnimator(null);
            rvReports.setAdapter(reportAdapter);

            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadSettings() {
        try {
            ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public class WrapContentLinearLayoutManager extends LinearLayoutManager {
        public WrapContentLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
            super(context, orientation, reverseLayout);
        }

        @Override
        public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
            try {
                super.onLayoutChildren(recycler, state);
            } catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
            llToday.setOnClickListener(v -> {
                selectedButton = llToday.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llToday);
                getToday();
            });
            llToday.performClick();
            llThisWeek.setOnClickListener(v -> {
                selectedButton = llThisWeek.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llThisWeek);
                getWeek();
            });
            llThisMonth.setOnClickListener(v -> {
                selectedButton = llThisMonth.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llThisMonth);
                getCurrentMonth();
            });
            llCustom.setOnClickListener(v -> {
                selectedButton = llCustom.getId();
                cvCustom.setVisibility(View.VISIBLE);
                chekedBtn(llCustom);
            });

            llFromDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view1, y, m, d) -> {
                        fromDay = d;
                        fromMonth = m;
                        fromYear = y;
                        fromDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        fromCalender.set(y, m, d);
                        tvFromDate.setText(CommonFunctions.formatMiliToDesireFormat(fromCalender.getTimeInMillis(), "dd/MM/yyyy"));
                        setDateText();
                        fetchReport();
                    }, fromCalender.get(Calendar.YEAR), fromCalender.get(Calendar.MONTH), fromCalender.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "FromPickerDialog");
                    if (!Validators.isNullOrEmpty(toDateString)) {
                        datePickerDialog.setMaxDate(toCalender);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            llToDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view12, y, m, d) -> {
                        toDay = d;
                        toMonth = m;
                        toYear = y;
                        toDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        toCalender.set(y, m, d);
                        tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalender.getTimeInMillis(), "dd/MM/yyyy"));
                        setDateText();
                        fetchReport();
                    }, toCalender.get(Calendar.YEAR), toCalender.get(Calendar.MONTH), toCalender.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "ToPickerDialog");
                    if (!Validators.isNullOrEmpty(fromDateString)) {
                        datePickerDialog.setMinDate(fromCalender);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });
            btnPrint.setOnClickListener(view -> {
                 createPrint();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void chekedBtn(View v) {
        try {
            vToday.setBackgroundResource(R.color.light_gray);
            tvToday.setAlpha(0.5f);

            vThisWeek.setBackgroundResource(R.color.light_gray);
            tvThisWeek.setAlpha(0.5f);

            vThisMonth.setBackgroundResource(R.color.light_gray);
            tvThisMonth.setAlpha(0.5f);

            vCustom.setBackgroundResource(R.color.light_gray);
            tvCustom.setAlpha(0.5f);

            if (v == llToday) {
                vToday.setBackgroundResource(R.color.persian_green);
                tvToday.setAlpha(1f);
            }
            if (v == llThisWeek) {
                vThisWeek.setBackgroundResource(R.color.persian_green);
                tvThisWeek.setAlpha(1f);
            }
            if (v == llThisMonth) {
                vThisMonth.setBackgroundResource(R.color.persian_green);
                tvThisMonth.setAlpha(1f);
            }
            if (v == llCustom) {
                vCustom.setBackgroundResource(R.color.persian_green);
                tvCustom.setAlpha(1f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDateText() {
        try {
            if (fromDateString.equalsIgnoreCase(toDateString)) {
                tvSelectedDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            } else {
                tvSelectedDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy") + " to " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            }

            tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
            tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getCurrentMonth() {
        try {
            c.set(year, month, day);
            startDate = c.getTime();


            int numOfDaysInMonth = c.getActualMaximum(Calendar.DAY_OF_MONTH);
            c.add(Calendar.DAY_OF_MONTH, numOfDaysInMonth - 1);

            endDate = c.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();

            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getWeek() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setFirstDayOfWeek(Calendar.MONDAY);
            cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
            startDate = cal.getTime();

            cal.add(Calendar.DATE, 6);
            endDate = cal.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();
            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getToday() {
        try {
            fromDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");

            setDateText();
            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchReport() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                llProgress.setVisibility(View.VISIBLE);
                llData.setVisibility(View.GONE);
                btnPrint.setVisibility(View.GONE);
            });
        }
        transaction_value = "";
        Log.e("fromDateString","fromDateString "+fromDateString +" toDateString "+toDateString+" getMyPreferences "+merchantBusiness.restaurant_id);
        ANRequest.GetRequestBuilder requestBuilder = AndroidNetworking.get(ApiEndPoints.online_report)
                .addQueryParameter("shift_status", "both")
                .addQueryParameter("from_date", fromDateString)
                .addQueryParameter("restaurant_id", merchantBusiness.restaurant_id)
                .addQueryParameter("to_date", toDateString);
        //requestBuilder.addQueryParameter("archived", isArchived ? "1" : "0");
        requestBuilder.build()
                .getAsObject(FullReport.class,new ParsedRequestListener<FullReport>() {
                    @Override
                    public void onResponse(FullReport response) {
                        try {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llProgress.setVisibility(View.GONE);
                                    llData.setVisibility(View.VISIBLE);
                                    btnPrint.setVisibility(View.VISIBLE);
                                });
                            }
                            reports.clear();
                            //reports.add(new ReportTextModel("Orders", response.online_order_count, ""));
                            reports.add(new ReportTextModel("Orders", response.online_order_count,  response.online_order_total_business));
                            //reports.add(new ReportTextModel("Order Businesses", response.online_order_total_business, ""));

                            if (!Validators.isNullOrEmpty(defaultPrinter) && defaultPrinter.toLowerCase().contains("imin")) {
                                reports.add(new ReportTextModel("Ord Comm.", "0", response.online_order_calculated_commission));
                            }else {
                                reports.add(new ReportTextModel("Order Commission", "0", response.online_order_calculated_commission));
                            }
                            reports.add(new ReportTextModel("Reservation", response.online_reservation_count, ""));

                            reports.add(new ReportTextModel("Device Wise", "", true));
                            if (response.android_online_order_count != null && !response.android_online_order_count.isEmpty()) {
                                reports.add(new ReportTextModel("Android ", "" + response.android_online_order_count.get(0).count, MyApp.df.format(response.android_online_order_count.get(0).total)));
                            }
                            if (response.web_online_order_count != null && !response.web_online_order_count.isEmpty()) {
                                reports.add(new ReportTextModel("Web", "" + response.web_online_order_count.get(0).count, MyApp.df.format(response.web_online_order_count.get(0).total)));
                            }
                            if (response.ios_online_order_count != null && !response.ios_online_order_count.isEmpty()) {
                                reports.add(new ReportTextModel("IOS ", "" + response.ios_online_order_count.get(0).count, MyApp.df.format(response.ios_online_order_count.get(0).total)));
                            }

                            if (response.online_order_type != null && response.online_order_type.size() > 0) {
                                reports.add(new ReportTextModel("Order Type Wise", "", true));
                                for (ReportOrderType something : response.online_order_type) {
                                    reports.add(new ReportTextModel("" + something.order_type, String.valueOf(something.count), MyApp.df.format(something.total)));
                                }
                            }

                            if (response.online_order_payment != null && response.online_order_payment.size() > 0) {
                                reports.add(new ReportTextModel("Order Payment Wise ", "", true));
                                for (ReportOrderPaymentMethod something : response.online_order_payment) {
                                    reports.add(new ReportTextModel("" + something.payment_method, String.valueOf(something.count), MyApp.df.format(something.total)));
                                }
                            }

                            if (getActivity() != null)
                                rvReports.post(() -> {
                                    rvReports.stopScroll();
                                    reportAdapter.notifyDataSetChanged();
                                    btnPrint.setVisibility(View.VISIBLE);
                                });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            Log.e("ANError","ANErrorANErrorANError "+anError.getErrorBody());
                            if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llProgress.setVisibility(View.GONE);
                                        llData.setVisibility(View.GONE);
                                    });
                            }

                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            btnPrint.setVisibility(View.GONE);
                                        });
                                    }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
    }

    private void createPrint() {
        try {
            if (!Validators.isNullOrEmpty(defaultPrinter)) {
                String title = "Online Order Report";
                if (defaultPrinter.toLowerCase().contains("imin")) {
                    myApp.iMinPrinterUtils.printFoodHubFullReport(myApp.restaurantLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(), null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.getMyPreferences());
                }else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                    cs20PrintHelper.printFoodHubFullReport(myApp.restaurantLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(), null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.getMyPreferences());
                }else if (defaultPrinter.toLowerCase().contains("ip printer")) {
                    zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                    //zoneRichPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(), selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "",myApp.myPreferences);
                    zoneRichPrinter.printFoodHubFullReport(myApp.restaurantLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(), null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.getMyPreferences());
                    getActivity().onBackPressed();
                } else if (defaultPrinter.toLowerCase().contains("sunmi") || defaultPrinter.toLowerCase().contains("t2")) {
                    //sunmiPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(), selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "",myPreferences);
                    sunmiPrinter.printFoodHubFullReport(myApp.restaurantLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(),  null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.getMyPreferences());
                    getActivity().onBackPressed();
                } else if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                    sunmiPrinter.printFoodHubFullReport(myApp.restaurantLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(),  null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.getMyPreferences());
                    getActivity().onBackPressed();
                }
            } else {
                ToastUtils.makeSnackToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}