package com.tiffintom.partner1.fragments;

import android.app.TimePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.TimePicker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.TimeslotsSelectionAdapter;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Amrish on 11-11-2020.
 */
public class OrderSetTimeBottomSheetFragment extends BaseBottomSheet {
    private int order_type = -1; // 0 dinein, 1 delivery, 2 pickup
    private String order_id;
    private boolean delay;
    private ArrayList<String> timeSlotsString = new ArrayList<>();
    private TimeslotsSelectionAdapter adapter;
    private RecyclerView rvSlots;
    private LinearLayout llLoading;
    private String selectedTimeSlot = "";
    private LinearLayout llData;
    private Button btnConfirm, btnCancel;
    private DialogDismissListener dialogDismissListener;
    private TextView tvTitle;

    public static OrderSetTimeBottomSheetFragment getInstance(int order_type, String order_id) {
        OrderSetTimeBottomSheetFragment orderViewBottomSheetFragment = new OrderSetTimeBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("order_type", order_type);
        bundle.putString("order_id", order_id);
        orderViewBottomSheetFragment.setArguments(bundle);
        return orderViewBottomSheetFragment;
    }

    public static OrderSetTimeBottomSheetFragment getInstance(int order_type, String order_id, boolean delay) {
        OrderSetTimeBottomSheetFragment orderViewBottomSheetFragment = new OrderSetTimeBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("order_type", order_type);
        bundle.putString("order_id", order_id);
        bundle.putBoolean("delay", delay);
        orderViewBottomSheetFragment.setArguments(bundle);
        return orderViewBottomSheetFragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_order_settime_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (order_type == 2) {
                if (delay) {
                    tvTitle.setText("Select Delay Pickup Time");
                } else {
                    tvTitle.setText("Select Pickup Time");
                }
            } else if (order_type == 1) {
                if (delay) {
                    tvTitle.setText("Select Delay Delivery Time");
                } else {
                    tvTitle.setText("Select Delivery Time");
                }
            } else {
                if (delay) {
                    tvTitle.setText("Delay order");
                } else {
                    tvTitle.setText("Select Time");
                }
            }
            fetchTimeSlots();
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                delay = getArguments().getBoolean("delay");
                order_id = getArguments().getString("order_id");
                order_type = getArguments().getInt("order_type");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            ivClose = view.findViewById(R.id.ivClose);
            llLoading = view.findViewById(R.id.llLoading);
            rvSlots = view.findViewById(R.id.rvTimeSlots);
            llData = view.findViewById(R.id.llData);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            tvTitle = view.findViewById(R.id.tvTitle);

            adapter = new TimeslotsSelectionAdapter(timeSlotsString, (position, data) -> {
                adapter.notifyDataSetChanged();
                if (position < timeSlotsString.size() - 1)
                    selectedTimeSlot = (String) data;
                if (position == timeSlotsString.size() - 1) {
                    Calendar calendar = Calendar.getInstance();

                    TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), timeSetListener, calendar.get(Calendar.HOUR_OF_DAY), calendar.get(Calendar.MINUTE), false);
                    timePickerDialog.show();
                    timePickerDialog.setOnCancelListener(dialogInterface -> {
                        adapter.selectedTimeslot = selectedTimeSlot;
                        timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
                        adapter.notifyDataSetChanged();
                    });
                }
            });
            rvSlots.setAdapter(adapter);
            rvSlots.setLayoutManager(new GridLayoutManager(getActivity(), 2));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setListeners() {
        super.setListeners();
        try {
            btnCancel.setOnClickListener(view -> dismiss());
            btnConfirm.setOnClickListener(view -> {
                if (!Validators.isNullOrEmpty(selectedTimeSlot)) {
                    if (delay) {
                        delayOrder();
                    } else
                        acceptOrder();
                } else ToastUtils.makeToast(getActivity(), "Please select time slot first.");
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void acceptOrder() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("preparation", selectedTimeSlot);
            params.put("status", "Accepted");
            AndroidNetworking.post(ApiEndPoints.orders + order_id + "/change-status")
                    .addQueryParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                if (dialogDismissListener != null) {
                                    dialogDismissListener.onDialogDismiss(selectedTimeSlot);
                                    dismiss();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                LogUtils.e("Order Status Change error");
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void delayOrder() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("preparation", selectedTimeSlot);
            AndroidNetworking.post(ApiEndPoints.orders + order_id + "/time-extend")
                    .addQueryParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                if (dialogDismissListener != null) {
                                    dialogDismissListener.onDialogDismiss(selectedTimeSlot);
                                    dismiss();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                LogUtils.e("Order Status Change error");
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchTimeSlots() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                    llData.setVisibility(View.GONE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.orders + order_id + "/time-slots")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                    llData.setVisibility(View.VISIBLE);
                                });
                            }
                            try {
                                timeSlotsString.clear();
                                timeSlotsString.addAll(new Gson().fromJson(response.toString(), new TypeToken<List<String>>() {
                                }.getType()));
                                timeSlotsString.add("Custom");
                                adapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                                ToastUtils.makeToast(getActivity(), "Time slots not found");
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                LogUtils.e("Fetch timeslots error");
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectOldTimeSlot() {
        try {
            adapter.selectedTimeslot = selectedTimeSlot;
            timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
            adapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    TimePickerDialog.OnTimeSetListener timeSetListener = new TimePickerDialog.OnTimeSetListener() {
        @Override
        public void onTimeSet(TimePicker timePicker, int hour, int minutes) {
            try {
                Calendar calendar = Calendar.getInstance();
                int currentHour = calendar.get(Calendar.HOUR_OF_DAY);
                int currentMinute = calendar.get(Calendar.MINUTE);
                boolean valid = false;
                String pickedTime = hour + ":" + minutes;
                String current = currentHour + ":" + currentMinute;
                LogUtils.e(pickedTime);
                LogUtils.e(current);
                if (hour == currentHour) {
                    valid = minutes >= currentMinute;
                } else valid = hour > currentHour;
                if (valid) {
                    String timeSet = "";
                    if (hour > 12) {
                        hour -= 12;
                        timeSet = "PM";
                    } else if (hour == 0) {
                        hour += 12;
                        timeSet = "AM";
                    } else if (hour == 12) {
                        timeSet = "PM";
                    } else {
                        timeSet = "AM";
                    }

                    String min = "";
                    if (minutes < 10)
                        min = "0" + minutes;
                    else
                        min = String.valueOf(minutes);
                    selectedTimeSlot = String.valueOf(hour) + ':' + min + " " + timeSet;
                    adapter.selectedTimeslot = selectedTimeSlot;
                    timeSlotsString.set(timeSlotsString.size() - 1, selectedTimeSlot);
                    adapter.notifyDataSetChanged();
                } else {
                    selectedTimeSlot = "";
                    ToastUtils.makeToast(getActivity(), "Invalid timeslot");
                    selectOldTimeSlot();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };


}
