package com.tiffintom.partner1.fragments;

import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.widget.NestedScrollView;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.snackbar.Snackbar;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.OrderedProductItemsAdapter;
import com.tiffintom.partner1.adapters.SurChargesAdapter;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.models.OrderProductDetail;
import com.tiffintom.partner1.models.SurChargesModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

/**
 * Created by Amrish on 11-11-2020.
 */
public class OrderViewBottomSheetFragment extends BaseBottomSheet {
    private int order_type = -1; // 0 dinein, 1 delivery, 2 pickup
    private String order_id;
    private RecyclerView rvCartItems, rvSurCharges;
    private OrderedProductItemsAdapter productItemsAdapter;
    private SurChargesAdapter surChargesAdapter;
    private ArrayList<OrderProductDetail> productDetails = new ArrayList<>();
    private ArrayList<SurChargesModel> surChargesArrayList = new ArrayList<>();
    private TextView tvOrderType, tvPersonalDetails, tvSubTotal, tvServiceCharge, tvDeliveryFee, tvTipAmount, tvCharityAmount, tvDiscount, tvTotal, tvAddress, tvCardDetails, tvOrderId, tvRewardDiscount, tvRewardDiscountLabel, tvWalletAmount, tvPaymentMethodName;
    private ImageView ivMethod;
    private TextView tvInstructionTitle, tvInstructions, tvCancelReasonTitle, tvCancelReason, tvGratuityAmount;
    private LinearLayout cvInstructions;
    private OrderDetail orderDetail;
    private LinearLayout llDiscount, llDeliveryFee, llCharityAmount, llTipAmount, llWalletAmountl, llRewardDiscount, llLoader, llData, llNoRecords, llServiceCharge, llCancelReason, llGratuity;
    private MaterialButton btnAccept, btnReject, btnDelay, btnSetReminder;
    private NestedScrollView nestedScrollView;
    private View shadowDivider;
    private DialogDismissListener dialogDismissListener;
    private Snackbar snackbar;
    private boolean isPreOrder = true;
    private CS20PrintHelper cs20PrintHelper;
    private ImageView ivPrint;
    private SunmiPrinter sunmiPrinter;
    private BluetoothPrinter bluetoothPrinter;
    private ZoneRichPrinter zoneRichPrinter;
    private boolean justPrint = false;
    private TextView tvReadMore;

    public static OrderViewBottomSheetFragment getInstance(int order_type, String order_id) {
        OrderViewBottomSheetFragment orderViewBottomSheetFragment = new OrderViewBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("order_type", order_type);
        bundle.putString("order_id", order_id);
        orderViewBottomSheetFragment.setArguments(bundle);
        return orderViewBottomSheetFragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_orderview_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        fetchData();
    }

    private void fetchData() {
        new Thread(this::fetchOrderDetails).start();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (intentExtrasData.containsKey("order_id")) {
                order_id = String.valueOf(intentExtrasData.get("order_id"));
            }
            if (intentExtrasData.containsKey("order_type"))
                order_type = (int) intentExtrasData.get("order_type");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                cs20PrintHelper = new CS20PrintHelper();
            }
            sunmiPrinter = new SunmiPrinter(getActivity());
            bluetoothPrinter = new BluetoothPrinter(getActivity());

            ivClose = view.findViewById(R.id.ivClose);
            ivPrint = view.findViewById(R.id.ivPrint);

            tvReadMore = view.findViewById(R.id.tvReadMore);
            shadowDivider = view.findViewById(R.id.shadowDivider);
            nestedScrollView = view.findViewById(R.id.nestedScroll);
            rvCartItems = view.findViewById(R.id.rvCartItems);
            rvSurCharges = view.findViewById(R.id.rvSurCharges);
            tvOrderId = view.findViewById(R.id.tvOrderId);
            tvOrderType = view.findViewById(R.id.tvOrderType);
            tvPersonalDetails = view.findViewById(R.id.tvPersonalDetails);
            tvSubTotal = view.findViewById(R.id.tvSubtotal);
            tvServiceCharge = view.findViewById(R.id.tvServiceFee);
            tvDeliveryFee = view.findViewById(R.id.tvDeliveryFee);
            tvDiscount = view.findViewById(R.id.tvDiscount);
            tvTotal = view.findViewById(R.id.tvTotal);
            tvAddress = view.findViewById(R.id.tvAddress);
            tvCardDetails = view.findViewById(R.id.tvCardDetails);
            ivMethod = view.findViewById(R.id.ivMethod);
            tvPaymentMethodName = view.findViewById(R.id.tvPaymentMethodName);

            tvTipAmount = view.findViewById(R.id.tvTipAmount);
            tvRewardDiscount = view.findViewById(R.id.tvRewardDiscount);
            tvRewardDiscountLabel = view.findViewById(R.id.tvRewardDiscountLabel);
            tvCharityAmount = view.findViewById(R.id.tvCharityAmount);
            tvWalletAmount = view.findViewById(R.id.tvWalletAmount);
            tvInstructionTitle = view.findViewById(R.id.tvInstructionsTitle);
            cvInstructions = view.findViewById(R.id.cvInstruction);
            tvInstructions = view.findViewById(R.id.tvInstructions);
            btnAccept = view.findViewById(R.id.btnAccept);
            btnReject = view.findViewById(R.id.btnReject);
            btnSetReminder = view.findViewById(R.id.btnReminder);
            btnDelay = view.findViewById(R.id.btnDelayOrder);
            tvCancelReasonTitle = view.findViewById(R.id.tvCancelReasionTitle);
            llCancelReason = view.findViewById(R.id.llCancelReason);
            tvCancelReason = view.findViewById(R.id.tvCancelReason);

            llCharityAmount = view.findViewById(R.id.ll_CharityAmount);
            llDeliveryFee = view.findViewById(R.id.ll_Delivery);
            llDiscount = view.findViewById(R.id.ll_Discount);
            llTipAmount = view.findViewById(R.id.ll_TipAmount);
            llWalletAmountl = view.findViewById(R.id.ll_WalletAmount);
            llRewardDiscount = view.findViewById(R.id.llRewardDiscount);
            llLoader = view.findViewById(R.id.llLoading);
            llData = view.findViewById(R.id.llData);
            llNoRecords = view.findViewById(R.id.llNoRecord);
            llServiceCharge = view.findViewById(R.id.ll_ServiceCharge);
            llGratuity = view.findViewById(R.id.ll_Gratuity);
            tvGratuityAmount = view.findViewById(R.id.tvGratuityAmount);

            rvCartItems.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            productItemsAdapter = new OrderedProductItemsAdapter(productDetails, true);
            rvCartItems.setNestedScrollingEnabled(false);
            rvCartItems.setAdapter(productItemsAdapter);

            rvSurCharges.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            surChargesAdapter = new SurChargesAdapter(requireActivity(), surChargesArrayList, (position, data) -> {

            });
            rvSurCharges.setNestedScrollingEnabled(false);
            rvSurCharges.setAdapter(surChargesAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setListeners() {
        super.setListeners();
        try {
            ivPrint.setOnClickListener(view -> {
                justPrint = true;
                printOrder();
            });
            nestedScrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener) (v, scrollX, scrollY, oldScrollX, oldScrollY) -> {
                if (scrollY == 0) {
                    shadowDivider.setVisibility(View.INVISIBLE);
                } else {
                    shadowDivider.setVisibility(View.VISIBLE);
                }
            });
            tvReadMore.setOnClickListener(view -> {
                if (tvReadMore.getText().toString().contains("less")) {
                    tvReadMore.setText("Read more");
                    if (orderDetail.order_description.length() > 50)
                        tvInstructions.setText(orderDetail.order_description.substring(0, 50));
                    else tvInstructions.setText(orderDetail.order_description);
                } else {
                    tvReadMore.setText("Read less");
                    tvInstructions.setText(orderDetail.order_description);
                }
            });
            btnAccept.setOnClickListener(view -> {
                if (btnAccept.getText().toString().equalsIgnoreCase("accept")) {
                    if (order_type > 0) {
                        OrderSetTimeBottomSheetFragment orderSetTimeBottomSheetFragment = OrderSetTimeBottomSheetFragment.getInstance(order_type, order_id);
                        orderSetTimeBottomSheetFragment.show(getFragmentManager(), "accept_order_set_time");
                        orderSetTimeBottomSheetFragment.setDialogDismissListener(acceptOrderDialogListener);
                    } else {
                        acceptOrder("Accepted");
                    }
                } else {
                    if (orderDetail.status.equalsIgnoreCase("accepted"))
                        acceptOrder("Delivered");
                    else {
                        ToastUtils.makeToast(getActivity(), "Unknown action");
                    }
                }
            });
            btnSetReminder.setOnClickListener(view -> {
                PreorderSetReminderFragment preorderSetReminderFragment = PreorderSetReminderFragment.getInstance(orderDetail);
                preorderSetReminderFragment.show(getChildFragmentManager(), "set_reminder");
            });
            btnReject.setOnClickListener(view -> {
                RejectReasonDialogFragment rejectReasonDialogFragment = RejectReasonDialogFragment.getInstance("Item out of stock, Not taking orders, Customer error, Other");
                rejectReasonDialogFragment.show(getChildFragmentManager(), "reject_order");
                rejectReasonDialogFragment.setDialogDismissListener(rejectOrderDialogListener);
            });
            btnDelay.setOnClickListener(view -> {
                OrderSetTimeBottomSheetFragment orderSetTimeBottomSheetFragment = OrderSetTimeBottomSheetFragment.getInstance(order_type, order_id, true);
                orderSetTimeBottomSheetFragment.show(getActivity().getSupportFragmentManager(), "delay_order_set_time");
                orderSetTimeBottomSheetFragment.setDialogDismissListener(orderDelayDialogListener);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void acceptOrder(String status) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("status", status);
            AndroidNetworking.post(ApiEndPoints.orders + order_id + "/change-status")
                    .addQueryParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                orderDetail.status = status;
                                if (status.equalsIgnoreCase("Accepted")) {
                                    orderDetail.status = "Accepted";
                                    orderRejected = false;
                                    orderStatusMessage = "Order has been accepted";
                                    justPrint = false;
                                    printOrder();
                                }
                                if (status.equalsIgnoreCase("Delivered")) {
                                    orderRejected = false;
                                    orderStatusMessage = "Order has been delivered";
                                    if (dialogDismissListener != null) {
                                        dialogDismissListener.onDialogDismiss("refresh");
                                    }
                                    sendStatusChangeEvent();
                                    dismiss();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                LogUtils.e("Order Status Change error");
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    DialogDismissListener rejectOrderDialogListener = o -> {
        if (o instanceof String)
            rejectOrder(String.valueOf(o));
    };

    DialogDismissListener acceptOrderDialogListener = o -> {
        orderStatusMessage = "Order has been accepted";
        orderDetail.status = "Accepted";
        orderDetail.preparation = (String) o;
        justPrint = false;
        printOrder();
    };
    DialogDismissListener orderDelayDialogListener = o -> {
        orderStatusMessage = "Order time has been extended";
        sendStatusChangeEvent();
        dismiss();
    };

    private void rejectOrder(String reason) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("failed_reason", reason);
            params.put("status", "Failed");
            AndroidNetworking.post(ApiEndPoints.orders + order_id + "/change-status")
                    .addQueryParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                orderDetail.failed_reason = reason;
                                orderRejected = true;
                                orderStatusMessage = "Order has been rejected";
                                orderDetail.status = "failed";
                                justPrint = false;
                                printOrder();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                LogUtils.e("Order Status Change error");
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOrderDetails() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                            llLoader.setVisibility(View.VISIBLE);
                        }
                );
            }
            AndroidNetworking.get(ApiEndPoints.orders + order_id).setPriority(Priority.IMMEDIATE)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                orderDetail = new Gson().fromJson(response.toString(), OrderDetail.class);
                                //if (orderDetail.productdetail != null) {
                                //orderDetail = response;
                                if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                                    rvSurCharges.setVisibility(View.VISIBLE);
                                    surChargesArrayList.addAll(orderDetail.surcharges);
                                    surChargesAdapter.notifyDataSetChanged();
                                }
                                if (orderDetail.cart_view != null) {
                                    productDetails.addAll(orderDetail.cart_view);
                                    productItemsAdapter.notifyDataSetChanged();
                                }
                                updateViews();
                            } catch (Exception e) {
                                e.printStackTrace();
                                ToastUtils.makeToast(getActivity(), "Order not found");
                            }
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoader.setVisibility(View.GONE);
                                    llData.setVisibility(View.VISIBLE);
                                });
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoader.setVisibility(View.GONE);
                                        llNoRecords.setVisibility(View.VISIBLE);
                                    });
                                }
                                LogUtils.e("ERROR IN ORDER VIEW");
                                LogUtils.e(anError.getErrorBody());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoader.setVisibility(View.GONE);
                    llNoRecords.setVisibility(View.VISIBLE);
                });
            }
        }

    }

    private void updateViews() {

        try {
            if (orderDetail != null) {
                if (orderDetail.status.equalsIgnoreCase("pending"))
                    ivPrint.setVisibility(View.INVISIBLE);
                else ivPrint.setVisibility(View.VISIBLE);
                String orderType = CommonFunctions.getOrderType(order_type);
                if (order_type > 0)
                    isPreOrder = CommonFunctions.isPreOrderNew(orderDetail.delivery_date, orderDetail.status);
                else isPreOrder = false;
                StringBuilder personalDetails = new StringBuilder();
                personalDetails.append("Name: ");
                personalDetails.append(orderDetail.customer_name);
                personalDetails.append("\n");
                if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                    personalDetails.append("Mobile: ");
                    personalDetails.append(orderDetail.customer_phone);
                    personalDetails.append("\n");
                }
                if (order_type == 0) {
                    personalDetails.append("Table no: ");
                    personalDetails.append(orderDetail.table_no);
                    personalDetails.append("\n");
                    personalDetails.append("Guests: ");
                    personalDetails.append(orderDetail.no_of_guest);
                    personalDetails.append("\n");
                }
                if (order_type == 1 && !Validators.isNullOrEmpty(orderDetail.address)) {
                    personalDetails.append("Delivery address: ");
                    personalDetails.append(orderDetail.address);
                    personalDetails.append("\n");
                }
                if (!Validators.isNullOrEmpty(orderDetail.created)) {
                    personalDetails.append("Ordered at: ");
                    personalDetails.append(CommonFunctions.formatUnknownDateTime(orderDetail.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "HH:mm"));
                    personalDetails.append("\n");
                }
                if (isPreOrder) {
                    tvOrderType.setText("Pre-order - " + orderType);
                    personalDetails.append("Required by: ");
                    personalDetails.append(CommonFunctions.convertTimeFormat(orderDetail.delivery_time)).append(", ").append(CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd/MM/yyyy"));
                } else {
                    tvOrderType.setText(orderType);
                    if (order_type > 0)
                        if (!Validators.isNullOrEmpty(orderDetail.delivery_time)) {
                            if (orderDetail.assoonas.equalsIgnoreCase("asap")) {
                                personalDetails.append("Required by: ");
                                personalDetails.append("ASAP");
                            } else {
                                personalDetails.append("Required by: ");
                                personalDetails.append(CommonFunctions.convertTimeFormat(orderDetail.delivery_time));
                                personalDetails.append(", ");
                                personalDetails.append(CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd/MM/yyyy"));
                            }
                        }
                }
                if (order_type > 0 && orderDetail.status.equalsIgnoreCase("accepted")) {
                    personalDetails.append("\nConfirmed for: ").append(orderDetail.preparation);
                }
                tvOrderId.setText("Order #" + orderDetail.order_number);
                tvPersonalDetails.setText(personalDetails);

                tvSubTotal.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.order_sub_total)));

                tvTotal.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.order_grand_total + orderDetail.charity_amount)));
                if (orderDetail.offer_amount + orderDetail.voucher_amount > 0) {
                    tvDiscount.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.voucher_amount + orderDetail.offer_amount)));
                    llDiscount.setVisibility(View.VISIBLE);
                } else {
                    llDiscount.setVisibility(View.GONE);
                }

                if (orderDetail.reward_offer > 0) {
                    tvRewardDiscountLabel.setText("Redeem Amount (" + orderDetail.reward_offer_percentage + "%)");
                    tvRewardDiscount.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.reward_offer)));
                    llRewardDiscount.setVisibility(View.VISIBLE);
                } else {
                    llRewardDiscount.setVisibility(View.GONE);
                }
                if (orderDetail.service_charge > 0) {
                    if ("no".equalsIgnoreCase(loggedInRestaurant.service_charge_status)) {
                        llServiceCharge.setVisibility(View.GONE);
                    } else {
                        llServiceCharge.setVisibility(View.VISIBLE);
                    }
                    tvServiceCharge.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.service_charge)));
                } else {
                    llServiceCharge.setVisibility(View.GONE);
                }

                if (orderDetail.delivery_charge > 0) {
                    tvDeliveryFee.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.delivery_charge)));
                    llDeliveryFee.setVisibility(View.VISIBLE);
                } else {
                    llDeliveryFee.setVisibility(View.GONE);
                }

                if (orderDetail.driver_tip > 0) {
                    tvTipAmount.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format((orderDetail.driver_tip))));
                    llTipAmount.setVisibility(View.VISIBLE);
                } else {
                    llTipAmount.setVisibility(View.GONE);
                }
                if (orderDetail.charity_amount > 0)
                    tvCharityAmount.setText(String.format("%s%s", orderDetail.charity_message + "(" + myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.charity_amount)) + ")");
                else {
                    llCharityAmount.setVisibility(View.GONE);
                }

                if (orderDetail.wallet_amount > 0)
                    tvWalletAmount.setText(String.format(myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.wallet_amount)));
                else
                    llWalletAmountl.setVisibility(View.GONE);

                if (Validators.isNullOrEmpty(orderDetail.order_description)) {
                    tvInstructionTitle.setVisibility(View.GONE);
                    cvInstructions.setVisibility(View.GONE);
                } else {
                    tvInstructionTitle.setVisibility(View.VISIBLE);
                    cvInstructions.setVisibility(View.VISIBLE);
                    if (orderDetail.order_description.length() > 50) {
                        tvReadMore.setVisibility(View.VISIBLE);
                        tvInstructions.setText(orderDetail.order_description.substring(0, 50));
                    } else {
                        tvInstructions.setText(orderDetail.order_description);
                        tvReadMore.setVisibility(View.GONE);
                    }
                }

                if (orderDetail.gratuity > 0) {
                    tvGratuityAmount.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(orderDetail.gratuity)));
                    llGratuity.setVisibility(View.VISIBLE);
                } else {
                    llGratuity.setVisibility(View.GONE);
                }
                if (orderDetail.payment_method.equalsIgnoreCase("stripe")) {
                    if (orderDetail.card_view != null && !Validators.isNullOrEmpty(orderDetail.card_view.card_brand)) {
                        tvCardDetails.setText(String.format("**** %s", orderDetail.card_view.card_number));
                        tvCardDetails.setVisibility(View.VISIBLE);
                    } else {
                        tvCardDetails.setVisibility(View.GONE);
                    }
                    tvPaymentMethodName.setText(String.format("%s%s Paid via Credit/Debit card", myApp.getCurrencySymbol(), (orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount));
                } else if (orderDetail.payment_method.equalsIgnoreCase("paypal")) {
                    tvPaymentMethodName.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format(((orderDetail.order_grand_total + orderDetail.charity_amount)) - orderDetail.wallet_amount)) + " Paid via Paypal");
                } else if (orderDetail.payment_method.equalsIgnoreCase("cod")) {
                    if (orderDetail.payment_status.equalsIgnoreCase("p"))
                        tvPaymentMethodName.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format((orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount)) + " Payment Type: Cash\nStatus: Unpaid");
                    else {
                        if (order_type == 0)
                            tvPaymentMethodName.setText("Due to pay at restaurant");
                        else if (order_type == 1)
                            tvPaymentMethodName.setText("Cash on delivery");
                        else if (order_type == 2)
                            tvPaymentMethodName.setText("Cash on collection");
                    }
                } else if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit")) {
                    tvPaymentMethodName.setText(String.format("%s%s", myApp.getCurrencySymbol(), MyApp.df.format((orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount)) + " Paid via Credit");
                }
                String positiveButtonText = "Accept";
                btnReject.setVisibility(View.GONE);
                btnDelay.setVisibility(View.GONE);
                btnSetReminder.setVisibility(View.GONE);
                btnAccept.setEnabled(true);
                btnReject.setText("Reject");
                if (orderDetail.status.equalsIgnoreCase("pending")) {
                    btnReject.setVisibility(View.VISIBLE);
                    btnAccept.setVisibility(View.VISIBLE);
                    positiveButtonText = "Accept";
                    if (!isPreOrder) {
                        btnSetReminder.setVisibility(View.GONE);
                    } else {
                        btnSetReminder.setVisibility(View.VISIBLE);
                    }
                } else if (orderDetail.status.equalsIgnoreCase("accepted")) {
                    if (order_type == 0) {
                        positiveButtonText = "Ready to serve";
                    } else if (order_type == 2) {
                        positiveButtonText = "Ready to collect";
                    } else {
                        positiveButtonText = "Mark as delivered";
                    }
                    if (order_type > 0)
                        btnDelay.setVisibility(View.VISIBLE);
                    btnAccept.setVisibility(View.VISIBLE);
                } else if (orderDetail.status.equalsIgnoreCase("delivered")) {
                    btnAccept.setEnabled(false);
                    if (order_type == 0) {
                        positiveButtonText = "Served";
                    } else if (order_type == 2) {
                        positiveButtonText = "Collected";
                    } else {
                        positiveButtonText = "Delivered";
                    }
                } else if (orderDetail.status.equalsIgnoreCase("failed")) {
                    btnAccept.setVisibility(View.GONE);
                    btnReject.setVisibility(View.VISIBLE);
                    positiveButtonText = "Rejected";
                    btnReject.setEnabled(false);
                    btnReject.setText("Rejected");

                }
                btnAccept.setText(positiveButtonText);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertDateToLong(String dateTime) {
        String givenDateString = dateTime;
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        try {
            Date mDate = sdf.parse(givenDateString);
            long timeInMilliseconds = mDate.getTime();
            System.out.println("Date in milli :: " + timeInMilliseconds);
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void printOrder() {
        try {
            if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                    builder.setMessage("Do you want print of this order?");
                    builder.setPositiveButton("Yes", (dialogInterface, i) -> {
                        dialogInterface.dismiss();
                        continuePrint();
                    });
                    builder.setNegativeButton("No", (dialogInterface, i) -> {
                        dialogInterface.dismiss();
                        if (dialogDismissListener != null) {
                            dialogDismissListener.onDialogDismiss("refresh");
                            sendStatusChangeEvent();
                            dismiss();
                        }
                    });
                    AlertDialog alertDialog = builder.create();
                    alertDialog.show();
                } else {
                    continuePrint();
                }

            } else {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("refresh");
                }
                sendStatusChangeEvent();
                dismiss();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void continuePrint() {
        try {
            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                printIMin(orderDetail, false);
            } else if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                printCS20(orderDetail, false);
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                if (zoneRichPrinter == null) {
                    ToastUtils.makeToast(getActivity(), "Printer is null");
                } else {
                    printZonerich(orderDetail, false);
                }
            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                try {
                    if (bluetoothPrinter != null) {
                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                        if (device != null) {
                            CommonFunctions.functionThatDelay(200);
                            printBT(orderDetail, false);
                        } else {
                            ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                printSunmi(orderDetail, false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printIMin(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            myApp.iMinPrinterUtils.printOrder(myApp.restaurantLogo, myApp.merchantLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed") && !justPrint) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setMessage("You want kitchen copy?");
                builder.setPositiveButton("Yes", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printIMin(orderDetail, true);
                });
                builder.setNegativeButton("No", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss("refresh");
                        sendStatusChangeEvent();
                        dismiss();
                    }
                });
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
            } else {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("refresh");
                    sendStatusChangeEvent();
                    dismiss();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCS20(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            cs20PrintHelper.printOrder(myApp.restaurantLogo, myApp.merchantLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed") && !justPrint) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setMessage("You want kitchen copy?");
                builder.setPositiveButton("Yes", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printCS20(orderDetail, true);
                });
                builder.setNegativeButton("No", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss("refresh");
                        sendStatusChangeEvent();
                        dismiss();
                    }
                });
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
            } else {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("refresh");
                    sendStatusChangeEvent();
                    dismiss();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printZonerich(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
            zoneRichPrinter.printOrder(myApp.restaurantLogo, myApp.merchantLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed") && !justPrint) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setMessage("You want kitchen copy?");
                builder.setPositiveButton("Yes", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                    printZonerich(orderDetail, true);
                });
                builder.setNegativeButton("No", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss("refresh");
                        sendStatusChangeEvent();
                        dismiss();
                    }
                });
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
            } else {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("refresh");
                    sendStatusChangeEvent();
                    dismiss();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSunmi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            sunmiPrinter.printOrder(myApp.restaurantLogo, myApp.merchantLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed") && !justPrint) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setMessage("You want kitchen copy?");
                builder.setPositiveButton("Yes", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printSunmi(orderDetail, true);
                });
                builder.setNegativeButton("No", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss("refresh");
                        sendStatusChangeEvent();
                        dismiss();
                    }
                });
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
            } else {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("refresh");
                    sendStatusChangeEvent();
                    dismiss();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBT(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            bluetoothPrinter.printOrder(myApp.restaurantLogo, myApp.merchantLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed") && !justPrint) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setMessage("You want kitchen copy?");
                builder.setPositiveButton("Yes", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printBT(orderDetail, true);
                });
                builder.setNegativeButton("No", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss("refresh");
                        sendStatusChangeEvent();
                        dismiss();
                    }
                });
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
            } else {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("refresh");
                    sendStatusChangeEvent();
                    dismiss();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    String orderStatusMessage;
    boolean orderRejected = false;

    private void sendStatusChangeEvent() {
        LogUtils.e("sending status change");
        if (!Validators.isNullOrEmpty(orderStatusMessage)) {
            Intent pushNotification = new Intent(Constants.ORDER_STATUS_CHANGE);
            pushNotification.putExtra("rejected", orderRejected);
            pushNotification.putExtra("message", orderStatusMessage);
            pushNotification.putExtra("orderdetail", new Gson().toJson(orderDetail));
            LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(pushNotification);
        }
    }

}
