package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 25-11-2020.
 */
public class OverviewFilterSelectionFragment extends BaseBottomSheet {
    String filter;

    public static OverviewFilterSelectionFragment getInstance(String filter) {
        OverviewFilterSelectionFragment filterSelectionFragment = new OverviewFilterSelectionFragment();
        Bundle bundle = new Bundle();
        bundle.putString("filter", filter);
        filterSelectionFragment.setArguments(bundle);
        return filterSelectionFragment;
    }

    private TextView tvToday, tvWeek, tvMonth, tvYear, tvCustomDate, tvDateRange;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_filters_selection, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        filter = getArguments().getString("filter");
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            tvToday = view.findViewById(R.id.tvToday);
            tvWeek = view.findViewById(R.id.tvWeek);
            tvMonth = view.findViewById(R.id.tvMonth);
            tvYear = view.findViewById(R.id.tvYear);
            tvCustomDate = view.findViewById(R.id.tvCustomDate);
            tvDateRange = view.findViewById(R.id.tvDateRange);

            tvToday.setText("Daily");
            tvWeek.setText("Weekly");
            tvMonth.setText("Monthly");
            tvYear.setVisibility(View.GONE);
            tvCustomDate.setVisibility(View.GONE);
            tvDateRange.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setListeners() {
        super.setListeners();
        try {
            tvToday.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("daily");
                    dismiss();
                }
            });
            tvWeek.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("weekly");
                    dismiss();
                }
            });
            tvMonth.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("monthly");
                    dismiss();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
