package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.BuildConfig;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.TransactionsAndStatementsAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.models.MerchantUserPermission;
import com.tiffintom.partner1.models.PaymentLink;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by Amrish on 12-12-2020.
 */
public class PaymentLinkFragment extends BaseFragment {
    public static PaymentLinkFragment getInstance() {
        return new PaymentLinkFragment();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    private EditText etAmount, etPhone, etTip;
    private MaterialButton btnSend, btnCancel;
    private TextView tvViewAll, tvTipTitle;
    private RecyclerView rvPaymentLinks;
    private ArrayList<Object> paymentLinks = new ArrayList<>();
    private TransactionsAndStatementsAdapter transactionsAndStatementsAdapter;
    private LinearLayout llMoto;
    private float amount = 0;
    int merchantRole = myApp.getMyPreferences().getMerchantRole();
    private LinearLayout llMainLayout;
    String stripe_private_key, stripe_public_key, stripe_mode, descriptor, description;
    private MerchantUserPermission permission;

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            merchantRole = myApp.getMyPreferences().getMerchantRole();
            if (merchantRole == 1) {
                permission = merchantBusiness.supervisor_permissions;
            } else if (merchantRole == 2) {
                permission = merchantBusiness.admin_permissions;
            }
            //stripe_mode = merchantBusiness.stripe_mode;
            stripe_mode = ApiEndPoints.ubsidiBuild?"live":"test";
           // if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && !Validators.isNullOrEmpty(merchantBusiness.connect_stripe_public_key)) {
            if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                //stripe_private_key = merchantBusiness.connect_stripe_private_key;
                stripe_private_key = BuildConfig.connect_stripe_private_key;
               // stripe_public_key = merchantBusiness.connect_stripe_public_key;
                stripe_public_key = BuildConfig.connect_stripe_public_key;
            } else {
                if (stripe_mode.equalsIgnoreCase("live")) {
                    //stripe_private_key = merchantBusiness.stripe_private_key_live;
                    stripe_private_key = BuildConfig.stripe_private_key_live;
                    //stripe_public_key = merchantBusiness.stripe_public_key_live;
                    stripe_public_key = BuildConfig.stripe_public_key_live;
                } else {
                   // stripe_private_key = merchantBusiness.stripe_private_key_test;
                    stripe_private_key = BuildConfig.stripe_private_key_test;
                   // stripe_public_key = merchantBusiness.stripe_public_key_test;
                    stripe_public_key = BuildConfig.stripe_public_key_test;
                }
            }

            llMainLayout = view.findViewById(R.id.llMainLayout);
            etAmount = view.findViewById(R.id.etAmount);
            etPhone = view.findViewById(R.id.etPhone);
            etTip = view.findViewById(R.id.etTip);
            tvTipTitle = view.findViewById(R.id.tvTipeTitle);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnSend = view.findViewById(R.id.btnSend);
            rvPaymentLinks = view.findViewById(R.id.rvPaymentLinks);
            tvViewAll = view.findViewById(R.id.tvViewAll);
            llMoto = view.findViewById(R.id.llMoto);

            rvPaymentLinks.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));

            transactionsAndStatementsAdapter = new TransactionsAndStatementsAdapter(getActivity(), paymentLinks, (position, data) -> {
                resendPaymentLink((PaymentLink) data);
            });
            rvPaymentLinks.setAdapter(transactionsAndStatementsAdapter);

            if (permission != null && permission.moto_service) {
                llMoto.setVisibility(View.VISIBLE);
            } else {
                if (merchantRole == 0) {
                    llMoto.setVisibility(View.VISIBLE);
                } else {
                    llMoto.setVisibility(View.GONE);
                }
            }
            if (merchantBusiness.tip) {
                etTip.setVisibility(View.VISIBLE);
                tvTipTitle.setVisibility(View.VISIBLE);
            } else {
                etTip.setVisibility(View.GONE);
                tvTipTitle.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_payment_link, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            getRecentPaymentLinks();
            startTimer();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
            if(getArguments()!=null && getArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT)!=null){
                etAmount.setText(getArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT));
                etPhone.requestFocus();
                CommonFunctions.openKeyboard(requireActivity(),etPhone);
            }
            btnSend.setOnClickListener(view -> {
                if (Validators.isNullOrEmpty(etPhone.getText().toString())) {
                    etPhone.setError("Please enter phone");
                    etPhone.requestFocus();
                } else if (Validators.isNullOrEmpty(etAmount.getText().toString())) {
                    etAmount.setError("Please enter amount");
                    etAmount.requestFocus();
                } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) == 0) {
                    etPhone.setError("Amount should be greater than zero");
                    etPhone.requestFocus();
                } else {
                    new Thread(this::generatePaymentLink).start();

                }
            });
            btnCancel.setOnClickListener(view -> {
                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                CommonFunctions.hideKeyboard(getActivity(), etPhone);
                getActivity().onBackPressed();
            });
            tvViewAll.setOnClickListener(view -> {
                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                CommonFunctions.hideKeyboard(getActivity(), etPhone);
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, PaymentLinksTransactionFragment.getInstance(), "Payment link transactions");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });
            llMoto.setOnClickListener(v -> {
                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                CommonFunctions.hideKeyboard(getActivity(), etPhone);
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, MotoPaymentFragment.getInstance(), "Moto payment");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resendPaymentLink(PaymentLink data) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            AndroidNetworking.post(ApiEndPoints.payment_message + "/" + data.id + "/resend")
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                            }
                            try {
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Message sent successfully.");
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generatePaymentLink() {
        try {
            float total_amount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
            if (!Validators.isNullOrEmpty(etTip.getText().toString()) && Float.parseFloat(etTip.getText().toString().replace(",", "")) >= 0) {
                total_amount = total_amount + Float.parseFloat(etTip.getText().toString().replace(",", ""));
            }
            if (total_amount <= 0.30) {
                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Amount should be greater than 0.30");
                return;
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("phone", etPhone.getText().toString());
            params.put("secretkey", stripe_private_key);
            params.put("publishkey", stripe_public_key);
            params.put("amount", String.valueOf(total_amount));
            params.put("name", merchantBusiness.name);
            params.put("device_id", myApp.getMyPreferences().getUserFCMToken());
            params.put("description", merchantBusiness.statement_description);
            params.put("descriptor", merchantBusiness.statement_descriptor);
            params.put("business_id", merchantBusiness.id);
            params.put("order_id", "");

            AndroidNetworking.post(ApiEndPoints.payment_message)
                    .addQueryParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                    etAmount.setText(null);
                                    etPhone.setText(null);
                                    CommonFunctions.hideKeyboard(getActivity(), etAmount);
                                    CommonFunctions.hideKeyboard(getActivity(), etPhone);
                                });
                            }
                            try {
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Message sent successfully.");
                                getRecentPaymentLinks();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();
                        }
                    });
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private final Calendar toCalendar = Calendar.getInstance();

    private void getRecentPaymentLinks() {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("nopaginate", "1");
            params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("from_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            AndroidNetworking.get(ApiEndPoints.payment_message)
                    .addQueryParameter(params)
                    //.addBodyParameter("action", "paymentLinks")
                    // .addBodyParameter("name", merchantBusiness.name)
                    .build()
                    .getAsObjectList(PaymentLink.class, new ParsedRequestListener<List<PaymentLink>>() {
                        @Override
                        public void onResponse(List<PaymentLink> response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {

                                });
                            }
                            try {
                                paymentLinks.clear();
                                paymentLinks.addAll(response);
                                transactionsAndStatementsAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    TimerTask timerTask;
    Timer timer;

    public void startTimer() {
        try {
            timer = new Timer();
            initTimerTask();
            //schedule the timer, to wake up every 2 second
            if (timerTask != null) timer.schedule(timerTask, 1000, 15000); //

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTimerTask() {
        try {
            timerTask = new TimerTask() {
                public void run() {
                    try {
                        getRecentPaymentLinks();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        setListeners();
    }

    @Override
    public void onStop() {
        try {
            CommonFunctions.hideKeyboard(getActivity(), etAmount);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();
    }

    @Override
    public void onDestroy() {
        try {
            if (timerTask != null) timerTask.cancel();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }
}
