package com.tiffintom.partner1.fragments;

import android.app.DatePickerDialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.WebviewActivity;
import com.tiffintom.partner1.adapters.TransactionsAndStatementsAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.StickHeaderItemDecoration;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.Header;
import com.tiffintom.partner1.models.MerchantStatement;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PaymentStatementsFragment extends BaseFragment {

    private RecyclerView rvStatements;
    private TransactionsAndStatementsAdapter transactionsAndStatementsAdapter;
    private SwipeRefreshLayout swipeRefreshLayout;
    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private Calendar today = Calendar.getInstance();
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private ArrayList<MerchantStatement> merchantStatements = new ArrayList<>();
    private ArrayList<Object> objectArrayList = new ArrayList<>();
    private TextView tvToDate, tvFromDate;
    private RelativeLayout llFromDate, llToDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private String pdfPath;
    private ImageView ivBack;

    public static PaymentStatementsFragment getInstance() {
        return new PaymentStatementsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragement_statment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
        setListeners();
        getData();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        try {
            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            ivBack = view.findViewById(R.id.ivBack);

            rvStatements = view.findViewById(R.id.rvStatment);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            transactionsAndStatementsAdapter = new TransactionsAndStatementsAdapter(getActivity(), objectArrayList, (position, data) -> {
                MerchantStatement statement = (MerchantStatement) data;
                String pathUrl = ApiEndPoints.MERCHANT_BUSINESSES_STATEMENT + statement.id + "/download";
                Intent i = new Intent(getActivity(), WebviewActivity.class);
                i.putExtra("pdfUrl", pathUrl);
                startActivity(i);
            }, (position, data) -> {
                MerchantStatement statement = (MerchantStatement) data;
                String pathUrl = ApiEndPoints.MERCHANT_BUSINESSES_STATEMENT + statement.id + "/download";
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(pathUrl));
                startActivity(browserIntent);

            });
            rvStatements.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvStatements.setNestedScrollingEnabled(false);
            rvStatements.setAdapter(transactionsAndStatementsAdapter);
            rvStatements.addItemDecoration(new StickHeaderItemDecoration(transactionsAndStatementsAdapter));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DATE, -30);

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            ivBack.setOnClickListener(v -> getActivity().onBackPressed());
            swipeRefreshLayout.setOnRefreshListener(this::getData);
            llFromDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                    fromDay = d;
                    fromMonth = m;
                    fromYear = y;
                    fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    fromCalendar.set(y, m, d);
                    tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                    fetchStatements();
                }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                if (!Validators.isNullOrEmpty(toDate)) {
                    datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
                }

            });
            llToDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                    toDay = d;
                    toMonth = m;
                    toYear = y;
                    toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    toCalendar.set(y, m, d);
                    tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                    fetchStatements();
                }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                if (!Validators.isNullOrEmpty(fromDate)) {
                    datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void getData() {
        new Thread(this::fetchStatements).start();
    }

    private void fetchStatements() {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                swipeRefreshLayout.setRefreshing(true);
            });
            AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES_STATEMENT)
                    .addQueryParameter("nopaginate", "1")
                    .addQueryParameter("from_date", fromDate)
                    .addQueryParameter("to_date", toDate)
                    .addPathParameter("business_id", merchantBusiness.id)
                    .build()
                    .getAsObjectList(MerchantStatement.class, new ParsedRequestListener<List<MerchantStatement>>() {
                        @Override
                        public void onResponse(List<MerchantStatement> response) {
                            try {
                                objectArrayList.clear();
                                merchantStatements.clear();
                                objectArrayList.addAll(response);
                                merchantStatements.addAll(response);
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                    transactionsAndStatementsAdapter.notifyDataSetChanged();
                                    setupAdapter();
                                });
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                    if (anError.getErrorCode() == 400) {
                                        objectArrayList.clear();
                                        transactionsAndStatementsAdapter.notifyDataSetChanged();
                                    }
                                });
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> monthYear = new ArrayList<>();

    private void setupAdapter() {
        try {
            monthYear.clear();
            Calendar fromCalendarTemp = Calendar.getInstance();
            fromCalendarTemp.setTime(fromCalendar.getTime());

            Calendar toCalendarTemp = Calendar.getInstance();
            toCalendarTemp.setTime(toCalendar.getTime());

            fromCalendarTemp.add(Calendar.DATE, -30);
            while (toCalendarTemp.after(fromCalendarTemp)) {
                String mY = CommonFunctions.formatMiliToDesireFormat(toCalendarTemp.getTimeInMillis(), "MMMM yyyy");
                monthYear.add(mY);
                toCalendarTemp.add(Calendar.MONTH, -1);
            }

            objectArrayList.clear();

            for (String mmYY : monthYear) {
                ArrayList<MerchantStatement> monthlyInvoices = new ArrayList<>();
                for (MerchantStatement statement : merchantStatements) {
                    String invoiceMonthYear = CommonFunctions.formatUnknownDateTime(statement.to_date, "yyyy-MM-dd", "MMMM yyyy");
                    if (invoiceMonthYear.equals(mmYY)) {
                        monthlyInvoices.add(statement);
                    }
                }
                if (monthlyInvoices.size() > 0) {
                    objectArrayList.add(new Header(mmYY));
                    objectArrayList.addAll(monthlyInvoices);
                }
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    transactionsAndStatementsAdapter.notifyDataSetChanged();
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
